/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
import java.awt.*;

class DrawControls extends Panel {
    DrawPanel target;
    String currentSelected = "Node";

    public DrawControls(DrawPanel target) {
	this.target = target;
	setLayout(new FlowLayout());
	setBackground(Color.lightGray);
	target.setForeground(Color.red);
	CheckboxGroup group = new CheckboxGroup();
	Checkbox b;
	add(b = new Checkbox(null, group, false));
	b.setBackground(Color.red);
	add(b = new Checkbox(null, group, false));
	b.setBackground(Color.green);
	add(b = new Checkbox(null, group, false));
	b.setBackground(Color.blue);
	add(b = new Checkbox(null, group, false));
	b.setBackground(Color.pink);
	add(b = new Checkbox(null, group, false));
	b.setBackground(Color.orange);
	add(b = new Checkbox(null, group, true));
	b.setBackground(Color.black);
	target.setForeground(b.getForeground());
	Choice shapes = new Choice();
	shapes.addItem("Node");
	shapes.addItem("Arc");
	shapes.addItem("Copy");
	shapes.addItem("Move");
	shapes.addItem("Remove");
	shapes.addItem("Reshape");
	shapes.addItem("Name");
	shapes.addItem("-------");
	shapes.addItem("Cell");
	shapes.addItem("Goal");
	shapes.addItem("Prove");
	shapes.addItem("Fuse");
	shapes.addItem("-------");
	shapes.addItem("Clear");
	shapes.addItem("Demo");
	shapes.addItem("Init");
	shapes.addItem("-------");
	shapes.addItem("AutoDemo");
	shapes.addItem("Debug");
	shapes.setBackground(Color.lightGray);
	add(shapes);
    }

    public void paint(Graphics g) {
	Rectangle r = bounds();

	g.setColor(Color.lightGray);
	g.draw3DRect(0, 0, r.width, r.height, false);
    }

    public boolean action(Event e, Object arg) {
	if (e.target instanceof Checkbox) {
	    target.setForeground(((Component)e.target).getBackground());
	} else if (e.target instanceof Choice) {
	    String choice = (String)arg;
	    
	    if (choice.equals("Arc")) {
		target.setDrawMode(DrawPanel.LINES);
	    } else if (choice.equals("Node")) {
		target.setDrawMode(DrawPanel.NODES);
	    } else if (choice.equals("Move")) {
		target.setDrawMode(DrawPanel.MOVE);
	    } else if (choice.equals("Remove")) {
		target.setDrawMode(DrawPanel.REMOVE);
	    } else if (choice.equals("Reshape")) {
		target.setDrawMode(DrawPanel.RESHAPE);
	    } else if (choice.equals("Clear")) {
	        target.init();
		target.repaint();
		((Choice)e.target).select(currentSelected);
	    } else if (choice.equals("Goal")) {
		target.setDrawMode(DrawPanel.GOAL);
	    } else if (choice.equals("Cell")) {
		target.setDrawMode(DrawPanel.MENSO);
	    } else if (choice.equals("Name")) {
		target.setDrawMode(DrawPanel.NAME);
	    } else if (choice.equals("Prove")) {
		target.setDrawMode(DrawPanel.PROVE);
	    } else if (choice.equals("Fuse")) {
		target.setDrawMode(DrawPanel.FUSE);
	    } else if (choice.equals("Copy")) {
		target.setDrawMode(DrawPanel.COPY);
	    } else if (choice.equals("Debug")) {
	        target.dump();
		((Choice)e.target).select(currentSelected);
	    } else if (choice.equals("Demo")) {
	        target.demo();
	        ((Choice)e.target).select(currentSelected);
	    } else if (choice.equals("AutoDemo")) {
	        target.autoDemo();
	        ((Choice)e.target).select(currentSelected);
	    } else if (choice.equals("Init")) {
	      Node.initNum();
	      Arc.initNum();
	      ((Choice)e.target).select(currentSelected);
	    } else {
	      ((Choice)e.target).select(currentSelected);
	    }
	    currentSelected = ((Choice)e.target).getSelectedItem();
	}
	return true;
    }
}
