/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
import java.awt.Graphics;
import java.awt.Color;
import java.util.Hashtable;

class Cluster extends Object {
  public Set nodes;
  public Set loops = new Set();

  public Cluster(){
    nodes = new Set();
  }
  public Cluster(Set s, Set l){
    nodes = s;
    loops = l;
  }

  public Cluster(int x, int y){
    this();
    nodes.addElement(new Node(x,y));
  }

  public Cluster(int x, int y, Color col0, String name){
    this();
    nodes.addElement(new Node(x,y,col0, name));
  }

  public Cluster movecopy(int x, int y){
    Set nnodes = new Set();
    Set nloops = new Set();
    Hashtable ht = new Hashtable();
    for (int i = 0; i < nodes.size(); i++)
      nnodes.addElement(((Node)nodes.elementAt(i)).movecopy(x, y, ht));
    for (int i = 0; i < loops.size(); i++)
      nloops.addElement(((Loop)loops.elementAt(i)).movecopy(x, y, ht));
    return new Cluster(nnodes, nloops);
  }

  public String toString(){
    String tmp =  "Cluster: \n" ;
    int np = nodes.size();
    for (int i = 0; i < np; i++)
      tmp = tmp + "\t" + ((Node)nodes.elementAt(i)).toString() + " \n";
    for (int i = 0; i < loops.size(); i++)
      tmp = tmp + "\t" + ((Loop)loops.elementAt(i)).toString() + " \n";
    return tmp;
  }

  public void addCluster(Cluster c){
    loops.addAll(c.loops);
    nodes.addAll(c.nodes);
  }

  public void addNode(Node n){
    nodes.addElement(n);
  }

  public boolean containsArc(Arc a){
    int np = nodes.size();
    for (int i = 0; i < np; i++)
      if (((Node)nodes.elementAt(i)).arcs.contains(a))
	return true;
    return false;
  }

  public boolean containsNode(Node a){
    return nodes.contains(a);
  }


  /** remove obsolute loops */
  void maintainLoopSub(){
    Set tloops = (Set)loops.clone();
    for (int i = 0; i < loops.size(); i++){
      Loop tmp = (Loop)loops.elementAt(i);
      if (!(tmp.included(nodes)))
	tloops.removeElement(tmp);
    }
    loops = tloops;
  }

  void maintainLoopRemoveArc(Arc a){
    Set tloops = (Set)loops.clone();
    for (int i = 0; i < loops.size(); i++){
      Loop tmp = (Loop)loops.elementAt(i);
      if (tmp.includes(a))
	tloops.removeElement(tmp);
    }
    loops = tloops;
  }

  /* if this Cluster divided into 2 Cluster, return new Cluster.
     unless return null */
  public Cluster removeArc(Arc a){
    maintainLoopRemoveArc(a);
    int np = nodes.size();
    for (int i = 0; i < np; i++)
      ((Node)nodes.elementAt(i)).removeArc(a);
    Set startNodes = a.start.trace();
    if (startNodes.size() == np)
      return null;
    Cluster newOne = new Cluster(startNodes, (Set)loops.clone());
    nodes.removeAll(startNodes);
    newOne.maintainLoopSub();
    this.maintainLoopSub();
    return newOne;
  }

  /* Cluster may divided into some Clusters, return new ClusterSet. */

  public Set removeNode(Node p){
    Set returnSet = new Set();
    Set cloneArcs = (Set) p.arcs.clone();
    int np = cloneArcs.size();
    Cluster current = this;
    for (int i = 0; i < np && current.nodes.size() > 1; i++){
      Arc tmpArc = (Arc)cloneArcs.elementAt(i);
      Cluster tmpCluster = current.removeArc(tmpArc);
      if (tmpCluster != null){
	if (tmpArc.amIstart(p)){
	  returnSet.addElement(current);
	  current = tmpCluster;
	} else {
	  returnSet.addElement(tmpCluster);
	}
      }
    }
    return returnSet;
  }

  public void move(int x0, int y0){
    int np = nodes.size();
    for (int i = 0; i < np; i++)
      ((Node)nodes.elementAt(i)).move(x0, y0);
  }

  public Node getNearestNode(double min, int x, int y) {
    int np = nodes.size();
    Node tmpNode = null;
    
    for (int i = 0; i < np; i++){
      Node cNode = (Node)nodes.elementAt(i);
      double dist = cNode.distance(x, y);
      if (dist < min){
	min = dist;
	tmpNode = cNode;
      }
    }
    return tmpNode;
  }

  public Arc getNearestArc(double min, int x, int y) {
    int np = nodes.size();
    Arc tmpArc = null;
    
    for (int i = 0; i < np; i++){
      Arc cArc = ((Node)nodes.elementAt(i)).getNearestArc(min, x, y); 
      if (cArc != null){
	double dist = cArc.distance(x, y);
	if (dist < min){
	  min = dist;
	  tmpArc = cArc;
	}
      }
    }
    return tmpArc;
  }

  void paint(Graphics g, int x0, int y0){
    g.translate(x0, y0);
    paint(g);
    g.translate(-x0, -y0);
  }
  public void paint(Graphics g){
    for (int i = 0; i < loops.size(); i++)
      ((Loop)loops.elementAt(i)).paint(g);
    int np = nodes.size();
    for (int i = 0; i < np; i++)
      ((Node)nodes.elementAt(i)).paint(g);
  }

  public void maintainLoop(Arc tmpArc){
    Set nodes = new Set();
    Set arcs = new Set();
    arcs.addElement(tmpArc);
    nodes.addElement(tmpArc.start);
    Set tmpLoops = maintainLoopSub(tmpArc.start, tmpArc.end, arcs, nodes);
    for (int i = 0; i < tmpLoops.size(); i++){
      Loop tmpLoop = Loop.newLoop((Set)tmpLoops.elementAt(i));
      if (tmpLoop != null){
	loops.addElement(tmpLoop);
      }
    }
  }

  public Set maintainLoopSub(Node node, Node end, Set arcs, Set nodes){
    Set answer = new Set();
    for (int i = 0; i < node.arcs.size(); i++){
      Arc tArc = (Arc)node.arcs.elementAt(i);
      if (arcs.contains(tArc))
	continue;
      Node other = tArc.myBuddy(node);
      for (int j = 0; j < nodes.size(); j++)
	System.out.print(nodes.elementAt(j) + " ");
      System.out.println("\n "+ other);

      if (nodes.contains(other))
	continue;
      Set tmpArcs = (Set)arcs.clone();
      tmpArcs.addElement(tArc);
      if (other == end){
	answer.addElement(tmpArcs);
      } else {
	Set tmpNodes = (Set)nodes.clone();
	tmpNodes.addElement(other);
	answer.addAll(maintainLoopSub(other, end, tmpArcs, tmpNodes));
      }
    }
    return answer;
  }

  public void addArc(Arc a){
    a.registerSelf();
    maintainLoop(a);
  }

  public void addArcs(Set narcs){
    for (int i = 0; i < narcs.size(); i++){
      Arc a = (Arc)narcs.elementAt(i);
      a.registerSelf();
      maintainLoop(a);
    }
  }

  public Loop getLoop(Set narcs){
    for (int i = 0; i < loops.size(); i++){
      Loop l = (Loop)loops.elementAt(i);
      if (l.arcs.compare(narcs))
	return l;
    }
    return null;
  }

  public void getMatchPointsSubSub(Loop a, Loop b, int ai, int bi, int ao, int bo, Set s, Set s2){
    int min = Math.min(a.arcs.size(), b.arcs.size());
    for (int i = 1; i < min; i++){
      Arc atmp = (Arc)a.arcs.elementAt(ai, i * ao);
      Arc btmp = (Arc)b.arcs.elementAt(bi, i * bo);
      if (atmp.compareByName(btmp)){
	s.addElement(atmp);
	s2.addElement(btmp);
      }
      else 
	return;
    }
  }

  public Set getMatchPointsSub(Loop goal, Loop hypo, int bindex, Arc b){
    Set ans = new Set();
    
    Set tmp = goal.arcs.getSameNameSet(b);
    if (tmp.size() == 0)
      return new Set();
    for (int i = 0; i < tmp.size(); i ++){
      Set one = new Set();
      Set another = new Set();
      Arc a = (Arc)tmp.elementAt(i);
      int aindex = goal.arcs.indexOf(a);
      one.addElement(a);
      another.addElement(b);
      getMatchPointsSubSub(goal, hypo, aindex, bindex,  1,  1, one, another);
      getMatchPointsSubSub(goal, hypo, aindex, bindex, -1,  1, one, another);
      getMatchPointsSubSub(goal, hypo, aindex, bindex,  1, -1, one, another);
      getMatchPointsSubSub(goal, hypo, aindex, bindex, -1, -1, one, another);
      ans.addElement(new Pair(one, another));
    }
    return ans;
  }

  public Set getNodes(Set arcs){
    Set tmp = new Set();
    for (int i = 0; i < arcs.size(); i++){
      Arc a = (Arc)arcs.elementAt(i);
      tmp.addElement(a.start);
      tmp.addElement(a.end);
    }    
    return tmp;
  }


  public Set filterSameNameNode(Set nans, Loop goal, Loop hypo){
    Set ans = new Set();
    for (int i = 0; i < nans.size(); i++){
      Pair pair = (Pair)nans.elementAt(i);
      Set gRestNodes  = goal.getNodes().removeAll(((Path)pair.car).getNodes());
      Set hRestNodes  = hypo.getNodes().removeAll(((Path)pair.cdr).getNodes());
      Set tmp = gRestNodes.andByName(hRestNodes);
      if (tmp.size() == 0)
	ans.addElement(pair);
    }
    return ans;
  }

  public boolean checkDone(Loop goal, Loop hypo){
    if ( (goal.onePath.compareByName(hypo.onePath) 
        &&goal.otherPath.compareByName(hypo.otherPath)) 
     ||  (goal.otherPath.compareByName(hypo.onePath) 
        &&goal.onePath.compareByName(hypo.otherPath)))
      return true;
    return false;
  }

  public Set getMatchPoints(Loop goal, Loop hypo){
    Set nans = new Set();
    
    nans.addAll(goal.onePath.getMatches(hypo.onePath));
    nans.addAll(goal.onePath.getMatches(hypo.otherPath));
    nans.addAll(goal.otherPath.getMatches(hypo.onePath));
    nans.addAll(goal.otherPath.getMatches(hypo.otherPath));

    System.out.println("nans:" + nans);

//    return filterSameNameNode(nans, goal, hypo);
    return nans;
  }

/* obsolute

  public Set getMatchPoints(Loop goal, Loop hypo){
    Set ans = new Set();
   
    for (int i = 0; i < hypo.arcs.size(); i++){
      Arc a = (Arc)hypo.arcs.elementAt(i);
      ans.addAll(getMatchPointsSub(goal, hypo, i, a));
    }
    Set nans = new Set();
    for (int i = 0; i < ans.size(); i++){
      Pair pair = (Pair)ans.elementAt(i);
      Set sa = (Set)pair.car;
      boolean flag = true;
      for (int j = 0; j < nans.size(); j++){
	Set sb = (Set)(((Pair)nans.elementAt(j)).car);
	if (sa.compare(sb)){
	  flag = false;
	  break;
	}
      }
      if (flag)
	nans.addElement(pair);
    }
    return filterSameNameNode(nans, goal, hypo);
  }
*/

  public void getNewNodes(Set hnodes, MyPoint start, MyPoint center, MyPoint end, Set gnodes){
    int num = hnodes.size();
    double toCenter = start.distance(center);
    double len = toCenter + end.distance(center);
    double divlen = len / (num + 1);

    for (int i = 0; i < num; i++){
      MyPoint mp;
      double dis = divlen * (i + 1);
      if (dis < toCenter)
	mp = start.getDivide(center, dis);
      else 
	mp = center.getDivide(end, (dis - toCenter));
      Node nnode = ((Node)hnodes.elementAt(i)).copy(mp);
      addNode(nnode);
      gnodes.addElement(nnode);
    }
  }

  public Path getGoalOtherPath(Path hop, Node start, Node end, MyPoint center){
    Set nodes = new Set();
    nodes.addElement(start);
    getNewNodes(hop.getMidNodes(), start.point(), center, end.point(), nodes);
    nodes.addElement(end);
    return hop.copy(nodes);
  }

  public Loop getNextGoal(Loop goal, Loop hypo, Pair matched){
    Path goalMatchPath = (Path)matched.car;
    Path hypoMatchPath = (Path)matched.cdr;

    Path hypoOtherPath = hypo.getOtherPath(hypoMatchPath);
    System.out.println("hypoOtherPath:" + hypoOtherPath);

    Path goalOtherPath = getGoalOtherPath(hypoOtherPath, goalMatchPath.start(),
					  goalMatchPath.end(), goal.center);
    System.out.println("goalOtherPath:" + goalOtherPath);
    addArcs(goalOtherPath.arcs);

    Set newGoalArcs = (((Set)goal.arcs.clone()).removeAll(goalMatchPath.arcs)).
                              addAll(goalOtherPath.arcs);
    System.out.println("newGoalArcs:" + newGoalArcs);

    Set newHypoArcs = (((Set)goalMatchPath.arcs.clone()).
                              addAll(goalOtherPath.arcs));
    System.out.println("newHypoArcs:" + newHypoArcs);


    Loop newGoal = getLoop(newGoalArcs);
    System.out.println("newGoal:" + newGoal);

    Loop filled = getLoop(newHypoArcs);
    System.out.println("filled:" + filled);
    filled.name(hypo.getName());
    filled.setColor(hypo.col);
    filled.visible();

    return newGoal;
  }


  /* obsolute */
  public Loop getNextGoal(Loop goal, Loop hypo){
    if (goal.compareByName(hypo)){

      /** prove complete */
      goal.name(hypo.getName());
      goal.setColor(hypo.col);
      goal.visible();

      return null;
    }
	
    /* common.arcs = goal.arcs && hypo.arcs 
       restArcs = hypo.arcs - common.arcs 
       goalRest = goal.arcs - common.arcs
       nextgoal.arcs = restArcs + goalRest;
       donw.arcs = common.arcs + restArcs
      */
    Set commonArcs = goal.commonArcs(hypo);
    System.out.println("commonArcs:" + commonArcs);

    if (commonArcs.size() == 0)
      return goal;

    Set hypoRestArcs = ((Set)hypo.arcs.clone()).removeAllByName(commonArcs);
    System.out.println("hypoRestArcs:" + hypoRestArcs);

    Set goalRestArcs = ((Set)goal.arcs.clone()).removeAllByName(commonArcs);
    System.out.println("goalRestArcs:" + goalRestArcs);

    Set commonNodes = goal.commonNodes(hypo);
    System.out.println("commonNodes:" + commonNodes);

    Set hypoRestNodes = hypo.getNodes().removeAllByName(commonNodes);
    System.out.println("hypoRestNodes:" + hypoRestNodes);

    Set goalRestNodes = goal.getNodes().removeAllByName(commonNodes);
    System.out.println("goalRestNodes:" + goalRestNodes);

    Set newNodes = goal.getNewNodes(hypoRestNodes);
    System.out.println("newNodes:" + newNodes);

    Set newArcs = goal.getNewArcs(hypoRestArcs, newNodes, commonNodes);
    System.out.println("newArcs:" + newArcs);

    nodes.addAll(newNodes);
    addArcs(newArcs);

    Loop newGoal = getLoop(goalRestArcs.addAll(newArcs));
    System.out.println("newGoal:" + newGoal);

    Loop filled = getLoop(commonArcs.addAll(newArcs));
    System.out.println("filled:" + filled);
    filled.name(hypo.getName());
    filled.setColor(hypo.col);
    filled.visible();

    return newGoal;
    
  }

  Pair getNodesPair(Pair arcPair, Node n){
    Node a = ((Arc)arcPair.car).myBuddy(n);
    Node b = ((Arc)arcPair.cdr).myBuddy(n);
    return new Pair(a, b);
  }

  public void replaceInLoops(Pair arcPair){
    for (int i = 0; i < loops.size(); i++){
      ((Loop)loops.elementAt(i)).fuse(arcPair);
    }
  }

  /* if the goal is proved by fusing return zero sized Loop */
  /* if the fusing is impossible , return null */ 
  public Loop fuse(Loop goal, Node n){
    Pair arcPair = goal.getFuseArcs(n);
    if (arcPair == null)
      return null;
    Pair nodePair = getNodesPair(arcPair, n);
    if (nodePair.car == nodePair.cdr){
      removeArc((Arc)arcPair.car);
      return new Loop(new Set());
    }
    Pair nextPair = goal.getFuseNextArcs(n);

    ((Node)nodePair.cdr).replace((Node)nodePair.car);
    ((Node)nodePair.cdr).arcs = new Set();
    nodes.removeElement((Node)nodePair.cdr);
    System.out.println("loops:" + loops);

    replaceInLoops(arcPair);
    System.out.println("loops:" + loops);
    removeArc((Arc)arcPair.car);

    return goal;
  }

}
