/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
import java.awt.Graphics;
import java.awt.Color;
import java.lang.Math;
import java.awt.Polygon;
import java.util.Hashtable;

class ArcRect extends Arc {
  public int centerx, centery;
  public int controlx, controly;
  public int radius;
  public int startTheta;
  public int endTheta;
  public int kakudo;
  public int controlTheta;
  public int divAngle = 10;
  public MyPoint points[] = new MyPoint[0];
  public boolean arcflag = false;

  public ArcRect(Arc a, int cx, int cy){
    super(a.start, a.end, a.col, a.arrow, a.name);
    myReshape(cx, cy);
  }

  public ArcRect(Arc a){
    super(a.start, a.end, a.col, a.arrow, a.name);
    myReshape((start.x+end.x)/2, (start.y+end.y)/2);
  }

  public ArcRect(Node start, Node end, Color col, boolean arrow, String name){
    super(start, end, col, arrow, name);
    myReshape((start.x+end.x)/2, (start.y+end.y)/2);
  }

  public ArcRect(Node start, Node end, Color col, boolean arrow, String name, 
		 boolean arcflag, int controlx, int controly){
    super(start, end, col, arrow, name);
    this.arcflag = arcflag;
    myReshape(controlx, controly);
  }

  public ArcRect(Node start, Node end, Color col, boolean arrow){
    this(start, end, col, arrow, null);
  }

  public Arc copy(Set nodes){
//    System.out.println("copy Arc:" + start + " or "+ end);
    Arc a = super.copy(nodes);
//    System.out.println("copied Arc:" + a.start + " or "+ a.end);
    return new ArcRect(a);
  }

  public Arc copy(Node st, Node en){
    return new ArcRect(st, en, col, arrow, name);
  }

  public Arc movecopy(int x, int y, Hashtable ht){
    if (ht.containsKey(this))
      return (Arc)ht.get(this);
    Arc a = new ArcRect(start, end, col, arrow, name, arcflag, controlx +x, controly +y);
    ht.put(this, a); // to avoid infinite loop, a must be inserted before copy nodes;
    Node start0 = start.movecopy(x, y, ht);
    Node end0 = end.movecopy(x, y, ht);
    a.start = start0;
    a.end = end0;
    a.reshape();
    return a;
  }

  public void move(int x, int y){
    centerx += x;
    centery += y;
    for (int i = 0; i < points.length; i++)
      points[i].move(x,y);
  }

  public double distance(int x0, int y0){
    if (radius > 1000 || !arcflag)
      return super.distance(x0, y0);

    int tmp = angle(x0, y0);
    tmp -= startTheta;
    if (kakudo < 0 && !(tmp < 0)) tmp -= 360;
    if (kakudo > 0 && !(tmp > 0)) tmp += 360;

    if (Math.abs(kakudo) < Math.abs(tmp))
      return 100;


    double d = Math.abs(
	Math.sqrt((centerx - x0) * (centerx - x0) + 
		  (centery - y0) * (centery - y0)) - radius);
    return d;
  }

  public Arc myReshape(int cx, int cy){
    controlx = cx;
    controly = cy;
    return reshape();
  }

  public Arc reshape(int cx, int cy){
    controlx = cx;
    controly = cy;
    arcflag = true;
    return reshape();
  }

/*
  public Arc kakudoReshape(){
    double dist = start.distance(end);
    double length = (dist/2.0) / Math.abs(Math.sin(kakudo/2.0));

    double tmpx = centerx + radius * Math.cos((startTheta + kakudo/2) * Math.PI /180);
    double tmpy = centery + radius * Math.sin((startTheta + kakudo/2) * Math.PI /180);

    
  }
*/
  public Arc reshape(){
//    System.out.println(start.y +","+ end.y+","+ controly);
    
    double a1 = 0, b1 = 0, a2 = 0, b2 = 0;
    double tcenterx = 0 , tcentery = 0;

    double x1 = start.x - controlx;
    double y1 = start.y - controly;
    double x2 = end.x - controlx;
    double y2 = end.y - controly;

    if (y1 != 0){
      a1 = -x1/y1;
      b1 = ((x1 * x1) + (y1 * y1))/(2 * y1);
    }
    if (y2 != 0){    
      a2 = -x2/y2;
      b2 = ((x2 * x2) + (y2 * y2))/(2 * y2);
    }
    if (y1 == 0 && y2 != 0){
      tcenterx = x1 / 2;
      tcentery = a2 * tcenterx + b2;
    } else if (y1 != 0 && y2 == 0){ 
      tcenterx = x2 / 2;
      tcentery = a1 * tcenterx + b1;
    } else if (y1 == 0 && y2 == 0){
      tcenterx = (x1 + x2) /2;
      tcentery = 100000;
    } else {
      tcenterx = (-(b1-b2)/(a1-a2));
      tcentery = (tcenterx * a1 + b1);
    }
//    System.out.println(tcenterx +","+ tcentery);
    radius = (int) (Math.sqrt(tcenterx * tcenterx + tcentery * tcentery) + 0.5);
    centerx = controlx + (int)(tcenterx + 0.5);
    centery = controly + (int)(tcentery + 0.5);
    
    startTheta =  angle(start.x, start.y);
    endTheta =  angle(end.x, end.y);
    controlTheta = angle(controlx, controly);
    kakudo = endTheta - startTheta;
    if (kakudo < 0) kakudo += 360;
    int ckakudo = controlTheta - startTheta;
    if (ckakudo < 0) ckakudo += 360;
    if (kakudo < ckakudo)
      kakudo -= 360;
    makeupPoints();
    return this;
  }

  void makeupPoints(){
    int div = (Math.abs(kakudo) / divAngle) + 1;
    points = new MyPoint[div - 1];
    for (int i = 0; i < div - 1; i++){
      double tmpx = centerx + radius * Math.cos((startTheta + (((double)kakudo)/div) * (i+1)) * Math.PI /180);
      double tmpy = centery + radius * Math.sin((startTheta + (((double)kakudo)/div) * (i+1)) * Math.PI /180);
      points[i] = new MyPoint((int)tmpx, (int)tmpy);
    }
  }

  int  angle(int x, int y){
    int tmp = (int)(Math.atan2(((double)(y-centery)), ((double)(x- centerx)))
			    / Math.PI * 180);
    return tmp;

  }

  public String toString(){
    if (name != null)
      return name;

    return ("ArcRect: " + start.x + "," + start.y + ":" + end.x + ","+ end.y+
	    "::" +centerx + "," + centery + "," + radius); 
  }

  public double arcAngle(){
    if (radius >= 1000 || !arcflag)
      return super.arcAngle();
    if (kakudo > 0)
      return ((endTheta - 90) * Math.PI /180);
    else 
      return ((endTheta + 90) * Math.PI /180);

  }

  public MyPoint center(){
    if (radius >= 1000 || !arcflag){
      return super.center();
    }
    int tmpx = 0;
    int tmpy = 0;
    tmpx += start.x + end.x;
    tmpy += start.y + end.y;
    for (int i = 0; i < points.length; i++){
      tmpx += points[i].x;
      tmpy += points[i].y;
    }
    return new MyPoint(tmpx/(points.length+2), tmpy/(points.length+2));
  }

  public void paint(Graphics g, Color c){
    g.setColor(c);
    if (radius >= 1000 || !arcflag){
      super.paint(g, c);
    } else {
      g.drawArc(centerx-radius, centery-radius, radius*2, radius*2, -startTheta, -kakudo);
      if (name != null){
	double tmpx = centerx + radius * Math.cos((startTheta + kakudo/2) * Math.PI /180);
	double tmpy = centery + radius * Math.sin((startTheta + kakudo/2) * Math.PI /180);
	g.setFont(font);
	g.drawString(name, (int)tmpx, (int)tmpy);
      }
    }
    paintArrow(g);
  }
  public Node addNodeToPolygon(Polygon p, Node n){
    if (radius >= 1000 || !arcflag){
      return super.addNodeToPolygon(p, n);
    }
    if (n == start){
      for (int i = 0; i < points.length; i++)
	p.addPoint(points[i].x, points[i].y);
    } else {
      for (int i = points.length - 1; i >= 0 ; i--)
	p.addPoint(points[i].x, points[i].y);
    }
    return super.addNodeToPolygon(p, n);
  }

}
