/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
import java.awt.Graphics;
import java.awt.Font;
import java.awt.Color;
import java.lang.Math;
import java.awt.Polygon;
import java.util.Hashtable;

class Arc implements Namable {
  public Node start, end;
  public Color col = Color.black;
  public String name = null;
  public boolean arrow;
  public int arrowLen = 15;
  public double arrowAngle = (25.0/180.0) * Math.PI;
  public static int num = 0;
  public static Font font = new Font("Helvetica", Font.PLAIN, 24);

  public Arc(Node start0, Node end0) {
    this(start0, end0, Color.black, false);
  }

  public Arc(Node start0, Node end0, Color col0) {
    this(start0, end0, col0, false);
  }

  public Arc(Node start0, Node end0, Color col0, boolean arrow0) {
    this(start0, end0, col0, arrow0, null);
  }

  public Arc(Node start, Node end, Color col, boolean arrow, String name){
    this.start = start;
    this.end = end;
    this.col = col;
    this.arrow = arrow;
    if (name == null)
      autoName();
    else
      this.name = name;
  }

  /** copy using same named nodes */
  public Arc copy(Set nodes){
    System.out.println("Coping Nodes:" + nodes);
    Node start0 = null, end0 = null;
    start0 = (Node)nodes.getSameNameOne(start);
    end0 = (Node)nodes.getSameNameOne(end);
    if (start0 == null || end0 == null)
      System.out.println("Can't copy Node:" + start + " or "+ end);
    Arc tmp = new Arc(start0, end0, col, arrow, name);
    return tmp;
  }

  public Arc copy(Node st, Node en){
    return new Arc(st, en, col, arrow, name);
  }

  public Arc movecopy(int x, int y, Hashtable ht){
    if (ht.containsKey(this))
      return (Arc)ht.get(this);
    Arc a = new Arc(start, end, col, arrow, name);
    ht.put(this, a); // to avoid infinite loop, a must be inserted before copy nodes;
    Node start0 = start.movecopy(x, y, ht);
    Node end0 = end.movecopy(x, y, ht);
    a.start = start0;
    a.end = end0;
    return a;
  }

  public static void initNum(){
    num = 0;
  }

  public void registerSelf(){
    start.addArc(this);
    end.addArc(this);
  }

  public void autoName(){
    name = (new Integer(num)).toString();
    num++;
  }

  public void name(String n){
    name = n;
  }

  public String getName(){
    return name;
  }

  public void setColor(Color col0){
    col = col0;
  }

  public boolean compareByName(Namable a0){
    Arc a = (Arc)a0;
    if (a.getName().compareTo(getName()) == 0 &&
	a.start.getName().compareTo(start.getName()) == 0 &&
	a. end .getName().compareTo( end .getName()) == 0 )
      return true;
    return false;
  }

  public double distance(int x0, int y0){
    int minx, miny, maxx, maxy;
    if (start.x > end.x) {minx = end.x; maxx = start.x;}
    else {minx = start.x; maxx = end.x;}
    if (start.y > end.y) {miny = end.y; maxy = start.y;}
    else {miny = start.y; maxy = end.y;}
    if ((maxx - minx) > (maxy - miny)){
      if (x0 > maxx || x0 < minx) return 100;
    }else {
      if (y0 > maxy || y0 < miny) return 100;
    }
    double ax = start.x - end.x;
    double ay = start.y - end.y;
    double px = x0 - end.x;
    double py = y0 - end.y;
    double d = Math.abs(ax * py - ay * px) / Math.sqrt(ax * ax + ay * ay);
//    System.out.println(start + ": " + end + ":" + x0 + ", " + y0 + ":" + d);

    return d;
  }
  public Arc reshape(){
    return this;
  }

  public MyPoint center(){
    return new MyPoint((start.x + end.x) /2, (start.y + end.y)/2);
  }

  public void replace (Node a, Node b){
    if (start == a){
      start = b;
      registerSelf();
      reshape();
      return;
    }else if (end == a){
      end = b;
      reshape();
      registerSelf();
    }
  }

  public Arc reshape(int cx, int cy){
    Arc tmpArc = new ArcRect(this, cx, cy);
    start.replaceMe(this, tmpArc);
    end.replaceMe(this, tmpArc);
    return tmpArc;
  }
  public void move(int x, int y){
  }

  public Node myBuddy(Node p){
    if (start == p)
      return end;
    return start;
  }

  public String toString(){
    if (name != null)
      return name;
    return ("Arc: " + start.x + "," + start.y + ":" + end.x + "," + end.y); 

  }

  public boolean amIstart(Node p){
    if (start == p)
      return true;
    return false;
  }

  public boolean includes(Node p){
    if (start == p || end == p)
      return true;
    return false;
  }

  public double arcAngle(){
    return Math.atan2((double)(start.y - end.y), (double)(start.x - end.x));
  }

  public void paintArrow(Graphics g){
    if (!arrow) return;
    double angle = arcAngle();
    int end1x = (int)(arrowLen * Math.cos(angle + arrowAngle));
    int end1y = (int)(arrowLen * Math.sin(angle + arrowAngle));
    int end2x = (int)(arrowLen * Math.cos(angle - arrowAngle));
    int end2y = (int)(arrowLen * Math.sin(angle - arrowAngle));
    g.drawLine(end.x, end.y, end.x + end1x, end.y + end1y);
    g.drawLine(end.x, end.y, end.x + end2x, end.y + end2y);
  }

  public void paint(Graphics g, Color c){
    g.setColor(c);
    g.drawLine(start.x, start.y, end.x, end.y);
    g.setFont(font);
    if (name != null)
      g.drawString(name, (start.x + end.x) /2, (start.y + end.y) /2);
    paintArrow(g);

  }

  public void paint(Graphics g){
    paint(g, col);
  }

  public void paint(Graphics g, Node p){
    if (start == p)
      paint(g);
  }

  public Node addNodeToPolygon(Polygon p, Node n){
    Node buddy = myBuddy(n);
    p.addPoint(buddy.x, buddy.y);
    return buddy;
  }

}
