/* Copyright (C) 1997 Itoh Hidenori */

/* $B%X%C%@%U%!%$%k(B */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>

#include "shogi.h"

/* $B96J}$N6p%S%C%H%^%C%W%G!<%?(B */

#include "Xboard_bmp_data/gyoku.bmp"
#include "Xboard_bmp_data/kin.bmp"
#include "Xboard_bmp_data/ryuou.bmp"
#include "Xboard_bmp_data/hisha.bmp"
#include "Xboard_bmp_data/ryuma.bmp"
#include "Xboard_bmp_data/kaku.bmp"
#include "Xboard_bmp_data/nari_gin.bmp"
#include "Xboard_bmp_data/gin.bmp"
#include "Xboard_bmp_data/nari_keima.bmp"
#include "Xboard_bmp_data/keima.bmp"
#include "Xboard_bmp_data/nari_kyosha.bmp"
#include "Xboard_bmp_data/kyosha.bmp"
#include "Xboard_bmp_data/to_kin.bmp"
#include "Xboard_bmp_data/fu.bmp"

/* $B6LJ}$N6p%S%C%H%^%C%W%G!<%?(B */

#include "Xboard_bmp_data/en_gyoku.bmp"
#include "Xboard_bmp_data/en_kin.bmp"
#include "Xboard_bmp_data/en_ryuou.bmp"
#include "Xboard_bmp_data/en_hisha.bmp"
#include "Xboard_bmp_data/en_ryuma.bmp"
#include "Xboard_bmp_data/en_kaku.bmp"
#include "Xboard_bmp_data/en_nari_gin.bmp"
#include "Xboard_bmp_data/en_gin.bmp"
#include "Xboard_bmp_data/en_nari_keima.bmp"
#include "Xboard_bmp_data/en_keima.bmp"
#include "Xboard_bmp_data/en_nari_kyosha.bmp"
#include "Xboard_bmp_data/en_kyosha.bmp"
#include "Xboard_bmp_data/en_to_kin.bmp"
#include "Xboard_bmp_data/en_fu.bmp"

extern BOARD *bd ;
extern char  file[64] ;
	
Display *d ;
Window	windowID ;
GC 	gc ;
Pixmap	gyoku,kin,ryuou,hisha,ryuma,kaku,nari_gin,gin,nari_keima,keima,nari_kyosha,kyosha,to_kin,fu ;

Pixmap	en_gyoku,en_kin,en_ryuou,en_hisha,en_ryuma,en_kaku,en_nari_gin,en_gin,en_nari_keima,en_keima,en_nari_kyosha,en_kyosha,en_to_kin,en_fu ;

Window        child[40] ;
Window        yx[10][10] ;

void xkoma_visual(i)
UC i ;
{
  Pixmap temp ;

  XMapWindow(d,child[i]) ;
  if (bd->koma[i].turn == SENTE) {
    switch(bd->koma[i].code) {
    case	OU:
      temp = gyoku ;
      break ;
    case	KI:
      temp = kin ;
      break ;
    case	RY:
      temp = ryuou ;
      break ;
    case	HI:
      temp = hisha ;
      break ;
    case	UM:
      temp = ryuma ;
      break ;
    case	KA:
      temp = kaku ;
      break ;
    case	NG:
      temp = nari_gin ;
      break ;
    case	GI:
      temp = gin ;
      break ;
    case	NK:
      temp = nari_keima ;
      break ;
    case	KE:
      temp = keima ;
      break ;
    case	NY:
      temp = nari_kyosha ;
      break ;
    case	KY:
      temp = kyosha ;
      break ;
    case	TO:
      temp = to_kin ;
      break ;
    case	FU:
      temp = fu ;
      break ;
    }
  }
  else {
    switch(bd->koma[i].code) {
    case	OU:
      temp = en_gyoku ;
      break ;
    case	KI:
      temp = en_kin ;
      break ;
    case	RY:
      temp = en_ryuou ;
      break ;
    case	HI:
      temp = en_hisha ;
      break ;
    case	UM:
      temp = en_ryuma ;
      break ;
    case	KA:
      temp = en_kaku ;
      break ;
    case	NG:
      temp = en_nari_gin ;
      break ;
    case	GI:
      temp = en_gin ;
      break ;
    case	NK:
      temp = en_nari_keima ;
      break ;
    case	KE:
      temp = en_keima ;
      break ;
    case	NY:
      temp = en_nari_kyosha ;
      break ;
    case	KY:
      temp = en_kyosha ;
      break ;
    case	TO:
      temp = en_to_kin ;
      break ;
    case	FU:
      temp = en_fu ;
      break ;
    }
  }
  XSetStipple(d,gc,temp);
  XFillRectangle(d,child[i],gc,0,0,50,50);
}

void xkoma_non_visual(i) 
UC i ;
{
  XUnmapWindow(d,child[i]) ;
}

void xmove_koma_board(i) 
UC  i ;
{
  UC x,y ;

  y = bd->koma[i].yx >> 4 ;
  x = bd->koma[i].yx & 0x0f ;

  XMoveWindow(d,child[i],25 + (9 - x) * 52,25 + (y - 1) * 52) ; 
  xkoma_non_visual(i) ;
  xkoma_visual(i);
}

void xkoma_in_hand(i) 
UC i ;
{
  static int z = 0 ;
  static int x = 0 ;
  static int y = 0 ;

  if (bd->koma[i].turn == SENTE) {
    XMoveWindow(d,child[i],500 + x * 52,y + 25) ;
    xkoma_non_visual(i) ;
    xkoma_visual(i);
    z ++ ;
    x = z % 2 ;
    if (x == 0) y += 52 ;
    z = z % 18 ;
    if (z == 0) {
      x = 0 ; y = 0 ;
    }
  }
  else {
    xkoma_non_visual(i) ;    
    XMoveWindow(d,child[i],0,0) ;
  }
}

void xclosedisplay()
{
  sleep(1);
  XCloseDisplay(d);
}

void xboard() 
{
  XSetWindowAttributes att ;
  UC j ;
  int x,y ;

  if ((d = XOpenDisplay(NULL)) == 0) {
    printf("Can not Open Window on %s/n",getenv("DISPLAY"));
    exit(1);
  }
  
  if ((windowID = XCreateSimpleWindow(d,DefaultRootWindow(d),0,0,610,518,3,
				      BlackPixel(d,0),WhitePixel(d,0))) == 0) {
    printf("Window create faild.\n");
  }
  
  att.override_redirect = True ;
  XChangeWindowAttributes(d,windowID,CWOverrideRedirect,&att) ;
  
  XMapWindow(d,windowID) ;
  
  /* $B96J}%S%C%H%^%C%W%G!<%?$N:n@.(B */
  gyoku = XCreateBitmapFromData (d,windowID,gyoku_bits,
				 gyoku_width,gyoku_height) ;
  kin = XCreateBitmapFromData (d,windowID,kin_bits,
			       kin_width,kin_height) ;
  ryuou = XCreateBitmapFromData (d,windowID,ryuou_bits,
				 ryuou_width,ryuou_height) ;
  hisha = XCreateBitmapFromData (d,windowID,hisha_bits,
				 hisha_width,hisha_height) ;
  ryuma = XCreateBitmapFromData (d,windowID,ryuma_bits,
				 ryuma_width,ryuma_height) ;
  kaku = XCreateBitmapFromData (d,windowID,kaku_bits,
				kaku_width,kaku_height) ;
  nari_gin = XCreateBitmapFromData (d,windowID,nari_gin_bits,
				 nari_gin_width,nari_gin_height) ;
  gin = XCreateBitmapFromData (d,windowID,gin_bits,
				 gin_width,gin_height) ;
  nari_keima = XCreateBitmapFromData (d,windowID,nari_keima_bits,
				 nari_keima_width,nari_keima_height) ;
  keima = XCreateBitmapFromData (d,windowID,keima_bits,
				 keima_width,keima_height) ;
  nari_kyosha = XCreateBitmapFromData (d,windowID,nari_kyosha_bits,
				 nari_kyosha_width,nari_kyosha_height) ;
  kyosha = XCreateBitmapFromData (d,windowID,kyosha_bits,
				 kyosha_width,kyosha_height) ;
  to_kin = XCreateBitmapFromData (d,windowID,to_kin_bits,
				  to_kin_width,to_kin_height) ;
  fu = XCreateBitmapFromData (d,windowID,fu_bits,
			      fu_width,fu_height) ;

  /* $B6LJ}%S%C%H%^%C%W%G!<%?$N:n@.(B */
  en_gyoku = XCreateBitmapFromData (d,windowID,en_gyoku_bits,
				    en_gyoku_width,en_gyoku_height) ;
  en_kin = XCreateBitmapFromData (d,windowID,en_kin_bits,
				  en_kin_width,en_kin_height) ;
  en_ryuou = XCreateBitmapFromData (d,windowID,en_ryuou_bits,
				    en_ryuou_width,en_ryuou_height) ;
  en_hisha = XCreateBitmapFromData (d,windowID,en_hisha_bits,
				    en_hisha_width,en_hisha_height) ;
  en_ryuma = XCreateBitmapFromData (d,windowID,en_ryuma_bits,
				    en_ryuma_width,en_ryuma_height) ;
  en_kaku = XCreateBitmapFromData (d,windowID,en_kaku_bits,
				   en_kaku_width,en_kaku_height) ;
  en_nari_gin = XCreateBitmapFromData (d,windowID,en_nari_gin_bits,
				       en_nari_gin_width,en_nari_gin_height) ;
  en_gin = XCreateBitmapFromData (d,windowID,en_gin_bits,
				  en_gin_width,en_gin_height) ;
  en_nari_keima = XCreateBitmapFromData (d,windowID,en_nari_keima_bits,
					 en_nari_keima_width,en_nari_keima_height) ;
  en_keima = XCreateBitmapFromData (d,windowID,en_keima_bits,
				    en_keima_width,en_keima_height) ;
  en_nari_kyosha = XCreateBitmapFromData (d,windowID,en_nari_kyosha_bits,
					  en_nari_kyosha_width,en_nari_kyosha_height) ;
  en_kyosha = XCreateBitmapFromData (d,windowID,en_kyosha_bits,
				     en_kyosha_width,en_kyosha_height) ;
  en_to_kin = XCreateBitmapFromData (d,windowID,en_to_kin_bits,
				     en_to_kin_width,en_to_kin_height) ;
  en_fu = XCreateBitmapFromData (d,windowID,en_fu_bits,
				 en_fu_width,en_fu_height) ;
  
  gc = XCreateGC(d,windowID,0,0);
  XSetForeground(d,gc,BlackPixel(d,0));
  XSetFillStyle(d,gc,FillStippled);

  for (x=1;x<10;x++)
    for (y=1;y<10;y++) {
      yx[y][x] = XCreateSimpleWindow(d,windowID,
				     25 + (9-x) * 52,25 + (y-1) * 52,50,50,1,
				     BlackPixel(d,0),WhitePixel(d,0)) ;
    }
  
  XMapSubwindows(d,windowID);

  for (j = 0;j<39;j++) {
    child[j] = XCreateSimpleWindow(d,windowID,0,0,50,50,1,
				   BlackPixel(d,0),WhitePixel(d,0)) ;
  }

  j = bd->sente_on_board ;
  while (j != NILL) {
    xmove_koma_board(j) ;
    j = bd->koma[j].next ;
  }

  j = bd->gote_on_board ;
  while (j != NILL) {
    xmove_koma_board(j) ;
    j = bd->koma[j].next ;
  }

  j = bd->sente_in_hand ;
  while (j != NILL) {
    xkoma_in_hand(j) ;
    j = bd->koma[j].next ;
  }

  XFlush(d);
  sleep(1);
}

void xdisplay_flush() {
  int i ;
  XFlush(d);
  for (i=0;i<2000000;i++);
}
