/* Copyright (C) 1997 Itoh Hidenori */

#include "shogi.h"

extern BOARD 	*bd ;
extern UC	sente_tobi_kiki[256] ;	

/* $B@h<jHt$SMx$-%^%C%W$N99?7(B */
void check_sente_tobi(yx,vec)
UC yx,vec ;
{
    UC i ;
    
    i = yx + vec ;
    while (bd->yx[i] == EMP) {
	i += vec ;
	sente_tobi_kiki[i]++ ;
    }	
    if (bd->yx[i] == bd->ou_num) {
	i += vec ;
	sente_tobi_kiki[i]++ ;
    }
}

void sente_tobi_vec(i)
UC i;
{
    switch(bd->koma[i].code) {
      case KA:
      case UM:
	check_sente_tobi(bd->koma[i].yx,FL) ;
	check_sente_tobi(bd->koma[i].yx,FR) ;
	check_sente_tobi(bd->koma[i].yx,BL) ;
	check_sente_tobi(bd->koma[i].yx,BR) ;
	break ;
      case HI:
      case RY:
	check_sente_tobi(bd->koma[i].yx,BD) ;
	check_sente_tobi(bd->koma[i].yx,LT) ;
	check_sente_tobi(bd->koma[i].yx,RT) ;
      case KY:
	check_sente_tobi(bd->koma[i].yx,FD) ;
	break ;
    }
}

void update_sente_tobi_kiki_map()
{
    UC i,j,k,l,ptr ;
    
    for (i=1;i<10;i++) {
	k = i << 4 ;
	for (j=1;j<10;j++) {
	    l = k + j ;
	    sente_tobi_kiki[l] = 0 ;
	}
    }

    ptr = bd->sente_on_board ;
    while (ptr != NILL) {
	sente_tobi_vec(ptr);
	ptr = bd->koma[ptr].next ;
    }
}

/* pin $B$N99?7(B */
void tobi_kiki_pin(i,vec)
UC	i,vec;
{	    
    int ct = 0 ;
    UC temp,koma_num ;

    koma_num = OUT;
    for (temp = bd->koma[i].yx + vec ;temp != bd->ou_yx ;temp += vec) {
	if (bd->yx[temp] != EMP) {
	    koma_num = bd->yx[temp] ;
	    ct++ ;
	}		
	if (ct > 1) break ;
    }
    if (ct == 1) {
	bd->koma[i].pin = koma_num ;
	bd->koma[koma_num].pinf = i ;
	bd->koma[koma_num].vec = vec ;
    }
    if (ct == 0) {
	bd->koma[i].pin = EMP ;
	bd->koma[bd->ou_num].pinf = i ;
	bd->koma[bd->ou_num].vec  = vec ;
    }
    if (ct >  1) bd->koma[i].pin = OUT ;
}

void check_pin(i)
UC i ;
{
    bd->koma[i].pin = OUT ;
    switch (bd->koma[i].code) {
      case KY:
	if ((bd->koma[i].yx & 0x0f) == (bd->ou_yx & 0x0f))/* $B9a<V=D%i%$%s(B */
	    if (bd->koma[i].yx > bd->ou_yx)	
		tobi_kiki_pin(i,FD) ;			/* $B9a<V$N>e$K6L(B */
	break ;
      case HI:
      case RY:
        if ((bd->koma[i].yx & 0x0f) == (bd->ou_yx & 0x0f))/* $BHt<V=D%i%$%s(B */
	{
	    if (bd->koma[i].yx > bd->ou_yx) 
		tobi_kiki_pin(i,FD) ;  			/* $BHt<V$N>e$K6L(B */
	    if (bd->koma[i].yx < bd->ou_yx) 
		tobi_kiki_pin(i,BD) ;  			/* $BHt<V$N2<$K6L(B */
	}
	if ((bd->koma[i].yx & 0xf0) == (bd->ou_yx & 0xf0))/* $BHt<V2#%i%$%s(B */
	{
	    if (bd->koma[i].yx > bd->ou_yx) 
		tobi_kiki_pin(i,RT) ;			/* $BHt<V$N1&$K6L(B */
	    if (bd->koma[i].yx < bd->ou_yx) 
		tobi_kiki_pin(i,LT) ;			/* $BHt<V$N:8$K6L(B */
	}
	break ;
      case KA:
      case UM:
	if (((bd->koma[i].yx >> 4) - (bd->ou_yx >> 4)) ==
	    ((bd->koma[i].yx & 0x0f) - (bd->ou_yx & 0x0f)))/* $B3Q1&<P>e%i%$%s(B */
	{
	    if (bd->koma[i].yx > bd->ou_yx) 
		tobi_kiki_pin(i,FR) ;	  		/* $B3Q$N1&<P$a>e$K6L(B */
	    if (bd->koma[i].yx < bd->ou_yx) 
		tobi_kiki_pin(i,BL) ;	  		/* $B3Q$N:8<P$a2<$K6L(B */
	}
	if (-((bd->koma[i].yx >> 4) - (bd->ou_yx >> 4)) ==
	    ((bd->koma[i].yx & 0x0f) - (bd->ou_yx & 0x0f)))/* $B3Q1&<P2<%i%$%s(B */
	{
	    if (bd->koma[i].yx > bd->ou_yx)
		tobi_kiki_pin(i,FL) ;	  		/* $B3Q$N:8<P$a>e$K6L(B */
	    if (bd->koma[i].yx < bd->ou_yx) 
		tobi_kiki_pin(i,BR) ;	  		/* $B3Q$N1&<P$a2<$K6L(B */
	}
	break ;
    }
}

void set_pin_num(orig)
UC orig ;
{
    UC ptr ;
    int i ;
    
    for (i=0;i<40;i++)
	bd->koma[i].pinf = EMP ;
        
    ptr = orig ;
    while (ptr != NILL) {
	check_pin(ptr) ;
	ptr = bd->koma[ptr].next ;
    }
}

/* $B@h<jMx$-%^%C%W$N99?7(B */
void update_sente_kiki_map(code,yx,deff)
UC code,yx,deff ;
{
  UC	temp ;

  switch (code) {
  case KA:
    temp = yx + FL ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + FR ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + BL ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + BR ;
    bd->sente_kiki_map[temp] += deff ;
    break ;
  case HI:
    temp = yx + FD ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + LT ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + RT ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + BD ;
    bd->sente_kiki_map[temp] += deff ;
    break ;
  case KE:
    temp = yx + KL ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + KR ;
    bd->sente_kiki_map[temp] += deff ;
    break ;
  case OU:
  case RY:
  case UM:
    temp = yx + LT ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + RT ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + BD ;
    bd->sente_kiki_map[temp] += deff ;
  case GI:
    temp = yx + FL ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + FR ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + BL ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + BR ;
    bd->sente_kiki_map[temp] += deff ;
  case KY:
  case FU:
    temp = yx + FD ;
    bd->sente_kiki_map[temp] += deff ;
    break ;
  default:
    temp = yx + FL ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + FD ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + FR ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + LT ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + RT ;
    bd->sente_kiki_map[temp] += deff ;
    temp = yx + BD ;
    bd->sente_kiki_map[temp] += deff ;
  }
}

/* $B@h<j$N;X$7<j$K$h$k>-4}HW%G!<%?$N99?7(B */
void update_board_sente(ptr)
PLAY *ptr ;
{
  UC i,ic,fyx,tyx,nari,code,ic_code,next,prev,mochi ;
    
  i = ptr->j ;
  ic = ptr->jc ;
  fyx = ptr->from_yx ;	
  tyx = ptr->to_yx ;	
  nari = ptr->j_code & 0x01 ;
  code = ptr->j_code >> 4 ;
  ic_code = ptr->jc_code ;
  
  /* $B@h<j$NMx$-%^%C%W$N99?7(B */
  if (fyx != 0x00) {			/* $B2&<j$,BG$A<j$G$O$J$$;~(B	*/ 
    update_sente_kiki_map(code,fyx,0xff) ;
    if (code == FU) bd->sente_fu[tyx & 0x0f] = 0 ;
  }
  code ^= nari ;
  update_sente_kiki_map(code,tyx,0x01) ;
  if (code == FU) bd->sente_fu[tyx & 0x0f] = 1 ;
  /* $B@h<j6p$N>-4}HW>e$N0\F0(B */
  if (fyx == 0x00) {
    if ((code == HI) || (code == KA) || (code == KE)) (bd->tobi_koma)-- ; 
    /* $B@h<j;}$A6p%j%9%H$+$i@h<j>-4}HW>e6p%j%9%H$K0\F0(B */
    next = bd->koma[i].next ;
    prev = bd->koma[i].prev ;
    if (next != NILL) bd->koma[next].prev = prev ;
    if (prev  != NILL) bd->koma[prev].next = next ;
    else bd->sente_in_hand = next ;
	
    if (bd->sente_on_board != NILL)
      bd->koma[bd->sente_on_board].prev = i ;
    bd->koma[i].next = bd->sente_on_board ;
    bd->koma[i].prev = NILL ;
    bd->sente_on_board = i ;
  }
  else
    bd->yx[fyx] = EMP ;
    
  bd->koma[i].yx = tyx ;
  bd->koma[i].code = code ;
  bd->yx[tyx] = i ;
  /* $BAj<j$N6p$rJa3M$7$?;~$N=hM}(B */
  if ((ic != EMP) && (ic != AIGOMA)) {
    (bd->sente_koma_num)++ ;
    if ((ic_code == RY) || (ic_code == HI) ||
	(ic_code == UM) || (ic_code == KA) ||
	(ic_code == KE) || (ic_code == NK) ) (bd->tobi_koma)++ ;
   
    /* $B#2Jb%U%i%0$N99?7(B */
    if (ic_code == FU) bd->gote_fu[tyx & 0x0f] = 0 ;
    /* $B8e<j>-4}HW>e6p%j%9%H$+$i@h<j;}$A6p%j%9%H$K0\F0(B */
    next = bd->koma[ic].next ;
    prev = bd->koma[ic].prev ;
    if (next != NILL) bd->koma[next].prev = prev ;
    if (prev  != NILL) bd->koma[prev].next = next ;
    else bd->gote_on_board = next ;
	
    if (bd->sente_in_hand != NILL) {
      mochi = bd->sente_in_hand ;
      while (bd->koma[mochi].next != NILL)
	mochi = bd->koma[mochi].next ;
      bd->koma[mochi].next = ic ;
      bd->koma[ic].prev = mochi ;
    }
    else {
      bd->sente_in_hand = ic ;
      bd->koma[ic].prev = NILL ;
    }
    bd->koma[ic].next = NILL ;

/*
    if (bd->sente_in_hand != NILL)
      bd->koma[bd->sente_in_hand].prev = ic ;
    bd->koma[ic].next = bd->sente_in_hand ;
    bd->koma[ic].prev = NILL ;
    bd->sente_in_hand = ic ;
*/
	
    bd->koma[ic].yx = 0x00 ;
    bd->koma[ic].turn = SENTE ;
    if (ic_code != KI)
      bd->koma[ic].code |= 0x01 ;
  }
}

void reupdate_board_sente(ptr)
PLAY *ptr ;
{
  UC i,ic,fyx,tyx,nari,code,ic_code,next,prev ;
    
  i = ptr->j ;
  ic = ptr->jc ;
  fyx = ptr->from_yx ;	
  tyx = ptr->to_yx ;
  nari = ptr->j_code & 0x01 ;
  code = ptr->j_code >> 4 ;
  nari ^= code ;
  ic_code = ptr->jc_code ;
    
  /* $BJa3M$7$?Aj<j$N6p$r85$KLa$9(B */
  if ((ic != EMP) && (ic != AIGOMA)) {
    (bd->sente_koma_num)-- ;
    if ((ic_code == RY) || (ic_code == HI) ||
	(ic_code == UM) || (ic_code == KA) ||
	(ic_code == KE) || (ic_code == NK) ) (bd->tobi_koma)-- ;
    bd->yx[tyx] = ic ;
    bd->koma[ic].yx = tyx ;
    bd->koma[ic].turn = GOTE ;
    bd->koma[ic].code = ic_code ;
    /* $B8e<j#2Jb%U%i%0$NI|85(B */
    if (ic_code == FU) bd->gote_fu[tyx & 0x0f] = 1 ;
    /* $B@h<j;}$A6p%j%9%H$+$i8e<j>-4}HW>e6p%j%9%H$K0\F0(B */
    next = bd->koma[ic].next ;
    prev = bd->koma[ic].prev ;
    if (next != NILL) bd->koma[next].prev = prev ;
    if (prev  != NILL) bd->koma[prev].next = next ;
    else bd->sente_in_hand = next ;
    
    if (bd->gote_on_board != NILL)
      bd->koma[bd->gote_on_board].prev = ic ;
    bd->koma[ic].next = bd->gote_on_board ;
    bd->koma[ic].prev = NILL ;
    bd->gote_on_board = ic ;
  }
  else
    bd->yx[tyx] = ic ;
    
  /* $B@h<j$NMx$-%^%C%W$NI|85(B */
  if (nari == FU) bd->sente_fu[tyx & 0x0f] = 0 ;
  update_sente_kiki_map(nari,tyx,0xff) ;
  /* $B@h<j6p$N>-4}HW>e$N0\F0(B */
  if (fyx != 0x00) {			/* $B2&<j$,BG$A<j$G$O$J$$;~(B	*/ 
    update_sente_kiki_map(code,fyx,0x01) ;
    if (code == FU) bd->sente_fu[fyx & 0x0f] = 1 ;
    bd->yx[fyx] = i ;
  }
  else {
    if ((code == HI) || (code == KA) || (code == KE)) (bd->tobi_koma)++ ;
    /* $B@h<j>-4}HW>e6p%j%9%H$+$i@h<j;}$A6p%j%9%H$K0\F0(B */
    next = bd->koma[i].next ;
    prev = bd->koma[i].prev ;
    if (next != NILL) bd->koma[next].prev = prev ;
    if (prev  != NILL) bd->koma[prev].next = next ;
    else bd->sente_on_board = next ;
    
    if (bd->sente_in_hand != NILL)
      bd->koma[bd->sente_in_hand].prev = i ;
    bd->koma[i].next = bd->sente_in_hand ;
    bd->koma[i].prev = NILL ;
    bd->sente_in_hand = i ;
  }
  bd->koma[i].yx = fyx ;
  bd->koma[i].code = code ;
}

/* $B8e<j$N;X$7<j$K$h$k>-4}HW%G!<%?$N99?7(B */
void update_board_gote(ptr)
PLAY *ptr ;
{
  UC i,ic,fyx,tyx,nari,code,ic_code,next,prev ;
    
  i = ptr->j  ;
  if (i != AIGOMA) {
    ic = ptr->jc  ;
    fyx = ptr->from_yx ;	
    tyx = ptr->to_yx ;	
    nari = ptr->j_code & 0x01 ;
    code = ptr->j_code >> 4 ;
    ic_code = ptr->jc_code ;
    /* $B8e<j$NMx$-%^%C%W$N99?7(B */
    if (fyx != 0x00)		/* $B8e<j$,BG$A<j$G$O$J$$;~(B	*/ 
      if (code == FU) bd->gote_fu[tyx & 0x0f] = 0 ;
    code ^= nari ;
    if (code == FU) bd->gote_fu[tyx & 0x0f] = 1 ;
    /* $B8e<j6p$N>-4}HW>e$N0\F0(B */
    if (fyx == 0x00) {
      /* $B8e<j;}$A6p%j%9%H$+$i8e<j>-4}HW>e6p%j%9%H$K0\F0(B */
      next = bd->koma[i].next ;
      prev = bd->koma[i].prev ;
      if (next != NILL) bd->koma[next].prev = prev ;
      if (prev  != NILL) bd->koma[prev].next = next ;
      else bd->gote_in_hand = next ;
      
      if (bd->gote_on_board != NILL)
	bd->koma[bd->gote_on_board].prev = i ;
      bd->koma[i].next = bd->gote_on_board ;
      bd->koma[i].prev = NILL ;
      bd->gote_on_board = i ;
    }
    else
      bd->yx[fyx] = EMP ;
    
    bd->koma[i].yx = tyx ;
    bd->koma[i].code = code ;
    bd->yx[tyx] = i ;
    /* $BAj<j$N6p$rJa3M$7$?;~$N=hM}(B */
    if (ic != EMP) {
      (bd->sente_koma_num)-- ;
      /* $B@h<jMx$-%^%C%W$N99?7(B */
      update_sente_kiki_map(ic_code,tyx,0xff) ;
      /* $B#2Jb%U%i%0$N99?7(B */
      if (ic_code == FU) bd->sente_fu[tyx & 0x0f] = 0 ;
      /* $B@h<j>-4}HW>e6p%j%9%H$+$i8e<j;}$A6p%j%9%H$K0\F0(B */
      next = bd->koma[ic].next ;
      prev = bd->koma[ic].prev ;
      if (next != NILL) bd->koma[next].prev = prev ;
      if (prev  != NILL) bd->koma[prev].next = next ;
      else bd->sente_on_board = next ;
	
      if (bd->gote_in_hand != NILL)
	bd->koma[bd->gote_in_hand].prev = ic ;
      bd->koma[ic].next = bd->gote_in_hand ;
      bd->koma[ic].prev = NILL ;
      bd->gote_in_hand = ic ;
      
      bd->koma[ic].yx = 0x00 ;
      bd->koma[ic].turn = GOTE ;
      if (ic_code != KI)
	bd->koma[ic].code |= 0x01 ;
    }
    /* $B6L$N0LCV$N99?7(B */
    bd->ou_yx = bd->koma[bd->ou_num].yx ;
  }
}

void reupdate_board_gote(ptr)
PLAY *ptr ;
{
  UC i,ic,fyx,tyx,nari,code,ic_code,next,prev ;
  
  i = ptr->j ;
  if (i != AIGOMA) {
    ic = ptr->jc ;
    fyx = ptr->from_yx ;	
    tyx = ptr->to_yx ;	
    nari = ptr->j_code & 0x0f ;
    code = ptr->j_code >> 4 ;
    nari ^= code ;
    ic_code = ptr->jc_code ;
    
    /* $BJa3M$7$?Aj<j$N6p$r85$KLa$9(B */
    if (ic != EMP) {
      (bd->sente_koma_num)++ ;
      bd->yx[tyx] = ic ;
      bd->koma[ic].yx = tyx ;
      bd->koma[ic].turn = SENTE ;
      bd->koma[ic].code = ic_code ;
      /* $B@h<jMx$-%^%C%W$NI|85(B */
      update_sente_kiki_map(ic_code,tyx,0x01) ;
      /* $B@h<j#2Jb%U%i%0$NI|85(B */
      if (ic_code == FU) bd->sente_fu[tyx & 0x0f] = 1 ;
      /* $B8e<j;}$A6p%j%9%H$+$i@h<j>-4}HW>e6p%j%9%H$K0\F0(B */
      next = bd->koma[ic].next ;
      prev = bd->koma[ic].prev ;
      if (next != NILL) bd->koma[next].prev = prev ;
      if (prev  != NILL) bd->koma[prev].next = next ;
      else bd->gote_in_hand = next ;
      
      if (bd->sente_on_board != NILL)
	bd->koma[bd->sente_on_board].prev = ic ;
      bd->koma[ic].next = bd->sente_on_board ;
      bd->koma[ic].prev = NILL ;
      bd->sente_on_board = ic ;
    }
    else
      bd->yx[tyx] = EMP ;

    /* $B8e<j#2Jb%U%i%0$NI|85(B */
    if (nari == FU) bd->gote_fu[tyx & 0x0f] = 0 ;
    /* $B8e<j6p$N>-4}HW>e$N0\F0(B */
    if (fyx != 0x00){			/* $B<j$,BG$A<j$G$O$J$$;~(B	*/ 
      if (code == FU) bd->gote_fu[fyx & 0x0f] = 1 ;
      bd->yx[fyx] = i ;
    }
    else {
      /* $B8e<j>-4}HW>e6p%j%9%H$+$i8e<j;}$A6p%j%9%H$K0\F0(B */
      next = bd->koma[i].next ;
      prev = bd->koma[i].prev ;
      if (next != NILL) bd->koma[next].prev = prev ;
      if (prev  != NILL) bd->koma[prev].next = next ;
      else bd->gote_on_board = next ;
	
      if (bd->gote_in_hand != NILL)
	bd->koma[bd->gote_in_hand].prev = i ;
      bd->koma[i].next = bd->gote_in_hand ;
      bd->koma[i].prev = NILL ;
      bd->gote_in_hand = i ;
    }
    bd->koma[i].yx = fyx ;
    bd->koma[i].code = code ;
    /* $B6L$N0LCV$NI|85(B */
    bd->ou_yx = bd->koma[bd->ou_num].yx ;
  }
}

