/* Copyright (C) 1997 Itoh Hidenori */

#include "shogi.h"
#include "proc.h"

extern BOARD		*bd ;
extern UC 		sente_tobi_kiki[256] ;	

extern TREE_LIST_SENTE	*tree_sente ;
extern TREE_LIST_GOTE	*tree_gote ;

extern USI		*memory_use_gote ;

extern int 	kiki_table();
extern void 	update_board_sente();
extern void	reupdate_board_sente();
extern void	update_board_gote();
extern void	reupdate_board_gote();
extern void	update_sente_tobi_kiki_map() ;
extern void 	set_pin_num();
extern void 	move_koma();
extern void     uke_move();
extern void     ukete_gyoku_nige() ;
extern void	ukete_idou_ai() ;
extern void	uke_aigoma();
extern void 	load_data();
extern void	print_list();
extern void	print_te();
extern void	rm_list();
extern void 	send_and_recv_msg();
extern void 	add_tree_list();
extern void     search_tree();
extern void	reconstruct_tree();
extern int	present_sashite();
extern int	index_fuc();
extern void	check_move_ote();
extern void	check_uchi_ote();
    
/* $B2&<j(B ptr $B$KBP$9$k8e<j$N<u$1<j$r9M$($k(B		*/
void gote_ukete(node,head,rear,get_ai_tumi)
USI 		node,head,rear ;
int		get_ai_tumi ;
{
  TREE_LIST_GOTE *tree ;
  int flag = 0 ;
  int node_point = TUMAZU ;
  TREE_LIST_SENTE *ote ;
  UC	temp,code ;
    
  tree = &(tree_gote[node]) ;
  while (head != rear) {
    ote = &(tree_sente[head]) ; 
    
    /* $B2&<j$K=>$C$F>-4}HW$N%G!<%?$rJQ99(B			*/
    update_board_sente(&(ote->play));
    
    /* $BHt$SMx$-%^%C%W$N99?7(B 				*/
    update_sente_tobi_kiki_map() ;
    
    /* pin $B$N99?7(B 					*/
    set_pin_num(bd->sente_on_board);

    if (ote->link != LINK_SLAVE) {
      ote->get_head = ote->get_rear = *memory_use_gote ;
      /* $BD>@\$V$D$1$F$-$?2&<j6p$r>-4}HW>e$N6p$rF0$+$7<h$k(B	*/
      uke_move(head,ote,&(ote->get_rear),1);
      *memory_use_gote = ote->get_rear ;
    }
    else {
      ote->get_head = tree_sente[head - 1].get_head ;
      ote->get_rear = tree_sente[head - 1].get_rear ;
    }
      
    ote->away_head = ote->away_rear = *memory_use_gote ;
    /* $B6L$rF(Hr$9$k!"$^$?$O6u$-2&<j$N6p$r<h$k(B			*/
    uke_move(head,ote,&(ote->away_rear),0);
    /* $B0\F09g6p(B							*/
    ukete_idou_ai(head,&(ote->away_rear)) ;
    *memory_use_gote = ote->away_rear ;
    
    flag = (ote->get_head != ote->get_rear) || 
      (ote->away_head != ote->away_rear) ;
    
    ote->ai_head = ote->ai_rear = *memory_use_gote + 1 ;
/*
    if (!get_ai_tumi || ((tree->play.from_yx != 0x00) && (tree->play.j != ote->play.jc))) {
*/
    if (!get_ai_tumi) {
      /* $B9g6p$GF(Hr$9$k(B					*/
      uke_aigoma(head,&(ote->ai_rear),flag) ;
   
      if (ote->ai_head != ote->ai_rear) {
	*memory_use_gote = ote->ai_rear ;
	tree_gote[ote->away_rear].play = tree_gote[ote->ai_head].play ;
	code = tree_gote[ote->away_rear].play.j_code >> 4 ;
	temp = bd->gote_in_hand ;
	while (bd->koma[temp].code != code) temp = bd->koma[temp].next ;
	tree_gote[ote->away_rear].play.j = temp ;
	tree_gote[ote->away_rear].link 		= NON_LINK ;
	tree_gote[ote->away_rear].leaf		= UKETE_LEAF ;
	tree_gote[ote->away_rear].point         = 0 ;
	tree_gote[ote->away_rear].tesu          = 0 ;
	tree_gote[ote->away_rear].parent        = head ;
	tree_gote[ote->away_rear].get_ai_tumi     = 0 ;
	tree_gote[ote->away_rear].pre_get_ai_tumi = 0 ;
	(ote->away_rear)++ ;
	flag = 1 ;
      }
    }
    
    if (!flag) {
      if ((ote->play.from_yx == 0x00) &&
	  ((ote->play.j_code >> 4 ) == FU)) 
      {
	ote->leaf = CLOSE_NODE ;
	ote->point = TUMAZU ;
      }
      else {
	if (bd->sente_in_hand == NILL)
	  ote->point = TUMI ;
	else
	  ote->point = TUMI_MOCHIGOMA_SENTE ;
	flag = 1 ;
      }
    }
    else {
      flag = 0 ;
      ote->point = index_fuc(ote);
    }
    
#ifdef DEBUG1
    printf ("===================================\n$B2&<j(B\n");
    /* $B2&<j$NI=<((B $B%G%P%C%0MQ(B			*/
    print_te(&(ote->play));
    /* $B<u<j$NI=<((B $B%G%P%C%0MQ(B 			*/
    printf ("$B<u$1<j(B\n");
    print_list(ote) ;
    if (ote->point == TUMI) printf ("$B5M$_(B\n");
    if (ote->point == TUMI_MOCHIGOMA_SENTE) printf ("$B;}$A6pM-$j$G5M$_(B\n");
    if (ote->point == TUMAZU)	printf ("$BIT5M$HH=CG(B\n");
#endif	
	
    /* $B0l$D>e$N>uBV$NI>2ACM(B node_point $B$r7W;;(B */
    if (node_point > ote->point) 
      node_point = ote->point ;

    /* $B2&<j$NA0$N>uBV$K>-4}HW$N%G!<%?$rJQ99(B	*/
    reupdate_board_sente(&(ote->play));

    head ++ ;
    /* $B2&<j(B (ote) $B$G5M$`$3$H$,$o$+$C$?$i!"(B
       $BB>$N2&<j$OI>2A$7$J$$(B */
    if (flag)
      while (head != rear) {
	
	head ++ ;
      }
  }
  
  /* $BHt$SMx$-%^%C%W$NI|85(B */
  update_sente_tobi_kiki_map() ;
  /* pin $B$NI|85(B */
  set_pin_num(bd->sente_on_board) ;
  if (node_point == TUMI_MOCHIGOMA_SENTE)
      node_point = TUMI_MOCHIGOMA_GOTE ;
  if (node_point < TUMISO) tree->leaf = CLOSE_NODE ;
  tree->point = node_point ;
}
