/* Copyright (C) 1997 Itoh Hidenori */

#include "shogi.h"

#define 	GAP_SENTE	500
#define 	GAP_GOTE	1000

extern BOARD	*bd ;

extern TREE_LIST_SENTE	*tree_sente ;
extern TREE_LIST_GOTE	*tree_gote ;
extern USI		*memory_use_sente,*memory_use_gote ;
extern int		process_run ;

extern void	print_te() ;
extern void     update_board_sente() ;
extern void     update_board_gote() ;
extern void     reupdate_board_sente() ;
extern void     reupdate_board_gote() ;
extern void     search_gote_tree() ;
extern int	muda_ai_process() ;

void set_depth_and_point(ote,max_depth,max_point)
TREE_LIST_SENTE *ote ;
SI    		*max_depth,*max_point ;
{
  USI   head , rear ;

  /*	$B:GBg?<$5$r5a$a$k(B	*/
  *max_depth = 0 ;
  head = ote->get_head ;
  rear = ote->get_rear ;
  while (head != rear) {
    if (tree_gote[head].tesu > *max_depth)
      *max_depth = tree_gote[head].tesu ;
    head ++ ;
  } 
  head = ote->away_head ;
  rear = ote->away_rear ;
  while (head != rear) {
    if (tree_gote[head].tesu > *max_depth)
      *max_depth = tree_gote[head].tesu ;
    head ++ ;
  } 
  /*	$B:GBg?<$5$r;}$D%N!<%I$N:GBgCM$r%;%C%H(B	*/
  *max_point = TUMI - 100 ;
  head = ote->get_head ;
  rear = ote->get_rear ;
  while (head != rear) {
    if ((tree_gote[head].point > *max_point) && 
	(*max_depth == tree_gote[head].tesu)) 
      *max_point = tree_gote[head].point ;
    head ++ ;
  } 
  head = ote->away_head ;
  rear = ote->away_rear ;
  while (head != rear) {
    if ((tree_gote[head].point > *max_point) && 
	(*max_depth == tree_gote[head].tesu))
      *max_point = tree_gote[head].point ;
    head ++ ;
  }
}

void search_sente_tree(node,ukete,flag)
USI	node ;
PLAY	*ukete ;
int	flag ;
{
  TREE_LIST_SENTE	*ote ;
  TREE_LIST_GOTE	*temp_node ;	
  USI	head , rear , tmp_sente_use , tmp_gote_use ;
  SI	max_depth,sigma_point ;
/*SI    max_point ; */
  
  if (*memory_use_sente + GAP_SENTE > MEMORY_SIZE_SENTE) {
#ifdef DEBUG
    printf ("Using Memory SENTE = %d  EXIT\n",*memory_use_sente) ;
#endif
    process_run = 0;
    return ;
  }
  if (*memory_use_gote + GAP_GOTE > MEMORY_SIZE_GOTE) {
#ifdef DEBUG
    printf ("Using Memory GOTE = %d EXIT\n",*memory_use_gote);
#endif
    process_run = 0;
    return ;
  }

  ote = &(tree_sente[node]) ;
  switch(ote->leaf) {
  case CLOSE_NODE:
    break ;
  case NODE:
  case OTE_LEAF:
    ote->access_times += 1 ;
    ote->leaf = NODE ;
    if (ote->play.state) {
      ote->leaf = CLOSE_NODE ;
      ote->point = TUMAZU ;
      ote->tesu = TUMAZU ;
      return ;
    }
    max_depth = 0 ;
/*  max_point = TUMI - 100 ; */
    sigma_point = TUMI - 100 ;
    
    /*	$BF(Hr<u<j$rD4$Y$k(B			*/
    head = ote->away_head ;
    rear = ote->away_rear ;
    
    if (flag) {
      while (head != rear) {
	temp_node = &(tree_gote[head]) ;
	
	/* $B;X<j$K=>$$!">-4}HW$N%G!<%?$r99?7(B */
	update_board_gote(&(temp_node->play));
	
	/* $B%N!<%I(B temp $B0J2<$rC5:w(B */
	search_gote_tree(head,&(ote->play),0) ;

	/* $B;X<j$K=>$$!">-4}HW$N%G!<%?$rI|85(B */	
	reupdate_board_gote(&(temp_node->play));
	
	if (max_depth < temp_node->tesu) max_depth = temp_node->tesu ;
/*	if (max_point < temp_node->point)
	  max_point = temp_node->point ; */
	if (temp_node->point == TUMAZU)
	  sigma_point = TUMAZU ;
	else {
          if (((temp_node->point < 0) && (temp_node->point > sigma_point)) ||
	      ((temp_node->point >= 0) && (sigma_point < 0)))
	    sigma_point = temp_node->point ;
	  else if (temp_node->point >= 0)
	         sigma_point += temp_node->point ;
        }
/*	if (max_point == TUMAZU) */
        if (sigma_point == TUMAZU) {
	  head = rear ;
	}
	else	{
	  head ++ ;
	  if (!process_run) goto memory_full ;
	}
      }
    }
    else {
      while (head != rear) {
	temp_node = &(tree_gote[head]) ;
	if (max_depth < temp_node->tesu) max_depth = temp_node->tesu ;
/*	if (max_point < temp_node->point)
	  max_point = temp_node->point ; */
	if (temp_node->point == TUMAZU)
	  sigma_point = TUMAZU ;
        else {
	  if (((temp_node->point < 0) && (temp_node->point > sigma_point)) ||
	      ((temp_node->point >= 0) && (sigma_point < 0)))
	    sigma_point = temp_node->point ;
	  else if (temp_node->point >= 0)
	         sigma_point += temp_node->point ;
        }
/*	if (max_point == TUMAZU) */
	if (sigma_point == TUMAZU) head = rear ;
	else  head ++ ;
      }
    }
      	
/*  if (max_point == TUMAZU) */
    if (sigma_point == TUMAZU) {
      switch(ote->link) {
      case LINK_MASTER:
	tree_sente[node + 1].link = NON_LINK ;
	ote->link = NON_LINK ;
	head = ote->get_head ;
	rear = ote->get_rear ;
	while (head != rear) {
	  tree_gote[head].play.jc_code |= 0x01 ;
	  tree_gote[head].parent = node + 1 ;
	  head ++ ;
	}
	ote->get_head = ote->get_rear ;
	ote->leaf = CLOSE_NODE ;
	break ;
      case LINK_SLAVE:
	tree_sente[node - 1].link = NON_LINK ;
	ote->link = NON_LINK ;
	ote->get_rear = ote->get_head ;
	ote->leaf = CLOSE_NODE ;
	break ;
      }
    }
    else {
      if (ote->link == LINK_SLAVE) {
	head = ote->get_head ;
	while (head != ote->get_rear) {
	  if (max_depth < tree_gote[head].tesu) 
	    max_depth = tree_gote[head].tesu ;
/*	  if (max_point < tree_gote[head].point)
	    max_point = tree_gote[head].point ; */
          if (((tree_gote[head].point < 0) && (tree_gote[head].point > sigma_point)) ||
	      ((tree_gote[head].point >= 0) && (sigma_point < 0)))
	    sigma_point = tree_gote[head].point ;
	  else if (tree_gote[head].point >= 0)
	         sigma_point += tree_gote[head].point ;
	  head++ ;
	}	
      }
      else {
	head = ote->get_head ;
	rear = ote->get_rear ;
	
	while (head != rear) {
	  temp_node = &(tree_gote[head]) ;
	  
	  /* $B;X<j$K=>$$!">-4}HW$N%G!<%?$r99?7(B */
	  update_board_gote(&(temp_node->play));
	  
	  /* $B%N!<%I(B head $B0J2<$rC5:w(B */
	  search_gote_tree(head,&(ote->play),0) ;
	  
	  /* $B;X<j$K=>$$!">-4}HW$N%G!<%?$rI|85(B */
	  reupdate_board_gote(&(temp_node->play));
	                  
	  if (max_depth < temp_node->tesu) max_depth = temp_node->tesu ;
/*        if (max_point < temp_node->point)
	    max_point = temp_node->point ; */
	  if (temp_node->point == TUMAZU)
	    sigma_point = TUMAZU ;
	  else {
            if (((temp_node->point < 0) && (temp_node->point > sigma_point)) ||
		((temp_node->point >= 0) && (sigma_point < 0)))
	      sigma_point = temp_node->point ;
	    else if (temp_node->point >= 0)
		   sigma_point += temp_node->point ;
	  }
/*	  if (max_point == TUMAZU) */
          if (sigma_point == TUMAZU) {	
	    head = rear ;
	    if (ote->link == LINK_MASTER) tree_sente[node + 1].play.state = 1 ;
	  }
	  else      {
	    head ++ ;
	    if (!process_run) goto memory_full ;
	  }
	}
      }
    }
    
    /*	$B9g6p$r;H$o$J$$$H5M$s$G$7$^$&(B		*/
/*  if ((max_point < TUMISO) && (ote->ai_head != ote->ai_rear)) {
      set_depth_and_point(ote,&max_depth,&max_point) ;     
      muda_ai_process(node,&max_point,&max_depth) ; */
    if ((sigma_point < TUMISO) && (ote->ai_head != ote->ai_rear)) {
      set_depth_and_point(ote,&max_depth,&sigma_point) ;
      muda_ai_process(node,&sigma_point,&max_depth) ;
      if (!process_run) {
	goto memory_full ;
      }
      /**************************************************/
      /*						*/
      /*	$BL5BL9g=hM}Cf$K%a%b%j$,%U%k$K$J$C$?;~(B   	*/
      /*	$B2>$N=hCV(B				*/
      /*						*/
      /**************************************************/
    }
    
/*  if (max_point < TUMISO) 
      set_depth_and_point(ote,&max_depth,&max_point) ; */
    if (sigma_point < TUMISO)
      set_depth_and_point(ote,&max_depth,&sigma_point) ;

/*  if (max_point == TUMI_MOCHIGOMA_GOTE)
      max_point = TUMI_MOCHIGOMA_SENTE ; */
    if (sigma_point == TUMI_MOCHIGOMA_GOTE)
      sigma_point = TUMI_MOCHIGOMA_SENTE ;
    ote->tesu = max_depth + 1 ;
/*  if (max_point == TUMAZU) */
    if (sigma_point == TUMAZU) {
      max_depth = TUMAZU ;
      ote->play.state = 1 ;
      ote->leaf = CLOSE_NODE ;
    }
/*  ote->point = max_point ; */
    ote->point = sigma_point ;
    break ;
  }
  return ;
  
 memory_full:
  head = ote->get_head ;
  rear = ote->get_rear ;
/*max_point = TUMI - 100 ; */
  sigma_point = TUMI - 100 ;
  max_depth = 0 ;
  while (head != rear) {
/*  if (tree_gote[head].point > max_point)
      max_point = tree_gote[head].point ; */
    if (((tree_gote[head].point < 0) && (tree_gote[head].point > sigma_point)) ||
	((tree_gote[head].point >= 0) && (sigma_point < 0)))
      sigma_point = tree_gote[head].point ;
    else if (tree_gote[head].point >= 0)
	   sigma_point += tree_gote[head].point ;
    if (tree_gote[head].tesu > max_depth)
      max_depth = tree_gote[head].tesu ;
    head ++ ;
  } 
  head = ote->away_head ;
  rear = ote->away_rear ;
  while (head != rear) { 
/*  if (tree_gote[head].point > max_point)
      max_point = tree_gote[head].point ; */
    if (((tree_gote[head].point < 0) && (tree_gote[head].point > sigma_point)) ||
        ((tree_gote[head].point >= 0) && (sigma_point < 0)))
      sigma_point = tree_gote[head].point ;
    else if (tree_gote[head].point >= 0)
           sigma_point += tree_gote[head].point ;
    if (tree_gote[head].tesu > max_depth)
      max_depth = tree_gote[head].tesu ;
    head ++ ;
  } 
  
/*if (max_point == TUMI_MOCHIGOMA_GOTE)
    max_point = TUMI_MOCHIGOMA_SENTE ; */
  if (sigma_point == TUMI_MOCHIGOMA_GOTE)
    sigma_point = TUMI_MOCHIGOMA_SENTE ;
  ote->tesu = max_depth + 1 ;
/*if (max_point == TUMAZU) */
  if (sigma_point >= TUMAZU) {
    sigma_point = TUMAZU ;
    max_depth = TUMAZU ;
    ote->play.state = 1 ;
    ote->leaf = CLOSE_NODE ;
  }
/*ote->point = max_point ; */
  ote->point = sigma_point ;
}
