/* Copyright (C) 1997 Itoh Hidenori */

#include "shogi.h"

extern BOARD		*bd ;
extern int		process_run ;

extern TREE_LIST_SENTE	*tree_sente ;
extern TREE_LIST_GOTE	*tree_gote ;

extern USI		*memory_use_sente ;
extern USI             	*memory_use_gote ;

extern void		print_te() ;
extern void		set_pin_num() ;
extern void     	update_board_sente() ;
extern void     	update_board_gote() ;
extern void     	reupdate_board_sente() ;
extern void     	reupdate_board_gote() ;
extern void     	search_gote_tree() ;
extern int 		select_kai() ;

int	kind_of_ai(ai_yx,code,ai_num) 
UC	ai_yx,code,*ai_num ;
{
  
  switch(code) {
  case KY:
    if (ai_yx > 0x8f) return 0 ;		/*	$BF0$1$J$$(B	*/
    break ;
  case KE:
    if (ai_yx > 0x7f) return 0 ;		/*      $BF0$1$J$$(B        */
    break ;
  }

  *ai_num = bd->gote_in_hand ;
  while ((*ai_num != NILL) && (bd->koma[*ai_num].code != code)) *ai_num = bd->koma[*ai_num].next ;
  if (*ai_num == NILL) return 0 ;			/*	$B6p(B code $B$O@Z$l$F$$$k(B	*/

  return 1 ;
}

SI	other_ai(ote,num,ai_num,code,max_depth,max_point,get_ai_tumi)
PLAY	*ote ;
USI	num;
SI	*max_depth,*max_point ;
UC	ai_num,code ;
int	get_ai_tumi ;
{
  USI	pre_memory_use_sente,pre_memory_use_gote ;
  SI	pre_max_depth ;
  int	flag = 1 ;
  
  pre_memory_use_sente	= *memory_use_sente ;
  pre_memory_use_gote	= *memory_use_gote ;

  tree_gote[num].play.from_yx	= 0 ;
  tree_gote[num].play.j 	= ai_num ;
  tree_gote[num].play.jc 	= EMP ;
  tree_gote[num].play.j_code 	= code << 4 ; 
  tree_gote[num].play.jc_code 	= EMP ;
  tree_gote[num].leaf 		= UKETE_LEAF ;
  tree_gote[num].point		= 0 ;
  
  update_board_gote(&(tree_gote[num].play)) ;
  set_pin_num(bd->sente_on_board) ;
  pre_max_depth = *max_depth ;
  
  while ((tree_gote[num].point > TUMISO) && (tree_gote[num].point < 3) && process_run)
    search_gote_tree(num,ote,get_ai_tumi);

  reupdate_board_gote(&(tree_gote[num].play)) ;

  if (process_run) {
    if ((tree_gote[num].point == TUMAZU) || (tree_gote[num].tesu > *max_depth) ||
	((tree_gote[num].point > *max_point) && 
	 (tree_gote[num].tesu == *max_depth ))) {
      *max_point = tree_gote[num].point ;
      *max_depth = tree_gote[num].tesu ; 
      tree_gote[num - 1] = tree_gote[num] ;
      flag = 0 ;
    }
    if (tree_gote[num].point > 2){
      *max_point = tree_gote[num].point ;
      flag = 0 ;
    }
        
    if ((tree_gote[num].point == TUMAZU) || (flag)) {
      *memory_use_sente	= pre_memory_use_sente ;
      *memory_use_gote	= pre_memory_use_gote ;
    }
  }
  
  return tree_gote[num].point ;
}

int  get_ai_tumi_fuc(addrs)
USI	addrs ;
{
  UC	turn ;
  SI	pt ;
  USI	ptr ;
  
  turn = GOTE ;  ptr = addrs ;
  pt = tree_gote[addrs].point ;
  select_kai(&turn,&ptr,&pt) ;
  if (tree_sente[ptr].play.jc == tree_gote[addrs].play.j) 
    return 1 ;
  else
    return 0 ;
}	

void	muda_ai_process(node,max_point,max_depth)
USI	node ;
SI	*max_point,*max_depth ;
{
  TREE_LIST_SENTE	*ote ;
  TREE_LIST_GOTE	*ai_node ;
  USI			pre_memory_use_sente,pre_memory_use_gote ;
  UC 			ai_code,ai_num,c_code,turn,pp,ai_yx ;
  char			mochi_koma[16] ;
  USI			te[100],ptr;
  SI			pt ;
  int			te_ptr,i ;
  int			pre_get_ai_tumi,get_ai_tumi ;
  
  ote = &(tree_sente[node]) ;
  pre_get_ai_tumi = 0 ;
  while (ote->ai_head != ote->ai_rear) {
    if (ote->ai_head == ote->away_rear) {
      /**************************************************/
      /*	 $B0l$DL\$N<oN`$N9g6p$K$h$k7k2L$O5M$_(B 	*/
      /*	$BL5BL9g$$$+H]$+$N%A%'%C%/(B		*/
      /**************************************************/
	
      ai_code = tree_gote[ote->away_rear - 1].play.j_code >> 4 ;
      ai_yx   =	tree_gote[ote->away_rear - 1].play.to_yx ;
      for (i=0;i<16;i++) mochi_koma[i] = 0 ;
      pp = bd->sente_in_hand ;
      while (pp != NILL) {
	c_code = bd->koma[pp].code ;
	(mochi_koma[c_code]) ++ ;
	pp = bd->koma[pp].next ;
      }
    
      if (get_ai_tumi = get_ai_tumi_fuc(ote->away_rear - 1))
	mochi_koma[ai_code] -- ;
      
      turn = GOTE ; ptr = ote->away_rear - 1 ; pt = tree_gote[ptr].point ;
      for (;;) {
	if (select_kai(&turn,&ptr,&pt)) break ;
	if (turn == SENTE) {
	  if (tree_sente[ptr].play.jc != EMP) {
	    c_code = tree_sente[ptr].play.jc_code ;
	    if (c_code > 2) c_code |= 0x01 ;
	    (mochi_koma[c_code]) ++ ;
	  }
	  if (tree_sente[ptr].play.from_yx == 0x00) {
	    c_code = tree_sente[ptr].play.j_code >> 4 ;
	    (mochi_koma[c_code]) -- ;
	  }
	}
      }
      if (get_ai_tumi && (mochi_koma[ai_code] > -1)) {
	/****************************************/
	/*	$BL5BL9g$$$G$"$k$3$H$,H=L@(B	*/
	/****************************************/
	tree_gote[ote->away_rear - 1].tesu -= 2 ;
	tree_gote[ote->away_rear - 1].point = TUMI_MOCHIGOMA_GOTE ;
	tree_gote[ote->away_rear - 1].leaf = CLOSE_NODE;
      }
      pre_get_ai_tumi = tree_gote[ote->ai_head].pre_get_ai_tumi ;
      tree_gote[ote->ai_head]
	= tree_gote[ote->away_rear - 1] ;
      tree_gote[ote->ai_head].head 
	= tree_gote[ote->ai_head].rear ;
      tree_gote[ote->ai_head].get_ai_tumi = get_ai_tumi ;
      tree_gote[ote->ai_head].pre_get_ai_tumi = pre_get_ai_tumi ;
      if (get_ai_tumi && (mochi_koma[ai_code] > -1)) (ote->ai_head) ++ ;
      (ote->away_rear) ++ ;
    }
    else {
      if ((tree_gote[ote->ai_head].tesu > tree_gote[ote->ai_head - 1].tesu) ||
	  ((tree_gote[ote->ai_head].point > tree_gote[ote->ai_head - 1].point) && 
	   (tree_gote[ote->ai_head].tesu == tree_gote[ote->ai_head - 1].tesu)))
	tree_gote[ote->ai_head - 1] = tree_gote[ote->ai_head] ;
      get_ai_tumi = get_ai_tumi_fuc(node,ote->away_rear - 1) ;
      tree_gote[ote->ai_head].get_ai_tumi =
	tree_gote[ote->ai_head].get_ai_tumi && get_ai_tumi ;
    }
    pre_get_ai_tumi = tree_gote[ote->ai_head].pre_get_ai_tumi ;
    if ((ote->ai_head != ote->ai_rear) && (ote->ai_head != ote->away_rear)) {
      /******************************************************************/
      /* $B9g6p$r;H$C$F5M$a$?(B $B"*(B $BM-8z9g$J$N$G9g6p$N<oN`Kh$KD4$Y$kI,MW$"$j(B	*/
      /******************************************************************/
      ai_code = tree_gote[ote->ai_head].play.j_code >> 4 ;
      ai_yx = tree_gote[ote->ai_head].play.j_code >> 4 ;
      switch(ai_code) {
      case FU:
	/************************/
	/*	$B7KGO$N9g6p(B	*/
	/************************/
	if(kind_of_ai(ai_yx,KE,&ai_num)) {
	  if ((pt = other_ai(&(ote->play),ote->ai_head,ai_num,KE,max_depth,max_point,pre_get_ai_tumi)) > TUMISO) return ;
	  get_ai_tumi = get_ai_tumi_fuc(ote->ai_head) ;
	  tree_gote[ote->ai_head].get_ai_tumi = 
	    tree_gote[ote->ai_head].get_ai_tumi && get_ai_tumi ;
	}
      case KE:
	/************************/
	/*	$B9a<V$N9g6p(B	*/
	/************************/
	if (kind_of_ai(ai_yx,KY,&ai_num)) {
	  if ((pt = other_ai(&(ote->play),ote->ai_head,ai_num,KY,max_depth,max_point,pre_get_ai_tumi)) > TUMISO) return ;
	  get_ai_tumi = get_ai_tumi_fuc(ote->ai_head) ;
	  tree_gote[ote->ai_head].get_ai_tumi = 
	    tree_gote[ote->ai_head].get_ai_tumi && get_ai_tumi ;
	}
      case KY:
	/************************/
	/*	$B6d>-$N9g6p(B	*/
	/************************/
	if (kind_of_ai(ai_yx,GI,&ai_num)) {
	  if ((pt = other_ai(&(ote->play),ote->ai_head,ai_num,GI,max_depth,max_point,pre_get_ai_tumi)) > TUMISO) return ;
	  get_ai_tumi = get_ai_tumi_fuc(ote->ai_head) ;
	  tree_gote[ote->ai_head].get_ai_tumi = 
	    tree_gote[ote->ai_head].get_ai_tumi && get_ai_tumi ;
	}
      case GI:
	/************************/
	/*	$B6b>-$N9g6p(B	*/
	/************************/
	if (kind_of_ai(ai_yx,KI,&ai_num)) {
	  if ((pt = other_ai(&(ote->play),ote->ai_head,ai_num,KI,max_depth,max_point,pre_get_ai_tumi)) > TUMISO) return ;
	  get_ai_tumi = get_ai_tumi_fuc(ote->ai_head) ;
	  tree_gote[ote->ai_head].get_ai_tumi = 
	    tree_gote[ote->ai_head].get_ai_tumi && get_ai_tumi ;
	}
      case KI:
	/************************/
	/*	$B3Q9T$N9g6p(B	*/
	/************************/
	if (kind_of_ai(ai_yx,KA,&ai_num)) {
	  if ((pt = other_ai(&(ote->play),ote->ai_head,ai_num,KA,max_depth,max_point,pre_get_ai_tumi)) > TUMISO) return ;
	  get_ai_tumi = get_ai_tumi_fuc(ote->ai_head) ;
	  tree_gote[ote->ai_head].get_ai_tumi = 
	    tree_gote[ote->ai_head].get_ai_tumi && get_ai_tumi ;
	}
      case KA:
	/************************/
	/*	$BHt<V$N9g6p(B	*/
	/************************/
	if (kind_of_ai(ai_yx,HI,&ai_num)) {
	  if ((pt = other_ai(&(ote->play),ote->ai_head,ai_num,HI,max_depth,max_point,pre_get_ai_tumi)) > TUMISO) return ;
	  get_ai_tumi = get_ai_tumi_fuc(ote->ai_head) ;
	  tree_gote[ote->ai_head].get_ai_tumi = 
	    tree_gote[ote->ai_head].get_ai_tumi && get_ai_tumi ;
	}
      }
      (ote->ai_head) ++ ;
    }
    if (ote->ai_head != ote->ai_rear) {
      /*	$B$5$i$K0l$D1s$/$K9g6p$rBG$D$3$H$r9M$($k(B	*/
      tree_gote[ote->ai_head].pre_get_ai_tumi = 
	pre_get_ai_tumi = tree_gote[ote->ai_head-1].get_ai_tumi ;
      tree_gote[ote->away_rear - 1].play = tree_gote[ote->ai_head].play ;
      ai_code = tree_gote[ote->away_rear - 1].play.j_code >> 4 ;
      ptr = bd->gote_in_hand ;
      while (bd->koma[ptr].code != ai_code) ptr = bd->koma[ptr].next ;
      tree_gote[ote->away_rear - 1].play.j = ptr ;
      tree_gote[ote->away_rear - 1].leaf = UKETE_LEAF ;
      tree_gote[ote->away_rear - 1].link = NON_LINK ;
      tree_gote[ote->away_rear - 1].point = 0 ;
            
      pre_memory_use_sente = *memory_use_sente ;
      pre_memory_use_gote  = *memory_use_gote ;	
      
      update_board_gote(&(tree_gote[ote->away_rear - 1].play)) ;
      set_pin_num(bd->sente_on_board) ;
      while ((tree_gote[ote->away_rear - 1].point > TUMISO) && (tree_gote[ote->away_rear - 1].point < 3) && process_run) {
	search_gote_tree(ote->away_rear - 1,&(ote->play),pre_get_ai_tumi);
      }
      reupdate_board_gote(&(tree_gote[ote->away_rear - 1].play)) ;
      

      if ((tree_gote[ote->away_rear - 1].point > 2) || (tree_gote[ote->away_rear - 1].tesu > *max_depth)) {
	*max_point = tree_gote[ote->away_rear - 1].point ;
	*max_depth = tree_gote[ote->away_rear - 1].tesu ; 
      }

      if (tree_gote[ote->away_rear - 1].point == TUMAZU) {
	*memory_use_sente    = pre_memory_use_sente ;
	*memory_use_gote     = pre_memory_use_gote ;
      }
      if (tree_gote[ote->away_rear - 1].point > TUMISO) return ;
    }
  }
}

