/* Copyright (C) 1997 Itoh Hidenori */

#include "shogi.h"

extern BOARD		*bd ; 	

extern TREE_LIST_SENTE	*tree_sente ;
extern TREE_LIST_GOTE	*tree_gote ;

/* $B;X<j%j%9%H$X$NDI2C(B */
void add_list(node,list_rear,from_yx,to_yx,j,jc,nari,turn,nari_ote)
USI 	node,*list_rear ;
UC	from_yx ;	/* $B0\F085:BI8(B 	*/
UC 	to_yx ;		/* $B0\F0@h:BI8(B 	*/
UC 	j  ;		/* $B0\F06pHV9f(B 	*/
UC 	jc ;		/* $BJa3M6pHV9f(B 	*/
UC      nari ;		/* $B@.$j!?IT@.$j(B */
UC	turn ;		/* $B?X1D%U%i%0(B	*/
UC	nari_ote ;	/* $BIT@.$j(B:$B@.$j2&<j$,$"$k(B $B%j%s%/@)8f(B*/
{
  TREE_LIST_SENTE *ote ;
  TREE_LIST_GOTE  *ukete ;
  
  if (turn == SENTE) {
    ote = &(tree_sente[*(list_rear)]) ;
    ote->play.from_yx 	= from_yx 	;
    ote->play.to_yx   	= to_yx   	;
    ote->play.j       	= j       	;
    ote->play.jc      	= jc      	;
    ote->play.j_code  	= (bd->koma[j].code << 4) + nari ;

    if (jc == EMP)
      ote->play.jc_code = EMP ;
    else 
      ote->play.jc_code = bd->koma[jc].code ;

    ote->play.turn    	= turn    	;
    ote->play.state   	= 0       	;

    if (nari_ote) {
      ote->link = LINK_SLAVE ;
      tree_sente[*(list_rear) - 1].link = LINK_MASTER ;
    }
    else
      ote->link = NON_LINK ;

    ote->leaf    	= OTE_LEAF   	;
    ote->point 		= 0	 	;
    ote->tesu 		= 1 		;
    ote->access_times	= 0 		;
    ote->parent		= node 		;
    ote->sub_tree	= 0 		;
  }
  else {
    ukete = &(tree_gote[*(list_rear)]) ;

    if (j != AIGOMA)
      ukete->play.j_code  = (bd->koma[j].code << 4) + nari ;
    else {
      ukete->play.j_code  = from_yx << 4 ;
      from_yx = 0x00 ;
    }
        
    ukete->play.from_yx 	= from_yx 	;
    ukete->play.to_yx   	= to_yx   	;
    ukete->play.j       	= j       	;
    ukete->play.jc      	= jc      	;
    if (jc == EMP)
      ukete->play.jc_code = EMP ;
    else 
      ukete->play.jc_code = bd->koma[jc].code ;
    ukete->play.turn    	= turn    	;
    ukete->play.state   	= 0       	;
    ukete->link			= NON_LINK      ;
    ukete->leaf    		= UKETE_LEAF   	;
    ukete->point 		= 0	 	;
    ukete->tesu 		= 0 		;
    ukete->parent		= node 		;
    ukete->get_ai_tumi 		= 0 		;
    ukete->pre_get_ai_tumi	= 0		;
  }
  (*list_rear) ++ ;
}

/* $B;X$7<j$r%j%9%H$X5-O?(B */	
void move_koma(node,list_rear,i,fyx,tyx,nari,nari_ote)
USI node,*list_rear ;
UC i ;			/* $B6pHV9f(B	*/	
UC fyx ;		/* $B0\F0A0:BI8(B	*/
UC tyx ;		/* $B0\F08e:BI8(B	*/
UC nari ;		/* $B@.$j!?IT@.$j(B	*/
UC nari_ote ;		/* $BIT@.$j(B:$B@.$j2&<j$,$"$k(B */
{
    UC turn,bd_koma_turn ;
    
    if (i != AIGOMA)
	turn = bd->koma[i].turn ;
    else
	turn = GOTE ;
    
    if (bd->yx[tyx] < 39)
	bd_koma_turn = bd->koma[bd->yx[tyx]].turn ;
    else
	bd_koma_turn = GOTE ;
    
    switch (bd->yx[tyx])
    {
      case OUT:
	break ;
      case EMP:
	add_list(node,list_rear,fyx,tyx,i,EMP,nari,turn,nari_ote);
	break ;
      default:
	if (bd_koma_turn != turn)
	    add_list(node,list_rear,fyx,tyx,i,bd->yx[tyx],nari,turn,nari_ote) ; 
    }
}
