/* Copyright (C) 1997 Itoh Hidenori */

#include "shogi.h"
#include "proc.h"

extern MSG		msg ;
extern BOARD		*bd ;
extern UC 		sente_tobi_kiki[256] ;	
extern TREE_LIST_SENTE	*tree_sente ;
extern TREE_LIST_GOTE	*tree_gote ;

void koma_print(code)
UC code ;
{
    switch(code)
    {
      case OU:
	printf(" $B6L(B ");
	break;
      case KI:
	printf(" $B6b(B ");
	break;
      case RY:
	printf(" $BN6(B ");
	break;
      case HI:
	printf(" $BHt(B ");
	break;
      case UM:
	printf(" $BGO(B ");
	break;
      case KA:
	printf(" $B3Q(B ");
	break;
      case NG:
	printf("$B@.6d(B");
	break;
      case GI:
	printf(" $B6d(B ");
	break;
      case NK:
	printf("$B@.7K(B");
	break;
      case KE:
	printf(" $B7K(B ");
	break;
      case NY:
	printf("$B@.9a(B");
	break;
      case KY:
	printf(" $B9a(B ");
	break;
      case TO:
	printf(" $B$H(B ");
	break;
      case FU:
	printf(" $BJb(B ");
	break;
      case AIGOMA:
	printf(" $B9g(B ");
	break;
      default:
	printf("    ");
    }
}

/* $B%j%9%H$NCf?H$r8+$k!#%G%P%C%0MQ(B */
void pp_list(head,rear)
USI head,rear ;
{
  TREE_LIST_GOTE *ptr ;
  UC code,fx,fy,tx,ty,nari,num ;

  while (head != rear) {
    ptr = &(tree_gote[head]) ;
    fx = ptr->play.from_yx & 0x0f ;
    fy = ptr->play.from_yx >> 4 ;
    tx = ptr->play.to_yx & 0x0f ;
    ty = ptr->play.to_yx >> 4 ;
    num = ptr->play.j ;
    if (num == AIGOMA) {
      nari = 0 ;
      code = AIGOMA ;
    }
    else {
      nari = ptr->play.j_code & 0x0f ;
      code = ptr->play.j_code >> 4;
    }
    printf ("%2d %2d %2d  %2d %2d   %2d ",num,fx,fy,tx,ty,code);
    koma_print(code);
    if (nari) printf("\t$B@.$j(B") ;
    printf("\n");
    head ++ ;
  }
}

void print_list(ote)
TREE_LIST_SENTE *ote ;
{
    printf ("num x  y   x  y  code \n");  

    pp_list(ote->get_head,ote->get_rear) ;
    pp_list(ote->away_head,ote->away_rear) ;
    pp_list(ote->ai_head,ote->ai_rear) ;
}

/* $B;X$7<j$NI=<((B $B%G%P%C%0MQ(B */
void print_te(ptr,point)
PLAY *ptr;
SI   point ;			
{
    UC code,fx,fy,tx,ty,nari ;
    
/*
    printf (" x  y   x  y  point code\n");  
*/
    fx = ptr->from_yx & 0x0f ;
    fy = ptr->from_yx >> 4 ;
    tx = ptr->to_yx & 0x0f ;
    ty = ptr->to_yx >> 4 ;
    if (ptr->j == AIGOMA)
    {
	nari = 0 ;
	code = AIGOMA ;
    }
    else
    {
	nari = ptr->j_code & 0x0f ;
	code = ptr->j_code >> 4 ;
    }
    printf ("%2d %2d  %2d %2d   %2d  %2d",fx,fy,tx,ty,code,point);
    koma_print(code);
    if (nari) printf(" $B@.$j(B\n") ;
    else printf("\n");
}

int select_kai(turn,ptr,pt)
UC 	*turn ;
USI 	*ptr;
SI	*pt ;
{
  USI head ,rear,temp ;
  int dansu,point,leaf = 0;
    
  if ((*turn == SENTE) && (*pt == TUMI_MOCHIGOMA_SENTE))
    *pt = TUMI_MOCHIGOMA_GOTE ;
  if ((*turn == GOTE) && (*pt == TUMI_MOCHIGOMA_GOTE))
    *pt = TUMI_MOCHIGOMA_SENTE ;

  if (*turn == GOTE)	{
    head = tree_gote[*ptr].head ;
    rear = tree_gote[*ptr].rear ;
    while ((head != rear) && (tree_sente[head].point != *pt))
/*
	   ((tree_sente[head].point != *pt) || (tree_sente[head].tesu + 1 != tree_gote[*ptr].tesu)))
*/
	head ++ ;

    if (head == rear) leaf = 1 ;
    *turn = SENTE ; 
    *ptr = head ;
  }
  else {
    dansu = 0 ;
    temp = tree_sente[*ptr].away_rear ;
    point = 0 ;

    head  = tree_sente[*ptr].get_head ;
    rear  = tree_sente[*ptr].get_rear ;
           
    while (head != rear) {
      if (dansu < tree_gote[head].tesu) {
	dansu = tree_gote[head].tesu ;
	temp = head ;
	point = tree_gote[head].point ;
      }
      if ((dansu == tree_gote[head].tesu) && (tree_gote[head].point == *pt) && (point != *pt)) {
	point = tree_gote[head].point ;
	temp = head ;
      }
      head ++ ;
    }
    
    head = tree_sente[*ptr].away_head ;
    rear = tree_sente[*ptr].away_rear ;
    while (head != rear) {
      if (dansu < tree_gote[head].tesu) {
	dansu = tree_gote[head].tesu ;
	temp = head ;
	point = tree_gote[head].point ;
      }
      if ((dansu == tree_gote[head].tesu) && (tree_gote[head].point == *pt) && (point != *pt)) {
	temp = head ;
	point = tree_gote[head].point ;
      }
      head ++ ;
    }
    leaf = (temp == tree_sente[*ptr].away_rear) ;    
    *turn = GOTE ;
    *ptr = temp ;
    *pt = tree_gote[temp].point ;
  }
  return(leaf) ;
}
