/* Copyright (C) 1997 Itoh Hidenori */

#include "shogi.h"

extern BOARD	*bd ;
extern TREE_LIST_GOTE	*tree_gote ;
extern UC 		sente_tobi_kiki[256] ;	

extern USI		*memory_use_sente ;
extern USI              *memory_use_gote ;

extern int		kiki_table() ;
extern void     	update_board_gote() ;
extern void     	reupdate_board_gote() ;
extern void		update_sente_tobi_kiki_map() ;
extern void		set_pin_num() ;

/****************************************/	
/*	$BJI6p$,L#J}$NHt<V$d3Q$G$"$k(B	*/
/****************************************/	
int	ryo_ote() {
  UC	temp,pin,code,vec ;
  
  temp = bd->sente_on_board ;
  while (temp != NILL) {
    if ((pin = bd->koma[temp].pin) < 40) {
      if (bd->koma[pin].turn == SENTE) {
	code = bd->koma[pin].code ;
	vec = bd->koma[pin].vec ;
	if ((code == RY) || (code == HI) ||(code == UM) || (code == KA))
	  return 1 ;
      }
    }
    temp = bd->koma[temp].next ;
  }
  return 0 ;
}

int	ukete_kiki(yx) 
UC yx ;
{
  UC	temp,num ;
  
  temp = yx + KL ;
  num = bd->yx[temp] ;
  if ((num < 40) && (bd->koma[num].turn == GOTE) && 
      (bd->koma[num].pinf == EMP) && (bd->koma[num].code == KE)) return 0 ;
  temp = yx + KR ;
  num = bd->yx[temp] ;
  if ((num < 40) && (bd->koma[num].turn == GOTE) && 
      (bd->koma[num].pinf == EMP) && (bd->koma[num].code == KE)) return 0 ;
  
  temp = yx + BL ;
  num = bd->yx[temp] ;
  if ((num < 40) && (bd->koma[num].turn == GOTE) && (bd->koma[num].pinf == EMP)) 
    switch (bd->koma[num].code) {
    case RY:
    case UM:
    case KA:
    case GI:
      return 0 ;
      break ;
    }
      
  temp = yx + BD ;
  num = bd->yx[temp] ;
  if ((num < 40) && (bd->koma[num].turn == GOTE) && (bd->koma[num].pinf == EMP)) 
    switch (bd->koma[num].code) {
    case KA:
    case GI:
    case KE:
    case KY:
    case FU:
    case OU:
      break ;
    default:
      return 0 ;
    }
      
  temp = yx + BR ;
  num = bd->yx[temp] ;
  if ((num < 40) && (bd->koma[num].turn == GOTE) && (bd->koma[num].pinf == EMP)) 
    switch (bd->koma[num].code) {
    case RY:
    case UM:
    case KA:
    case GI:
      return 0 ;
      break ;
    }

  temp = yx + LT ;
  num = bd->yx[temp] ;
  if ((num < 40) && (bd->koma[num].turn == GOTE) && (bd->koma[num].pinf == EMP))
    switch (bd->koma[num].code) {
    case KA:
    case GI:
    case KE:
    case KY:
    case FU:
    case OU:
      break ;
    default:
      return 0 ;
    }

  temp = yx + RT ;
  num = bd->yx[temp] ;
  if ((num < 40) && (bd->koma[num].turn == GOTE) && (bd->koma[num].pinf == EMP))
    switch (bd->koma[num].code) {
    case KA:
    case GI:
    case KE:
    case KY:
    case FU:
    case OU:
      break ;
    default:
      return 0 ;
    }
  
  temp = yx + FL ;
  num = bd->yx[temp] ;
  if ((num < 40) && (bd->koma[num].turn == GOTE) && (bd->koma[num].pinf == EMP))
    switch (bd->koma[num].code) {
    case OU:
    case HI:
    case KE:
    case KY:
    case FU:
      break ;
    default:
      return 0 ;
    }
  
  temp = yx + FD ;
  num = bd->yx[temp] ;
  if ((num < 40) && (bd->koma[num].turn == GOTE) && (bd->koma[num].pinf == EMP))
    switch (bd->koma[num].code) {
    case OU:
    case KE:
    case KA:
      break ;
    default:
      return 0 ;
    }
  
  temp = yx + FR ;
  num = bd->yx[temp] ;
  if ((num < 40) && (bd->koma[num].turn == GOTE) && (bd->koma[num].pinf == EMP))
    switch (bd->koma[num].code) {
    case OU:
    case HI:
    case KE:
    case KY:
    case FU:
      break ;
    default:
      return 0 ;
    }
  
  return 1 ;
}

int	koma_in_hand(code)
UC	code ; 
{
  int	ct = 0 ;
  UC	ptr ;

  ptr = bd->sente_in_hand ;
  while ((ptr != NILL) && (bd->koma[ptr].code != code)) 
    ptr = bd->koma[ptr].next ;

  if (ptr != NILL) return 1 ;
  else	return 0 ;
}

int movable(t_yx,ote_num,code) 
UC t_yx,ote_num,code ;
{
  int   dummy ;
  UC	temp,nari,place ;
 
  if ((place = bd->yx[t_yx]) < 40) {
    if (bd->koma[place].turn == SENTE) return 0 ;
  }
  
  dummy = 0 ;
  temp = bd->sente_on_board ;
  while (temp != NILL) {
    if (kiki_table(bd->koma[temp].code,bd->koma[temp].yx,t_yx,KIKIARI)){
      if ((t_yx < 0x40) || (bd->koma[temp].yx < 0x40)) nari = 1 ;
      else	nari = 0 ;
      switch(bd->koma[temp].code){
      case RY:
	if ((code != UM) && (code != KA) && (code != KE)) dummy = 1 ;
	break ;
      case UM:
	if ((code != RY) && (code != HI) && (code != KE) && (code != KY)) dummy = 1 ;
	break ;
      case HI:
	if ((nari) && (code != UM) && (code != KA) && (code != KE)) dummy = 1 ;
	else dummy = (code == HI) ;
	break ;
      case KA:
	if ((nari) && (code != RY) && (code != HI) && (code != KE) && (code != KY)) dummy = 1 ;
	else dummy = (code == KA) ;
	break ;
      case FU:
	if ((nari) && (code == KI)) dummy = 1 ;
	else dummy = (code == FU) ;
	break ;
      case KY:
	if ((nari) && (code == KI)) dummy = 1 ;
	else dummy = (code == KY) ;
	break ;
      case KE:
	if ((nari) && (code == KI)) dummy = 1 ;
	else dummy = (code == KE) ;
	break ;
      case GI:
	if ((nari) && (code == KI)) dummy = 1 ;
	else dummy = (code == GI) ;
	break ;
      default:
	if (code == KI) dummy = 1 ;
      }
    }
    if (dummy)	temp = NILL ;
    else	temp = bd->koma[temp].next ;
  }
  return dummy ;
}

int look_around(ki,gi,hi,ka,ke,ky,play,ote_num) 
  int	ki,gi,hi,ka,ke,ky ;
  PLAY	*play ;
  UC	ote_num ;
{
  UC ou_yx,temp,temp1,ai_yx,koma_num ;
  int dummy,dummy_FL,dummy_FD,dummy_FR,dummy_LT,dummy_RT,
    dummy_BL,dummy_BD,dummy_BR,move_uke,skiki ;

  int uke_FL,uke_FD,uke_FR,uke_LT,uke_RT,uke_BL,uke_BD,uke_BR,uke_P ;
  int emp_FL,emp_FD,emp_FR,emp_LT,emp_RT,emp_BL,emp_BD,emp_BR ;
  
  dummy = 0 ;
  ou_yx = bd->ou_yx ;

  /******************************/
  /*	$BN>2&<j$N2DG=@-$,$"$k$+(B	*/
  /******************************/
  if (ryo_ote()) return 1 ;
  /**************************************/
  /*	$BL5BL9g$K@.$j$=$&$+(B		*/
  /**************************************/
  if (play->from_yx == 0x00) {
    ai_yx = play->to_yx ;
    if ((bd->sente_kiki_map[ai_yx] + sente_tobi_kiki[ai_yx] > 1) &&
	ukete_kiki(ai_yx))
      return 1 ;
  }
		
  /*				*/
  /*	$B6L$N2s$j$rD4$Y$k(B	*/
  /*			       	*/
  uke_P = ukete_kiki(ou_yx) ;
  temp = ou_yx + FL ;
  dummy_FL = (bd->yx[temp] == OUT) ||
    ((bd->yx[temp] < 40) && (bd->koma[bd->yx[temp]].turn == GOTE)) ||
      (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp]) ;
  uke_FL = ukete_kiki(temp);
  emp_FL = (bd->yx[temp] == EMP) ;
  
  temp = ou_yx + FD ;
  dummy_FD = (bd->yx[temp] == OUT) ||
    ((bd->yx[temp] < 40) && (bd->koma[bd->yx[temp]].turn == GOTE)) ||
      (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp]) ;
  uke_FD = ukete_kiki(temp);
  emp_FD = (bd->yx[temp] == EMP) ;

  temp = ou_yx + FR ;
  dummy_FR = (bd->yx[temp] == OUT) ||
    ((bd->yx[temp] < 40) && (bd->koma[bd->yx[temp]].turn == GOTE)) ||
      (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp])  ;
  uke_FR = ukete_kiki(temp);
  emp_FR = (bd->yx[temp] == EMP) ;

  temp = ou_yx + LT ;
  dummy_LT = (bd->yx[temp] == OUT) ||
    ((bd->yx[temp] < 40) && (bd->koma[bd->yx[temp]].turn == GOTE)) ||
      (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp])  ;
  uke_LT = ukete_kiki(temp);
  emp_LT = (bd->yx[temp] == EMP) ;
  
  temp = ou_yx + RT ;
  dummy_RT = (bd->yx[temp] == OUT) ||
    ((bd->yx[temp] < 40) && (bd->koma[bd->yx[temp]].turn == GOTE)) ||
      (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp]) ;
  uke_RT = ukete_kiki(temp);
  emp_RT = (bd->yx[temp] == EMP) ;

  temp = ou_yx + BL ;
  dummy_BL = (bd->yx[temp] == OUT) ||
    ((bd->yx[temp] < 40) && (bd->koma[bd->yx[temp]].turn == GOTE)) ||
      (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp])  ;
  uke_BL = ukete_kiki(temp);
  emp_BL = (bd->yx[temp] == EMP) ;

  temp = ou_yx + BD ;
  dummy_BD = (bd->yx[temp] == OUT) ||
    ((bd->yx[temp] < 40) && (bd->koma[bd->yx[temp]].turn == GOTE)) ||
      (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp])  ;
  uke_BD = ukete_kiki(temp);
  emp_BD = (bd->yx[temp] == EMP) ;

  temp = ou_yx + BR ;
  dummy_BR = (bd->yx[temp] == OUT) ||
    ((bd->yx[temp] < 40) && (bd->koma[bd->yx[temp]].turn == GOTE)) ||
      (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp])  ;
  uke_BR = ukete_kiki(temp);
  emp_BR = (bd->yx[temp] == EMP) ;

  /**************************************/
  /*	$BB(5M$,M-$j$=$&$+H]$+D4$Y$k(B	*/
  /**************************************/

  /**************************************/
  /*		$B6L$N??>e$G2&<j(B		*/
  /**************************************/
  temp = ou_yx + BD ;
  move_uke = uke_BD && (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp]) ;
  
  if (move_uke) {
    skiki = (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp] > 1) ;
    /*		######			*/
    /*		  $B6L(B			*/
    /*		  $B6b(B			*/
    dummy = (dummy_FL && dummy_FD && dummy_FR) || 
      (sente_tobi_kiki[temp] && (dummy_FL + dummy_FD + dummy_FR));
/*
    dummy = dummy_FL && dummy_FD && dummy_FR ;
*/
    
    if (dummy && (((ki && emp_BD) || 
		   (skiki && movable(temp,ote_num,KI))))) return 1 ;
    /*		######			*/
    /*		  $B6L(B			*/
    /*		  $BGO(B			*/
    dummy = dummy_FL + dummy_FD + dummy_FR ;
    if (dummy && skiki && movable(temp,ote_num,UM)) return 1 ;
    
    /*		######			*/
    /*		  $B6L(B			*/
    /*		##$B6d(B##			*/

    dummy = dummy_FL && dummy_FD && dummy_FR && ((dummy_BL && dummy_BR) || (sente_tobi_kiki[temp])) ;

/*
    dummy = dummy_FL && dummy_FD && dummy_FR && dummy_BL && dummy_BR ;
*/
    if (dummy && ((gi && emp_BD) || (skiki && movable(temp,ote_num,GI))))
      return 1 ;
    
    /*		######			*/
    /*		##$B6L(B##			*/
    /*		##$BJb(B##			*/
    dummy = dummy_FL && dummy_FD && dummy_FR && dummy_LT && dummy_RT && dummy_BL && dummy_BR ;
    if (dummy && skiki && movable(temp,ote_num,FU)) return 1 ;
    
    /*		##  ##			*/
    /*		##$B6L(B##			*/
    /*		##$B",(B##			*/
    /*		  $B9a(B			*/
    dummy = dummy_FL && dummy_FR && dummy_LT && dummy_RT && dummy_BL && dummy_BR ;
    if (dummy) {
      temp1 = ou_yx + BD ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && ((ky && (bd->yx[temp1] == EMP)) || (skiki && movable(temp1,ote_num,KY))))
	return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += BD ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && ((ky && (bd->yx[temp1] == EMP)) || movable(temp1,ote_num,KY))) return 1 ;
      }
    }	
    dummy = dummy_FL && dummy_FD && dummy_FR ;
    if ((dummy) && (temp < 0x40)){
      temp1 = ou_yx + BD ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && skiki && movable(temp1,ote_num,KY))
	return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += BD ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && ((ky && (bd->yx[temp1] == EMP)) || movable(temp1,ote_num,KY)))
	  return 1 ;
      }
    }
    /*		##  ##			*/
    /*		##$B6L(B##			*/
    /*		  $B",(B			*/	
    /*		  $BHt(B			*/
    dummy = dummy_FR && dummy_FL && dummy_LT && dummy_RT ;
    if (dummy) {
      temp1 = ou_yx + BD ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && ((hi && (bd->yx[temp1] == EMP)) || (skiki && movable(temp1,ote_num,HI))))
	return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += BD ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && ((hi && (bd->yx[temp1] == EMP)) || movable(temp1,ote_num,HI))) return 1 ;
      }
    }
    /*		##  ##			*/
    /*		  $B6L(B			*/
    /*            $B",(B                    */
    /*		  $BN6(B			*/
    dummy = dummy_FL && dummy_FR ;
    if (dummy) {
      temp1 = ou_yx + BD ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && (((temp < 0x40) && skiki && movable(temp1,ote_num,HI)) ||
		       (skiki && movable(temp1,ote_num,RY)))) return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += BD ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && (((temp < 0x40) && ((hi && (bd->yx[temp1] == EMP)) ||
					    movable(temp1,ote_num,HI))) ||
			 movable(temp1,ote_num,RY))) return 1 ;
      } 
    }
  }
  
  /**************************************/
  /*		$B6L$N1&>e$G2&<j(B		*/
  /**************************************/
  temp = ou_yx + BR ;
  move_uke = uke_BR && (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp]) ;
  
  if (move_uke) {
    skiki = (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp] > 1) ;
    /*		######			*/
    /*		##$B6L(B			*/
    /*		##  $B6b(B			*/
    dummy = dummy_FL && dummy_FD && dummy_FR && dummy_LT && dummy_BL ;
    if (dummy && ((ki && emp_BR) || (skiki && movable(temp,ote_num,KI)))) return 1 ;
    /*		######			*/
    /*		##$B6L(B			*/
    /*		####$B6d(B			*/
    dummy = dummy_FL && dummy_FD && dummy_FR && dummy_LT && dummy_BL && dummy_BD ;
    if (dummy && ((gi && emp_BR) || (skiki && movable(temp,ote_num,GI)))) return 1 ;
    
    /*		####			*/
    /*		##$B6L(B  			*/
    /*		    $BN6(B			*/
    dummy = dummy_FL && dummy_LT && (dummy_FD || ((ki || gi) && uke_P));
    if (dummy && skiki && movable(temp,ote_num,RY)) return 1 ;
    
    /*		  ####			*/
    /*		##$B6L(B##			*/
    /*		####$B3Q(B			*/
    dummy = ((dummy_FD && dummy_FR) || ((ki || gi) && uke_P)) 
      && dummy_LT && dummy_RT && dummy_BL && dummy_BD ;
    if (dummy) {
      temp1 = ou_yx + BR ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && ((ka && (bd->yx[temp1] == EMP)) || (skiki && movable(temp1,ote_num,KA))))
	return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += BR ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && ((ka && (bd->yx[temp1] == EMP)) || movable(temp1,ote_num,KA)))
	  return 1 ;
      }
    }
    
    /*		  ####			*/
    /*		##$B6L(B  			*/
    /*		##  $BGO(B			*/
    dummy = ((dummy_FD && dummy_FR) || ((ki || gi) && uke_P)) && 
      (dummy_LT || ((ki || gi) && emp_FD && uke_FD)) && dummy_BL ;
    if (dummy) {
      temp1 = ou_yx + BR ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && (((temp < 0x40) && skiki && movable(temp1,ote_num,KA)) || 
		       (skiki && movable(temp1,ote_num,UM)))) return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += BR ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && (((temp < 0x40) && ((ka && (bd->yx[temp1] == EMP)) ||
					    movable(temp1,ote_num,KA))) ||
			 movable(temp1,ote_num,UM))) return 1 ;
      } while (move_uke && (bd->yx[temp1] == EMP));
    }
  }
  
  /**************************************/
  /*		$B6L$N:8>e$G2&<j(B		*/
  /**************************************/
  temp = ou_yx + BL ;
  move_uke = uke_BL && (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp]) ;
  if (move_uke) {
    skiki = (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp] > 1) ;
    /*		######			*/
    /*		  $B6L(B##			*/
    /*		$B6b(B  ##			*/
    dummy = dummy_FL && dummy_FD && dummy_FR && dummy_RT && dummy_BR ;
    if (dummy && ((ki && emp_BL) || (skiki && movable(temp,ote_num,KI)))) return 1 ;

    /*		######			*/
    /*		  $B6L(B##			*/
    /*		$B6d(B####			*/
    dummy = dummy_FL && dummy_FD && dummy_FR && dummy_RT && dummy_BD && dummy_BR ;
    if (dummy && ((gi && emp_BL) || (skiki && movable(temp,ote_num,GI)))) return 1 ;

    /*		  ####			*/
    /*		  $B6L(B## 			*/
    /*		$BN6(B			*/
    dummy = dummy_FR && dummy_RT && (dummy_FD || ((ki || gi) && uke_P));
    if (dummy && skiki && movable(temp,ote_num,RY)) return 1 ;

    /*		####			*/
    /*		##$B6L(B##			*/
    /*		$B3Q(B####			*/

    dummy = ((dummy_FD && dummy_FL) || ((ki || gi) && uke_P)) 
      && dummy_LT && dummy_RT && dummy_BR && dummy_BD ;
    if (dummy) {
      temp1 = ou_yx + BL ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && ((ka && (bd->yx[temp1] == EMP)) || (skiki && movable(temp1,ote_num,KA))))
	return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += BL ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && ((ka && (bd->yx[temp1] == EMP)) || movable(temp1,ote_num,KA))) return 1 ;
      }
    }
    
    /*		####			*/
    /*		  $B6L(B## 			*/
    /*		$BGO(B  ##			*/
    dummy = ((dummy_FL && dummy_FD) || ((ki || gi) && uke_P)) && 
      (dummy_RT || ((ki || gi) && emp_FD && uke_FD)) && dummy_BR ;
    if (dummy) {
      temp1 = ou_yx + BL ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && (((temp < 0x40) && skiki && movable(temp1,ote_num,KA)) || 
		       (skiki && movable(temp1,ote_num,UM)))) return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += BL ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && (((temp < 0x40) && ((ka && (bd->yx[temp1] == EMP)) || 
					    movable(temp1,ote_num,KA))) || 
			 movable(temp1,ote_num,UM))) return 1 ;
      }
    }
  }
  
  /**************************************/
  /*		$B6L$N:8$+$i2&<j(B		*/
  /**************************************/

  temp = ou_yx + LT ;
  move_uke = uke_LT && (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp]);
  if (move_uke) {
    skiki = (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp] > 1) ;
    /*		    ##			*/
    /*		$B6b6L(B##			*/
    /*		  ####			*/
    dummy = dummy_FR && dummy_RT && dummy_BD && dummy_BR ;
    if (dummy && ((ki && emp_LT) || (skiki && movable(temp,ote_num,KI))))
      return 1 ;
    
    /*		    ##			*/
    /*		$BGO6L(B##			*/
    /*		    ##			*/	
    dummy = ((dummy_FR && dummy_BR) || ((ki || gi) && uke_P)) && dummy_RT ;
    if (dummy && skiki && movable(temp,ote_num,UM)) return 1 ;
      
    /*		  ####			*/
    /*	$BHt(B  $B"*(B	**$B6L(B			*/
    /*		  ####			*/	
    dummy = ((dummy_FD && dummy_FR) || ((ki || gi) && uke_P)) && dummy_BD && dummy_BR ;
    if (dummy) {
      temp1 = ou_yx + LT ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && ((hi && (bd->yx[temp1] == EMP)) || (skiki && movable(temp1,ote_num,HI))))
	return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += LT ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && ((hi && (bd->yx[temp1] == EMP)) || movable(temp1,ote_num,HI)))
	  return 1 ;
      }
    }
      
    /*		    ##			*/
    /*	$BN6(B  $B"*(B  **$B6L(B			*/
    /*		    ##			*/	
    dummy = dummy_FR && dummy_BR ;
    if (dummy) {
      temp1 = ou_yx + LT ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && 
	  (((temp < 0x40) && skiki && movable(temp1,ote_num,HI)) || 
	   (skiki && movable(temp1,ote_num,RY)))) return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += LT ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && 
	    (((temp < 0x40) && 
	      ((hi && (bd->yx[temp1] == EMP)) || movable(temp1,ote_num,HI))) || 
	     movable(temp1,ote_num,RY))) return 1 ;
      }
    }
  }
  
  /**************************************/
  /*		$B6L$N1&$+$i2&<j(B		*/
  /**************************************/
  temp = ou_yx + RT ;
  move_uke = uke_RT && (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp]);
  
  if (move_uke) {
    skiki = (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp] > 1) ;
    /*	        ##			*/
    /*		##$B6L6b(B			*/
    /*		####			*/
    dummy = dummy_FL && dummy_LT && dummy_BD && dummy_BL ;
    if (dummy && ((ki && emp_RT) || (skiki && movable(temp,ote_num,KI)))) return 1 ;
     
    /*		##			*/
    /*		##$B6LGO(B			*/
    /*		##			*/	
    dummy = ((dummy_FL && dummy_BL) || ((ki || gi) && uke_P)) && dummy_LT ;
    if (dummy && skiki && movable(temp,ote_num,UM)) return 1 ;

    /*		####			*/
    /*		  $B6L(B**  $B"+(B  $BHt(B		*/
    /*		####			*/	
    dummy = ((dummy_FL && dummy_FD) || ((ki || gi) && uke_P)) && dummy_BL && dummy_BD ;
    if (dummy) {
      temp1 = ou_yx + RT ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && ((hi && (bd->yx[temp1] == EMP)) || 
		       (skiki && movable(temp1,ote_num,HI)))) return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += RT ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && ((hi && (bd->yx[temp1] == EMP)) || 
			 movable(temp1,ote_num,HI))) return 1 ;
      }
    }
    
    /*		##			*/
    /*		  $B6L(B**  $B"+(B  $BN6(B		*/
    /*		##			*/
    dummy = dummy_FL && dummy_BL || ki || gi ;
    if (dummy) {
      temp1 = ou_yx + RT ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && (((temp < 0x40) && skiki && movable(temp1,ote_num,HI)) ||
		       (skiki && movable(temp1,ote_num,RY)))) return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += RT ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && (((temp < 0x40) && ((hi && (bd->yx[temp1] == EMP)) || 
					    movable(temp1,ote_num,HI))) ||
			 movable(temp1,ote_num,RY))) return 1 ;
      }
    }
  }
  
  /**************************************/
  /*		$B6L$N??2<$+$i2&<j(B	*/
  /**************************************/
  temp = ou_yx + FD ;
  move_uke = uke_FD && (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp]) ;
  if (move_uke) {
    skiki = (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp] > 1) ;
    /*	          $B6b(B			*/
    /*		##$B6L(B##			*/
    /*		######			*/
    dummy = dummy_LT && dummy_RT && dummy_BL && dummy_BD && dummy_BR ;
    if (dummy && ((ki && emp_FD) || (skiki && movable(temp,ote_num,KI)))) return 1 ;
    
    /*		  $BGO(B			*/
    /*		  $B6L(B			*/
    /*		######			*/	
    dummy = (dummy_BL + dummy_BD + dummy_BR > 1);
    if (dummy && skiki && movable(temp,ote_num,UM)) return 1 ;
    
    /*		  $BHt(B			*/
    /*		  $B"-(B			*/
    /*		##$B6L(B##			*/
    /*		##  ##			*/	
    dummy = dummy_LT && dummy_RT && dummy_BL && dummy_BR ;
    if (dummy) {
      temp1 = ou_yx + FD ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && ((hi && (bd->yx[temp1] == EMP)) || (skiki && movable(temp1,ote_num,HI))))
	return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += FD ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && ((hi && (bd->yx[temp1] == EMP)) || movable(temp1,ote_num,HI)))
	  return 1 ;
      } 
    }
    /*		  $BN6(B			*/
    /*		  $B"-(B			*/
    /*		  $B6L(B			*/
    /*		##  ##			*/	
    dummy = dummy_BL && dummy_BR ;
    if (dummy) {
      temp1 = ou_yx + FD ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && (((temp1 < 0x40) && skiki && movable(temp1,ote_num,HI)) ||
		       (skiki && movable(temp1,ote_num,RY)))) return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += FD ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && (((temp1 < 0x40) && 
			  ((hi && (bd->yx[temp1] == EMP)) || movable(temp1,ote_num,HI))) ||
			 movable(temp1,ote_num,RY))) return 1 ;
      }
    }
  }
  
  /**************************************/
  /*		$B6L$N:82<$+$i2&<j(B	*/
  /**************************************/
  temp = ou_yx + FL ;
  move_uke = uke_FL && (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp]);
  
  if (move_uke) {
    skiki = (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp] > 1) ;
    /*	        $B6d(B####			*/
    /*		##$B6L(B##			*/
    /*		######			*/
    dummy = dummy_FD && dummy_FR && dummy_LT && dummy_RT && dummy_BL && dummy_BD && dummy_BR ;
    if (dummy && ((gi && emp_FL) || (skiki && movable(temp,ote_num,GI)))) return 1 ;
  
    /*		$BN6(B			*/
    /*		  $B6L(B##			*/
    /*		  ####			*/	
    dummy = dummy_RT && dummy_BD && dummy_BR ;
    if (dummy && skiki && movable(temp,ote_num,RY)) return 1 ;
    
    /*		$B3Q(B####			*/
    /*		##$B6L(B##			*/
    /*		####			*/
    dummy = dummy_FD && dummy_FR && dummy_LT && dummy_RT && dummy_BL && dummy_BD ;
    if (dummy) {
      temp1 = ou_yx + FL ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && ((ka && (bd->yx[temp1] == EMP)) || (skiki && movable(temp1,ote_num,KA))))
	return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += FL ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && ((ka && (bd->yx[temp1] == EMP)) || movable(temp1,ote_num,KA))) return 1 ;
      }
    }
    
    /*		$BGO(B  ##			*/
    /*		  $B6L(B##			*/
    /*		####			*/	
    dummy = ((dummy_FR && dummy_RT) || ((ki || gi) && uke_P)) && dummy_BL && dummy_BD ;
    if (dummy) {
      temp1 = ou_yx + FL ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && (((temp1 < 0x40) && skiki && movable(temp1,ote_num,KA)) || 
		       (skiki && movable(temp1,ote_num,UM)))) return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += FL ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && (((temp1 < 0x40) && 
			  ((ka && (bd->yx[temp1] == EMP)) || movable(temp1,ote_num,KA))) || 
			 movable(temp1,ote_num,UM))) return 1 ;
      }
    }
  }

  /**************************************/
  /*		$B6L$N1&2<$+$i2&<j(B	*/
  /**************************************/
  temp = ou_yx + FR ;
  move_uke = uke_FR && (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp]);
  if (move_uke) {
    skiki = (bd->sente_kiki_map[temp] + sente_tobi_kiki[temp] > 1) ;
    /*	        ####$B6d(B			*/
    /*		##$B6L(B##			*/
    /*		######			*/
    dummy = dummy_FL && dummy_FD && dummy_LT && dummy_RT && dummy_BL && dummy_BD && dummy_BR ;
    if (dummy && ((gi && emp_FR) || (skiki && movable(temp,ote_num,GI)))) return 1 ;
  
    /*		    $BN6(B			*/
    /*		##$B6L(B			*/
    /*		####			*/	
    dummy = dummy_LT && dummy_BL && dummy_BD ;
    if (dummy && skiki && movable(temp,ote_num,RY)) return 1 ;
    
    /*		####$B3Q(B			*/
    /*		##$B6L(B##			*/
    /*		  ####			*/
    dummy = dummy_FL && dummy_FD && dummy_LT && dummy_RT && dummy_BD && dummy_BR ;
    if (dummy) {
      temp1 = ou_yx + FR ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && ((ka && (bd->yx[temp1] == EMP)) || (skiki && movable(temp1,ote_num,KA))))
	return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += FR ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && ((ka && (bd->yx[temp1] == EMP)) || movable(temp1,ote_num,KA))) return 1 ;
      }
    }
    
    /*		##  $BGO(B 			*/
    /*		##$B6L(B			*/
    /*		  ####			*/	
    dummy = ((dummy_FL && dummy_LT) || ((ki || gi) && uke_P)) && dummy_BD && dummy_BR ;
    if (dummy) {
      temp1 = ou_yx + FR ;
      move_uke = ukete_kiki(temp1) ;
      if (move_uke && (((temp1 < 0x40) && skiki && movable(temp1,ote_num,KA)) ||
		       (skiki && movable(temp1,ote_num,UM)))) return 1 ;
      while (move_uke && (bd->yx[temp1] == EMP)) {
	temp1 += FR ;
	move_uke = ukete_kiki(temp1) ;
	if (move_uke && (((temp1 < 0x40) && 
			  ((ka && (bd->yx[temp1] == EMP)) || movable(temp1,ote_num,KA))) || 
			 movable(temp1,ote_num,UM))) return 1 ;
      }
    }
  }
  
  dummy = dummy_FL && dummy_FD && dummy_FR && dummy_LT && dummy_RT &&
    dummy_BL && dummy_BD && dummy_BR ;
  if (dummy) {
    /**************************************/
    /*		$B:87KGO$N2&<j(B		*/
    /**************************************/

    /*		######			*/
    /*		##$B6L(B##		       	*/
    /*		######			*/
    /*		$B7K(B			*/
    temp = ou_yx + KBL ;
    if (ukete_kiki(temp) && 
	((ke && (bd->yx[temp] == EMP)) || movable(temp,ote_num,KE))) return 1 ;
  
    /**************************************/
    /*		$B1&7KGO$N2&<j(B		*/
    /**************************************/

    /*		######			*/
    /*		##$B6L(B##		       	*/
    /*		######			*/
    /*		    $B7K(B			*/
    temp = ou_yx + KBR ;
    if (ukete_kiki(temp) && ((ke && (bd->yx[temp] == EMP)) || 
			     movable(temp,ote_num,KE)))
      return 1 ;
  }

  /**************************************/
  /*	$B6u$-2&<j(B			*/
  /**************************************/
  
  koma_num = bd->sente_on_board ;
  while (koma_num != NILL) {
    if ((temp = bd->koma[koma_num].pin) < 40) {
      if (bd->koma[temp].turn == SENTE) { 
	switch(bd->koma[koma_num].code) {
	case HI:
	case RY:
	  switch (bd->koma[temp].vec) {
	  case FD:
	  case BD:
	    dummy = dummy_FL && dummy_FR && dummy_LT && dummy_RT && dummy_BL && dummy_BR ;
	    if (dummy) return 1 ;
	    break ;
	  case RT:
	  case LT:
	    dummy = dummy_FL && dummy_FD && dummy_FR && dummy_BL && dummy_BD && dummy_BR ;
	    if (dummy) return 1 ;
	    break ;
	  }
	  break ;
	case KA:
	case UM:
	  switch (bd->koma[temp].vec) {
	  case FR:
	  case BL:
	    dummy = dummy_FL && dummy_FD && dummy_LT && dummy_RT && dummy_BD && dummy_BR ;
	    if (dummy) return 1 ;
	    break ;
	  case FL:
	  case BR:
	    dummy = dummy_FD && dummy_FR && dummy_LT && dummy_RT && dummy_BL && dummy_BD ;
	    if (dummy) return 1 ;
	    break ;
	  }
	  break ;
	case KY:
	  dummy = dummy_FL && dummy_FR && dummy_LT && dummy_RT && dummy_BL && dummy_BR ;
	  if (dummy) return 1 ;
	  break ;
	}
      }
    }
    koma_num = bd->koma[koma_num].next ;
  }

  /**************************************/
  /*		$BB(5M$J$7(B		*/
  /**************************************/
  return 0 ;
}

int index_fuc(ote)
TREE_LIST_SENTE *ote ;
{
    int kin,gi,ky,ke,hi,ka,num,ct ;
    USI	temp ;
    
    num = ote->get_rear - ote->get_head ;
    num = num + ote->away_rear - ote->away_head ;
    
    kin = koma_in_hand(KI) ;
    gi = koma_in_hand(GI) ;
    hi = koma_in_hand(HI) ;
    ka = koma_in_hand(KA) ;
    ky = koma_in_hand(KY) ;
    ke = koma_in_hand(KE) ;
/*
    tobi = (bd->sente_kiki_map[bd->ou_yx]) ;
*/
    temp = ote->get_head ;
    while (temp != ote->get_rear) {
      update_board_gote(&(tree_gote[temp].play));
      update_sente_tobi_kiki_map() ;      
      set_pin_num(bd->sente_on_board) ;
      if (look_around(kin,gi,hi,ka,ke,ky,&(tree_gote[temp].play),ote->play.j))
	num -- ;
      reupdate_board_gote(&(tree_gote[temp].play));
      temp ++ ;
    }
    temp = ote->away_head ;
    while (temp != ote->away_rear) {
      update_board_gote(&(tree_gote[temp].play));
      update_sente_tobi_kiki_map() ;      
      set_pin_num(bd->sente_on_board) ;
      if (look_around(kin,gi,hi,ka,ke,ky,&(tree_gote[temp].play),ote->play.j))
	num -- ;
      reupdate_board_gote(&(tree_gote[temp].play));
      temp ++ ;
    }
    
    if (ote->ai_rear != ote->ai_head)
      num += ote->ai_rear - ote->ai_head - 1;

    /*	$B;}6p(B($BJb(B)$B$K$h$k2&<j$J$i$P!"(B1$B8:$i$9(B */
    if ((ote->play.from_yx == 0x00) &&
	 (ote->play.j_code == 0xf0) && (kin || gi)) num -- ;

    /*  $B;}6p(B($B7KGO(B)$B$K$h$k2&<j$GHW>e$N6p$,(B1$B8D$^$?$O(B0$B8D$J$i$P!"(B1$B8:$i$9(B */
    if ((ote->play.from_yx == 0x00) && (ote->play.j_code == 0xb0)) {
      temp = bd->sente_on_board ;
      ct = 0 ;
      while (temp != NILL) {
	ct ++ ;
	temp = bd->koma[temp].next ;
      }	
      if (ct < 3) num -- ;
    }	
    
    if ((bd->sente_kiki_map[bd->ou_yx] == 0) && 
	((bd->koma[ote->play.j].code == RY) || 
	 (bd->koma[ote->play.j].code == UM))) num -- ;
    
    return (num);
}
