/* Copyright (C) 1997 Itoh Hidenori */

#include "shogi.h"

extern BOARD		*bd ;

extern TREE_LIST_SENTE	*tree_sente ;
extern TREE_LIST_GOTE	*tree_gote ;
extern process_run ;

extern void   		ote_ukete() ;
extern void     	set_pin_num() ;
extern void		print_te() ;
extern void		update_sente_tobi_kiki_map() ;
extern void    		update_board_sente() ;
extern void    	 	update_board_gote() ;
extern void     	reupdate_board_sente() ;
extern void     	reupdate_board_gote() ;
extern void		search_sente_tree() ;

void search_gote_tree(node,ote,get_ai_tumi)
USI	node ;
PLAY	*ote ;
int	get_ai_tumi ;
{
  TREE_LIST_GOTE	*ukete ;
  TREE_LIST_SENTE	*temp_node ;
  PLAY_FLAG 		p_flag ;
  USI			temp ;
  int 			get_koma,pre ;
  int			min_depth,i ;
  int 			min_point = TUMAZU ;
  int			ote_leaf ;
  USI			access ;
  
  ukete = &(tree_gote[node]) ;
  switch (ukete->leaf){
  case UKETE_LEAF:
    /* pin $B$NI|85(B */
    set_pin_num(bd->sente_on_board) ;
    /* $BMU(B ukete $B$rE83+(B */
    p_flag.ote_from_yx = ote->from_yx ;
    p_flag.ote_num = ote->j ;  
    p_flag.ote_pre_code = ote->j_code >> 4 ;
    p_flag.ote_nari = ote->j_code & 0x01 ;
    p_flag.ukete_from_yx = ukete->play.from_yx ;
    p_flag.ukete_to_yx = ukete->play.to_yx ;
    p_flag.ukete_num = ukete->play.j ;
    p_flag.ukete_get_koma = ukete->play.jc ;
    get_koma = (ote->jc == EMP) ;
    ote_ukete(node,&p_flag,get_koma,get_ai_tumi);
    break ;
  case NODE:
    min_point = TUMAZU ;
    min_depth = TUMAZU ;
    temp = ukete->head ;
    access = 0xffff ;
    while (temp != ukete->rear) {
      temp_node = &(tree_sente[temp]) ;
      if((temp_node->point == ukete->point) && 
	 (access > temp_node->access_times)) {
	access = temp_node->access_times ;
      }
      temp ++ ;
    }
    temp = ukete->head ;
    pre = 1 ;
    while (temp != ukete->rear) {
      temp_node = &(tree_sente[temp]) ;
      
      if ((temp_node->point == ukete->point) &&
	  (access == temp_node->access_times)){

	if ((temp_node->link == LINK_SLAVE) && pre) {
	  update_board_sente(&(tree_sente[temp - 1].play));
	  
	  if (tree_sente[temp - 1].leaf == OTE_LEAF)
	    search_sente_tree(temp-1,&(ukete->play),1) ;
	  else
	    search_sente_tree(temp-1,&(ukete->play),0) ;
	
	  reupdate_board_sente(&(tree_sente[temp - 1].play));
	  if (min_depth > tree_sente[temp - 1].tesu) 
	    min_depth = tree_sente[temp - 1].tesu ;
	  if (min_point > tree_sente[temp - 1].point) 
	    min_point = tree_sente[temp - 1].point ;
	}  
	/* $B;X<j$K=>$$!">-4}HW$N%G!<%?$r99?7(B */
	update_board_sente(&(temp_node->play));
	
	/* $B%N!<%I(B temp $B0J2<$rC5:w(B */
	search_sente_tree(temp,&(ukete->play),1) ;
	  
	/* $B;X<j$K=>$$!">-4}HW$N%G!<%?$rI|85(B */
	reupdate_board_sente(&(temp_node->play));
/*
	if (temp_node->point + 2 < ukete->point)
	  ukete->point = temp_node->point ;
*/
	pre = 0 ;
      }
      else 
	pre = 1 ;
      
      if (min_depth > temp_node->tesu) min_depth = temp_node->tesu ;
      if (min_point > temp_node->point) min_point = temp_node->point ;
      if (min_point < TUMISO) {
	min_depth = temp_node->tesu ;
	temp = ukete->rear ;
	ukete->leaf = CLOSE_NODE ;
      }
      else
	temp ++ ;
      if (!process_run) goto memory_full ;
    }	
      
    ukete->tesu = min_depth + 1 ;
    if (min_point == TUMI_MOCHIGOMA_SENTE)
      min_point = TUMI_MOCHIGOMA_GOTE ;
    ukete->point = min_point ;
    break ;
  case CLOSE_NODE:
    break ;
  }
  return ;
  
 memory_full:
  if (min_point > TUMISO) {
    min_point = TUMAZU ;
    min_depth = TUMAZU ;
    temp = ukete->head ;
    while (temp != ukete->rear) {
      if (min_depth > tree_sente[temp].tesu) 
	min_depth = tree_sente[temp].tesu ;
      if (min_point > tree_sente[temp].point)
	min_point = tree_sente[temp].point ;
      temp ++ ;
    }
  }
  ukete->tesu = min_depth + 1 ;
  if (min_point == TUMI_MOCHIGOMA_SENTE)
    min_point = TUMI_MOCHIGOMA_GOTE ;
  ukete->point = min_point ;
}
