/* Copyright (C) 1997 Itoh Hidenori */

#include "shogi.h"

extern TREE_LIST_SENTE	*tree_sente ;
extern TREE_LIST_GOTE	*tree_gote ;

extern USI	        *memory_use_sente ;
extern USI		*memory_use_gote ;

extern BOARD		*bd ;
extern UC 		sente_tobi_kiki[256] ;	

extern int	kiki_table();
extern void	move_koma();
extern void	set_pin_num();
extern void     sente_ote() ;
extern void	update_sente_tobi_kiki_map() ;
extern void	update_board_sente();
extern void	reupdate_board_sente();
extern void	rm_list();
extern int	check_gyoku_nige();

void idou_aigoma(node,uke_list_rear,ai_yx)
USI node,*uke_list_rear ;
UC ai_yx ;
{
  UC ptr,yx,code ;
  
  ptr = bd->gote_on_board ;
  while (ptr != NILL) {
    if ((ptr != bd->ou_num) &&  	       /* $B6L$G$O$J$$(B */
	(bd->koma[ptr].pinf == EMP)) {  /* $BHt$SMx$-$NJI$K$J$C$F$$$J$$(B */

      code = bd->koma[ptr].code ;
      yx = bd->koma[ptr].yx ;
      /* $B6p(B ptr $B$,(B $B>l=j(B ai_yx $B$K0\F02DG=$G$"$l$P0\F09g6p$H$J$k(B */    
      if (kiki_table(code,yx,ai_yx,KIKIARI)) {
	/* $B@.$C$F9g6p$K$J$k(B */ 
	if (((yx > 0x6f) || (ai_yx > 0x6f)) &&  (code & 0x01))	
	  move_koma(node,uke_list_rear,ptr,yx,ai_yx,NARI,0);
	/* $B@.$i$:9g6p$K$J$k(B */
	move_koma(node,uke_list_rear,ptr,yx,ai_yx,NARAZU,0);
      }
    }
    ptr = bd->koma[ptr].next ;
  }
}

void ukete_idou_ai(node,uke_list_rear) 
USI	node,*uke_list_rear ;
{
  UC vec,ote_num,ote_yx,yx  ;
    
  if ((sente_tobi_kiki[bd->ou_yx] == 1) &&	/* $B@h<j$NMx$-$OHt$SMx$-$N$_$G(B 	*/
      (bd->sente_kiki_map[bd->ou_yx] == 0)) {	/* $BJ#?t6p$NN>2&<j$G$O$J$$(B 	*/
  
    /* $B9g6p$r8uJdCO$r9M$($k(B	    */
    
    vec     = bd->koma[bd->ou_num].vec ;
    ote_num = bd->koma[bd->ou_num].pinf ;
    ote_yx  = bd->koma[ote_num].yx ;
        
    for (yx = bd->ou_yx - vec ; yx != ote_yx ; yx -= vec)
      idou_aigoma(node,uke_list_rear,yx);
  }
}

int idou_saki(ai_yx)
UC ai_yx ;
{	
  UC dummy ;
    
  switch (bd->yx[ai_yx]) {
  case AIGOMA:
  case OUT:
    dummy = 0 ;
    break ;
  case EMP:
    dummy = 1 ;
    break ;
  default:
    if (bd->koma[bd->yx[ai_yx]].turn == SENTE) dummy = 2 ;
    else dummy = 0 ;
  }
  return (dummy);
}	

int sokuzumi_ai_hantei(ai_yx,flag,ote_num)
UC 	ai_yx ;
int 	flag ;
UC 	ote_num ;
{
  PLAY_FLAG	p_flag ;
  UC ptr,yx,code,ote_yx ;
  int dummy;
  PLAY *p_ptr ;
  USI	ai_list_head,ai_list_rear ;
  
  ai_list_head = ai_list_rear = *memory_use_sente ;

  p_flag.ote_from_yx = 0 ;
  p_flag.ote_num = EMP ;  
  p_flag.ote_pre_code = EMP ;
  p_flag.ote_nari = 0 ;
  p_flag.ukete_from_yx = 0 ;
  p_flag.ukete_to_yx = 0 ;
  p_flag.ukete_num = EMP ;
  p_flag.ukete_get_koma = EMP ;
    
  bd->yx[ai_yx] = AIGOMA ;
  bd->koma[AIGOMA].yx   = ai_yx ;
  bd->koma[AIGOMA].turn = GOTE  ;
  bd->koma[AIGOMA].code = AIGOMA ;
        
  update_sente_tobi_kiki_map() ;
  set_pin_num(bd->sente_on_board);
  sente_ote(0,&ai_list_rear,&p_flag,1);

  dummy = 1 ;
  while ((ai_list_head != ai_list_rear) && (dummy)) {
    p_ptr = &(tree_sente[ai_list_head].play) ;
    update_board_sente(p_ptr);
    /* $BHt$SMx$-%^%C%W$N99?7(B */
    update_sente_tobi_kiki_map() ;
    /* pin $B$N99?7(B */
    set_pin_num(bd->sente_on_board);
    dummy = 0 ;
    for (;;){
      if ((flag == 0) && (p_ptr->to_yx != ai_yx)){
	dummy = 1 ;
	break ;
      }
      /* $B6L$,F($2$i$l$k(B */
      if (check_gyoku_nige(bd->ou_yx + FL) && idou_saki(bd->ou_yx + FL)) {
	dummy = 1 ;
	break ;
      }
      if (check_gyoku_nige(bd->ou_yx + FD) && idou_saki(bd->ou_yx + FD)) {
	dummy = 1 ;
	break ;
      }
      if (check_gyoku_nige(bd->ou_yx + FR) && idou_saki(bd->ou_yx + FR)) {
	dummy = 1 ;
	break ;
      }
      if (check_gyoku_nige(bd->ou_yx + LT) && idou_saki(bd->ou_yx + LT)) {
	dummy = 1 ;
	break ;
      }
      if (check_gyoku_nige(bd->ou_yx + RT) && idou_saki(bd->ou_yx + RT)) {
	dummy = 1 ;
	break ;
      }
      if (check_gyoku_nige(bd->ou_yx + BL) && idou_saki(bd->ou_yx + BL)) {
	dummy = 1 ;
	break ;
      }
      if (check_gyoku_nige(bd->ou_yx + BD) && idou_saki(bd->ou_yx + BD)) {
	dummy = 1 ;
	break ;
      }
      if (check_gyoku_nige(bd->ou_yx + BR) && idou_saki(bd->ou_yx + BR)) {
	dummy = 1 ;
	break ;
      }
      if ((bd->koma[AIGOMA].pinf == EMP) && (p_ptr->jc != AIGOMA)){
	dummy = 1 ;
	break ;
      }
      
      if (sente_tobi_kiki[bd->ou_yx] + bd->sente_kiki_map[bd->ou_yx] == 1)  {
	if (sente_tobi_kiki[bd->ou_yx] == 0)
	  ote_yx = p_ptr->to_yx ;
	else
	  /* $BHt$S6p$N2&<j$r?)$i$C$?!J6u$-2&<j$r4^$`!K(B */
	  ote_yx = bd->koma[bd->koma[bd->ou_num].pinf].yx ;
		
	/* $B2&<j$N6p$r<h$k$3$H$r9M$($k(B */
	ptr = bd->gote_on_board ;
	while (ptr != NILL) {
	  if ((ptr != bd->ou_num) && 	        /* $B6L$G$O$J$/!"Ht$SMx$-(B */
	      (bd->koma[ptr].pinf == EMP)) { 	/* $B$NJI$K$J$C$F$$$J$$(B   */
	    code = bd->koma[ptr].code ;
	    yx = bd->koma[ptr].yx ;
	    /* $B6p(B ptr $B$,(B $B2&<j$N6p$KMx$-$,$"$l$P<h$k$3$H$r9M$($k(B */    
	    if (kiki_table(code,yx,ote_yx,KIKIARI)) {
	      dummy = 1 ;
	      break ;
	    }
	  }
	  ptr = bd->koma[ptr].next ;	
	}
	/* $B9g6p$N2DG=@-(B */
	if ((sente_tobi_kiki[bd->ou_yx] == 1) &&    /* $B@h<j$NMx$-$OHt$SMx$-$N$_(B */
	    (bd->sente_kiki_map[bd->ou_yx] == 0) && /* $BJ#?t6p$NO"782&<j$G$O$J$$(B */
	    (ote_num != bd->koma[bd->ou_num].pinf) && /*  $B@h$[$I$N6p0J30$N2&<j(B    */
	    (p_ptr->jc != AIGOMA)) {
	  dummy = 1 ;
	  break ;
	}
      }
      if ((p_ptr->from_yx == 0x00) && (p_ptr->j_code >> 4 == FU)) dummy = 1 ;
      break ;
    }
    reupdate_board_sente(p_ptr);
    ai_list_head ++ ;
  }
  bd->yx[ai_yx] = EMP ;
  
  update_sente_tobi_kiki_map() ;
  set_pin_num(bd->sente_on_board);
  return (dummy);
}

int aigoma_ok(ai_yx,code)
UC ai_yx ;
UC *code ;	
{
  int double_fu = 0 ;
  UC  ptr ;
  
  double_fu = bd->gote_fu[ai_yx & 0x0f] ;


  if ((double_fu == 0) && (ai_yx < 0x90)) {
    ptr = bd->gote_in_hand ;
    while ((ptr != NILL) && (bd->koma[ptr].code != FU)) 
      ptr = bd->koma[ptr].next ;
    if (ptr != NILL) {
      *code = FU ;		/*	$B9g6p$KJb$r;H$&(B		*/
      return 1 ;
    }
  }
  if (ai_yx < 0x80) {
    ptr = bd->gote_in_hand ;
    while ((ptr != NILL) && (bd->koma[ptr].code != KE))
      ptr = bd->koma[ptr].next ;
    if (ptr != NILL) {
      *code = KE ;		/*	$B9g6p$K7KGO$r;H$&(B	*/
      return 1 ;
    }
  }
  if (ai_yx < 0x90) {
    ptr = bd->gote_in_hand ;
    while ((ptr != NILL) && (bd->koma[ptr].code != KY))
      ptr = bd->koma[ptr].next ;
    if (ptr != NILL) {
      *code = KY ;              /*      $B9g6p$K9a<V$r;H$&(B 	*/
      return 1 ;
    }
  }
  ptr = bd->gote_in_hand ;
  while ((ptr != NILL) && (bd->koma[ptr].code != GI))
    ptr = bd->koma[ptr].next ;
  if (ptr != NILL) {
    *code = GI ;		/*      $B9g6p$K6d>-$r;H$&(B 	*/
    return 1 ;
  }
  ptr = bd->gote_in_hand ;
  while ((ptr != NILL) && (bd->koma[ptr].code != KI))
    ptr = bd->koma[ptr].next ;
  if (ptr != NILL) {
    *code = KI ;		/*      $B9g6p$K6b>-$r;H$&(B 	*/
    return 1 ;
  }
  ptr = bd->gote_in_hand ;
  while ((ptr != NILL) && (bd->koma[ptr].code != KA))
    ptr = bd->koma[ptr].next ;
  if (ptr != NILL) {
    *code = KA ;		/*      $B9g6p$K3Q9T$r;H$&(B 	*/
    return 1 ;
  }
  ptr = bd->gote_in_hand ;
  while ((ptr != NILL) && (bd->koma[ptr].code != HI))
    ptr = bd->koma[ptr].next ;
  if (ptr != NILL) {
    *code = HI ;		/*      $B9g6p$KHt<V$r;H$&(B 	*/
    return 1 ;
  }
  
  return 0 ;
}


void uke_aigoma(node,uke_list_rear,flag)
USI	node,*uke_list_rear ;
int	flag ;
{
  UC vec,ote_num,ote_yx,yx,code  ;

  /* $BHt$SMx$-$K$h$k2&<j!JHt<V!"3Q(B etc.$B!K$N;~!"9g6p$r9M$($k(B */
  if ((sente_tobi_kiki[bd->ou_yx] == 1) &&	/* $B@h<j$NMx$-$OHt$SMx$-$N$_$G(B 	*/
      (bd->sente_kiki_map[bd->ou_yx] == 0)){	/* $BJ#?t6p$NN>2&<j$G$O$J$$(B 	*/
    /* $B9g6p$r8uJdCO$r9M$($k(B	    */
    vec     = bd->koma[bd->ou_num].vec ;
    ote_num = bd->koma[bd->ou_num].pinf ;
    ote_yx  = bd->koma[ote_num].yx ;

    if (bd->gote_in_hand != NILL)
      for (yx = bd->ou_yx - vec ; yx != ote_yx ; yx -= vec){
	if (aigoma_ok(yx,&code))
	  if (sokuzumi_ai_hantei(yx,flag,ote_num))
	    move_koma(node,uke_list_rear,AIGOMA,code,yx,NARAZU,0);
      }
  }
}
