/* Copyright (C) 1997 Itoh Hidenori */

#include <stdio.h>
#include <stdlib.h>

/*	$B%a%b%j%5%$%:!J%9%?%C%/!K(B	*/
#define MEMORY_SIZE_SENTE	3000
#define MEMORY_SIZE_GOTE        8000

/* debug flag */
/*
#define DEBUG1          0
#define CASIM           0
*/
#define SHOW_BROAD      0
/*
#define SHOW_BOARD      0
*/
/* $B6p$N<oN`%3!<%I(B			 */
/* $B2<0L(B 1 bit $B$,(B 1 $B$J$i$P(B $B@.$k$3$H$,2DG=(B */
#define	OU		0x00	/* $B6L(B	*/
#define	KI		0x02	/* $B6b(B	*/
#define	RY		0x04	/* $BN62&(B	*/
#define	HI		0x05	/* $BHt<V(B	*/
#define	UM		0x06	/* $BN6GO(B	*/
#define	KA		0x07	/* $B3Q9T(B	*/
#define	NG		0x08	/* $B@.6d(B	*/
#define	GI		0x09	/* $B6d(B	*/
#define	NK		0x0a	/* $B@.7K(B	*/
#define	KE		0x0b	/* $B7KGO(B	*/
#define	NY		0x0c	/* $B@.9a(B	*/
#define	KY		0x0d	/* $B9a<V(B	*/
#define TO		0x0e	/* $B$H(B	*/
#define	FU		0x0f	/* $BJb(B	*/

/* 	$B>-4}HW30(B			*/
#define OUT    	 	0xff		

/*	$B6uGr!J6p$J$7!K(B			*/
#define EMP		0x7f
#define EMP_1   	0xfe

#define AIGOMA		39	/* dummy */

/*	$BAjBP0LCV$N%3!<%I(B		 */

#define	KL		0xe1		/* ----+----+---- */
#define	KR		0xdf		/*  KL |    | KR  */
#define FL		0xf1		/* ----+----+---- */
#define FD		0xf0		/*  FL | FD | FR  */
#define FR		0xef		/* ----+----+---- */
#define	LT		0x01		/*  LT | $B"%(B | RT  */
#define	RT		0xff		/* ----+----+---- */
#define BL		0x11		/*  BL | BD | BR  */
#define BD		0x10		/* ----+----+---- */
#define	BR		0x0f            /* KBL |    | KBR */ 
#define KBL		0x21		/* ----+----+---- */
#define KBR		0x1f		/* $B"%(B : $B3:Ev6p(B    */  

/*	$B%N!<%I$N<oJL%3!<%I(B		*/
#define NODE       	0	/* $B%N!<%I(B		*/
#define UKETE_LEAF 	1	/* $B<u<jMU%N!<%I(B 	*/
#define OTE_LEAF   	2	/* $B2&<jMU%N!<%I(B 	*/
#define CLOSE_NODE      3	/* $B5M$aJD:?%N!<%I(B	*/
#define BROAD_NODE	4	/* $BJ|Aw:Q$_%N!<%I(B	*/
#define SUB_TREE_NODE   5	/* $BItJ,LZ@\B3%N!<%I(B	*/
#define AI_NODE		6	/* $B9g6p%N!<%I(B		*/
#define DELETE_NODE	7	/* $BGQ4~%N!<%I(B		*/

/*	$B@h<j!"8e<j$N<oJL%3!<%I(B		*/

#define SENTE		0
#define GOTE		1

/*	$B5M$a!"IT5M$a>uBV%3!<%I(B		*/

/*#define TUMI    	-999		*//* $B;}6p$J$7$G5M$_(B	*/
/*#define TUMI_MOCHIGOMA_SENTE	-950	*//* $B;}6pM-$j$G5M$_(B($B2&<j(B)	*/
/*#define TUMI_MOCHIGOMA_GOTE	-1050	*//* $B;}6pM-$j$G5M$_(B($B<u<j(B)	*/
/*#define TUMAZU   	999		*//* $BIT5M(B			*/

#define TUMI            -999
#define TUMI_MOCHIGOMA_SENTE    -950
#define TUMI_MOCHIGOMA_GOTE     -1050
#define TUMAZU          999
#define TUMISO          -900            /* -900 */
#define AISHIRABE       -1              /* -1 */
#define OMAKASE         500             /* 100 */

/*	$B@.$j!"IT@.$j(B $B%3!<%I(B		*/

#define NARAZU  	0
#define NARI    	1

/*	$B6p%j%9%H$N=*$j(B			*/

#define NILL		63

/*	$BMx$-%^%C%W@)8f%3!<%I(B		*/

#define KIKIARI    	0
#define	KIKINASHI  	1

/*	$BC5:wLZ%j%s%/@)8f%3!<%I(B		*/

#define NON_LINK     	0 	/* $BFHN)(B	*/
#define LINK_MASTER 	1 	/* $B2&<j3MF@<u<j$r6&M-(B($B%^%9%?(B) 	*/	
#define LINK_SLAVE  	2 	/* $B2&<j3MF@<u<j$r6&M-(B($B%9%l!<%V(B) */

/****************************************/
/*	$B7?Dj5A(B				*/
/****************************************/

typedef	unsigned int	UI ;
typedef unsigned char   UC ; 
typedef unsigned short int USI ;
typedef short int       SI ;

/*	$B6p%j%9%H(B			*/

typedef struct {
  UC yx   ;			/* $B6p0LCV(B(y:4bit|x:4bit)	*/
  UC turn ;			/* $B?X1D(B($B@h<j(Bor$B<u<j(B)		*/
  UC code ;			/* $B6p%3!<%I(B			*/
  UC pin  ;			/* $BHt$SMx$-$,$"$?$C$F$$$k6pHV9f(B	*/
  UC pinf ;			/* $BHt$SMx$-$,$"$?$C$F$$$kHt6p(B	*/
  UC vec  ;			/* $BHt$SMx$-$NJ}8~(B		*/
  UC prev ;			/* $B6p%j%9%H$NA0%]%$%s%?(B		*/
  UC next ;			/* $B6p%j%9%H$N<!%]%$%s%?(B		*/
} KOMA ;

/*	$B>-4}HW(B				*/

typedef struct {
  KOMA koma[40];			/*	$B6p%j%9%H(B	*/
  UC yx[256];				/*	$B>-4}HW(B		*/
  UC sente_kiki_map[256];		/*	$B@h<jMx$-%^%C%W(B	*/
  UC sente_fu[10] ;			/*	$B@h<j#2Jb%U%i%0(B	*/
  UC sente_on_board ;			/*	$B@h<jHW6p%j%9%H(B	*/
  UC sente_in_hand ;			/*     	$B@h<j;}6p%j%9%H(B	*/
  UC gote_fu[10] ;			/*	$B8e<j#2Jb%U%i%0(B  */
  UC gote_on_board ;			/*	$B8e<jHW6p%j%9%H(B	*/
  UC gote_in_hand ;			/*	$B8e<j;}6p%j%9%H(B	*/
  UC ou_num ;				/*	$B6L6pHV9f(B	*/	
  UC ou_yx ;				/*	$B6L8=:_0LCV(B	*/
  UC tobi_koma ;			/*	$BBg6p?t(B		*/
  UC sente_koma_num ;			/*	$B@h<j6p?t(B	*/
} BOARD ;

/*	$B;X<j(B				*/

typedef struct {
  UC 	from_yx ;			/* $B0\F085:BI8(B	y | x 	*/
  UC 	to_yx ;				/* $B0\F0@h:BI8(B 	y | x	*/
  UC 	j  ;				/* $B0\F06pHV9f(B 	num	*/
  UC 	jc ;				/* $BJa3M6pHV9f(B 	num	*/
  UC 	j_code ;			/* $B0\F06p<oN`(B code|nari */
  UC 	jc_code ;			/* $BJa3M6p<oN`(B 	code	*/
  UC	state ;
  UC	turn  ;  			/* $B@.$j(B $B!?(B $BIT@.$j(B	*/	
} PLAY ;

/*	$BC5:wLZ(B				*/

typedef struct 
{
  PLAY	play  ;				/* $B;X<j(B			*/	
  UC 	link ;				/* $B>uBV(B			*/	
  UC	leaf  ;				/* $B%N!<%I<oN`(B		*/	
  SI    point ;   			/* $BI>2ACM(B 		*/
  SI    tesu ;				/* $B<j?t(B			*/
  USI	access_times ;			/* $BI>2A2s?t(B		*/
  USI	parent ;			/* $B?F%N!<%I(B             */
  USI  	sub_tree ;			/* $B@\B3ItJ,LZ(B		*/	
  USI   get_head ;			/* $BJa3M;X<j!J8e<j!K(B	*/
  USI   get_rear ;			/* $BJa3M;X<j!J8e<j!K(B	*/
  USI   away_head ;			/* $BF(Hr;X<j!J8e<j!K(B	*/
  USI   away_rear ;			/* $BF(Hr;X<j!J8e<j!K(B	*/
  USI	ai_head ;			/* $B9g6p;X<j!J8e<j!K(B     */	
  USI	ai_rear ;			/* $B9g6p;X<j!J8e<j!K(B     */
} TREE_LIST_SENTE ;

typedef struct 
{
  PLAY	play  ;				/* $B;X<j(B			*/	
  UC 	link ;				/* $B>uBV(B			*/	
  UC	leaf  ;				/* $B%N!<%I<oN`(B		*/	
  SI    point ;   			/* $BI>2ACM(B 		*/
  SI    tesu ;				/* $B<j?t(B			*/
  USI	parent ;			/* $B?F%N!<%I(B		*/	
  USI   head ;				/* $BJa3M;X<j!J8e<j!K(B	*/
  USI   rear ;				/* $BJa3M;X<j!J8e<j!K(B	*/
  USI	get_ai_tumi ;
  USI	pre_get_ai_tumi ;
} TREE_LIST_GOTE ;

typedef struct {
  UC ote_from_yx ;			/* $B2&<j6p$N0\F085:BI8(B 	*/
  UC ote_num ;				/* $B2&<j6pHV9f(B 		*/
  UC ote_pre_code ;			/* $B2&<j6p$N85$N6p%3!<%I(B */
  UC ote_nari ;				/* $B2&<j6p$N@.$j!?IT@.(B	*/
  UC ukete_from_yx ;			/* $B<u<j6p$N0\F085:BI8(B 	*/
  UC ukete_to_yx ;			/* $B<u<j6p$N0\F0@h:BI8(B   */
  UC ukete_num ;			/* $B<u<j6pHV9f(B 		*/
  UC ukete_get_koma ; 			/* $B<u<jJa3M6pHV9f(B 	*/
} PLAY_FLAG ;

/************************/
/* $B%a%C%;!<%89=B$BN(B	*/
/************************/

typedef struct {
  USI		p_tree ;	/* $B852&<j%N!<%I$NItJ,LZHV9f(B */
  USI		p_node ;	/* $B852&<j%N!<%I$N%j%9%HHV9f(B */
  PLAY		ote ;		/* $B2&<j9=B$BN(B	*/	
  PLAY		uke[32] ;	/* $B<u<j%j%9%H(B	*/
  SI		uke_get ;	/* $B<h$k<u<j$N?t(B */
  SI		uke_away ;	/* $BF($2$k<u<j$N?t(B */
  SI		uke_ai ;	/* $B9g6p<u<j$N?t(B */
  SI		point ;		/* $B2&<j$NI>2ACM(B	*/
} JOB_NODE ;

/* $B%[%9%H$+$i%;%k$KAw$k%a%C%;!<%89=B$BN(B */

typedef struct {
  BOARD       	bd ;		/* $B>-4}HW%G!<%?(B */
  JOB_NODE	job ;		/* $B2&<j!]<u<j%G!<%?(B */
} MSG ;

/* $B%;%k$+$i%[%9%H$KAw$kItJ,LZ9=B$BN(B	*/

typedef struct {
  USI		p_tree ;
  USI		p_node ;
  TREE_LIST_SENTE sente[MEMORY_SIZE_SENTE] ;
  TREE_LIST_GOTE  gote [MEMORY_SIZE_GOTE] ;
  USI		use_sente ;
  USI		use_gote ;
} MSG_RE ;

/* $B%;%k$+$i%[%9%H$KAw$kDd;_;~%a%C%;!<%89=B$BN(B */

typedef struct 
{
  USI           p_tree ;
  USI           p_node ;
  SI		point ;
  SI		tesu ;
  USI		access_times ;
  USI		dummy ;
} QUIT_MSG_RE ;

