/* Copyright (C) 1997 Itoh Hidenori */

#include "shogi.h"
#define  CHANGE  99 

extern BOARD 	*bd ;		

char file[64];
FILE *fp ;

UC count = 0 ;    
int fu = 18 ;
int ke = 4 ;
int ky = 4 ;
int gi = 4 ;
int ki = 4 ;
int hi = 2 ;
int ka = 2 ;

void set_koma_code(yx,turn,code,orig)
UC *orig ;
UC yx,turn,code ;
{
    bd->yx[yx] = count ;
    bd->koma[count].yx = yx ;
    bd->koma[count].turn = turn ;
    bd->koma[count].code = code ;
    bd->koma[count].next = *orig ;
    bd->koma[count].prev = NILL ;
    if (*orig != NILL)	bd->koma[*orig].prev = count ;  
    *orig = count ;
    count++ ;
}

void input_data (orig,turn) 
UC	*orig ;
UC      turn ;
{
    int code,x,y ;
    UC yx ;
    
    for (;;) {
	fscanf (fp,"%d",&code) ;
	if (code == CHANGE) break ;
	fscanf (fp,"%d %d",&x,&y);
	yx = (char)((y << 4) + x) ;
    	if (code == OU) {
	    bd->ou_yx = yx ;


	    bd->ou_num = count ;
	}
	set_koma_code(yx,turn,(char)code,orig);
	if ((code == TO) || (code == FU)) {fu-- ;continue ;}    /* $B$H(B	 $BJb(B */
	if ((code == NY) || (code == KY)) {ky-- ;continue ;}	/* $B@.9a(B  $B9a(B */
	if ((code == NK) || (code == KE)) {ke-- ;continue ;}	/* $B@.7K(B  $B7K(B */
	if ((code == NG) || (code == GI)) {gi-- ;continue ;}	/* $B@.6d(B  $B6d(B */
	if ((code == UM) || (code == KA)) {ka-- ;continue ;}	/* $BGO(B	 $B3Q(B */
	if ((code == RY) || (code == HI)) {hi-- ;continue ;}	/* $BN6(B	 $BHt(B */
	if (code == KI) {ki-- ;}				/* $B6b(B	    */
    }
}

void set_gote_koma_in_hand(orig)
UC	*orig ;
{
  while (ke) {			/* $B7KGO$N;D$j$r8e<j$N;}$A6p$K(B	*/
    set_koma_code(0,GOTE,KE,orig);
    ke--;
  }
  
  while (hi) {			/* $BHt<V$N;D$j$r8e<j$N;}$A6p$K(B 	*/
    set_koma_code(0,GOTE,HI,orig);
    hi--;
  }
  
  while (ka) {			/* $B3Q$N;D$j$r8e<j$N;}$A6p$K(B 	*/
    set_koma_code(0,GOTE,KA,orig);
    ka--;
  }

  while (gi) {			/* $B6d$N;D$j$r8e<j$N;}$A6p$K(B 	*/
    set_koma_code(0,GOTE,GI,orig);
    gi--;
  }

  while (ki) {			/* $B6b$N;D$j$r8e<j$N;}$A6p$K(B 	*/
    set_koma_code(0,GOTE,KI,orig);
    ki--;
  }

  while (ky) {			/* $B9a<V$N;D$j$r8e<j$N;}$A6p$K(B 	*/
    set_koma_code(0,GOTE,KY,orig);
    ky--;
  }

  while (fu) {			/* $BJb$N;D$j$r8e<j$N;}$A6p$K(B 	*/
    set_koma_code(0,GOTE,FU,orig);
    fu--;
  }
}	

/* pin $B$N99?7(B */
/*
void tobi_kiki_pin(i,vec)
UC	i,vec;
{	    
    int ct = 0 ;
    UC temp,koma_num ;

    koma_num = OUT;
    for (temp = bd->koma[i].yx + vec;temp != bd->ou_yx;temp += vec) {
	if (bd->yx[temp] != EMP) {
	    koma_num = bd->yx[temp] ;
	    ct++ ;
	}		
	if (ct > 1) break ;
    }
    if (ct == 1) {
	bd->koma[i].pin = koma_num ;
	bd->koma[koma_num].pinf = i ;
	bd->koma[koma_num].vec = vec ;
    }
    if (ct == 0) {
	bd->koma[i].pin = EMP ;
	bd->koma[bd->ou_yx].pinf = i ;
	bd->koma[bd->ou_yx].vec = vec ;
    }
    if (ct >  1) bd->koma[i].pin = OUT ;
}
*/


void set_sente_kiki_map()
{
  UC ptr,yx ;
    
  ptr = bd->sente_on_board ;
  while (ptr != NILL) {
    yx = bd->koma[ptr].yx ;
    switch (bd->koma[ptr].code) {
    case HI:
      bd->sente_kiki_map[0x00ff & (yx + FD)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + LT)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + RT)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + BD)]++ ;
      break ;
    case KA:
      bd->sente_kiki_map[0x00ff & (yx + FL)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + FR)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + BL)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + BR)]++ ;
      break ;
    case KE:
      bd->sente_kiki_map[0x00ff & (yx + KL)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + KR)]++ ;
      break ;
    case OU:
    case RY:
    case UM:
      bd->sente_kiki_map[0x00ff & (yx + LT)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + RT)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + BD)]++ ;
    case GI:
      bd->sente_kiki_map[0x00ff & (yx + FL)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + FR)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + BL)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + BR)]++ ;
    case KY:
    case FU:
      bd->sente_kiki_map[0x00ff & (yx + FD)]++ ;
      break ;
    default:
      bd->sente_kiki_map[0x00ff & (yx + FL)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + FD)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + FR)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + LT)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + RT)]++ ;
      bd->sente_kiki_map[0x00ff & (yx + BD)]++ ;
    }
    if (bd->koma[ptr].code == FU)		/* $B#2JbKI;_%U%i%0%;%C%H(B */
      bd->sente_fu[yx & 0x0f] = 1 ;
    ptr = bd->koma[ptr].next ;
  }
}

void set_gote_fu(ptr)
UC ptr ;
{
  UC yx ;
    
  while (ptr != NILL) {
    if (bd->koma[ptr].code == FU) {           /* $B#2JbKI;_%U%i%0%;%C%H(B */
      yx = bd->koma[ptr].yx ;
      bd->gote_fu[yx & 0x0f] = 1 ;
    }
    ptr = bd->koma[ptr].next ;
  }
}

/* $BLdBj$N>pJs$r%U%!%$%k$+$iFI$_$H$k!#(B */
void load_data(argc,argv)
int argc ;
char **argv ; 
{
  UC sente_on_board ;
  UC sente_in_hand ;
  UC gote_on_board ;
  UC gote_in_hand ;
  UC ptr ;
  int i,j,k,l ;

  if (argc > 1)
    strcpy(file,argv[1]);      
  else {
    printf("Filename of Problem :");
    scanf("%s",file);
  }
    
  if (NULL == (fp = fopen(file,"r"))) {
    printf ("***** Cannot Open File : %s *****\n",file);
    exit(0);
  }
  
  /* $B=i4|CM@_Dj(B */
  
  for (i=0;i<256;i++) bd->yx[i] = OUT ;	/* $B>-4}HW$N=i4|2=(B	*/
  for (i=1;i<10;i++) {
    k = i << 4 ;
    for (j=1;j<10;j++) {
      l = k + j ;
      bd->yx[l] = EMP ;
    }
  }
    
  for (i=0;i<256;i++) {			/* $BMx$-%^%C%W$N=i4|2=(B	*/
    bd->sente_kiki_map[i] = 0 ;
  }
  for (i=0;i<40;i++) {
    bd->koma[i].pin = OUT ;
    bd->koma[i].pinf = EMP ;
  }
    
  for (i=0;i<10;i++) {			/* $B#2JbKI;_%U%i%0=i4|2=(B	*/
    bd->sente_fu[i] = 0 ;
    bd->gote_fu[i] = 0 ;
  }
        
  /* $BHW>e!";}$A6p$N=i4|2=(B	*/
  
  sente_on_board = sente_in_hand = gote_on_board = gote_in_hand = NILL ;
  bd->sente_koma_num = bd->tobi_koma = 0 ;
    
  /* $B@h<jHW>e6p%G!<%?%;%C%H(B */
  input_data(&sente_on_board,SENTE);
  ptr = sente_on_board ;
  while (ptr != NILL)    {
    (bd->sente_koma_num) ++ ;
    ptr = bd->koma[ptr].next ;
  }
  /* $B@h<j;}$A6p%G!<%?%;%C%H(B */
  input_data(&sente_in_hand,SENTE);
  ptr = sente_in_hand ;
  while (ptr != NILL)    {
    if ((bd->koma[ptr].code == HI) || (bd->koma[ptr].code == KA) ||
	(bd->koma[ptr].code == KE) || (bd->koma[ptr].code == KY))
      (bd->tobi_koma)++ ;
    (bd->sente_koma_num) ++ ;
    ptr = bd->koma[ptr].next ;
  }
  /* $B8e<jHW>e6p6p%G!<%?%;%C%H(B */
  input_data(&gote_on_board,GOTE);
  /* $B8e<j;}$A6p6p%G!<%?%;%C%H(B */
  set_gote_koma_in_hand(&gote_in_hand);
  
  /* $B3F%]%$%s%?@_Dj(B */
  bd->yx[0] = OUT ;
  bd->sente_on_board = sente_on_board ;
  bd->sente_in_hand = sente_in_hand ;
  bd->gote_on_board = gote_on_board ;
  bd->gote_in_hand = gote_in_hand ;
  
  set_pin_num(bd->sente_on_board);
  /*	$BMx$-%^%C%W$N%;%C%H(B */
  set_sente_kiki_map();
  set_gote_fu(bd->gote_on_board);
  
  fclose(fp);
}
