/* Copyright (C) 1997 Itoh Hidenori */

#include "host.h"

extern MSG	msg ;
extern QUIT_MSG_RE quit_msg_re ;

extern BOARD		*bd ;
extern TREE_NODE_LIST	*tree ;
extern char 		*tree_flag ;
extern CELL_STATE	*c_state ;

extern int	number_of_useing_cells ;
extern int	useing_tasks ;

extern int	cell_x,cell_y ;

extern int 	issue_job_num ;
extern int      find_answer ;
extern int 	total_tree ;

extern void	update_board_sente() ;
extern void	reupdate_board_sente() ;
extern void	update_board_gote() ;
extern void	reupdate_board_gote() ;
extern void	ab_ext_gote() ;
extern void	link_broken() ;

extern void	free_tree() ;
extern char 	file[64];

USI def_receive_tree() {
  int i ;
  
  i=0 ;
  while (tree_flag[i]) i++ ;
  return (i) ;
}

void recv_data() {
  USI 	p_tree,p_node ;
  int	cell_num,cell_task,recv_tree ;
  
  qrecv() ;
  cell_num = getmcid() ;
  cell_task = getmtid() ;
  c_state[cell_num].task[cell_task].busy = 0 ;
  c_state[cell_num].jobs -= 1 ;
  issue_job_num -- ;
  switch(getmtype()) {
  case JOB:
    recv_tree = def_receive_tree() ;
    readmsg(&(tree[recv_tree]),sizeof(MSG_RE)) ;
    p_tree = tree[recv_tree].p_tree ;
    p_node = tree[recv_tree].p_node ;
#ifdef	SHOW_RECV
    printf("Recieve from cell_%d task_%d : Tree %d %d : Point = %d : SN = %d : GN = %d : ",
	   cell_num,cell_task,p_tree,p_node,tree[recv_tree].sente[0].point,
	   tree[recv_tree].use_sente,tree[recv_tree].use_gote) ;
#endif
    if (!c_state[cell_num].task[cell_task].ignore) {
      tree[p_tree].sente[p_node].leaf = SUB_TREE_NODE ;
      tree[p_tree].sente[p_node].sub_tree = recv_tree ;
      tree_flag[recv_tree] = 1 ;
      total_tree ++ ;
#ifdef  SHOW_RECV
      printf ("ADD_tree %d : ",recv_tree) ;
#endif
      tree[p_tree].sente[p_node].point = 
	tree[recv_tree].sente[0].point ;
      tree[p_tree].sente[p_node].tesu =
	tree[recv_tree].sente[0].tesu ;
/*
      tree[p_tree].sente[p_node].access_times =
	tree[recv_tree].sente[0].access_times ;
*/
      ab_ext_gote(p_tree,tree[p_tree].sente[p_node].parent) ;
    }
#ifdef  SHOW_RECV
    else {
      printf ("Ignore Job : ") ;
    }
#endif
    break ;
  case QUIT_RECV:
    readmsg(&quit_msg_re,sizeof(QUIT_MSG_RE)) ;
#ifdef  SHOW_RECV
    printf("Recieve from cell_%d task_%d : Point = %d : ",cell_num,cell_task,quit_msg_re.point) ;
#endif
    if (!c_state[cell_num].task[cell_task].ignore) {
      p_tree = quit_msg_re.p_tree ;
      p_node = quit_msg_re.p_node ;
      tree[p_tree].sente[p_node].point = quit_msg_re.point ;
      tree[p_tree].sente[p_node].tesu = quit_msg_re.tesu ;
/*
      tree[p_tree].sente[p_node].access_times = quit_msg_re.access_times ;
*/
      if (quit_msg_re.point == TUMAZU) {
	tree[p_tree].sente[p_node].leaf = CLOSE_NODE ;
	link_broken(p_tree,p_node) ;
      }
      else { 
	tree[p_tree].sente[p_node].leaf = OTE_LEAF ;
	tree[p_tree].sente[p_node].sub_tree = 0 ;
#ifdef  SHOW_RECV
	printf ("Free_tree : ") ;
#endif
      }
      ab_ext_gote(p_tree,tree[p_tree].sente[p_node].parent) ;
    }
#ifdef  SHOW_RECV
    else {
      printf ("Ignore Job : ") ;
    }
#endif
    break ;
  }
#ifdef  SHOW_RECV
  printf ("Complete\n") ;
#endif
  c_state[cell_num].task[cell_task].ignore = 0 ;
  if (tree[0].gote[0].point < TUMISO && !find_answer) {
    printf("\nFound answer and Stop Process\n") ;
    find_answer = 1 ;
  }
}

void check_msg_from_cell() {
  int i,signal ;
  
  while (cprobe()) {
    recv_data() ;
    if (find_answer) return ;
    free_tree() ;
    if (total_tree == MAX_TREE) {
      printf("Over Number of Tree array\n") ;
      printf("%s\n",file) ;
      signal = EXIT ;
      for (i=0;i<MAX_TASK;i++) {
	cbroad(i,EXIT,&signal,sizeof(int)) ;
      }
      waitexit() ;
      host_exit(0) ;
    }
  }
}	
