/* Copyright (C) 1997 Itoh Hidenori */

#include "host.h"

extern MSG		msg ;
extern BOARD		*bd ;
extern UC 		sente_tobi_kiki[256] ;	
extern TREE_NODE_LIST	*tree ;

extern void             xboard() ;
extern void             xkoma_in_hand() ;
extern void		xmove_koma_board() ;
extern void             xdisplay_flush() ;
extern void             xclosedisplay() ;
extern void		update_board_sente() ;
extern void		update_board_gote() ;

/* $B2rEz<j6Z$NA*Br(B 		*/
/* $B$b$C$H$bD9$/F($l$k<u<j$rA*$V(B */
int host_select_kai(turn,sub_tree,ptr,pt)
UC 	*turn ;
USI 	*sub_tree,*ptr;
SI	*pt ;
{
  TREE_LIST_SENTE *tree_sente ;
  TREE_LIST_GOTE  *tree_gote ;	
  USI head ,rear,temp ;
  int dansu,point,flag,leaf = 0;
    
  if ((*turn == SENTE) && (*pt == TUMI_MOCHIGOMA_SENTE))
    *pt = TUMI_MOCHIGOMA_GOTE ;
  if ((*turn == GOTE) && (*pt == TUMI_MOCHIGOMA_GOTE))
    *pt = TUMI_MOCHIGOMA_SENTE ;

  tree_gote = &(tree[*sub_tree].gote[0]) ;
  tree_sente = &(tree[*sub_tree].sente[0]) ;
  
  if (*turn == GOTE)	{
    head = tree_gote[*ptr].head ;
    rear = tree_gote[*ptr].rear ;
    while ((head != rear) && (tree_sente[head].point != *pt))
      head ++ ;

    if (head == rear) leaf = 1 ;
    *turn = SENTE ; 
    *ptr = head ;
    if (tree_sente[head].leaf == SUB_TREE_NODE) {
      *sub_tree = tree_sente[head].sub_tree ;
      *ptr = 0 ;
    }
  }
  else {
    dansu = 0 ;
    temp = tree_sente[*ptr].away_rear ;
    point = 0 ;
    head  = tree_sente[*ptr].get_head ;
    rear  = tree_sente[*ptr].get_rear ;
           
    while (head != rear) {
      if (dansu < tree_gote[head].tesu) {
	dansu = tree_gote[head].tesu ;
	temp = head ;
	point = tree_gote[head].point ;
      }
      if ((dansu == tree_gote[head].tesu) && (tree_gote[head].point == *pt) && (point != *pt)) {
	point = tree_gote[head].point ;
	temp = head ;
      }
      head ++ ;
    }
    
    head = tree_sente[*ptr].away_head ;
    rear = tree_sente[*ptr].away_rear ;
    while (head != rear) {
      if (dansu < tree_gote[head].tesu) {
	dansu = tree_gote[head].tesu ;
	temp = head ;
	point = tree_gote[head].point ;
      }
      if ((dansu == tree_gote[head].tesu) && (tree_gote[head].point == *pt) && (point != *pt)) {
	temp = head ;
	point = tree_gote[head].point ;
      }
      head ++ ;
    }
    leaf = (temp == tree_sente[*ptr].away_rear) ;    
    *turn = GOTE ;
    *ptr = temp ;
    *pt = tree_gote[temp].point ;
  }
  return(leaf) ;
}

/* $B2rEz$NI=<((B */
int present_sashite(turn,sub_tree,ptr,pt)
UC   	turn ;
USI	sub_tree,ptr ;
SI	pt ;
{
  TREE_LIST_SENTE *tree_sente ;
  TREE_LIST_GOTE  *tree_gote ;	
  UC code,fx,fy,tx,ty,nari,c_code ;
  int i = 0 ;
  int leaf ;
  SI point ;
  PLAY *temp ;
  
#ifdef XBOARD
  /* $B2rEz$r(B X $B$GI=<($9$k$?$a$N=i4|2=(B */
  xboard() ;
#endif

  printf ("te  x  y   x  y   $B6p(B    $B@.$j(B  $BJa3M6p(B   point\n");
  
  for (;;) {
    if (host_select_kai(&turn,&sub_tree,&ptr,&pt)) break ;
    tree_gote = &(tree[sub_tree].gote[0]) ;
    tree_sente = &(tree[sub_tree].sente[0]) ;
        
    if (turn == GOTE) {
      temp = &(tree_gote[ptr].play) ;
      update_board_gote(temp);
    }
    else {
      temp = &(tree_sente[ptr].play) ;
      update_board_sente(temp);
    }
    
    i++ ;
    fx = temp->from_yx & 0x0f ;
    fy = temp->from_yx >> 4 ;
    tx = temp->to_yx & 0x0f ;
    ty = temp->to_yx >> 4 ;
    nari = temp->j_code & 0x0f ;
    code = temp->j_code >> 4 ;
    c_code = temp->jc_code ;
      
    printf ("%2d %2d %2d  %2d %2d  ",i,fx,fy,tx,ty);
    koma_print(code);
    if (nari) printf("   $B@.$j(B") ;
    else      printf("       ");
    printf("   ");
    koma_print(c_code);

    if (turn == GOTE) 
      printf("    %5d  %4d",tree_gote[ptr].point,tree_gote[ptr].tesu);
    else
      printf("    %5d  %4d",tree_sente[ptr].point,tree_sente[ptr].tesu);


    printf (" Tree = %d  Adrrs = %d",sub_tree,ptr) ;
    printf("\n") ;
    
#ifdef XBOARD
    /* $B;X$7<j$r(BX$B$GI=<((B */
    if (temp->jc != EMP) 
      xkoma_in_hand(temp->jc) ;
    xmove_koma_board(temp->j,fx,fy) ;
    xdisplay_flush() ;
    sleep(2);
#endif
  }

#ifdef XBOARD
  /* X$B$N%&%#%s%I%&$r>C$9(B */
  xclosedisplay() ;
#endif
  return (i);
}
