/* Copyright (C) 1997 Itoh Hidenori */

#include "host.h"

extern MSG	msg ;
extern BOARD	*bd ;
extern TREE_NODE_LIST	*tree ;
extern char 		*tree_flag ;
extern UI		*tree_access ;

extern CELL_STATE	*c_state ;

extern int		useing_tasks ;
extern int		number_of_useing_cells ;
extern int		cell_x,cell_y ;
extern int 		issue_job_num ;
extern int 		total_tree ;

int check_free_sente(p_tree,p_node) 
USI	p_tree,p_node ;
{
  USI	t_tree,t_node,parent ;
  
  if ((p_tree != 0) && (p_node == 0)) {
    t_tree = tree[p_tree].p_tree ;
    t_node = tree[p_tree].p_node ;
    return (check_free_sente(t_tree,t_node)) ;
  }
  parent = tree[p_tree].sente[p_node].parent ;
  if (tree[p_tree].sente[p_node].leaf == DELETE_NODE) return 1 ;    

  return (check_free_gote(p_tree,parent)) ;
}

int check_free_gote(p_tree,p_node) 
USI	p_tree,p_node ;
{
  USI	parent ;
  int	msg ;
  
  if ((p_tree == 0) && (p_node == 0)) return 0 ;
  parent = tree[p_tree].gote[p_node].parent ;
  if (tree[p_tree].gote[p_node].leaf == DELETE_NODE) return 1 ;    
  return (check_free_sente(p_tree,parent)) ;
}	

void free_tree() {
  int	i,j,signal ;
  USI	p_tree,p_node ;
  
  for (i=1;i<MAX_TREE;i++) 
    if (tree_flag[i]) {
      if (check_free_sente(tree[i].p_tree,tree[i].p_node)) {
	total_tree -- ;
	tree_flag[i] = 0 ;
	tree_access[i] = 0 ;
	tree[tree[i].p_tree].sente[tree[i].p_node].point = TUMAZU ;
	tree[tree[i].p_tree].sente[tree[i].p_node].tesu = TUMAZU ;
	tree[tree[i].p_tree].sente[tree[i].p_node].leaf = CLOSE_NODE ;
	tree[tree[i].p_tree].sente[tree[i].p_node].sub_tree = 0 ;
#ifdef	SHOW_RECV	
	printf("Ignore Tree %d\n",i) ;
#endif
      }
    }
  
  for (signal=QUIT,i=0;i<number_of_useing_cells;i++)
    for (j=0;j<MAX_TASK;j++) {
      if ((c_state[i].task[j].busy) && (!c_state[i].task[j].ignore)) {
	p_tree = c_state[i].task[j].p_tree ;
	p_node = c_state[i].task[j].p_node ;
	if (check_free_sente(p_tree,p_node)) {
	  tree[p_tree].sente[p_node].point = TUMAZU ;
	  tree[p_tree].sente[p_node].tesu = TUMAZU ;
	  tree[p_tree].sente[p_node].leaf = CLOSE_NODE ;
	  tree[p_tree].sente[p_node].sub_tree = 0 ;
	  c_state[i].task[j].ignore = 1 ;
#ifdef	SHOW_RECV	
	  printf("Ignore Cell %d Task %d\n",i,j) ;
#endif
	  l_asend(i,j,QUIT,&signal,sizeof(int)) ;
	}
      }
    }
} 
