/* Copyright (C) 1997 Itoh Hidenori */

/* $B%2!<%`LZ$N$b$C$H$bNI$$%N!<%I$r%;%k$KAw$k(B
   $B%[%9%H$NAw?.=hM}(B				*/
#include "host.h"

extern MSG	msg ;
extern BOARD	*bd ;
extern TREE_NODE_LIST	*tree ;
extern char 		*tree_flag ;
extern UI		*tree_access ;
extern UI		lru ;

extern TREE_LIST_SENTE  *tree_sente ;
extern TREE_LIST_GOTE   *tree_gote ;

extern CELL_STATE	*c_state ;

extern int	number_of_useing_cells ;
extern int	cell_x,cell_y ;
extern int	find_answer ;	
extern int 	issue_job_num ;
extern int	useing_tasks ;

extern void	update_board_sente() ;
extern void	reupdate_board_sente() ;
extern void	update_board_gote() ;
extern void	reupdate_board_gote() ;
extern void	check_msg_from_cell() ;
extern void	process_host_aigoma() ;
extern void     xboard() ;
extern void     xclosedisplay() ;

SI	down_sente() ;
void 	broad_job() ;

void down_gote(node,addrs) 
USI node,addrs ;
{
  TREE_LIST_SENTE       *ote_node ;
  USI 	head,rear,temp,t1,t2 ;
  USI	access ;
  SI	min_point,min_depth,depth ;
  int 	flag ;
  
  if (tree[node].gote[addrs].leaf == CLOSE_NODE) return ;
  if (tree[node].gote[addrs].leaf == DELETE_NODE) return ;
  if (!(issue_job_num < useing_tasks)) return ;
  if (!(tree[node].gote[addrs].point < OMAKASE)) return ;

  head = tree[node].gote[addrs].head ;
  rear = tree[node].gote[addrs].rear ;

  access = 0xffff ;
  for(temp=head;temp != rear;temp++) {
    if ((tree[node].gote[addrs].point == tree[node].sente[temp].point) &&
	(access > tree[node].sente[temp].access_times))
      access = tree[node].sente[temp].access_times ;
  }

  for(temp=head;temp != rear;temp++) {
    if ((tree[node].gote[addrs].point == tree[node].sente[temp].point) &&
	(access == tree[node].sente[temp].access_times))break ;
  }

  if (temp != rear) { 

    if ((tree[node].sente[temp].link == LINK_SLAVE) &&
        (tree[node].sente[temp].leaf == NODE)) {

    update_board_sente(&(tree[node].sente[temp - 1].play)) ;
#ifdef  SHOW_BOARD
    xboard() ;
    xclosedisplay() ;
#endif
    down_sente(node,temp - 1,&depth,0) ;
    reupdate_board_sente(&(tree[node].sente[temp - 1].play)) ;
    }
          
      update_board_sente(&(tree[node].sente[temp].play)) ;
#ifdef  SHOW_BOARD
      xboard() ;
      xclosedisplay() ;
#endif
    down_sente(node,temp,&depth,1) ;
    reupdate_board_sente(&(tree[node].sente[temp].play)) ;

    if ((tree[node].sente[temp].link == LINK_MASTER) && 
	(tree[node].sente[temp].play.j_code >> 4 == KA)){
      update_board_sente(&(tree[node].sente[temp+1].play)) ;
#ifdef  SHOW_BOARD
        xboard() ;
        xclosedisplay() ;
#endif
      down_sente(node,temp+1,&depth,1) ;
      reupdate_board_sente(&(tree[node].sente[temp+1].play)) ;
    }
  }
  
  min_point = TUMAZU ;
  for (temp=head;temp != rear;temp++) {
    if (min_point > tree[node].sente[temp].point)
      min_point = tree[node].sente[temp].point ;
  }	
  if (min_point < TUMISO) {
    for (temp=head;temp != rear;temp++) {
      if (min_point == tree[node].sente[temp].point)
	break ;
    }	
    tree[node].gote[addrs].tesu
      = tree[node].sente[temp].tesu + 1 ;	
  }	
  if (min_point == TUMI_MOCHIGOMA_SENTE)
    min_point = TUMI_MOCHIGOMA_GOTE ;
  tree[node].gote[addrs].point = min_point ;
}

SI down_sente(node,addrs,depth,flag) 
USI 	node,addrs ; 
SI	*depth ;
int	flag ;
{
/*SI    max_point ; */
  SI    sigma_point,point,stock_point,max_depth ;
  USI 	head,rear,temp ;
/*
  printf ("node = %d   addrs = %d  depth = %d  flag = %d\n",node,addrs,depth,flag);
  printf ("tree[node].sente[addrs].sub_tree %d",tree[node].sente[addrs].sub_tree);
  printf ("  leaf %d    point %d\n",tree[node].sente[addrs].leaf,tree[node].sente[addrs].point);
*/
  if (tree[node].sente[addrs].leaf == CLOSE_NODE) return TUMAZU ;
  if (!(issue_job_num < useing_tasks)) return ;
  
  point = tree[node].sente[addrs].point ;
  tree[node].sente[addrs].access_times += 1 ;

  switch(tree[node].sente[addrs].leaf) {
  case SUB_TREE_NODE:
#ifdef  SHOW_BROAD
    printf("Down Tree %d %d -> %d : Point %d : free_tasks %d\n",node,addrs,
	   tree[node].sente[addrs].sub_tree,
	   point,
	   useing_tasks - issue_job_num) ;
#endif
    tree_access[tree[node].sente[addrs].sub_tree] = lru ;
    tree[node].sente[addrs].point =
      down_sente(tree[node].sente[addrs].sub_tree,0,depth,1) ;
    tree[node].sente[addrs].tesu = *depth ;
    break ;
  case AI_NODE:
    process_host_aigoma(node,addrs) ;
    if ((tree[node].use_sente >  MEMORY_SIZE_SENTE) ||
	(tree[node].use_gote > MEMORY_SIZE_GOTE)) {
      printf("MEMORY FULL WHILE AI KOMA PROCESSING!!\n");
      host_exit(0) ;
    }
    tree[node].sente[addrs].leaf = NODE;
    point = tree[node].sente[addrs].point ;
    if (point < TUMISO) break ;
  case NODE:
    if (flag) {
      head = tree[node].sente[addrs].away_head ;
      rear = tree[node].sente[addrs].away_rear ;
      stock_point = tree[node].gote[head].point ;
      while ((issue_job_num < useing_tasks) && (head != rear)) {
	if (tree[node].gote[head].point > stock_point) 
	  stock_point = tree[node].gote[head].point ;
	head++ ;
      }
      head = tree[node].sente[addrs].away_head ;
      while ((issue_job_num < useing_tasks) && (head != rear)) {
/*	if (tree[node].gote[head].point == point) */
        if (tree[node].gote[head].point == stock_point)  {
	  update_board_gote(&(tree[node].gote[head].play)) ;
	  down_gote(node,head) ;
	  reupdate_board_gote(&(tree[node].gote[head].play)) ;
	} 
	head++ ;
      }
    }
    if (tree[node].sente[addrs].link != LINK_SLAVE) {
      head = tree[node].sente[addrs].get_head ;
      rear = tree[node].sente[addrs].get_rear ;
      stock_point = tree[node].gote[head].point ;
      while ((issue_job_num < useing_tasks) && (head != rear)) {
	if (tree[node].gote[head].point > stock_point)
	    stock_point = tree[node].gote[head].point ;
	head++ ;
      }
      head = tree[node].sente[addrs].get_head ;
      while ((issue_job_num < useing_tasks) && (head != rear)) {
/*      if ((flag == 0) || (tree[node].gote[head].point == point)) */
        if ((flag == 0) || (tree[node].gote[head].point == stock_point)) {
	  update_board_gote(&(tree[node].gote[head].play)) ;
	  down_gote(node,head) ;
	  reupdate_board_gote(&(tree[node].gote[head].play)) ;
	}
	head++ ;
      }
    }
    
/*  max_point = TUMI - 100 ;
    point = TUMI - 100 ; */
    sigma_point = TUMI - 100 ;
    max_depth = 0 ;
    head = tree[node].sente[addrs].get_head ;
    rear = tree[node].sente[addrs].get_rear ;
    for (;head != rear;head++) {
/*    if (max_point < tree[node].gote[head].point)
	max_point = tree[node].gote[head].point ; */
      if (max_depth < tree[node].gote[head].tesu)
	max_depth = tree[node].gote[head].tesu ;
/*    if ((point < tree[node].gote[head].point) &&
	  (tree[node].gote[head].point != OMAKASE))
	point = tree[node].gote[head].point ; */
      if (((tree[node].gote[head].point < 0) && (tree[node].gote[head].point > sigma_point)) ||
	  ((tree[node].gote[head].point >= 0) && (sigma_point < 0)))
	sigma_point = tree[node].gote[head].point ;
      else if (tree[node].gote[head].point >= 0)
	     sigma_point += tree[node].gote[head].point ;
    }	
    head = tree[node].sente[addrs].away_head ;
    rear = tree[node].sente[addrs].away_rear ;
    for (;head != rear;head++) {
/*    if (max_point < tree[node].gote[head].point)
	max_point = tree[node].gote[head].point ; */
      if (max_depth < tree[node].gote[head].tesu)
        max_depth = tree[node].gote[head].tesu ;
/*    if ((point < tree[node].gote[head].point) &&
	  (tree[node].gote[head].point != OMAKASE))
	point = tree[node].gote[head].point ; */
      if (((tree[node].gote[head].point < 0) && (tree[node].gote[head].point > sigma_point)) ||
          ((tree[node].gote[head].point >= 0) && (sigma_point < 0)))
        sigma_point = tree[node].gote[head].point ;
      else if (tree[node].gote[head].point >= 0)
             sigma_point += tree[node].gote[head].point ;
    }
    tree[node].sente[addrs].tesu = max_depth + 1 ;
    /**********************************************/
    /*	$B9g6p=hM}(B				*/
    /**********************************************/
/*  if ((max_point < TUMISO) && */
    if ((sigma_point < TUMISO) &&
	(tree[node].sente[addrs].ai_head != tree[node].sente[addrs].ai_rear)) {
      tree[node].sente[addrs].leaf = AI_NODE ;
/*    max_point = -1 ; */
      sigma_point = AISHIRABE ;
    }
/*  if (max_point == TUMI_MOCHIGOMA_GOTE)
      max_point = TUMI_MOCHIGOMA_SENTE ; */
    if (sigma_point == TUMI_MOCHIGOMA_GOTE)
      sigma_point = TUMI_MOCHIGOMA_SENTE ;
/*  if (point > tree[node].sente[addrs].point)
      tree[node].sente[addrs].point = point ; */
    if (sigma_point > tree[node].sente[addrs].point)
      tree[node].sente[addrs].point = sigma_point ;
/*  if (point < TUMISO)
      tree[node].sente[addrs].point = max_point ; */
    if (sigma_point < TUMISO)
      tree[node].sente[addrs].point = sigma_point ;	
    break ;
  case OTE_LEAF:
    if (issue_job_num < useing_tasks)
    {
	broad_job(node,addrs) ;
        printf(" ### OTE_LEAF ### \n");
    }
    break ;
  default:
    break ;
  }
  *depth = tree[node].sente[addrs].tesu ;
  return (tree[node].sente[addrs].point) ;
}

void def_broad_cell(c_num,c_task)
int	*c_num,*c_task ;
{
  int i,min_job ;
  
  *c_num = 0 ; min_job = c_state[0].jobs ;
  for (i=1;i<number_of_useing_cells;i++)
    if (min_job > c_state[i].jobs) {
      min_job = c_state[i].jobs ;
      *c_num = i ;
    }
  
  for (i=0;i<MAX_TASK;i++)
    if (c_state[*c_num].task[i].busy == 0) break ;
  
  *c_task = i ;
}

/*	$B%;%k$K%N!<%I(B tree[node].sente[addrs] $B$N=hM}0MMj(B	*/
void broad_job(node,addrs) 
USI node,addrs ;
{
  USI 	i,head,rear ;
  UC	code,nari ;
  int	broad_cell,broad_task ;
  
  msg.job.p_tree = node ;
  msg.job.p_node = addrs ;
  msg.job.ote = tree[node].sente[addrs].play ;
  code = tree[node].sente[addrs].play.j_code >> 4 ;
  nari = tree[node].sente[addrs].play.j_code & 0x0f ;
  code = code ^ nari ;
  
  msg.job.uke_get = tree[node].sente[addrs].get_rear - 
    tree[node].sente[addrs].get_head ;
  head = tree[node].sente[addrs].get_head ;
  rear = tree[node].sente[addrs].get_rear ;
  for (i=0;head != rear;head++,i++) { 
    msg.job.uke[i] = tree[node].gote[head].play ;
    msg.job.uke[i].jc_code = code ;
  }
  
  msg.job.uke_away = tree[node].sente[addrs].away_rear -
    tree[node].sente[addrs].away_head ;
  head = tree[node].sente[addrs].away_head ;
  rear = tree[node].sente[addrs].away_rear ;
  for (;head != rear;head++,i++) 
    msg.job.uke[i] = tree[node].gote[head].play ;

  msg.job.uke_ai = tree[node].sente[addrs].ai_rear -
    tree[node].sente[addrs].ai_head ;
  head = tree[node].sente[addrs].ai_head ;
  rear = tree[node].sente[addrs].ai_rear ;
  for (;head != rear;head++,i++) 
    msg.job.uke[i] = tree[node].gote[head].play ;

  msg.job.point = tree[node].sente[addrs].point ;
  /*	$B%;%k(B broad_cell $B$K(B $BJ|Aw(B	*/
  def_broad_cell(&broad_cell,&broad_task) ;
  l_asend(broad_cell,broad_task,JOB,&msg,sizeof(MSG)) ;
  c_state[broad_cell].task[broad_task].busy = 1 ;
  c_state[broad_cell].task[broad_task].ignore = 0 ;
  c_state[broad_cell].task[broad_task].p_tree = node ;
  c_state[broad_cell].task[broad_task].p_node = addrs ;
  c_state[broad_cell].jobs += 1 ;
#ifdef	SHOW_BROAD
  printf ("Broard to cell_%d Broard to task_%d : Tree %d %d Point = %d\n",
	  broad_cell,broad_task,node,addrs,tree[node].sente[addrs].point) ;
  print_te(&(msg.job.ote)) ;
#endif

  /*	$BJ|Aw$9$k$b$N$N>uBVI=<((B	*/
#ifdef	SHOW_BOARD
  xboard() ;
  getchar() ;
  xclosedisplay() ;
#endif  
  tree[node].sente[addrs].point = OMAKASE ;
  tree[node].sente[addrs].leaf = BROAD_NODE ;
  issue_job_num ++ ;
}
