/* Copyright (C) 1997 Itoh Hidenori */

/* $B%[%9%H$K$*$1$k9g6p=hM}$r9T$J$&(B */
#include "host.h"

extern BOARD	*bd ;

extern TREE_NODE_LIST	*tree ;
extern char		*tree_flag ;
	
extern TREE_LIST_SENTE  *tree_sente ;
extern TREE_LIST_GOTE   *tree_gote ;

extern USI              *memory_use_sente ;
extern USI              *memory_use_gote ;
extern void		set_sente() ;
extern int		host_select_kai() ;

void set_diff_ai(ote,ai,code,num,pre_get) 
USI	ote,ai,pre_get ;
UC	code,num ;
{
  TREE_LIST_SENTE       *ote_node ;
  TREE_LIST_GOTE        *uke_node ;
  USI	ts,tu ;
  
  ote_node = &(tree_sente[ote]) ;
  uke_node = &(tree_gote[ai]) ;
  uke_node->play.j		= num ;
  uke_node->play.j_code	= code << 4 ;
  uke_node->link 		= NON_LINK ;
  uke_node->leaf		= UKETE_LEAF ;
  uke_node->point         	= 0 ;
  uke_node->tesu          	= 0 ;
  uke_node->parent        	= ote ;
  ts = *memory_use_sente ;
  tu = *memory_use_gote ;
  update_board_gote(&(uke_node->play));
  search_gote_tree(ai,&(ote_node->play),pre_get) ;
  reupdate_board_gote(&(uke_node->play));
  if (uke_node->point < TUMISO) {
    *memory_use_sente = ts ;
    *memory_use_gote = tu ;
  }
}

int  host_get_ai_tumi_fuc(node,addrs)
USI	node,addrs ;
{
  UC	turn ;
  SI	pt ;
  USI	sub_tree,ptr ;
  
  turn = GOTE ;  sub_tree = node ;  ptr = addrs ;
  pt = tree[node].gote[addrs].point ;
  host_select_kai(&turn,&sub_tree,&ptr,&pt) ;
  if (tree[sub_tree].sente[ptr].play.jc == tree[node].gote[addrs].play.j) 
    return 1 ;
  else
    return 0 ;
}	

void process_host_aigoma(node,addrs) 
USI	node,addrs ;
{
  UC	code,ai_yx,ai_num,pp,c_code ;
  TREE_LIST_SENTE       *ote ;
  UC	turn ;
  USI   sub_tree,ptr,head,get_ai_tumi,pre_get_ai_tumi ;
  SI	pt ;
  int	i,loop ;
  char  mochi_koma[16] ;
  
  ote = &(tree[node].sente[addrs]) ;
  tree_sente = &(tree[node].sente[0]) ;
  tree_gote = &(tree[node].gote[0]) ;
  memory_use_sente = &(tree[node].use_sente) ;
  memory_use_gote = &(tree[node].use_gote) ;
#ifdef AI_PROCESS  
  printf("AI PROCESS %x\n",tree_gote[ote->ai_head].play.to_yx) ;
#endif
  while (ote->ai_head != ote->ai_rear) {
    if (ote->ai_head == ote->away_rear) {
      /**************************************************/
      /*	 $B0l$DL\$N<oN`$N9g6p$K$h$k7k2L$O5M$_(B 	*/
      /*	$BL5BL9g$$$+H]$+$N%A%'%C%/(B		*/
      /**************************************************/
      code = tree[node].gote[ote->away_rear - 1].play.j_code >> 4 ;
      
      for (i=0;i<16;i++) mochi_koma[i] = 0 ;
      pp = bd->sente_in_hand ;
      while (pp != NILL) {
	c_code = bd->koma[pp].code ;
	(mochi_koma[c_code]) ++ ;
	pp = bd->koma[pp].next ;
      }
      if (get_ai_tumi = host_get_ai_tumi_fuc(node,ote->away_rear - 1))
	mochi_koma[code] -- ;

      turn = GOTE ;  sub_tree = node ;  ptr = ote->away_rear - 1 ;
      pt = tree[node].gote[ptr].point ;
      for (;;)  {
	if (host_select_kai(&turn,&sub_tree,&ptr,&pt)) break ;
	if (turn == SENTE) {
	  if (tree[sub_tree].sente[ptr].play.jc != EMP) {
	    c_code = tree[sub_tree].sente[ptr].play.jc_code ;
	    if (c_code > 2) c_code |= 0x01 ;
	    (mochi_koma[c_code]) ++ ;
	  }
	  if (tree[sub_tree].sente[ptr].play.from_yx == 0x00) {
	    c_code = tree[sub_tree].sente[ptr].play.j_code >> 4 ;
	    (mochi_koma[c_code]) -- ;
	  }
	}
      }
      if (get_ai_tumi && (mochi_koma[code] > -1)) {
	/****************************************/
	/*	$BL5BL9g$$$G$"$k$3$H$,H=L@(B	*/
	/****************************************/
	tree[node].gote[ote->away_rear - 1].tesu -= 2 ;
	tree[node].gote[ote->away_rear - 1].point = TUMI_MOCHIGOMA_GOTE ;
	tree[node].gote[ote->away_rear - 1].leaf = CLOSE_NODE;
      }
      pre_get_ai_tumi = tree[node].gote[ote->ai_head].pre_get_ai_tumi ;
      tree[node].gote[ote->ai_head]
	= tree[node].gote[ote->away_rear - 1] ;
      tree[node].gote[ote->ai_head].head 
	= tree[node].gote[ote->ai_head].rear ;
      tree[node].gote[ote->ai_head].get_ai_tumi = get_ai_tumi ;
      tree[node].gote[ote->ai_head].pre_get_ai_tumi = pre_get_ai_tumi ;
      if (get_ai_tumi && (mochi_koma[code] > -1)) (ote->ai_head) ++ ;
      (ote->away_rear) ++ ;
    }
    else {
      get_ai_tumi = host_get_ai_tumi_fuc(node,ote->away_rear - 1) ;
      tree[node].gote[ote->ai_head].get_ai_tumi =
	tree[node].gote[ote->ai_head].get_ai_tumi && get_ai_tumi ;
    }
    pre_get_ai_tumi = tree[node].gote[ote->ai_head].pre_get_ai_tumi ;
    if ((ote->ai_head != ote->ai_rear) && (ote->ai_head != ote->away_rear)) {
      /******************************************/
      /*	$BM-8z9g$$$G$"$k$3$H$,H=L@(B    	*/
      /*	$BB>$N<oN`$G9g6p$r;n$_$k(B	    	*/
      /******************************************/
      if (tree[node].gote[ote->ai_head].tesu >
	  tree[node].gote[ote->ai_head - 1].tesu) {
	tree[node].gote[ote->ai_head - 1] =
	  tree[node].gote[ote->ai_head] ;
	head = tree[node].gote[ote->ai_head].head ;
	while (head != tree[node].gote[ote->ai_head].rear) {
	  tree[node].sente[head].parent = ote->ai_head - 1 ;
	  head ++ ;
	}
	tree[node].gote[ote->ai_head].head =
	  tree[node].gote[ote->ai_head].rear ;
      }
      else {
	head = tree[node].gote[ote->ai_head].head ;
	tree[node].gote[ote->ai_head].point = 0 ; /* -1099 */
	while (head != tree[node].gote[ote->ai_head].rear) {
	  tree[node].sente[head].leaf = DELETE_NODE ;
	  head ++ ;
	}
	tree[node].gote[ote->ai_head].leaf = DELETE_NODE ;
      }
      code = tree[node].gote[ote->ai_head].play.j_code >> 4;
      ai_yx = tree[node].gote[ote->ai_head].play.to_yx ;
      switch(code) {
      case FU:
	if (kind_of_ai(ai_yx,KE,&ai_num)) {
	  set_diff_ai(addrs,ote->ai_head,KE,ai_num,pre_get_ai_tumi) ;
#ifdef AI_PROCESS
	  printf("AI PROCESS KEIMA : %x\n",ai_yx) ;
#endif	  
	  if (tree_gote[ote->ai_head].point > TUMISO) {
	    ote->point = tree_gote[ote->ai_head].point ;
	    return ;
	  }
	  get_ai_tumi = host_get_ai_tumi_fuc(node,ote->away_rear - 1) ;
	  tree[node].gote[ote->ai_head].get_ai_tumi =
	    tree[node].gote[ote->ai_head].get_ai_tumi && get_ai_tumi ;
	}
      case KE:
	if (kind_of_ai(ai_yx,KY,&ai_num)) {
	  set_diff_ai(addrs,ote->ai_head,KY,ai_num,pre_get_ai_tumi) ;
#ifdef AI_PROCESS
	  printf("AI PROCESS KYOSHA : %x\n",ai_yx) ;
#endif	  
	  if (tree_gote[ote->ai_head].point > TUMISO) {
	    ote->point = tree_gote[ote->ai_head].point ;
	    return ;
	  }
	  get_ai_tumi = host_get_ai_tumi_fuc(node,ote->away_rear - 1) ;
	  tree[node].gote[ote->ai_head].get_ai_tumi =
	    tree[node].gote[ote->ai_head].get_ai_tumi && get_ai_tumi ;
	}
      case KY:
	if (kind_of_ai(ai_yx,GI,&ai_num)) {
	  set_diff_ai(addrs,ote->ai_head,GI,ai_num,pre_get_ai_tumi) ;
#ifdef AI_PROCESS
	  printf("AI PROCESS GIN : %x\n",ai_yx) ;
#endif	  
	  if (tree_gote[ote->ai_head].point > TUMISO) {
	    ote->point = tree_gote[ote->ai_head].point ;
	    return ;
	  }
	  get_ai_tumi = host_get_ai_tumi_fuc(node,ote->away_rear - 1) ;
	  tree[node].gote[ote->ai_head].get_ai_tumi =
	    tree[node].gote[ote->ai_head].get_ai_tumi && get_ai_tumi ;
	}
      case GI:
	if (kind_of_ai(ai_yx,KI,&ai_num)) {
#ifdef AI_PROCESS
	  printf("AI PROCESS KIN : %x\n",ai_yx) ;
#endif	  
	  set_diff_ai(addrs,ote->ai_head,KI,ai_num,pre_get_ai_tumi) ;
	  if (tree_gote[ote->ai_head].point > TUMISO) {
	    ote->point = tree_gote[ote->ai_head].point ;
	    return ;
	  }
	  get_ai_tumi = host_get_ai_tumi_fuc(node,ote->away_rear - 1) ;
	  tree[node].gote[ote->ai_head].get_ai_tumi =
	    tree[node].gote[ote->ai_head].get_ai_tumi && get_ai_tumi ;
	}
      case KI:
	if (kind_of_ai(ai_yx,KA,&ai_num)) {
	  set_diff_ai(addrs,ote->ai_head,KA,ai_num,pre_get_ai_tumi) ;
#ifdef AI_PROCESS
	  printf("AI PROCESS KAKU : %x\n",ai_yx) ;
#endif	  
	  if (tree_gote[ote->ai_head].point > TUMISO) {
	    ote->point = tree_gote[ote->ai_head].point ;
	    return ;
	  }
	  get_ai_tumi = host_get_ai_tumi_fuc(node,ote->away_rear - 1) ;
	  tree[node].gote[ote->ai_head].get_ai_tumi =
	    tree[node].gote[ote->ai_head].get_ai_tumi && get_ai_tumi ;
	}
      case KA:
	if (kind_of_ai(ai_yx,HI,&ai_num)) {
	  set_diff_ai(addrs,ote->ai_head,HI,ai_num,pre_get_ai_tumi) ;
#ifdef AI_PROCESS
	  printf("AI PROCESS HISHA : %x\n",ai_yx) ;
#endif	  
	  if (tree_gote[ote->ai_head].point > TUMISO) {
	    ote->point = tree_gote[ote->ai_head].point ;
	    return ;
	  }
	  get_ai_tumi = host_get_ai_tumi_fuc(node,ote->away_rear - 1) ;
	  tree[node].gote[ote->ai_head].get_ai_tumi =
	    tree[node].gote[ote->ai_head].get_ai_tumi && get_ai_tumi ;
	}
      }
      (ote->ai_head) ++ ;
    }
    
    if (ote->ai_head != ote->ai_rear) {
      /*	$B$5$i$K0l$D1s$/$K9g6p$rBG$D$3$H$r9M$($k(B	*/
      tree_gote[ote->ai_head].pre_get_ai_tumi = 
	pre_get_ai_tumi = tree_gote[ote->ai_head-1].get_ai_tumi ;
      code = tree_gote[ote->ai_head].play.j_code >> 4 ;
      ai_yx = tree_gote[ote->ai_head].play.to_yx ;
      tree_gote[ote->away_rear - 1] = tree_gote[ote->ai_head] ;
      kind_of_ai(ai_yx,code,&ai_num) ;
      set_diff_ai(addrs,ote->away_rear - 1,code,ai_num,pre_get_ai_tumi) ;
      if (tree_gote[ote->away_rear - 1].point > TUMISO) {
	ote->point = tree_gote[ote->away_rear - 1].point ;
	return ;
      }
    }
  }
  set_sente(node,addrs) ;
}
