/* Copyright (C) 1997 Itoh Hidenori */

#include 	"cell.h"

MSG		msg ; 			/* $B<u?.%a%C%;!<%8(B       */
MSG_RE		msg_re ;		/* $BItJ,LZAw?.%a%C%;!<%8(B */
QUIT_MSG_RE	quit_msg_re ;		/* $B=hM}Dd;_;~%a%C%;!<%8(B */

BOARD		*bd ;			/* $B>-4}HW%]%$%s%?(B	*/	
UC 		sente_tobi_kiki[256] ;	/* $B@h<jHt$SMx$-%F!<%V%k(B */

TREE_LIST_SENTE	*tree_sente ;		/* $B2&<j%j%9%H(B		*/
TREE_LIST_GOTE	*tree_gote ;		/* $B<u<j%j%9%H(B		*/

USI	        *memory_use_sente ;	/* $B2&<j%j%9%H;HMQ%5%$%:(B */
USI		*memory_use_gote ;      /* $B<u<j%j%9%H;HMQ%5%$%:(B */

int		process_run ;		/* $B=hM}7QB32DG=%U%i%0(B	*/
int             quit_signal ;		/* $BDd;_?.9f<u?.%U%i%0(B	*/

extern void 	search_sente_tree() ;

/* $B=hM}Dd;_%a%C%;!<%8$NE~Ce3NG'(B */
void check_msg_arrive() {
  int signal ;

  if (cprobe()) {
    qrecv() ;
    readmsg(&signal,sizeof(int)) ;
    if (signal == EXIT) cell_exit(0) ;
    tree_sente[0].point = TUMAZU ;
    quit_signal = 1 ;
    process_run = 0 ;
  }
}

/* $B%;%k%a%$%s%W%m%0%i%`(B */
void cell_main() {
  int i ;

  /* $B=i4|2=!&3F%]%$%s%?$r%;%C%H(B	*/	
  tree_sente = &(msg_re.sente[0]) ;
  tree_gote = &(msg_re.gote[0]) ;
  memory_use_sente = &(msg_re.use_sente) ;
  memory_use_gote = &(msg_re.use_gote) ;
  bd = &(msg.bd) ;
  
  /* $B%a%C%;!<%8$rF@$FC5:w=hM}$r3+;O(B	*/
  for (;;) {
    crecv() ;
    switch(getmtype()){
    case EXIT:
      readmsg(&i,sizeof(int)) ;
      cell_exit(0) ;
      break ;
    case JOB:
      /* $BItJ,LZ9=B$BN$N=i4|2=(B	*/
      quit_signal = 0 ;
#ifdef	CASIM
      printf("Get job!\n") ;
#endif
      readmsg(&msg,sizeof(MSG)) ;
      process_run = 1 ;
      msg_re.p_tree = msg.job.p_tree ;
      msg_re.p_node = msg.job.p_node ;
      *memory_use_sente = 1 ;
      
      /* $B2&<j%N!<%I$r%;%C%H(B	*/
      tree_sente[0].play = msg.job.ote ;
      tree_sente[0].link = NON_LINK ;
      tree_sente[0].leaf = OTE_LEAF ;
      tree_sente[0].point = 0 ;
      tree_sente[0].tesu = 1 ;
      tree_sente[0].sub_tree = 0 ;
      
      /* $B<h$k<u<j$r%;%C%H(B	*/	
      tree_sente[0].get_head = 0 ;
      for (i=0;i<msg.job.uke_get;i++) {
	tree_gote[i].play = msg.job.uke[i] ;
	tree_gote[i].link = NON_LINK ;
	tree_gote[i].leaf = UKETE_LEAF ;
	tree_gote[i].point = 0 ;
	tree_gote[i].tesu = 0 ;
	tree_gote[i].parent = 0 ;
	tree_gote[i].get_ai_tumi = 0 ;
	tree_gote[i].pre_get_ai_tumi = 0 ;
      }
      tree_sente[0].get_rear = i ;
      
      /* $BF($2$k<u<j$r%;%C%H(B	*/
      tree_sente[0].away_head = i ;
      for (;i< msg.job.uke_get + msg.job.uke_away;i++) {
	tree_gote[i].play = msg.job.uke[i] ;
	tree_gote[i].link = NON_LINK ;
	tree_gote[i].leaf = UKETE_LEAF ;
	tree_gote[i].point = 0 ;
	tree_gote[i].tesu = 0 ;
	tree_gote[i].parent = 0 ;
	tree_gote[i].get_ai_tumi = 0 ;
	tree_gote[i].pre_get_ai_tumi = 0 ;
      }
      tree_sente[0].away_rear = i ;
      
      /* $B9g6p$N<u<j$r%;%C%H(B	*/
      tree_sente[0].ai_head = i ;
      for (;i< msg.job.uke_get + msg.job.uke_away + msg.job.uke_ai;i++) {
        tree_gote[i].play = msg.job.uke[i] ;
        tree_gote[i].link = NON_LINK ;
        tree_gote[i].leaf = UKETE_LEAF ;
        tree_gote[i].point = 0 ;
        tree_gote[i].tesu = 0 ;
	tree_gote[i].parent = 0 ;
	tree_gote[i].get_ai_tumi = 0 ;
	tree_gote[i].pre_get_ai_tumi = 0 ;
      }
      tree_sente[0].ai_rear = i ;
      *memory_use_gote = i ;
      
      /* $B%a%$%s%k!<%W(B:$BC5:w$r9T$J$&(B */	
      i = 1 ;
      while ((tree_sente[0].point > TUMISO) && 
	     (tree_sente[0].point < msg.job.point + 3) && process_run) {
#ifdef	CASIM
	printf("%d ############################### %d %d %d\n",
	       i,tree_sente[0].point,*memory_use_sente,*memory_use_gote) ;
#endif
	search_sente_tree(0,&(tree_gote[0].play),1);
	i ++ ;
      }
#ifdef	CASIM
      printf("Point=%d run=%d quit=%d\n",
	     tree_sente[0].point,process_run,quit_signal) ;
      getchar() ;
#endif

      /* $BDd;_%a%C%;!<%8$r<u?.$7$?>l9g(B	*/
      if (quit_signal) {
	quit_msg_re.point  = TUMAZU ;
	quit_msg_re.tesu = TUMAZU ;
      }	
      
      /* $B%a%C%;!<%8Aw?.(B			*/
      if (quit_signal || (tree_sente[0].point > msg.job.point + 2)) {
	quit_msg_re.p_tree = msg.job.p_tree ;
	quit_msg_re.p_node = msg.job.p_node ;
	quit_msg_re.point  = tree_sente[0].point ;
	quit_msg_re.tesu = tree_sente[0].tesu ;	
	quit_msg_re.access_times = tree_sente[0].access_times ;
	h_send(QUIT_RECV,&quit_msg_re,sizeof(QUIT_MSG_RE)) ;
      }      
      else
	h_send(JOB,&msg_re,sizeof(MSG_RE)) ;
      break ;
    case QUIT:
      readmsg(&i,sizeof(int)) ;
      break ;
    }
  }
}
