/* Copyright (C) 1997 Itoh Hidenori */
/******************************************************************************/
/*                                                                            */
/*  Predicates to remove redundant clauses.                                   */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  call      : remove_redundancy(+Clauses, -Non_redundant)                   */
/*                                                                            */
/*  arguments : Clauses       = a list of clauses found in a learning process.*/
/*              Non_redundant = a list of clauses that are not redundant.     */
/*                                                                            */
/******************************************************************************/
/* It removes redundant clauses from induced clauses.                         */
/******************************************************************************/
remove_redundancy([], []):-!.
remove_redundancy([Literal|Literals], Non_redundant):-
    remove_redundancy(Literals, Non_redundant1),
    remove_redundancy1(Literal, Non_redundant1, Non_redundant).
remove_redundancy1(Clause_maybe_junk, [], [Clause_maybe_junk]):-!.
remove_redundancy1(Clause_maybe_junk, Complete, Complete_new):-!,
    (possibly_covered(Clause_maybe_junk, Complete, [], Complete_new);
     possibly_covering(Clause_maybe_junk, Complete, [], Complete_new)).

/******************************************************************************/
/*                                                                            */
/*  call      : possibly_covered(+Clause_maybe_junk, +Clauses, +Checked,      */
/*                               -Result)                                     */
/*                                                                            */
/*  arguments : Clause_maybe_junk = a clause to be checked.                   */
/*              Clauses           = a list of clauses that may cover the      */
/*                                  clause above.                             */
/*              Checked           = a list of clauses checkd already.         */
/*              Result            = a resulting list of clauses.              */
/*                                                                            */
/******************************************************************************/
/* It checks if a clause is subsumed by another clauses. If so it results     */
/* a list of clauses without the clause.                                      */
/******************************************************************************/
possibly_covered(_,[],_,_):-!,fail.
possibly_covered(Clause_maybe_junk, [Clause|Rest], Checked, Result):-!,
    ( cover(Clause, Clause_maybe_junk) -> 
        append([Clause|Rest], Checked, Result)
      ;	possibly_covered(Clause_maybe_junk, Rest, [Clause|Checked], Result)
    ).

/******************************************************************************/
/*                                                                            */
/*  call      : possibly_covering(+Clause_maybe_complete, +Clauses, +Checked, */
/*                                -Result)                                    */
/*                                                                            */
/*  arguments : Clause_maybe_complete = a clause to be checked.               */
/*              Clauses               = a list of clauses that may be         */
/*                                      subsumed.                             */
/*              Checked               = a list of clauses checked already.    */
/*              Result                = a resulting list of clauses.          */
/*                                                                            */
/******************************************************************************/
/* It checks if a clause subsumes another clauses. If so it results a list    */
/* of clauses without the clauses subsumed.                                   */
/******************************************************************************/
possibly_covering(Clause_maybe_complete, [], Checked, Result):-!,
    Result = [Clause_maybe_complete|Checked].
possibly_covering(Clause_maybe_complete, [Clause|Rest],
		  Checked, Result):-!,
    ( cover(Clause_maybe_complete, Clause) ->
	possibly_covering(Clause_maybe_complete, Rest, Checked, Result)
      ; possibly_covering(Clause_maybe_complete, Rest, [Clause|Checked], Result)
    ).

/******************************************************************************/
/*                                                                            */
/*  call      : cover(+((Plus1,_),_,_,_,_,_), +((Plus2,_),_,_,_,_,_))         */
/*                                                                            */
/*  arguments : Plus1, Plus2 = sets of positive examples covered by clauses.  */
/*                                                                            */
/******************************************************************************/
/* It checks the subset relation between sets of positive examples covered.   */
/******************************************************************************/
cover(((Plus1,_),_,_,_,_,_), ((Plus2,_),_,_,_,_,_)):-
    target(_,Arity,_,_),
    project(Plus1, Arity, Projected1),
    project(Plus2, Arity, Projected2), !,
    subset(Projected2, Projected1).
