/* Copyright (C) 1997 Itoh Hidenori */
/******************************************************************************/
/*                                                                            */
/*  Predicates to process background predicates.                              */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  call          : calculate_hojo_tuples                                     */
/*                                                                            */
/*  subpredicates : plus_hojo_tuples                                          */
/*                                                                            */
/******************************************************************************/
/* It calcuates extensional definitions of background predicates.             */
/******************************************************************************/
calculate_hojo_tuples:-
    findall((Pred, Arity, Mode, Type, Definition),
	    hojo(Pred, Arity, Mode, Type, Definition), 
	    Hojo_list),
    abolish(hojo/5),
    calculate_hojo_tuples1(Hojo_list).

calculate_hojo_tuples1([]):-!.
calculate_hojo_tuples1([Hojo|Rest]):-!,
    Hojo = (Pred, Arity, Mode, Type, Definition),
    assert_definition(Definition),
    bagof(Tuple,
	  ( choose_a_tuple_in_type(Type, Tuple),
	    plus_hojo_tuple(Hojo, Tuple)),
	  Hojo_tuples),
    assert(hojo_tuples(Pred, Arity, Mode, Type, Hojo_tuples, [])),
    retract_definition(Definition),
    calculate_hojo_tuples1(Rest).

plus_hojo_tuple((Pred, _,_,_,_), Tuple):-
    G=..[Pred|Tuple],!,
    call(G).

/******************************************************************************/
/*                                                                            */
/*  call          : calculate_builtin_tuples                                  */
/*                                                                            */
/*  subpredicates : plus_hojo_tuples                                          */
/*                                                                            */
/******************************************************************************/
/* It calcuates extensional definitions of built-in predicates.               */
/******************************************************************************/
calculate_builtin_tuples:-
    findall((Pred, Arity, Mode, Type, Definition, Condition),
	    foili_builtin(Pred, Arity, Mode, Type, Definition, Condition), 
	    Hojo_list),
    calculate_builtin_tuples1(Hojo_list).

calculate_builtin_tuples1([]):-!.
calculate_builtin_tuples1([Builtin|Rest]):-!,
    Builtin = (Pred, Arity, Mode, Type, Definition, Condition),
    assert_definition(Definition),
    (bagof(Tuple,
	  ( choose_a_tuple_in_type(Type, Tuple),
	    plus_hojo_tuple(Builtin, Tuple)),
	  Hojo_tuples)
     -> assert(hojo_tuples(Pred, Arity, Mode, Type, Hojo_tuples, Condition))
      ; true),
    retract_definition(Definition),
    calculate_builtin_tuples1(Rest).

/******************************************************************************/
/*                                                                            */
/*  call          : assert_definition(Definitions)                            */
/*                  retruct_definition(Definitions)                           */
/*                                                                            */
/******************************************************************************/
/* It assert or retruct definitions of a background predicate.                */
/******************************************************************************/
assert_definition([]):-!.
assert_definition([Definition|Rest]):-
    assert(Definition),!,
    assert_definition(Rest).
retract_definition([]):-!.
retract_definition([Definition|Rest]):-
    retract(Definition),!,
    retract_definition(Rest).

/******************************************************************************/
/*                                                                            */
/*  call          : choose_a_tuple_in_type                                    */
/*                                                                            */
/*  subpredicates : domain_element                                            */
/*                                                                            */
/******************************************************************************/
/* It choose a tuple of types specified.                                      */
/******************************************************************************/
choose_a_tuple_in_type([], []):-!.
choose_a_tuple_in_type([Domain|Type], [X|Tuple]):-
    domain_element(X, Domain),
    choose_a_tuple_in_type(Type, Tuple).

domain_element(Element, Domain):-
    clause(domain(Domain, List), _),
    member(Element, List).
