/* Copyright (C) 1997 Itoh Hidenori */
/******************************************************************************/
/*                                                                            */
/*  Declarations and mata-predicates for FOIL-I                               */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Mata-predicates : repeat until                                            */
/*                                                                            */
/******************************************************************************/
:- op(900, fx, repeat).
:- op(850, xfx, until).
repeat Q until P :-
    repeat,
    call((Q, !)),
    call(P).

/******************************************************************************/
/*                                                                            */
/*  Declarations for dynamic predicates : to keep global information          */
/*                                                                            */
/******************************************************************************/
/*                                                                            */
/*  covered_sample          = keeps all positive example covered by clauses   */
/*                            induced so far.                                 */
/*  literals_sofar          = keeps literals found no use so far.             */
/*  intermediate_clauses    = keeps clauses under construction in this loop.  */
/*  this_depth              = keeps a depth of recursion during excecuting    */
/*                            a recursive definition.                         */
/*  this_call               = keeps a recursive call during excecuting        */
/*                            a recursive definition.                         */
/*  uncovered_plus          = keeps positive examples which remain not to be  */
/*                            covered so far.                                 */
/*  foili_exist_base_clause = to show that a base clause is induced already.  */
/*  result                  = keeps resulting clauses.                        */
/*  hojo_tuples             = keeps information of background predicates.     */
/*  plus                    = keeps all of original positive examples.        */
/*  negative                = keeps all of original negative examples.        */
/*  minus                   = keeps all of negative examples in the form      */
/*                            of nolimit list.                                */
/*  target_head_string      = keeps a head literal of target predicate        */
/*                            in a string.                                    */
/*  target_head             = keeps a head literal of target predicate        */
/*                            in a term.                                      */
/*  foili_known             = keeps all of instances known to be derived by   */
/*                            the induced clauses.                            */
/*                                                                            */
/******************************************************************************/
:-dynamic covered_sample/1,
    literals_sofar/1,
    intermediate_clauses/1,
    this_depth/1,
    this_call/1,
    uncovered_plus/1,
    foili_exist_base_clause/0,
    result/1,
    hojo_tuples/6,
    plus/1,
    negative/1,
    minus/1,
    target_head_string/1,
    target_head/1,
    foili_known/1.
