/* Copyright (C) 1997 Itoh Hidenori */
/******************************************************************************/
/*                                                                            */
/*  Built-in predicates for FOIL-I system.                                    */
/*                                                                            */
/*    eqlist : to say that a list is the same as another one.                 */
/*    eqatom : to say that an atom is the same as another one.                */
/*    eqint  : to say that an integer is the same as another one.             */
/*    lt     : to say that an integer is less than another one.               */
/*    le     : to say that an integer is less than or equals to another one.  */
/*                                                                            */
/******************************************************************************/
foili_builtin(eqlist, 2, [+,+], [list, list],
              [(eqlist(X,Y):-X==Y)], [proper_sorted]).
foili_builtin(eqatom, 2, [+,+], [atom, atom],
              [(eqatom(X,Y):-X==Y)], [proper_sorted]).
foili_builtin(eqint,  2, [+,+], [int, int],
              [(eqint(X,Y):-X==Y)],  [proper_sorted]).
foili_builtin(lt, 2, [+,+], [int, int],
              [(lt(X,Y):-X<Y)],  [apart]).
foili_builtin(le, 2, [+,+], [int, int],
              [(le(X,Y):-X=<Y)], [apart]).

/******************************************************************************/
/*                                                                            */
/*  Predicates to give conditions to built-in predicates and background       */
/*  predicates.                                                               */
/*                                                                            */
/*      proper_sorted : to request that argument ID should be sorted without  */
/*                      duplications.                                         */
/*      apart         : to request that argument ID should not be duplicated. */
/*                                                                            */
/******************************************************************************/
proper_sorted([]):-!.
proper_sorted([_]):-!.
proper_sorted([X, Y|R]):- X<Y, !, proper_sorted([Y|R]).

apart([]):-!.
apart([_]):-!.
apart([X|Y]):-!,(member(X,Y) -> false ; apart(Y)).
