/* Copyright (C) 1997 Itoh Hidenori */

/*	
	host.c
*/

#include<stdio.h>
#include<ctype.h>
#include<chost.c7.h>
#include"buffer.h"
#include"typedef.h"
#include"global.h"
#include"function.h"

void	host_main(argc,argv)
int	argc;
char	**argv;
{
	int	i, j, k, ncelx, ncely, max, locate, litno, arity;
	dliteral2	*hdl, *tdl;

	ncelx = ncely = 4;

	switch(argc)
	{
		case 4:
			ncelx = atoi(argv[2]);
			ncely = atoi(argv[3]);
		case 2:
			break;
		default:
			printf("PFOIL Error: Illigal arguments\n");
			exit(1);
	}

	printf("---------------------\n");
	printf("  Parallel FOIL 1.6\n");
	printf("---------------------\n");

	cconfxy(ncelx,ncely);
	ccreat("cell",30,NULL);

	printf("%d cells are ready.\n",ncelx*ncely);

	Count = 1;
	Subcount = 1;

	fp = fopen(argv[1],"r");
	read_data();
	fclose(fp);
	printf("%.2f sec.\n\n",dgettime());

	msg = buf_create();
	buf_add(msg,&Litnum,sizeof(Litnum));
	buf_add(msg,Functor,sizeof(string)*Litnum);
	buf_add(msg,Litdata,sizeof(Litnum)*Litnum*3);
	buf_add(msg,&Literalsize,sizeof(Literalsize));
	buf_add(msg,Literal,sizeof(Literalsize)*Literalsize);
	buf_add(msg,&Neganum,sizeof(Neganum));
	cbroad(30,0,msg->data,msg->size);
	buf_destroy(msg);

	set_init_state();

	printf("%d tuples are remaining.\n\n",Plustuplenum);

	send_state();	/* $B=i4|%9%F%$%H$NAw?.(B */

	for(;;)
	{
		Subcount = 1;
		for(j=1;j==1;++j)	/* D$B%U%'%$%:(B */
		{
			mk_cand();	/* D$B%j%F%i%k8uJd$N@8@.(B */
			devide();	/* D$B%j%F%i%k8uJd$NJ,G[(B */

			j = ncelx * ncely;
			hdl = tdl = NULL;
			max = Tuplelength-1;
			printf ("[Determinate Literals]\n");
			for(i=0;i<j;++i)
			{
				recv_dliteral();	/* D$B%j%F%i%k$N<u?.(B */
				if(Determnum > 0)
				{
					max = change_variable(max);	/* $BJQ?t$NIU$1BX$((B */

					if(hdl == NULL)
						hdl = tdl = putdliteral2(NULL);
					else
						tdl = putdliteral2(tdl);
					tdl->num = Determnum;
					tdl->size = Determsize;
					tdl->body = Determinate;
				}
			}
			add_dliteral(hdl,max);	/* D$B%j%F%i%k$NIU2C(B */
			send_state();	/* D$B%j%F%i%kIU2C8e$N%9%F%$%HAw?.(B */

			if(hdl == NULL)
			{
				printf("over.\n");
				break;
			}
		}

		Subcount = 2;
		for(;;)	/* N$B%U%'%$%:(B */
		{
			mk_cand();	/* $B%j%F%i%k8uJd$N@8@.(B */
			devide();	/* $B%j%F%i%k8uJd$NJ,G[(B */

			hsync();
			recv_state();	/* $B:GBgI>2ACM%9%F%$%H<u?.(B */

			printf("\n[Best Literal] (%d/%d)\n",Plustuplenum,Plustuplenum+Minustuplenum);	/* $B:NMQ%j%F%i%k$NI=<((B */
			printf("%s(",*(Functor+*(Right+*(Rightlocate+Rightnum-1))));
			for(i=0;i<*(Litdata+*(Right+*(Rightlocate+Rightnum-1))*3);++i)
				printf("%c,",*(Right+*(Rightlocate+Rightnum-1)+1+i)+0x41);
			printf("\b)\n");

			if(Minustuplenum == 0)
			{
				rm_remain();	/* Remaining$B$+$i%+%P!<$7$?;vNc$r<h$j=|$/(B */
				send_state();
				break;
			}

			send_state();	/* $B99?7$7$?%9%F%$%H$rAw?.(B */
		}

		if(Remainnum == 0)
			break;
	}
	waitstable();
	printf("%.2f sec.\n\n",dgettime());
}
