/* Copyright (C) 1997 Itoh Hidenori */

/*
	determinate.c
*/

#include<stdio.h>
#include<stdlib.h>
#include<ctype.h>
#include<math.h>
/*#ifdef	HOST
#include<chost.c7.h>
#endif
#ifdef	CELL
#include<ccell.c7.h>
#endif*/
#include"buffer.h"
#include"typedef.h"
#include"extern.h"
#include"function.h"


void	d_learn()
{
	int	i, j, k, l, litno, arity, size,*arg, *tmppt, *tmpmt;
	dliteral	*hdl, *tdl;

	hdl = tdl = NULL;
	for(i=0;i<Candnum;++i)	/* $B%j%F%i%k8uJd0l$D$:$D$K$D$$$F(B...	*/
	{
		litno = *(Candidate+*(Candlocate+i));
		arity = *(Litdata+litno*3);
		arg = Candidate+*(Candlocate+i)+1;
		size = 0;
		for(j=0;j<arity;++j)
			if(*(arg+j) >= Tuplelength)
				++size;
		if(size == 0)	/* $B?7JQ?t$,$J$$$J$i$P(B... */
			continue;

		tmppt = dp_expand(litno,arg,size);	/* $B@5%?%W%k$rE83+(B */

		if(tmppt == NULL)	/* $BE83+$K<:GT(B */
			continue;

		tmpmt = dm_expand(litno,arg,size);	/* $BIi%?%W%k$rE83+(B */

		if(tmpmt == NULL)	/* $BE83+$K<:GT(B ($B$"$k4p=`0J>e$G$N(B) */
		{
			xfree(tmppt);
			continue;
		}
		
		if(hdl == NULL)
			hdl = tdl = putdliteral(NULL);
		else
			tdl = putdliteral(tdl);

		tdl->literalno = litno;
		tdl->size = size;
		tdl->variable = arg;	/* $B%]%$%s%?$r$=$N$^$^;H$C$F$k$N$G>C$7$A$c$o$J$$$h$&$KCm0U(B! */
		tdl->plustuple = tmppt;
		tdl->minustuple = tmpmt;
	}
	Dliteral = hdl;

#if DEBUG == 1
	while(hdl != NULL)
	{
		printf("%s(",*(Functor+(hdl->literalno)));
		for(j=0;j<*(Litdata+(hdl->literalno)*3);++j)
			printf("%c,",*(hdl->variable+j)+0x41);
		printf("\b)\n");
		hdl = hdl->next;
	}
#endif
}


int	*dp_expand(litno,arg,size)
int	litno, *arg, size;
{
	int i, j, k, l, sw, sw2, sw3, arity, count, count2, locate, *tmppt, *posi, *posi2, *tuple, *tuple2;

	tmppt = xalloc(int,size*Plustuplenum);	/* $B@5%?%W%kA}2CJ,$r3NJ](B */

	arity = *(Litdata+litno*3);	/* $B%"%j%F%#(B */
	posi = Literal+*(Locate+litno)+arity*(1+*(Litdata+litno*3+1));	/* $B@5;vNc$N@hF,%]%$%s%?(B */
	tuple = State+Tuplelength;	/* $B@5%?%W%k$N@hF,%]%$%s%?(B */

	locate = 0;
	count2 = 0;
	for(j=0;j<Plustuplenum;++j)	/* $B@5%?%W%k0l$D$:$D$K$D$$$F(B... */
	{
		count = 0;
		sw2 = 1;
		tuple2 = tuple+j*Tuplelength;	/* $B%?%W%k(B j $B$N@hF,%]%$%s%?(B */
		for(k=0;k<*(Litdata+litno*3+2);++k)	/* $B%j%F%i%k$N@5;vNc0l$D$:$D$K$D$$$F(B... */
		{
			sw = 0;
			posi2 = posi+k*arity;	/* k $BHVL\$N@5;vNc$N@hF,%]%$%s%?(B */
			for(l=0;l<arity;++l)	/*	$BJQ?t0l$D$:$D$K$D$$$F(B... */
				if((*(arg+l) < Tuplelength)&&(*(tuple2+*(arg+l)) != *(posi2+l)))	/* $B$b$7?7JQ?t$G$O$J$$$N$K%?%W%k$H@5;vNc$,L7=b$9$k$J$i$P(B... */
				{
					sw =1;
					break;
				}
			if(sw == 0)	/* $B$b$7L7=b$,$J$$$J$i$P(B.. */
			{
				for(l=0;l<arity;++l)
					if(*(arg+l) >= Tuplelength)	/* $B?7JQ?t$J$i$P(B... */
					{
						*(tmppt+locate) = *(posi2+l);	
						++locate;
					}
				sw2 = 0;
				++count;
				if(count == 2)	/* $B$b$7%?%W%k$,#28D0J>e$KE83+$5$l$F$7$^$&$J$i$P(B... */
				{
					sw2 = 1;
					break;
				}
			}
		}
		if(sw2 == 1)	/* $BE83+$K<:GT(B */
		{
			xfree(tmppt);
			return(NULL);
		}
	}
	return(tmppt);
}


int	*dm_expand(litno,arg,size)
int	litno, *arg, size;
{
	int i, j, k, l, sw, sw2, sw3, arity, count, count2, locate, locate2;
	int	*tmpmt, *posi, *posi2, *tuple, *tuple2;

	tmpmt = xalloc(int,size*Minustuplenum);	/* $BIi%?%W%kA}2CJ,$r3NJ](B */

	arity = *(Litdata+litno*3);	/* $B%"%j%F%#(B */
	posi = Literal+*(Locate+litno)+arity*(1+*(Litdata+litno*3+1));	/* $B@5;vNc$N@hF,%]%$%s%?(B */
	tuple = State+Tuplelength*(1+Plustuplenum);	/* $BIi%?%W%k$N@hF,%]%$%s%?(B */

	locate = 0;
	count2 = 0;
	for(j=0;j<Minustuplenum;++j)	/* $BIi%?%W%k0l$D$:$D$K$D$$$F(B... */
	{
		count = 0;
		sw2 = 1;
		tuple2 = tuple+j*Tuplelength;	/* $B%?%W%k(B j $B$N@hF,%]%$%s%?(B */
		for(k=0;k<*(Litdata+litno*3+2);++k)	/* $B%j%F%i%k$N@5;vNc0l$D$:$D$K$D$$$F(B... */
		{
			sw = 0;
			posi2 = posi+k*arity;	/* $B%j%F%i%k$N(Bk $BHVL\$N@5;vNc$N@hF,%]%$%s%?(B */
			for(l=0;l<arity;++l)	/*	$BJQ?t0l$D$:$D$K$D$$$F(B... */
				if((*(arg+l) < Tuplelength)&&(*(tuple2+*(arg+l)) != *(posi2+l)))	/* $B$b$7?7JQ?t$G$O$J$$$N$KL7=b$9$k$J$i$P(B... */
				{
					sw = 1;
					break;
				}
			if(sw == 0)	/* $B$b$7L7=b$,$J$$$J$i$P(B... */
			{
				for(l=0;l<arity;++l)
					if(*(arg+l) >= Tuplelength)
					{
						*(tmpmt+locate) = *(posi2+l);
						++locate;
					}
			
				sw2 = 0;
				++count;
				if(count == 2)	/* $B$b$7%?%W%k$,#28D0J>e$KE83+$5$l$F$7$^$&$J$i$P(B... */
				{
					xfree(tmpmt);
					return(NULL);
				}
			}
		}
		if(sw2 == 1)	/* $BE83+$K<:GT(B */
		{
			for(l=0;l<arity;++l)
				if(*(arg+l) >= Tuplelength)
				{
					*(tmpmt+locate) = -1;
					++locate;
				}

			++count2;
			if((float)Minustuplenum*0.2 < (float)count2)
			{
				xfree(tmpmt);
				return(NULL);
			}
		}
	}
	return(tmpmt);
}


#ifdef	CELL
void	send_dliteral()
{
	int	i, j, arity, size, count, count2, *dlitdata;
	dliteral	*dl;
	
	if(Dliteral == NULL)	/* D$B%j%F%i%k$,$J$$$H$-(B */
	{
		msg = buf_create();
		h_send(4,msg->data,msg->size);
		buf_destroy(msg);
		return;
	}

	count = 0;
	size = 0;
	dl = Dliteral;
	while(dl != NULL)
	{
		size += dl->size;
		count += 2+*(Litdata+dl->literalno*3);
		dl = dl->next;
	}

	Determsize = size*(Plustuplenum+Minustuplenum)+count;
	dlitdata = xalloc(int,Determsize);
	count = 0;
	count2 = 0;
	dl = Dliteral;
	while(dl != NULL)
	{
		arity = *(Litdata+dl->literalno*3);
		*(dlitdata+count) = dl->literalno;
		++count;
		for(i=0;i<arity;++i)
		{
			*(dlitdata+count) = *(dl->variable+i);
			++count;
		}
		*(dlitdata+count) = dl->size;
		++count;
		for(i=0;i<Plustuplenum;++i)
			for(j=0;j<dl->size;++j)
			{
				*(dlitdata+count) = *(dl->plustuple+(dl->size*i)+j);
				++count;
			}
		for(i=0;i<Minustuplenum;++i)
			for(j=0;j<dl->size;++j)
			{
				*(dlitdata+count) = *(dl->minustuple+(dl->size*i)+j);
				++count;
			}
		dl = dl->next;
		++count2;
	}

	msg = buf_create();
	buf_add(msg,&count2,sizeof(count2));
	buf_add(msg,&Determsize,sizeof(Determsize));
	buf_add(msg,dlitdata,sizeof(Determsize)*Determsize);
	h_send(3,msg->data,msg->size);
	buf_destroy(msg);
	xfree(dlitdata);
	rmdliteral(Dliteral);
	xfree(Candidate);
}
#endif

void	recv_dliteral()
{
	ptr = crecv();
	if(getmtype() == 3)
	{
		msg = buf_init((char *)ptr,getmsize());
		buf_read(msg,&Determnum);
		buf_read(msg,&Determsize);
		Determinate = xalloc(int,Determsize);
		buf_read(msg,Determinate);
		buf_destroy(msg);
	}
	else
		Determnum = 0;
}


int	change_variable(max)
int	max;
{
	int	i, j, litno, arity, locate, size;
	
	locate = 0;
	for(i=0;i<Determnum;++i)
	{
		litno = *(Determinate+locate);
		arity = *(Litdata+litno*3);
		size = *(Determinate+locate+1+arity);
		for(j=0;j<arity;++j)
			if(*(Determinate+locate+1+j) >= Tuplelength)
				*(Determinate+locate+1+j) = ++max;
		printf("%s(",*(Functor+litno));
		for(j=0;j<arity;++j)
			printf("%c,",0x41+*(Determinate+locate+1+j));
		printf("\b)\n");
		locate += 1+arity+1+size*(Plustuplenum+Minustuplenum);
	}
	return(max);
}


void	add_dliteral(dl,max)
dliteral2	*dl;
int	max;
{
	int	i, j, k, newtuplelength, count, locate, locate2, litno, arity, size, pt, pt2;
	int	mt, mt2, newminustuplenum, *newstate, *mark, *newright;
	double	d;
	dliteral2	*dl2;

	if(dl == NULL)
		return;

	newtuplelength = max+1;	/* $B?7$7$$%9%F%$%H$N%?%W%kD9(B */
	newstate = xalloc(int,newtuplelength*(1+Plustuplenum+Minustuplenum));
	mark = xalloc(int,Minustuplenum);
	for(i=0;i<Minustuplenum;++i)
		*(mark+i) = 0;

	pt = Tuplelength;	/* $B:#$N%9%F%$%H$N%W%i%9%?%W%k$N0LCV(B */
	mt = Tuplelength*(1+Plustuplenum);	/* $B:#$N%9%F%$%H$N%^%$%J%9%?%W%k$N0LCV(B */
	pt2 = newtuplelength;	/* $B?7$7$$%9%F%$%H$N%W%i%9%?%W%k$N0LCV(B */
	mt2 = newtuplelength*(1+Plustuplenum);	/* $B?7$7$$%9%F%$%H$N%^%$%J%9%?%W%k$N0LCV(B */
	for(i=0;i<Tuplelength;++i)	/* $B%9%F%$%H$r%3%T!<(B */
	{
		*(newstate+i) = *(State+i);	/* $B%?%W%k%?%$%W$r%3%T!<(B */
		for(j=0;j<Plustuplenum;++j)	/* $B@5%?%W%k$r%3%T!<(B */
			*(newstate+pt2+j*newtuplelength+i) = *(State+pt+j*Tuplelength+i);
		for(j=0;j<Minustuplenum;++j)	/* $BIi%?%W%k$r%3%T!<(B */
			*(newstate+mt2+j*newtuplelength+i) = *(State+mt+j*Tuplelength+i);
	}

	count = 0;
	locate = Tuplelength;	/* $BJQ?tHV9f$rI=$o$9(B */
	dl2 = dl;
	while(dl2 != NULL)
	{
		locate2 = 0;	/* D$B%j%F%i%kK\BN$N$J$+$G$N0LCV$rI=$o$9(B */
		for(i=0;i<dl2->num;++i)
		{
			litno = *(dl2->body+locate2);
			arity = *(Litdata+litno*3);
			size = *(dl2->body+locate2+1+arity);
			count += 1+arity;
			pt = locate2+arity+2;
			mt = locate2+arity+2+size*Plustuplenum;

			for(j=0;j<arity;++j)	/* $B%?%$%W$r%3%T!<(B */
				*(newstate+*(dl2->body+locate2+1+j)) = *(Literal+*(Locate+litno)+j);

			for(j=0;j<Plustuplenum;++j)	/* $B%W%i%9%?%W%k$rDI2C(B */
				for(k=0;k<size;++k)
					*(newstate+newtuplelength*(j+1)+locate+k) = *(dl2->body+pt+j*size+k);

			for(j=0;j<Minustuplenum;++j)	/* $B%^%$%J%9%?%W%k$rDI2C(B */
				if(*(dl2->body+mt+j*size) == -1)
					*(mark+j) = 1;
				else
					for(k=0;k<size;++k)
						*(newstate+newtuplelength*(1+Plustuplenum+j)+locate+k) = *(dl2->body+mt+j*size+k);

			locate += size;
			locate2 += 2+arity+size*(Plustuplenum+Minustuplenum);
		}
		dl2 = dl2->next;
	}

	newright = xalloc(int,Rightsize+count);	/* $B1&JU$N99?7(B */
	for(i=0;i<Rightsize;++i)
		*(newright+i) = *(Right+i);
	locate = Rightsize;
	count = Rightnum;
	dl2 = dl;
	while(dl2 != NULL)
	{
/*		printf("@%d\n",dl2->num);*/
		locate2 = 0;
		for(i=0;i<dl2->num;++i)
		{
			++count;
			litno = *(dl2->body+locate2);
			arity = *(Litdata+litno*3);
			size = *(dl2->body+locate2+1+arity);
			*(newright+locate) = litno;	/* $B%j%F%i%kHV9f(B */
			++locate;
			for(j=0;j<arity;++j)
			{
				*(newright+locate) = *(dl2->body+locate2+1+j);
				++locate;
			}
			locate2 += 1+arity+1+size*(Plustuplenum+Minustuplenum);
		}
		dl2 = dl2->next;
	}
	xfree(Right);
	Right = newright;
	Rightsize = locate;
	Rightnum = count;

	xfree(Rightlocate);
	if(Rightnum > 0)
	{
		Rightlocate = xalloc(int,Rightnum);
		*(Rightlocate) = 0;
		locate = 0;
		for(i=0;i<Rightnum-1;++i)
		{
			locate += *(Litdata+*(Right+locate)*3) + 1;
			*(Rightlocate+i) = locate;
		}
	}


	count = 0;
	newminustuplenum = 0;
	for(i=0;i<Minustuplenum;++i)	/* $B%^%$%J%9%?%W%k$r=L$a$k(B */
	{
		if(*(mark+i) == 0)
		{
			++newminustuplenum;
			if(count>0)
				for(j=0;j<newtuplelength;++j)
					*(newstate+newtuplelength*(1+Plustuplenum+i-count)+j) = *(newstate+newtuplelength*(1+Plustuplenum+i)+j);
		}
		else
			++count;
	}
	
	Tuplelength = newtuplelength;
	Minustuplenum = newminustuplenum;
	Statesize = Tuplelength*(1+Plustuplenum+Minustuplenum);
	rmdliteral2(dl);
	xfree(State);
	State = newstate;

	d = (double)Plustuplenum/((double)Plustuplenum+(double)Minustuplenum);
	Info = -(float)log(d);
	Eval = (float)0;
	
#if DEBUG == 3
	printf("\n@@@@@\n");
	for(i=0;i<Tuplelength;++i)
		printf("%d ",*(State+i));
	printf("\n\n");
#endif
}
