/* Copyright (C) 1997 Itoh Hidenori */

/*
	learn.c
*/

#include<stdio.h>
#include<stdlib.h>
#include<ctype.h>
#include<math.h>
/*#ifdef	HOST
#include<chost.c7.h>
#endif
#ifdef	CELL
#include<ccell.c7.h>
#endif*/
#include"buffer.h"
#include"typedef.h"
#include"extern.h"
#include"function.h"

void	n_learn()
{
	int	i, j, k, litno, arity, *arg, size, locate, newptlength, newmtlength;
	int	ptlength, mtlength, tuplelength, *tupletype, rightlitno, *rightarg, *newstate, *newright;
	float	info, newinfo, eval, neweval;
	double	d;
	tuplestruct	*hts, *tts, *tmppt, *tmpmt, *pt, *mt;

	eval = info = (float)-9999999999.9;
	pt = mt = NULL;
	tupletype = NULL;
	ptlength = mtlength = tuplelength = 0;
	for(i=0;i<Candnum;++i)	/* $B%j%F%i%k8uJd0l$D$:$D$K$D$$$F(B... */
	{
		litno = *(Candidate+*(Candlocate+i));
		arity = *(Litdata+litno*3);
		arg = Candidate+*(Candlocate+i)+1;
		
		size = 0;
		for(j=0;j<arity;++j)	/* $B?7JQ?t$N?t$r%+%&%s%H(B */
			if(*(arg+j) >= Tuplelength)
				++size;

		tmppt = expand(litno,arg,0,size,&newptlength);	/* $B%W%i%9%?%W%k$NE83+(B */

		if(tmppt != NULL)
				tmpmt = expand(litno,arg,1,size,&newmtlength);	/* $B%^%$%J%9%?%W%k$NE83+(B */
		else
		{
				tmpmt = NULL;
				newptlength = newmtlength = 0;
		}

		if(newptlength+newmtlength > 0)
		{
			d = (double)newptlength/((double)newptlength+(double)newmtlength);
			newinfo = -(float)log(d);
			neweval = (float)newptlength*(Info-newinfo);
		}
		else
			newinfo = neweval = -99999999.9;

		if(neweval > eval || i == 0)
		{
			info = newinfo;
			eval = neweval;
			rmtuplestruct(pt);
			rmtuplestruct(mt);
			pt = tmppt;
			mt = tmpmt;
			ptlength = newptlength;
			mtlength = newmtlength;
			tuplelength = Tuplelength + size;

			rightlitno = litno;
			rightarg = arg;
		}
	}
	
	Info = info;
	Eval = eval;
	Tuplelength = tuplelength;
	Plustuplenum = ptlength;
	Minustuplenum = mtlength;
	Statesize = Tuplelength*(1+Plustuplenum+Minustuplenum);

	if(Candnum > 0)
	{
		if(Rightnum == 0)	/* $B1&JU$N99?7(B */
		{
			Rightnum = 1;
			arity = *(Litdata+3*rightlitno);
			Rightsize = 1+arity;
			Right = xalloc(int,Rightsize);
			*(Right) = rightlitno;
			for(j=0;j<arity;++j)
				*(Right+1+j) = *(rightarg+j);
		}
		else
		{
			++Rightnum;
			arity = *(Litdata+3*rightlitno);
			newright = xalloc(int,Rightsize+1+arity);
			for(j=0;j<Rightsize;++j)
				*(newright+j) = *(Right+j);
			*(newright+Rightsize) = rightlitno;
			for(k=0;k<arity;++k)
				*(newright+Rightsize+1+k) = *(rightarg+k);
/*			xfree(Right);	*/
			Right = newright;
			Rightsize += 1+arity;
		}

		newstate = xalloc(int,Statesize);	/* $B%9%F%$%HK\BN$N99?7(B */
		for(j=0;j<Tuplelength;++j)
			*(newstate+j) = *(State+j);
		locate = Tuplelength;
		for(j=0;j<*(Litdata+rightlitno*3);++j)
			if(*(rightarg+j) >= Tuplelength)
			{
				*(newstate+locate) = *(Literal+*(Locate+rightlitno)+j);
				++locate;
			}
		tmppt = pt;
		while(tmppt != NULL)
		{
			for(i=0;i<Tuplelength;++i)
			{
				*(newstate+locate) = *(tmppt->data+i);
				++locate;
			}
			tmppt = tmppt->next;
		}
		tmpmt = mt;
		while(tmpmt != NULL)
		{
			for(i=0;i<Tuplelength;++i)
			{
				*(newstate+locate) = *(tmpmt->data+i);
				++locate;
			}
			tmpmt = tmpmt->next;
		}
		xfree(State);
		State = newstate;
		rmtuplestruct(pt);
		rmtuplestruct(mt);
	}
}


tuplestruct	*expand(litno,arg,sw,size,count)	/* sw $B$,!!(B0:$B%W%i%9%?%W%k!$(B1:$B%^%$%J%9%?%W%k(B */
int	litno, *arg, sw, size, *count;
{
	int	i, j ,k, l, z, sw2, arity, newtuplelength, locate, *posi, *posi2, *tuple, *tuple2, *newtuple;
	tuplestruct	*hts, *tts;

	arity = *(Litdata+litno*3);	/* $B%"%j%F%#(B */
	newtuplelength = Tuplelength + size;	/* $B?7$7$$%?%W%kD9(B */
	posi = Literal+*(Locate+litno)+arity*(1+*(Litdata+litno*3+1));	/* $B@5;vNc$N@hF,%]%$%s%?(B */
	if(sw == 0)
		tuple = State+Tuplelength;
	else
		tuple = State+Tuplelength*(1+Plustuplenum);

	hts = tts = NULL;
	*count = 0;
	if(sw == 0)
		z = Plustuplenum;
	else
		z = Minustuplenum;
	for(i=0;i<z;++i)	/* $B%?%W%k0l$D$:$D$K$D$$$F(B... */
	{
		tuple2 = tuple+i*Tuplelength;	/* $B%?%W%k(B i $B$N@hF,%]%$%s%?(B */
		for(j=0;j<*(Litdata+litno*3+2);++j)	/* $B%j%F%i%k$N@5;vNc0l$D$:$D$K$D$$$F(B... */
		{
			sw2 = 0;
			posi2 = posi+j*arity;	/* j $BHVL\$N@5;vNc$N@hF,%]%$%s%?(B */
			for(k=0;k<arity;++k)	/*	$BJQ?t0l$D$:$D$K$D$$$F(B... */
				if(*(arg+k) < Tuplelength)	/* $B?7JQ?t$G$O$J$/(B... */
					if(*(tuple2+*(arg+k)) != *(posi2+k))	/* $B%?%W%k$H@5;vNc$,L7=b$9$k$J$i(B... */
					{
						sw2 = 1;
						break;
					}
			if(sw2 == 0)	/* $B$b$7L7=b$,$J$$$J$i$P(B... */
			{
				if(hts == NULL)
					hts = tts = puttuplestruct(NULL);
				else
					tts = puttuplestruct(tts);
				tts->data = xalloc(int,newtuplelength);
				for(k=0;k<Tuplelength;++k)
					*(tts->data+k) = *(tuple2+k);
				locate = Tuplelength;
				for(l=0;l<arity;++l)
					if(*(arg+l) >= Tuplelength)
					{
						*(tts->data+locate) = *(posi2+l);
						++locate;
					}
				++*count;
			}
		}
	}
	return(hts);
}
