// Copyright (C) 1996-1997 by Haruo Yokota, 
//	Japan Advanced Inst. of Sci. and Tech.,
//	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-12, Japan.
//

//
// $B%b!<%IA*Br(BPanel

import java.awt.Graphics;
import java.awt.*;
import java.applet.Applet;
import java.net.*;
import java.lang.*;
import java.io.*;
import java.util.*;

// insert/delete/query$B%b!<%IA*Br!#(B
public class SelectPanel extends Panel {
	public static final int insertMode = 0;
	public static final int deleteMode = 1;
	public static final int queryMode = 2;
	public static final int createMode = 3;
	public static final int dropMode = 4;

	final int	maxqsp = 3;

	int currentMode;	// insertMode/deleteMode/queryMode
	Choice choice;
	QbeSettingPanel	qsp[];
	GroupTable	groupTable;
	DropPanel	dropPanel;
	CreatePanel	createPanel;
	Client parent;
	String host;
	int port;

	public SelectPanel(Client c, GroupTable gt, String s, int p) {
		parent = c;
		groupTable = gt;
		host = s;
		port = p;
		setLayout(new VStackLayout());
		qsp = new QbeSettingPanel[maxqsp];

		choice = new Choice();
		choice.addItem(Const.insertString);
		choice.addItem(Const.deleteString);
		choice.addItem(Const.queryString);
		choice.addItem(Const.createString);
		choice.addItem(Const.dropString);
		choice.select(Const.queryString);
		add(choice);
		
		addQbes(choice.getSelectedItem());
	}

	// ========================================================
	public void removeQbes() {
		int i;
		for(i = 0; i < maxqsp; i++) {
			if(qsp[i] != null) {
				remove(qsp[i]);
				qsp[i] = null;
			}
		}
		if(dropPanel != null) {
			remove(dropPanel);
			dropPanel = null;
		}
		if(createPanel != null) {
			remove(createPanel);
			createPanel = null;
		}
	}

	// ========================================================
	public void addQbes(String s) {
		//String s = choice.getSelectedItem();
		int i;

		if(s.equals(Const.insertString)) {
			currentMode = insertMode;
			qsp[0] = new QbeSettingPanel(groupTable, false);
			add((QbeSettingPanel)qsp[0]);
		} else if(s.equals(Const.deleteString)) {
			currentMode = deleteMode;
			qsp[0] = new QbeSettingPanel(groupTable, false);
			add((QbeSettingPanel)qsp[0]);
		} else if(s.equals(Const.queryString)) {
			currentMode = queryMode;
			for(i = 0; i < maxqsp; i++) {
				qsp[i] = new QbeSettingPanel(groupTable, true);
				add((QbeSettingPanel)qsp[i]);
			}
		} else if(s.equals(Const.createString)) {
			currentMode = createMode;
			createPanel = new CreatePanel();
			add(createPanel);
		} else if(s.equals(Const.dropString)) {
			currentMode = dropMode;
			dropPanel = new DropPanel(groupTable);
			add(dropPanel);
		}

	}

	// ========================================================
	// event$B=hM}(B
	public boolean handleEvent(Event e) {
		String s;

		if(e.target == choice && e.id == e.ACTION_EVENT) {
			removeQbes();
			addQbes((String)e.arg);
			doLayout();
			printComponents(getGraphics());
//			printAll(getGraphics());
//			update(getGraphics());
			repaint();
			//return false;
		}

		return super.handleEvent(e);
	}

	// ========================================================
	// query go go go
	public void query(ScrollableTable st) {
		String s;

		s = choice.getSelectedItem();
		if(s.equals(Const.insertString)) {
			QueryInsert qi;
			QbeSettingPanel q = (QbeSettingPanel)qsp[0];
			qi = new QueryInsert(host, port, q);
			qi.getResult();
			// parent.reinit();
		} else if(s.equals(Const.deleteString)) {
			QueryDelete qd;
			QbeSettingPanel q = (QbeSettingPanel)qsp[0];
			qd = new QueryDelete(host, port, q);
			qd.getResult();
			// parent.reinit();
		} else if(s.equals(Const.queryString)) {
			Updater u = new Updater(st, this, host, port);
		} else if(s.equals(Const.createString)) {
			QueryCreate qd;
			String sd = createPanel.getScript();
			if(sd == null) {
				return;
			}
			qd = new QueryCreate(host, port, sd);
			qd.getResult();
			parent.reinit();
		} else if(s.equals(Const.dropString)) {
			QueryDrop qd;
			String sd = dropPanel.getSelectedItem();
			qd = new QueryDrop(host, port, sd);
			qd.getResult();
			parent.reinit();
		}
	}

	// ========================================================
	// reference
	public GroupTable getGroupTable() {
		return groupTable;
	}

	public QbeSettingPanel[] getQbeSettingPanels() {
		return (QbeSettingPanel[])qsp;
	}


}	// End of SelectPanel


// ===================================
class Updater extends Thread {
	QueryData qd;
	SelectPanel sp;
	ScrollableTable st;
	String host;
	int port;

	public Updater(ScrollableTable s, SelectPanel g, String h, int p) {
		sp = g;
		st = s;
		host = h;
		port = p;
		start();
	}

	// ========================================================
	public synchronized void run() {
		QueryData qd;

		qd = new QueryData(host, port, sp);
		Vector a = qd.getResult();
//		if(a != null && a.size() > 0) {
			st.setData(a);
			//paintAll(getGraphics());
//		} else {
//			// $B$($i!<$8$c$N$&!#(B
//		}
	}
}

/* Takashi Ishikawa / tishi@jaist.ac.jp */

