// Copyright (C) 1996-1997 by Haruo Yokota, 
//	Japan Advanced Inst. of Sci. and Tech.,
//	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-12, Japan.
//

/*
	$@9TA^F~(B
*/
import java.awt.Graphics;
import java.awt.*;
import java.applet.Applet;
import java.net.*;
import java.lang.*;
import java.io.*;
import java.util.*;

// ===================================================
public class QueryInsert extends Communicate {
	Const c = new Const();
	Integer counter;
	QbeSettingPanel qsp;
	boolean	initializing = true;

	public QueryInsert() {
		;
	}

	public QueryInsert(String h, int p, QbeSettingPanel q) {
		super(h, p);
		qsp = q;
		initializing = false;
	}

	// ===================================================
	public void run() {
		Const c = new Const();

		if(host == null) {
			System.out.println("not specified the server");
			stop();
			return;
		}

		Vector v;
		v = getScript();
		if(v == null) {
			System.out.println("failed to make chat script");
			vResult = new Vector();
			stop();
		}
		v = Main(v);
		if(v == null) {
			vResult = new Vector();
			stop();
		}
		vResult = parseResult((String)v.elementAt(1));	// 2$@HVL\(B
		if(vResult == null) {
			vResult = new Vector();
			stop();
		}

		//notify();
		stop();
	}
	// ===================================================
	private Vector getScript() {
		Vector v;
		String script, label, s;
		String as[];
		int i, max;
		Tag ta[];
		AttributeTable at;
		GroupTable gt;
		Tag tag = new Tag();

		v = new Vector();

		while(initializing || qsp == null) {
			try {
				(Thread.currentThread()).sleep(1000);	// 100ms
			} catch(InterruptedException e) {
				System.out.println("InterruptedException " + e);
			}
		}
		label = qsp.getSelectedName();
		if(label == null) {
			return null;
		}
		
		gt = qsp.getGroupTable();
		at = gt.get(label);
		if(at == null) {
			return null;
		}
		ta = tag.makeTagArray(at, qsp);
		script = "insert(\"" + label + "\",[[";
		as = qsp.getItems();
		for(i = 0; i < as.length; i++) {
			if(i > 0) {
				script += ",";
			}
			s = as[i];
			if(((String)ta[i].attribute.getType()).equals("integer")) {
				try {
					Integer.parseInt(s);
				} catch(NumberFormatException e) {
					return null;
				}
				script += s;
			} else {
				if(s.equals("")) {
					return null;
				}
				script += "\"" + s + "\"";
			}
		}
		script += "]])";

		// $@8e;OKvItJ,(B
		v.addElement("[start_transaction]");
		v.addElement("[" + script + "]");
		v.addElement("[commit_transaction]");

		return v;
	}


}	// Client


/* Takashi Ishikawa / tishi@jaist.ac.jp */

