// Copyright (C) 1996-1997 by Haruo Yokota, 
//	Japan Advanced Inst. of Sci. and Tech.,
//	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-12, Japan.
//

/*
	$@9T:o=|(B
*/
import java.awt.Graphics;
import java.awt.*;
import java.applet.Applet;
import java.net.*;
import java.lang.*;
import java.io.*;
import java.util.*;

// ===================================================
public class QueryDelete extends Communicate {
	Const c = new Const();
	Integer counter;
	QbeSettingPanel qsp;
	Tag	ta[];
	Vector 	vScript;	// $@:n@.Cf$N(Bscript
	boolean	initializing = true;

	public QueryDelete() {
		;
	}

	public QueryDelete(String h, int p, QbeSettingPanel q) {
		super(h, p);
		qsp = q;
		counter = new Integer(0);
		vScript = new Vector();
		initializing = false;
	}

	// ===================================================
	public void run() {
		Const c = new Const();

		if(host == null) {
			System.out.println("not specified the server");
			stop();
			return;
		}

		Vector v;
		v = getScript();
		if(v == null) {
			System.out.println("failed to make chat script");
			vResult = new Vector();
			stop();
		}
		v = Main(v);
		if(v == null) {
			vResult = new Vector();
			stop();
		}
		vResult = parseResult((String)v.elementAt(1));	// 2$@HVL\(B
		if(vResult == null) {
			vResult = new Vector();
			stop();
		}

		//notify();
		stop();
	}

	// ==========================================================
	// script$@:n@.(B
	public Vector getScript() {
		Vector v = new Vector();
		int i, max, c;
		Object newBufno;
		Object bufno;
		Enumeration en;
		String s;
		GroupTable gt;
		AttributeTable at;
		Tag tag = new Tag();

		while(initializing || qsp == null) {
			try {
				(Thread.currentThread()).sleep(1000);	// 100ms
			} catch(InterruptedException e) {
				System.out.println("InterruptedException " + e);
			}
		}

		vScript = new Vector(); // vScript.removeAllElements();

		// $@=i$a$N$H$-$O:G=i$N$G$d$k!#(B
		bufno = qsp.getSelectedName();
		gt = qsp.getGroupTable();
		at = gt.get((String)bufno);
		ta = tag.makeTagArray(at, qsp);

		newBufno = makeMainScript(bufno);

		// $@8e;OKvItJ,(B
		vScript.addElement("delete(\"" + bufno + "\"," + newBufno + ")");
//		vScript.addElement("del_all_temp(" + newBufno + ")");
	
		s = catScript(vScript);

		v.addElement("[start_transaction]");
		v.addElement("[" + s + "]");
		v.addElement("[commit_transaction]");

		return v;
	}


	// ==========================================================
	//
	public Object makeMainScript(Object bufno) {
		Enumeration en;
		int i, max;
		String s;
		Object newBufno = bufno;
		int groupedNumber = -1;
		boolean b;

		newBufno = addSelection(newBufno);

		return newBufno;
	}		

	// ==========================================================
	// selection$@$r$D$/$k!#(B
	// $@Nc(B:"selection("emp",[[2],=,"hoge"],2)"
	// and$@$7$+$G$-$M$C$9!#(B
	protected Object addSelection(Object bufno) {
		Object newBufno = bufno;
		String script;
		int i;
		String s;
		int conds;

		newBufno = bufno;	// $@$H$j$"$($:!"$J$K$b$7$J$$(B($@$J$K$=$l(B)$@!#(B
		script = "selection(";
		if(bufno instanceof Integer) {
			script += bufno;
		} else {
			script += "\"" + bufno + "\"";
		}
		script += ",";
		// ----- 
		s = "";
		conds = 0;
		for(i = 0; i < ta.length; i++) {
			if(ta[i].condition != null) {
				if(conds > 0) {
					s += ",and,";
				}
				s += "[[" + (i + 1) + "],";
				s += ta[i].condition;
				s += "," + ta[i].constant + "]";
				conds++;
			}
		}
		if(conds == 0) {
			return bufno;
		}

		if(conds > 1) {
			s = "[" + s + "]";
		}
		// ----- 
		newBufno = nextCount();
		script += s + "," + newBufno +")";
		vScript.addElement(script);

		return newBufno;
	}

/*
	// ==========================================================
	// Attribute$@$N(Bserno$@=g$K(Bname$@$r(BVector$@$XF~$l$k!#(B
	// $@$*$=$m$7$/Hs8zN(E*$@$1$I$5$7$F(Belement$@$bB?$/$J$$$7(B($@8@$$Lu(B)$@!#(B
	private Tag[] makeTagArray(AttributeTable at, QbeSettingPanel q) {
		Enumeration en;
		Vector v;
		int i, max;
		Attribute a;
		String s;
		Tag t;
		Tag ta[];

		v = new Vector();
		max = at.size();
		for(i = 0; i < max; i++) {
			en = at.keys();
			while(en.hasMoreElements()) {
				s = (String)en.nextElement();
				a = at.get(s);
				if(a.getSerno() != (i + 1)) {
					continue;
				}
				t = new Tag(q.getChecked(i), q.getItem(i), a);
				v.addElement(t);
				break;
			}
		}

		ta = new Tag[v.size()];
		en = v.elements();
		for(i = 0; en.hasMoreElements(); i++) {
			ta[i] = (Tag)en.nextElement();
		}

		return ta;
	}
*/
	
	// ==========================================================
	private Integer nextCount() {
		counter = new Integer(counter.intValue() + 1);
		return counter;
	}

	// ==========================================================
	// vector$@$r0lNs$K!V(B,$@!W$G$D$J$2$k!#(B
	protected String catScript(Vector v) {
		Enumeration en;
		String s = "";

		en = v.elements();
		while(en.hasMoreElements()) {
			s = s + (String)en.nextElement();
			if(en.hasMoreElements()) {
				s = s + ",";
			} else {
				break;
			}
		}

		return s;
	}


}	// Client


/* Takashi Ishikawa / tishi@jaist.ac.jp */

