// Copyright (C) 1996-1997 by Haruo Yokota, 
//	Japan Advanced Inst. of Sci. and Tech.,
//	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-12, Japan.
//

/*
	$B>H2q(J(query)
*/
import java.awt.Graphics;
import java.awt.*;
import java.applet.Applet;
import java.net.*;
import java.lang.*;
import java.io.*;
import java.util.*;

// ===================================================
public class QueryData extends Communicate {
	Const c = new Const();
	Object counter;
	SelectPanel selectPanel;
	TagTable tagTable;	// $BESCf$N%P%C%U%!L>$^$?$OHV9f$r5-21$9$k!#(J($B%P%C%U%!HV9f(J,TagVector)
	Vector	vVariables;	// $B=hM}Cf$NJQ?tL>$r5-21$9$k!#(J
	Vector	vVisit;	// $B=hM}Cf$N%P%C%U%!L>$r5-21$9$k!#(J($BFs=E=hM}KI;_(J)
	Vector 	vScript;	// $B:n@.Cf$N(Jscript
	boolean	initializing = true;

	public QueryData() {
		;
	}

	public QueryData(String h, int p, SelectPanel sp) {
		super(h, p);
		
		selectPanel = sp;
		vVariables = new Vector();
		vVisit = new Vector();
		vScript = new Vector();
		counter = new Integer(0);
		initTagTable(sp.getGroupTable());
		initializing = false;
	}

	// ===================================================
	public void run() {
		Const c = new Const();

		if(host == null) {
			System.out.println("not specified the server");
			stop();
			return;
		}

		Vector v;
		v = getScript();
		if(v == null) {
			System.out.println("failed to make chat script");
			vResult = new Vector();
			stop();
		}
		v = Main(v);
		if(v == null) {
			vResult = new Vector();
			stop();
		}
		vResult = parseResult((String)v.elementAt(1));	// 2$BHVL\(J
		if(vResult == null) {
			vResult = new Vector();
			stop();
		}

		Tag ta[];
		String as[];
		int i;

		ta = tagTable.get(counter);
		as = new String[ta.length];
		for(i = 0; i < ta.length; i++) {
			as[i] = ta[i].attribute.getName();
		}
		vResult.insertElementAt(as, 0);	// $B9`L\L>$r@hF,$NMWAG$K2C$($k!#(J


		//notify();
		stop();
	}
	// ===================================================

	  
	// ==========================================================
	// script$B:n@.(J
	public Vector getScript() {
		Vector v = new Vector();
		int i, max, c;
		Object newBufno;
		Object bufno = new Object();
		Enumeration en;
		Tag tarray[];
		String s;

		while(initializing || tagTable == null) {
			// constructor$BBT$A(J
			try {
				(Thread.currentThread()).sleep(1000);	// 100ms
			} catch(InterruptedException e) {
				System.out.println("InterruptedException " + e);
			}
		}

		vScript = new Vector();

		// $B=i$a$N$H$-$O:G=i$N$G$d$k!#(J
		en = tagTable.keys();
		bufno = null;
		while(en.hasMoreElements()) {
			// $B$G$b(Jbusy$B$8$c$J$$$d$D(J
			bufno = en.nextElement();
			if(vVisit.contains(bufno)) {
				// busy$B$_$?$$$M!#(J
				continue;
			} else {
				counter = (Object)bufno;
				//break;
			}
		}
		if(bufno == null) {
			return null; // throw new NullPointerException("parsing");
		}

		newBufno = makeMainScript(bufno);

		// $B8e;OKvItJ,(J
		if(newBufno instanceof String) {
			// $BJ8;zNs$@$C$?$i(Jquote$B$9$k!#(J
			newBufno = "\"" + newBufno + "\"";
		}
		vScript.addElement("get_relation(" + newBufno + ")");
		vScript.addElement("del_all_temp(" + newBufno + ")");
	
		s = catScript(vScript);

		v.addElement("[start_transaction]");
		v.addElement("[" + s + "]");
		v.addElement("[commit_transaction]");

		return v;
	}


	// ==========================================================
	//
	public Object makeMainScript(Object bufno) {
		Tag tarray[];
		Enumeration en;
		int i, max;
		String s;
		Object newBufno = bufno;
		int groupedNumber = -1;
		boolean b;

		// join
		tarray = tagTable.get(bufno);

		// tarray$B$+$iJQ?t$r$5$,$9!#(J
		for(i = 0; i < tarray.length; i++) {
			s = tarray[i].variable;
			if(s != null &&
			!vVariables.contains(s) &&
			(newBufno = findNonVisited(s)) != null &&
			tarray[i].different == false) {
				vVariables.addElement(s);	// $BJQ?tEPO?(J
				vVisit.addElement(bufno);	// $B$$$C$?$3$H$"$k$<EPO?(J
				newBufno = makeMainScript(newBufno);
				if(newBufno == null) {
					// $B$J$+$C$?$3$H$K$9$k!#(J
					continue;
				}
				// join
				newBufno = addJoin(bufno, newBufno, s, false);
				vVariables.removeElement(s);
				if(newBufno != null) {
					bufno = newBufno;
				}
			}
		}

		// having
		tarray = tagTable.get(newBufno);
		for(i = 0; i < tarray.length; i++) {
			if(tarray[i].havingCondition != null) {
				newBufno = addHavingSelection(newBufno, i + 1);
				break;
			}
		}

		// group by
		tarray = tagTable.get(newBufno);
		for(i = 0; i < tarray.length; i++) {
			if(tarray[i].group) {
				newBufno = addGroupBy(newBufno, i + 1);
				groupedNumber = i + 1;
				break;
			}
		}

		// function
		tarray = tagTable.get(newBufno);
		for(i = 0; i < tarray.length; i++) {
			if(tarray[i].function != -1) {
				// having
				if(groupedNumber == -1) {
					// grouping$B$7$F$J$$$H$-$O6/@)(Jgrouping
					newBufno = addGroupBy(newBufno, -1);
					tarray = tagTable.get(newBufno);
					groupedNumber = 0;
				}
				// groupby$B$7$F$b!"$?$V$s(Jtarray$B$N(Ji$B$O!"$:$l$J$$!#(J
				switch(tarray[i].function) {
				case Const.fnAverage:
					newBufno = addAverage(newBufno, i + 1, groupedNumber);
					break;
				case Const.fnSum:
					newBufno = addSum(newBufno, i + 1, groupedNumber);
					break;
				case Const.fnCount:
					newBufno = addCount(newBufno, i + 1, groupedNumber);
					break;
				case Const.fnMax:
					newBufno = addMax(newBufno, i + 1, groupedNumber);
					break;
				case Const.fnMin:
					newBufno = addMin(newBufno, i + 1, groupedNumber);
					break;
				default:
					System.out.println("not implemented");
					break;
				}

				break;
			}
		}


		// --
		newBufno = addSelection(newBufno);
/*
		// --
		// different
		tarray = tagTable.get(newBufno);

		// tarray$B$+$iJQ?t$r$5$,$9!#(J
		for(i = 0; i < tarray.length; i++) {
			s = tarray[i].variable;
			if(s != null &&
			!vVariables.contains(s) &&
			(newBufno = findNonVisited(s)) != null) {
				vVariables.addElement(s);	// $BJQ?tEPO?(J
				vVisit.addElement(bufno);	// $B$$$C$?$3$H$"$k$<EPO?(J
				newBufno = makeMainScript(newBufno);
				// join
				newBufno = addJoin(bufno, newBufno, s, true);
				if(newBufno == null) {
					// $B$($i!<$J$i<!$X(J
					continue;
				}
				newBufno = addSelection(newBufno);
				bufno = newBufno;
			}
		}
*/

		// --
		newBufno = addProjection(newBufno);

		return newBufno;
	}		

	// ==========================================================
	// $BL$(Jvisit$B$GJQ?t(Js$B$r;}$D(Jbuf$B$rC5$9!#(J
	public Object findNonVisited(String s) {
		int i, max;
		Enumeration en;
		Object bufno;
		Tag ta[];

		en = tagTable.keys();
		while(en.hasMoreElements()) {
			bufno = en.nextElement();
			if(vVisit.contains(bufno)) {
				continue;
			}
			// $B$^$@8+$F$J$$(J
			ta = tagTable.get(bufno);
			if(findVariable(ta, s) >= 0) {
				// $B$O$C$1$s(J
				return bufno;
			}
		}

		return null;	// $B$3$J$$$O$:(J
	}

	// ==========================================================
	// join$B$+(Jdifferent$B$r$D$/$k!#(J
	// $BNc(J:join("emp",2,[[6],=,[1]],3)
	// $BNc(J:different("emp",2,3)
	protected Object addJoin(Object ob, Object nb, String s, boolean canDifferent) {
		// ob$B$O(Jjoin$B$5$l$k%P%C%U%!L>(J/nb$B$O(Jjoin$B$9$k%P%C%U%!L>(J/s$B$OJQ?tL>(J
		Tag taold[], tanew[];
		int oi, ni;
		String script;
		Object newBufno;
		Object o1, o2;
		boolean different;

		taold = tagTable.get(ob);
		tanew = tagTable.get(nb);

		oi = findVariable(taold, s);
		ni = findVariable(tanew, s);

		// join1
		if(taold[oi].different) {
			o1 = nb;
			o2 = ob;
			script = "different(";
			different = true;
		} else if(tanew[ni].different) {
			o1 = ob;
			o2 = nb;
			script = "different(";
			different = true;
		} else {
			// join$B$@$J!<!#(J
			o1 = ob;
			o2 = nb;
			script = "join(";
			different = false;
		}
		if(different && !canDifferent) {
			return null;
		}

		if(o1 instanceof String) {
			script += "\"" + o1 + "\",";
		} else {
			script += o1 + ",";
		}

		// join2
		if(o2 instanceof String) {
			script += "\"" + o2 + "\"";
		} else {
			script += o2;
		}

		script += ",[[";
/*
		// join1
		script = "join(";
		if(ob instanceof String) {
			script += "\"" + ob + "\",";
		} else {
			script += nb + ",";
		}

		// join2
		if(nb instanceof String) {
			script += "\"" + nb + "\",[[";
		} else {
			script += nb + ",[[";
		}
*/
		// condition
		if(different) {
			// different()
			script += "" + (oi + 1) + "],[" + (ni + 1) + "]],";
		} else {
			// join()
			script += "" + (oi + 1) + "],=,[" + (ni + 1) + "]],";
		}

		newBufno = nextCount();
		script += "" + newBufno + ")";
		vScript.addElement(script);

		// $BJQ?t:o=|(J
		taold[oi].body = "";
		tanew[ni].body = "";

		// catTagTable$B$7$F(JtagTable$B$N(Job$B$H(Jnb$B$O<N$F$k!#(J
		tagTable.put(newBufno, catTagArray(taold, tanew));
		tagTable.remove(ob);
		tagTable.remove(nb);


		return newBufno;
	}


	// ==========================================================
	// group_by$B$r$D$/$k!#(J
	// $BNc(J:"group_by("emp",[1],1)"
	// position = null$B$N$H$-$O$J$K$b$7$J$$(Jgroup_by$B$r$D$/$k!#(J
	protected Object addGroupBy(Object bufno, int position) {
		Object newBufno;
		String script;
		Tag ta[];

		ta = tagTable.get(bufno);
		ta[position].group = false;

		newBufno = bufno;
		script = "group_by(";
		if(bufno instanceof Integer) {
			script += bufno;
		} else {
			script += "\"" + bufno + "\"";
		}
		script += ",";
		if(position == -1) {
			script += "" + 0;
		} else {
			script += "[" + position + "]";
		}

		newBufno = nextCount();
		script += "," + newBufno +")";
		vScript.addElement(script);
		tagTable.put(newBufno, ta);	// $BEPO?(J

		return newBufno;
	}

	// ==========================================================
	protected Tag[] functionedTags(Tag ta[], int position, int groupedNumber) {
		Tag newTa[];

		newTa = new Tag[2];
		if(groupedNumber == 0) {
			// $B$N!"$H$-$O$I$&$7$h$&(J?
			Attribute a = new Attribute("---", 0, "integer", 0);
			newTa[0] = new Tag(true, "count", a);
		} else {
			newTa[0] = ta[groupedNumber - 1];
		}
		newTa[1] = ta[position - 1];

		return newTa;
	}

	// ==========================================================
	// avg_rdb$B$r$D$/$k!#(J
	// $BNc(J:"avg_rdb("emp",[1],1)"
	// position = null$B$N$H$-$O$J$K$b$7$J$$(Jgroup_by$B$r$D$/$k!#(J
	protected Object addAverage(Object bufno, int position, int groupedNumber) {
		Object newBufno;
		String script;
		Tag ta[], newTa[];

		ta = tagTable.get(bufno);

		newBufno = bufno;
		script = "avg_rdb(";
		if(bufno instanceof Integer) {
			script += bufno;
		} else {
			script += "\"" + bufno + "\"";
		}
		script += ",[" + position + "]";

		newBufno = nextCount();
		script += "," + newBufno +")";
		vScript.addElement(script);

		newTa = functionedTags(ta, position, groupedNumber);
		tagTable.put(newBufno, newTa);	// $BEPO?(J

		return newBufno;
	}


	// ==========================================================
	// sum$B$r$D$/$k!#(J
	// $BNc(J:"sum_rdb("emp",[1],1)"
	// position = null$B$N$H$-$O$J$K$b$7$J$$(Jgroup_by$B$r$D$/$k!#(J
	protected Object addSum(Object bufno, int position, int groupedNumber) {
		Object newBufno;
		String script;
		Tag ta[], newTa[];

		ta = tagTable.get(bufno);

		newBufno = bufno;
		script = "sum_rdb(";
		if(bufno instanceof Integer) {
			script += bufno;
		} else {
			script += "\"" + bufno + "\"";
		}
		script += ",[" + position + "]";

		newBufno = nextCount();
		script += "," + newBufno +")";
		vScript.addElement(script);

		// [[0,7753]]$B$_$?$$$K(J2$B9`L\$K$J$k$N$G!"(JTag[]$B$rJQ99$7$J$$$H$^$:$$!#(J
		newTa = functionedTags(ta, position, groupedNumber);
		tagTable.put(newBufno, newTa);	// $BEPO?(J

		return newBufno;
	}

	// ==========================================================
	// count_rdb$B$r$D$/$k!#(J
	// $BNc(J:"count_rdb("emp",1)"
	protected Object addCount(Object bufno, int position, int groupedNumber) {
		Object newBufno;
		String script;
		Tag ta[], newTa[];

		ta = tagTable.get(bufno);

		newBufno = bufno;
		script = "count_rdb(";
		if(bufno instanceof Integer) {
			script += bufno;
		} else {
			script += "\"" + bufno + "\"";
		}

		newBufno = nextCount();
		script += "," + newBufno +")";
		vScript.addElement(script);

		// [[0,7753]]$B$_$?$$$K(J2$B9`L\$K$J$k$N$G!"(J
		// Tag[]$B$rJQ99$7$J$$$H$^$:$$$C$9!#(J
		// $B$N!"$H$-$O$I$&$7$h$&(J?
		newTa = functionedTags(ta, position, groupedNumber);
		tagTable.put(newBufno, newTa);	// $BEPO?(J

		return newBufno;
	}

	// ==========================================================
	// max$B$r$D$/$k!#(J
	// $BNc(J:"max_rdb("emp",[1],1)"
	// position = null$B$N$H$-$O$J$K$b$7$J$$(Jgroup_by$B$r$D$/$k!#(J
	protected Object addMax(Object bufno, int position, int groupedNumber) {
		Object newBufno;
		String script;
		Tag ta[], newTa[];

		ta = tagTable.get(bufno);

		newBufno = bufno;
		script = "max_rdb(";
		if(bufno instanceof Integer) {
			script += bufno;
		} else {
			script += "\"" + bufno + "\"";
		}
		script += ",[" + position + "]";

		newBufno = nextCount();
		script += "," + newBufno +")";
		vScript.addElement(script);

		newTa = functionedTags(ta, position, groupedNumber);
		tagTable.put(newBufno, newTa);	// $BEPO?(J

		return newBufno;
	}
	// ==========================================================
	// min$B$r$D$/$k!#(J
	// $BNc(J:"min_rdb("emp",[1],1)"
	// position = null$B$N$H$-$O$J$K$b$7$J$$(Jgroup_by$B$r$D$/$k!#(J
	protected Object addMin(Object bufno, int position, int groupedNumber) {
		Object newBufno;
		String script;
		Tag ta[], newTa[];

		ta = tagTable.get(bufno);

		newBufno = bufno;
		script = "min_rdb(";
		if(bufno instanceof Integer) {
			script += bufno;
		} else {
			script += "\"" + bufno + "\"";
		}
		script += ",[" + position + "]";

		newBufno = nextCount();
		script += "," + newBufno +")";
		vScript.addElement(script);

		newTa = functionedTags(ta, position, groupedNumber);
		tagTable.put(newBufno, newTa);	// $BEPO?(J

		return newBufno;
	}

	// ==========================================================
	// selection$B$r$D$/$k!#(J
	// $BNc(J:"selection("emp",[[2],=,"hoge"],2)"
	// and$B$7$+$G$-$M$C$9!#(J
	protected Object addSelection(Object bufno) {
		Object newBufno = bufno;
		String script;
		Tag ta[];
		int i;
		String s;
		int conds;

		ta = tagTable.get(bufno);

		newBufno = bufno;	// $B$H$j$"$($:!"$J$K$b$7$J$$(J($B$J$K$=$l(J)$B!#(J
		script = "selection(";
		if(bufno instanceof Integer) {
			script += bufno;
		} else {
			script += "\"" + bufno + "\"";
		}
		script += ",";
		// ----- 
		s = "";
		conds = 0;
		for(i = 0; i < ta.length; i++) {
			if(ta[i].condition != null) {
				if(conds > 0) {
					s += ",and,";
				}
				s += "[[" + (i + 1) + "],";
				s += ta[i].condition;
				s += "," + ta[i].constant + "]";
				conds++;
			}
		}

		if(conds == 0) {
			return bufno;
		}

		if(conds > 1) {
			s = "[" + s + "]";
		}
		// ----- 
		newBufno = nextCount();
		script += s + "," + newBufno +")";
		vScript.addElement(script);
		tagTable.put(newBufno, ta);	// $BEPO?(J

		return newBufno;
	}

	protected Object addHavingSelection(Object bufno, int position) {
		Object newBufno = bufno;
		String script;
		Tag ta[];
		int i;
		String s;
		int conds;

		ta = tagTable.get(bufno);

		newBufno = bufno;	// $B$H$j$"$($:!"$J$K$b$7$J$$(J($B$J$K$=$l(J)$B!#(J
		script = "selection(";
		if(bufno instanceof Integer) {
			script += bufno;
		} else {
			script += "\"" + bufno + "\"";
		}
		script += ",";
		// ----- 
		s = "";
		conds = 0;
		if(ta[position - 1].havingCondition != null) {
			s += "[[" + position + "],";
			s += ta[position - 1].havingCondition;
			s += "," + ta[position - 1].havingConstant + "]";
			conds++;
		}

		if(conds == 0) {
			return bufno;
		}

		// ----- 
		newBufno = nextCount();
		script += s + "," + newBufno +")";
		vScript.addElement(script);
		tagTable.put(newBufno, ta);	// $BEPO?(J

		return newBufno;
	}

	// ==========================================================
	// projection$B$r$D$/$k!#(J
	// $BNc(J:"projection(1,[2,3,4,5],2)"
	// input$B$,(J0$B$N$H$-$O!"(Jgp.getName()$B$r(Jprojection$B$NF~NO$K$9$k!#(J
	protected Object addProjection(Object bufno) {
		Object newBufno = bufno;
		int i, max;
		Tag ta[];
		String script;
		Vector v = new Vector();
		Enumeration en;
		int projs;

		newBufno = bufno;	// $B$H$j$"$($:!"$J$K$b$7$J$$(J($B$J$K$=$l(J)$B!#(J
		ta = tagTable.get(bufno);
		max = ta.length;
		script = "projection(";
		if(bufno instanceof Integer) {
			script += bufno;
		} else {
			script += "\"" + bufno + "\"";
		}

		projs = 0;
		script += ",[";
		for(i = 0; i < max; i++) {
			if(ta[i].display) {
				if(projs > 0) {
					script += ",";
				}
				script += (i + 1);
				v.addElement(ta[i]);
				projs++;
			}
		}

		if(projs == 0) {
			// $BA4A3$7$J$/$F$b!"I,MW$J$7!#$G$b2?$b$G$J$$$h$&$K$7$J$$$H(J...$B!#(J
			// return null;
		} else if(projs == max) {
			// $BA4It(Jprojection$B$9$k$J$i!"I,MW$J$7!#(J
			return bufno;
		}

		newBufno = nextCount();
		script += "]," + newBufno +")";
		vScript.addElement(script);

		// $B$"$?$i$7$$(JTag[]$B$r$D$/$k!#(J
		ta = new Tag[v.size()];
		v.copyInto(ta);
		tagTable.put(newBufno, ta);

		return newBufno;
	}


	// ==========================================================
	// Tag$B$NG[Ns$+$iJQ?tL>(Js$B$NMWAGHV9f$rC5$9!#(J
	protected int findVariable(Tag ta[], String s) {
		int i;

		for(i = 0; i < ta.length; i++) {
			if(s.equals(ta[i].variable)) {
				return i;
			}
		}

		return -1;	// $B$"$j$($J$$(J
	}

	// ==========================================================
	protected void initTagTable(GroupTable gt) {
		Vector v;
		int i, max;
		String groupName;
		Enumeration en;
		AttributeTable at;
		Attribute a;
		QbeSettingPanel qsp[];
		QbePanel qp;
		Tag tarray[];
		Tag tag = new Tag();

		tagTable = new TagTable();
		qsp = selectPanel.getQbeSettingPanels();
		
		// ($B%0%k!<%WL>(J, TagVector)$B$NAH$r(Jqsp$B$N?t$@$1$D$/$k!#(J
		for(i = 0; i < qsp.length; i++) {
			if(qsp[i] == null) {
				continue;
			}
			groupName = qsp[i].getSelectedName();
			if(groupName == null) {
				// $B$J$1$l$P<!$X!#(J
				continue;
			}
			at = gt.get(groupName);
			tarray = tag.makeTagArray(at, qsp[i]);
			tagTable.put(groupName, tarray);
		}

		return;
	}
	
	// ==========================================================
	private Object nextCount() {
		if(counter instanceof Integer) {
			counter = (Object)new Integer(((Integer)counter).intValue() + 1);
		} else {
			// "dept"$B$J$s$F$H$-$b$"$k$+$i!#(J
			counter = (Object)new Integer(1);
		}
		return counter;
	}

	// ==========================================================
	private Tag[] catTagArray(Tag ta1[], Tag ta2[]) {
		int i1, i2, max;
		Tag newTa[];

		max = ta1.length + ta2.length;
		newTa = new Tag[max];

		for(i1 = 0; i1 < ta1.length; i1++) {
			newTa[i1] = ta1[i1];
		}
		for(i2 = 0; i2 < ta2.length; i1++, i2++) {
			newTa[i1] = ta2[i2];
		}

		return newTa;
	}

	// ==========================================================
	// $B$U$?$D$N(JVector$B$rB-$9!#(J v1 = v1 + v2
	private Vector catVector(Vector v1, Vector v2) {
		Vector v;
		int i, max;

		v = (Vector)v1.clone();
		max = v2.size();
		for(i = 0; i < max; i++) {
			v.addElement(v2.elementAt(i));
		}

		return v;
	}

	// ==========================================================
	// vector$B$r0lNs$K!V(J,$B!W$G$D$J$2$k!#(J
	protected String catScript(Vector v) {
		Enumeration en;
		String s = "";

		en = v.elements();
		while(en.hasMoreElements()) {
			s = s + (String)en.nextElement();
			if(en.hasMoreElements()) {
				s = s + ",";
			} else {
				break;
			}
		}

		return s;
	}


}	// Client

/* Takashi Ishikawa / tishi@jaist.ac.jp */

