// Copyright (C) 1996-1997 by Haruo Yokota, 
//	Japan Advanced Inst. of Sci. and Tech.,
//	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-12, Japan.
//

//
// QBE$BE*I=$X$NA`:n$HI=$NA*Br(B

import java.awt.Graphics;
import java.awt.*;
import java.applet.Applet;
import java.net.*;
import java.lang.*;
import java.io.*;
import java.util.*;

public class QbeSettingPanel extends Panel {
	GroupTable	groupTable;
	QbePanel	qbePanel;
	GroupChoice	groupChoice;
	TextField	textField;
	Label		currentLabel;
	String		oldItem;
	boolean		canSelect;	// can yellow/red toggle

	public QbeSettingPanel(GroupTable gt, boolean b) {
		canSelect = b;
		groupTable = gt;
		oldItem = null;
		createComponents();
	}

	// =============================================
	public void createComponents() {
		String s;

		setLayout(new VStackLayout());

		groupChoice = new GroupChoice(groupTable);
		add(groupChoice);

		currentLabel = new Label();
		add(currentLabel);

		textField = new TextField(15);
		add(textField);
		textField.setEditable(false);

		s = groupChoice.getSelectedItem();
		addQbePanel(s);
	}

	// =============================================
	public void addQbePanel(String s) {
		AttributeTable at;
		Vector v;

		if(s.equals(Const.doNothing)) {
			at = null;
		} else {
			at = groupTable.get(s);
		}
		v = createVector(at);
		qbePanel = new QbePanel(v, canSelect);
		add(qbePanel);
	}

	// =============================================
	public synchronized void paint(Graphics g) {
		Dimension d = getSize();

		g.setColor(getBackground());
		g.draw3DRect(2, 2, d.width - 4, d.height - 4, false);
	}

	// =============================================
	// $B%^!<%8%s$OMW$k$h$J!<!#(B
	public Insets getInsets() {
		return new Insets(10, 10, 10, 10);
	}

	// =============================================
	// QbePanel$B$XEO$9%G!<%?$r:n$k!#(B
	public Vector createVector(AttributeTable at) {
		Vector v = new Vector();
		String as1[], as2[];
		int i, j, max;
		Attribute	a;

		if(at == null) {
			return null;
		}

		// $B$U$D$&$O$3$C$A(B
		max = at.size();
		as1 = new String[max];
		as2 = new String[max];
		for(i = 0; i < max; i++) {
			a = at.elementAt(i + 1);
			as1[i] = a.getName();
			as2[i] = "";
		}
		v.addElement(as1);
		v.addElement(as2);
		
		return v;
	}

	// =============================================
	// event$B=hM}(B
	public boolean handleEvent(Event e) {
		String s;

		//System.out.println(e);

		if(e.target == qbePanel && e.id == e.MOUSE_DOWN) {
			// $B%/%j%C%/$5$l$?$i$7$$!#(B
			if(oldItem != null) {
				s = textField.getText();
				qbePanel.setItem(oldItem, s);
			}
			s = qbePanel.getCurrentItem();
			textField.setText(s);
			oldItem = s = qbePanel.getCurrentName();
			currentLabel.setText(s + ":");
			textField.setEditable(true);
			textField.requestFocus();
			return true;

		} else if(e.target == textField && e.id == e.ACTION_EVENT) { // e.KEY_PRESS
			// $B%F%-%9%HF~NO(B
			s = textField.getText();
			if(s == null) {
				return false;
			}
			qbePanel.setCurrentItem(s);
			textField.requestFocus();
			//return false; // true;

		} else if(e.target == groupChoice && e.id == e.ACTION_EVENT) {
			// $B$Y$D$J(Bgroup$B$,A*Br$5$l$?!#(B
			remove(qbePanel);
			addQbePanel((String)e.arg);
			currentLabel.setText("");
			//textField.setEditable(false);
			doLayout();
			repaint();
//			addNotify();
			printComponents(getGraphics());
////			qbePanel.repaint();
////			update(getGraphics());
		        
			return true;
		}

		return super.handleEvent(e);
	}

	// reference
	public QbePanel getQbePanel() {
		return qbePanel;
	}

	public String getSelectedName() {
		String s;

		s = groupChoice.getSelectedItem();
		if(s.equals(Const.doNothing)) {
			return null;
		}

		return s;
	}

	public boolean getChecked(int i) {
		return qbePanel.getChecked(i);
	}

	public String getItem(int i) {
		return qbePanel.getItem(i);
	}

	public String[] getItems() {
		return qbePanel.getItems();
	}

	public GroupTable getGroupTable() {
		return groupTable;
	}
}

// =============================================
// =============================================
// =============================================

class GroupChoice extends Choice {
	public GroupChoice(GroupTable gt) {
		setItems(gt);
		select(Const.doNothing);
	}

	public void setItems(GroupTable gt) {
		Enumeration en;

		addItem(Const.doNothing);
		en = gt.keys();
		while(en.hasMoreElements()) {
			addItem((String)en.nextElement());
		}

		return;
	}
}

/* Takashi Ishikawa / tishi@jaist.ac.jp */
