// Copyright (C) 1996-1997 by Haruo Yokota, 
//	Japan Advanced Inst. of Sci. and Tech.,
//	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-12, Japan.
//

/*
	communicate
	
	Com c = new Com();
	c.Communicate(host, port, script);
	$B$H$+$7$J$$$H;H$($J$$$N$GCm0U!#(B
	Com.Communicate(host, port, script);
	$B$C$F$N$O!"$G$-$J$$$>!#(B
*/

import java.awt.Graphics;
import java.awt.*;
import java.applet.Applet;
import java.net.*;
import java.lang.*;
import java.io.*;
import java.util.*;

public class Communicate implements Runnable {
	Thread	runner;
	Vector	vResult;
	String	host;
	int	port;

	// ===================================================
	public Communicate() {
		vResult = null;
	}

	// ===================================================
	public Communicate(String h, int p) {
		vResult = null;
		setServer(h, p);
		start();
	}

	// ===================================================
	public void setServer(String h, int p) {
		host = h;
		port = p;
	}

	// ===================================================
	public Vector getResult() {
		int i;

		try {
			System.out.println("waiting...");
			for(i = 0;; i++) {
				// join()$B$,$5$C$Q$j=*$o$i$J$$!"(B
				// $B$P$+(BNetscape$B$N$?$a$K%]!<%j%s%0$K$7$F$d$k!#(B
				if(runner != null) {
					runner.join(1000);
				}
				if(vResult != null) {
					System.out.println("wake! size:" + vResult.size());
					break;
				}
				if(i > 60) {	// timeout!!
					return null;
				}
			}

		} catch(InterruptedException e) {
			System.out.println("InterruptedException " + e);
			return null;
		}

		return vResult;
	}
 
	// ===================================================

	public void start() {
		if(runner == null) {
			runner = new Thread(this);
			runner.start();
		}
	}

	public void stop() {
		if(runner != null) {
			runner.stop();
			runner = null;
		}
	}

	public void run() {
		// notify();
		stop();
	}

	// ===================================================
	// Communicate routine
	//	sendVector has vector of String
	//	return Vector has also vector of String
	//
	protected Vector Main(Vector sendVector) {
		String sa[];

		sa = new String[sendVector.size()];
		sendVector.copyInto(sa);

		return Main(sa);
	}

	protected Vector Main(String sendString[]) {
		DataInputStream		dis;
		PrintStream		ps;
		Vector			returnVector = new Vector();
		int			i, max;
		String			s;

		// sendVector$B$NMWAG$,(BString$B$8$c$J$1$l$P$($i!<(B...$B$K!"$7$?$$$J$"!#(B

		// start!
		try {
			// $BAw?.MQ$H<u?.MQ$N%=%1%C%H$,JL$H$$$&!"(B
			// $B$^$C$?$/$b$C$FFf$J;EMM$G$"$k$i$7$$!#(B
			// $B$J$s$G$=$&$J$k$N(B($B5c(B)$B!#(B
			Socket sendSocket = new Socket(host, port);
			Socket recvSocket = new Socket(host, port);
			
			System.out.println(sendSocket);
			System.out.println(recvSocket);
			dis = new DataInputStream(recvSocket.getInputStream());
			ps = new PrintStream(sendSocket.getOutputStream());
			System.out.println("ps:" + ps);
			System.out.println("dis:" + dis);
/*
			try {
				runner.sleep((long)500);		// $BL5H?1~BP:v(B:500ms$BBT$C$F$_$k!#(B
			} catch(InterruptedException e) {
				System.out.println("InterruptedException " + e);
			}
*/

			max = sendString.length;
			for(i = 0; i < max; i++) {
				// send query
				s = sendString[i] + " .";	// need the space
				ps.println(s);
				System.out.println("send:" + s);
				ps.flush();

				// receive result
				s = dis.readLine();
				returnVector.addElement(s);
				if(s.length() > 40) {
					System.out.println("recv:" + s.substring(0, 40) + "...");
				} else {
					System.out.println("recv:" + s);
				}
			}

			// over!
			ps.close();
			recvSocket.close();
			sendSocket.close();
		} catch(IOException e) {
			System.out.println("IOException " + e);
			return null;
		}

		System.out.println("the session completed");

		return returnVector;
	}	// Communicate


	// ================================================================
	// parsing routine
	//	sendVector has vector of String
	//	return Vector has also vector of String
	// [["hoge",1,"hoe"],[1,3,4] ...]
	//
	// Vector$B$N(BVector$B$,!"$&$^$/$D$/$l$J$$$s$@$h$J!<!"$J$s$G$@(B?
	//
	protected Vector parseResult(String input) {
		Vector rv = new Vector();
		StreamTokenizer st = new StreamTokenizer(new StringBufferInputStream(input));

		try {
			st.slashSlashComments(false);
			st.slashStarComments(false);
			st.quoteChar('"');

			if(st.nextToken() == '[') {
				rv = parseResultMain1(st);
			} else {
				System.out.println("error at parseResult()");
				return null;
			}

			if(st.nextToken() != ']') {
				System.out.println("error at parseResult()");
				return null;
			}
		} catch(IOException e) {
			System.out.println("IOException " + e);
		}

		return rv;
	}	// parseResult

	// ["hoge",1,"hoe"],[1,3,4] ...
	private Vector parseResultMain1(StreamTokenizer st) {
		Vector rv = new Vector();
		String tuple[];
		int i;

		try {
			for(;;) {
				if(st.nextToken() == '[') {
					tuple = parseResultMain2(st);
				} else {
					System.out.println("error at parseResultMain1()");
					return null;
				}

				if(st.nextToken() != ']') {
					System.out.println("error at parseResultMain1()");
					return null;
				}
				if(tuple.length > 0) {
					rv.addElement(tuple);
				}

				i = st.nextToken();
				if(i == ']') {
					// $B$*$o$j(B
					st.pushBack();
					break;
				} else if(i != ',') {
					// $B$($i!<(B
					System.out.println("error at parseResultMain1()");
					return null;
				}
			}
		} catch(IOException e) {
			System.out.println("IOException " + e);
			return null;
		}

		return rv;
	}	// parseResultMain1

	// "hoge",1,"hoe",...
	private String[] parseResultMain2(StreamTokenizer st) {
		int c;
		String s;
		String tuple[];
		Vector rvs = new Vector();

		try {
			for(;;) {
				c = st.nextToken();
				if(c == ',') {
					// $B$D$E$-$,$"$k(B...$B$J$K$b$7$J$$(B
					;
				} else if(c == ']') {
					// $B$*$o$j(B
					st.pushBack();
					break;
				} else {
					// $B%H!<%/%s$_$?$$$M!#(B
					if(st.ttype == st.TT_NUMBER) {
						//Double.toString(st.nval);
						Double d = new Double(st.nval);
						s = Integer.toString(d.intValue());
					} else {
						s = st.sval;
					}
					rvs.addElement(s);
				}
			}
		} catch(IOException e) {
			System.out.println("IOException " + e);
			return null;
		}

		tuple = new String[rvs.size()];
		rvs.copyInto(tuple);

		return tuple;
	}	// parseResultMain2

	// =====================================================================

}	// Com

/* Takashi Ishikawa / tishi@jaist.ac.jp */

