// Copyright (C) 1996-1997 by Haruo Yokota, 
//	Japan Advanced Inst. of Sci. and Tech.,
//	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-12, Japan.
//

//
// Client Applet

import java.awt.Graphics;
import java.awt.*;
import java.applet.Applet;
import java.net.*;
import java.lang.*;
import java.io.*;
import java.util.*;

public class Client extends Applet implements Runnable {
	Thread runner;
	QueryAttributes qa;
	ScrollableTable st;
	SelectPanel sp;
	Button queryButton;
	GroupTable	groupTable;
	String host;
	int port;

	public void init() {
		String s;

		s = getParameter("server");
		if(s == null) {
			URL u = getCodeBase();
			s = u.getHost();
		}
		host = s;

		s = getParameter("port");
		if(s == null) {
			port = Const.defaultPort;
		} else {
			port = Integer.parseInt(s);
		}
		System.out.println("host=" + host + ", port=" + port);
		setLayout(new VStackLayout());
		//addNotify();
		coordinate();
		addComponents();
		System.out.println("the applet has been initialized");

	}

	public void reinit() {
		removeComponents();
		coordinate();
		addComponents();
		paintAll(getGraphics());

		// runner.resume();	// restart
	}

	public void removeComponents() {
		remove(sp);
		remove(queryButton);
		remove(st);
	}

	public void addComponents() {
		add(sp);
		add(queryButton);
		add(st);
	}

	public void coordinate() {
		Vector a = new Vector();
		while(a == null || a.size() == 0) {
			qa = new QueryAttributes(host, port);
			st = new ScrollableTable();

			groupTable = new GroupTable();
			a = qa.getResult();
			//st.setData(a);
		}
		groupTable.addGroup(a);

		sp = new SelectPanel(this, groupTable, host, port);

		queryButton = new Button(Const.queryButton);

		st.setData(new Vector());	// st.setData(a);
	}

	// ===========================================
	public void run() {
		;
	}

	// ===========================================
	public void paint() {
		paintAll(getGraphics());
	}


	// ===========================================
	// groupChoice$B$N%$%Y%s%H$r(Bhandling$B$7$F!"(BgroupPanel$B$rE=$jBX$($k!#(B
	public boolean handleEvent(Event e) {
		if(e.target == queryButton && e.id == e.ACTION_EVENT) {
			sp.query(st);
			return true;
		} else if(e.target instanceof Choice
		&& e.id == e.ACTION_EVENT) {
			doLayout();
			repaint();
			return true;
		}

		return super.handleEvent(e);
	}

	// =================================================================
	public void start() {
		if(runner == null) {
			runner = new Thread(this);
			runner.start();
		}
	}

	public void stop() {
		if(runner != null) {
			runner.stop();
			runner = null;
		}
	}
	// =================================================================
	public String getAppletInfo() {
		return Const.infoString;
	}

}	// Client



/* Takashi Ishikawa / tishi@jaist.ac.jp */

