%% User Interface for GDA-LES System Version 2
%% Copyright (C) 1997 Tokuyasu KAKUTA
%% 1997.4.30     v. 010

:-dynamic on_gda/0,comm_history/2,comm_history_count/1,comm_history_size/1,
          gda_result/1,select_pat/1,gen_rule/1,last_hypo_sort/1.
:-dynamic test_default/2.
:-op(700,fy,!).

gda_IO_version('010').

comm_history_size(20).
test_default('demo',prohibit(event3,this_park)).

gdales:-newgda(not_test).
newgda:-newgda(test).
newgda(SW):-
	(normal_inference,!;assert(normal_inference)),
	reset_comm_history,
	(on_gda,!,abolish(on_gda,0);true),
	(gda_version(GDA_Ver),!;
	 SW==test,!;
	 write('You have to compile or consult "newgda.pl" beforehand !!'),
	 nl,fail),
	gda_IO_version(IO_Ver),
	write('Welcome to GDA-LES System version '),
	write(GDA_Ver),write(-),write(IO_Ver),nl,
	write('HELP command --> help.'),nl,
	(SW==test,test_default(File,_),!,load_cl(File);true),
	repeat,
	gda_state,
	gda_prompt,
	%get_line(S),
	%parse(S,T,VL),
	read(T),
	comm(T,VL),
	put_comm_history(T),
	T==end,!,abolish(normal_inference).

comm(end,_):-!.
comm(load(F),_):-!,load_cl(F).
comm(convert(F1,F2,G),_):-!,convert(F1,F2,G),!.
comm(help,_):-!,
	nl,
	write('Command     : Function'),nl,
	write('------------:---------------------------------------------'),nl,
	write('end.        : System End'),nl,
	write('help.       : This help commnad'),nl,
	write('load(File). : Load Knowledge Base (File)'),nl,
	write('gda(GOAL).  : Begining GDA with your original goal as GOAL'),nl,
	write('GOAL.       : Inference of Normal OSL with your GOAL'),nl,
	write('on.         : Analogy mode'),nl,
	write('off.        : Normal mode'),nl,
	write('set(Num).   : Set similarity number'),nl,
	%write('convert(I,O). : Convert I as KB to O as internal file'),nl,
	write('?- GOAL.    : Call your GOAL as prolog system call'),nl,
	write('Number      : Execute the Number-th command again'),nl,
	write('!!          : Execute the previous command again'),nl,
	write('show(Name). : Show states'),nl,
	write('              Name    : State'),nl,
	write('              --------:-----------------'),nl,
	write('              sort    : sort information'),nl,
	write('              clause  : all clauses'),nl,
	write('              role    : all role restrictions'),nl,
	write('              history : command history'),nl,
	write('              sim     : similarites based on last gda'),nl,
	write('              sim(Num): one similarity based on last gda'),nl,
	nl.
comm(on,_):-!, 
	write('*** Analogy Mode ****'),nl,assert(on_gda),
	select_pat(N),
	set_hypothetical_sort(N).
comm(off,_):-!,write('*** Normal  Mode ****'),nl,abolish(on_gda,0),
	remove_hypothetical_sort.
comm(set(N),_):-!,
	(on_gda,!,(select_pat(N),!;
	           remove_hypothetical_sort,
	           abolish(select_pat,1),
	           assert(select_pat(N)),
	           set_hypothetical_sort(N));
	 abolish(select_pat,1),
	 assert(select_pat(N))).
comm(gda,_):-!,test_default(_,G),write('default goal --> '),write(G),nl,
	comm(gda(G),_).
comm(gda(G),_):-!,
	(abolish(normal_inference,0);
	 write('GDA Failed'),nl,assert(normal_inference),fail),
	main(G,Pat),
	similarity_disp(Pat),
	abolish(gda_result,1),
	abolish(select_pat,1),
	assert(gda_result(Pat)),
	assert(select_pat(1)),
	assert(normal_inference),!.
comm((?- G),_):-!,(call(G);true),!.
comm(show(N),_):-!,
	(N==sort,!,listing_sort;
	 N==clause,!,listing_clause;
	 N==role,!,listing_role;
	 N==history,!,listing_comm_history;
	 N==sim,!,listing_similarity;
	 N=sim(Num),!,listing_similarity(Num);
	 true).
comm(N, _):-number(N),!,
	(comm_history(N,T),!,
	 write('>>'),write(T),nl,put_comm_history(T),comm(T,_);
	 write('Invalid Number !!'),nl).
comm(!!,_):-
	(comm_history_count(N),N1 is N-1,comm_history(N1,T),!,
	 write('>>'),write(T),nl,put_comm_history(T),comm(T,_);
	 write('This is your first command.'),nl),!.
comm(!N,_):-
	(comm_history_count(N0),N1 is N0-N,comm_history(N1,T),!,
	 write('>>'),write(T),nl,put_comm_history(T),comm(T,_);
	 write('Invalid Number !!'),nl),!.
comm($,VL):-!,
	test_default(_,G),write('default goal --> '),write(G),nl,
	comm(G,VL).
comm(G,VL):-
	(solve(G,Hist),
	 analyze_result(G,Hist),
	 disp(G,VL),
	 more(Flag),
	 Flag==no,
	 gda_state,write('Yes'),nl;
	 gda_state,write('No'),nl),
	!.

gda_state:-on_gda,!,write('GDA: ').
gda_state:-write('gda: ').
gda_prompt:-write('> ').

more(F):-repeat,
	gda_state,write('More (y/n) ? '),
	%read(X),
	get0(C),
	char_code(X,C),
	get0(CR),
	CR==10, %%% SICStus dependent
	(X==y,!,F=yes;X==n,!,F=no),!.

%%%
char_code(y,121):-!.
char_code(y,89):-!.
char_code(n,110):-!.
char_code(n,78):-!.

listing_sort:-
	tab(7),
	write('[''IS-A Subclass of'' Relations]'),nl,
	sort_small(X,Y),tab(9),write((X=<Y)),nl,fail.
listing_sort:-
	tab(7),
	write('[''IS-An Instance of'' Relations]'),nl,
	in_sort(X,Y),tab(9),write(X),write('@'),write(Y),nl,fail.
listing_sort.

listing_clause:-
	cl(_,Type,_,H,B),
	numbervars((H,B),0,_),
	(Type==rule,write('Rule'),write(': ');Type\==rule,tab(6)),
	tab(1),write(H),
	(B==true,write(('.')),nl;B\==true,write((' :-')),nl,disp_body(B)),
	fail.
listing_clause.

%%
listing_role:-role_fil(R,F,T),tab(7),
	      write(R),write(': '),write(F),write(' -> '),write(T),nl,fail.
listing_role.

disp_body((A,B)):-!,tab(11),write(A),write((',')),nl,disp_body(B).
disp_body(A):-tab(11),write(A),write(('.')),nl.

%% History
listing_comm_history:-write('  NewGDA Command History'),nl,
	comm_history(N,Comm),tab(2),write(N),write(' : '),write(Comm),nl,fail.
listing_comm_history.

put_comm_history(T):-T\==(!!),\+T=(!_),\+number(T), !,
	comm_history_count(N),
	assertz(comm_history(N,T)),
	comm_history_size(Size),
	(N>Size,!,
	 Oldest is N-Size,
	 retract(comm_history(Oldest,_)),!;
	 true),
	up_comm_history_count.
put_comm_history(_).

up_comm_history_count:-retract(comm_history_count(N)),!,
	N1 is N+1,assert(comm_history_count(N1)).

reset_comm_history:-
	(comm_history(_,_),!,abolish(comm_history,2);true),
	(comm_history_count(_),!,abolish(comm_history_count,1);true),
	assert(comm_history_count(1)).

%% TEST Yet
analyze_result(G,VL0):-
	collect_var([G],Vs0,[]),
	compress_vars(Vs0,Vs),
	get_var_hist(Vs,VL0,VL),
	calc_meets(Vs,VL,VsL),
	%write(VL),nl,
	subst_const(VL),
	%write(VL),nl,
	%write(VsL),nl,
	short_var(VsL).

subst_const([]):-!.
subst_const([(C,C,_)|VL]):-!,subst_const(VL).
subst_const([(C:_,C,_)|VL]):-subst_const(VL).

short_var([]):-!.
short_var([(_:S,S)|L]):-!,short_var(L).
short_var([(C,S)|L]):-in_check(C,S),!,short_var(L).

%% TEST Yet
disp(G,VL):-!,write('Ans.>> '),
	%write(G),nl.
	dispG(G),nl.

dispG(V):-var(V),!,write(V).
dispG(V:S):-!,(var(V),!,write(V:S);write(V)).
dispG(A):-atomic(A),!,write(A).
dispG([F]):-!,dispG(F).
dispG([F|L]):-!,dispG(F),write((',')),dispG(L).
dispG(G):-G=..[F|L],write(F),write('('),dispG(L),write(')').
%%%

listing_similarity:-
	gda_result(L),
	listing_similarity_num(L,1).

listing_similarity_num([],_):-!.
listing_similarity_num([F|L],N):-
	write(N),write(:),
	similarity_disp1(F),   %% call newgda.pl
	N1 is N+1,
	listing_similarity_num(L,N1).

listing_similarity(Num):-
	gda_result(L),!,
	listing_similarity(L,1,Num).
listing_similarity(_):-!,write('Please try GDA at first!'),nl.

listing_similarity([],_,_):-!,write('empty or error'),nl.
listing_similarity([F|_],N,N):-!,similarity_disp1(F).  %% call newgda.pl
listing_similarity([_|L],C,N):-C1 is C+1,listing_similarity(L,C1,N).

set_hypothetical_sort(N):-
	backuped_rule(RL),  %% call newgda.pl
	retract_cl(RL),     %% call newgda.pl
	get_gda_result(N,Pat),
	assign_hypo_sort(Pat,SL),
	assert_cl(SL),      %% call newgda.pl
	generate_hypo_meet, %% call newgda.pl
	generalization(RL,SL,NewRL),
	abolish(gen_rule,1),
	assert(gen_rule(NewRL)),
	assert_cl(NewRL).   %% call newgda.pl

remove_hypothetical_sort:-
	remove_hypo_sort,
	gen_rule(RL),
	retract_cl(RL),
	backuped_rule(OrgRL),
	assert_cl(OrgRL).

get_gda_result(N,Pat):-
	gda_result(L),
	get_at(L,N,Pat).

get_at([X|_],1,X):-!.
get_at([_|L],N,X):-N1 is N-1,get_at(L,N1,X).

assign_hypo_sort(P,SL):-assign_hypo_sort(P,1,SL).

assign_hypo_sort([],Last,[]):-!,
	abolish(last_hypo_sort,1),assert(last_hypo_sort(Last)).
assign_hypo_sort([[_]|Pat],N,SL):-!,
	assign_hypo_sort(Pat,N,SL).
assign_hypo_sort([C|Pat],N,H):-
	make_hypo_sort(N,A),
	N1 is N+1,
	assign_hypo_super(C,A,H,T),
	assign_hypo_sort(Pat,N1,T).

make_hypo_sort(N,S):-name('$abs',[D,A,B,C]),name(N,L),name(S,[D,A,B,C,D|L]).

assign_hypo_super([],_,T,T):-!.
assign_hypo_super([S|L],A,[sort_small(S,A)|H],T):-assign_hypo_super(L,A,H,T).

generalization([],_,[]):-!.
generalization([R|RL],SL,[NewR|NewRL]):-
	generalization1(R,NewR,SL),
	generalization(RL,SL,NewRL).

generalization1(V,V1,_):-var(V),!,V1=V.
generalization1(A,A1,_):-atomic(A),!,A1=A.
generalization1(X:S,X:A,SL):-!,(mem(sort_small(S,A),SL),!;A=S).
generalization1([F|L],[F1|L1],SL):-!,
	generalization1(F,F1,SL),generalization1(L,L1,SL).
generalization1(G,G1,SL):-
	G=..[F|L],generalization1(L,L1,SL),G1=..[F|L1].

remove_hypo_sort:-
	last_hypo_sort(N),
	remove_hypo_sort(N),
	generate_hypo_meet.  %% call newgda.pl

remove_hypo_sort(0):-!.
remove_hypo_sort(N):-make_hypo_sort(N,A),retract(sort_small(_,A)),fail.
remove_hypo_sort(N):-N1 is N-1,remove_hypo_sort(N1).

