/* =====================================================
 * Japanese Probabilistic Dependency Analyzer
 * (Tree writer)
 * Computation Linguistics Laboratory
 * Nara Institute of Science and Technology
 * Copyright (C) 1997 Masakazu Fujio and Yuji Matsumoto
 * ===================================================== */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BUNSETSU_MAX  100
#define TRUE 1

char bun[BUNSETSU_MAX][BUFSIZ];
/*char calc[BUNSETSU_MAX][BUFSIZ];*/
char calc[BUFSIZ][BUFSIZ];
int dep_to[BUNSETSU_MAX];
int segment = 1, verbos = 0;

int saiki(int n, char *sp, int m)
{
  int i,j,fl;
  char ind[100], tmp[100], *p, *q;
  
  strcpy(ind,sp);
  printf("%2d %s%s\n", n, sp, bun[n]);
  
  for (i=n-1; i>=0; i--) {
    if (dep_to[i] == n) {
      for (fl=0, j=i-1; j>=0; j--) {
	if (dep_to[j] == m) {
	  fl=1; break;
	}
      }
      ind[strlen(ind)-2] = '\0';
      if (fl == 0){
	strcat(ind,"  ");
      } else {
	strcat(ind,"");
      }
      for (fl=0, j=i-1; j>=0; j--) {
	if (dep_to[j] == n) {
	  fl=1; break;
	}
      }
      if (fl==0){
	strcpy(ind+strlen(ind)-2, "");
      }
      saiki(i, ind, n);
      ind[strlen(ind)-2] = '\0';
    }
  }
}

usage()
{
  fprintf(stderr,"ki_edr : ki wo dasu.  ver 0.90 By Hirachan\n");
  fprintf(stderr,"USAGE: ki  \n");
  fprintf(stderr,"       -s : segmentation\n");
  fprintf(stderr,"       -v : verbos \n");
  exit(1);
}

void opt_chk(char *p)
{
  switch(*p){
  case 's':
    segment = TRUE; break;
  case 'v':
    verbos = TRUE; break;
  default:
    fprintf(stderr, "ki_edr: invalid option -- %c\n", *p);
    usage();
  }
}

main(int argc, char **argv)
{
  FILE *fr=NULL;
  double z;
  int i, j, x, y, n, line_id = 0;
  char in[BUFSIZ], *p, *s, *op;
  
  while(--argc) {
    if (*argv[argc]=='-') {
      opt_chk(argv[argc]+1);
    } else {
      if ((fr = fopen(argv[argc], "r")) == NULL) {
	printf("Can't open file '%s'\n",argv[argc]);
	exit(1);
      }
    }
  }
  if (fr==NULL) {
    fr=stdin;
  }

  while (!feof(fr)) {
    line_id++;
    for (i=0; fgets(s=in, BUFSIZ, fr), (strncmp(in, "EOS", 3)&&!feof(fr)); i++) {
      if (segment) {
	for (p=bun[i]; *s!=':';*s++) {
	  while (*s!='/') *p++=*s++;
	  while (*s!=' ') { if (*s==':') break; *s++; }
	}
	*p='\0';
      } else {
	for (p=bun[i]; *s!=':'; *p++=*s++)
	  ;
	*p='\0';
      }
    }
    n = i - 1;
    if (feof(fr)) break;
    while (fgets(in, 256, fr), (strncmp(in, "EOK", 3)&&!feof(fr))) {
      sscanf(in,"%d %d", &x, &y);
      dep_to[x]=y;
    }
    if (verbos) {
      i = 0; 
      while (fgets(calc[i], BUFSIZ, fr), (strncmp(calc[i++], "EOB", 3)&&!feof(fr))) {
	;
      }
      calc[i][0] = 0;
    }
    if (feof(fr)) break;
    
    saiki(n, "", n+1);
    if (verbos) {
      for (j=0; j<i; j++) {
	printf("%s", calc[j]);
      }
    }
    puts("\n");
  }
  fclose(fr);
}
