/* =====================================================
 * Japanese Probabilistic Dependency Analyzer
 * (Best parse finder)
 * Computation Linguistics Laboratory
 * Nara Institute of Science and Technology
 * Copyright (C) 1997 Masakazu Fujio and Yuji Matsumoto
 * ===================================================== */

#include <stdio.h>         
#include <stdlib.h>

#define BUNSETSU_MAX    100
#define TRUE   1
#define FAULSE 0

double stat[BUNSETSU_MAX][BUNSETSU_MAX];
char calc[BUNSETSU_MAX][BUNSETSU_MAX][256];
int mode=1, debug=0, eos=0, verbos=0;

void cyk(int bmx)  /* cyk Ȥä Ŭѥõ*/
{
  int bid, haba, haba_l, l, j, ds_to[BUNSETSU_MAX];
  int ds[BUNSETSU_MAX][BUNSETSU_MAX][BUNSETSU_MAX]; /* CYKƥ֥åΰ¸¤ */
  double p[BUNSETSU_MAX][BUNSETSU_MAX], atai, max;  /* CYKƥ֥åγΨ */
    
  for (haba=0; haba<bmx; haba++) {
    for (bid=0; bid<bmx; bid++) {
      p[bid][haba] = 0;
      for (haba_l=0; haba_l<bmx; haba_l++) {
	ds[bid][haba][haba_l] = 0;
      }
    }
  }
  for (bid=0; bid<bmx; bid++) {
    p[bid][0]=1;
  }
  
  for (haba=1; haba<bmx; haba++) {
    for (bid=0; bid<bmx-haba; bid++) {
      for (max=0, haba_l=0; haba_l<haba; haba_l++) {
	atai=p[bid][haba_l]*p[bid+haba_l+1][haba-haba_l-1]*stat[bid+haba_l][bid+haba];
	if (atai>max) {
	  max=atai;
	  for (l=0; l<bid+haba; l++) { 
	    if (bid+haba_l>l) {
 	      ds_to[l]=ds[bid][haba_l][l];
	    } else {
 	      ds_to[l]=ds[bid+haba_l+1][haba-haba_l-1][l];
	    }
	  }
	  ds_to[bid+haba_l]=bid+haba;
	}
/* 	if (debug) { */
/* 	  printf ("*bid%d, haba%d, haba_l%d, %f*", bid, haba, haba_l, atai); */
/* 	  for (l=0;l<bmx;l++){ */
/* 	    printf("%d ",ds_to[l]); */
/* 	  } */
/* 	  printf("\n");  */
/* 	}  */
      }
      p[bid][haba]=max;
      for (l=0; l<bid+haba; l++) {
	ds[bid][haba][l]=ds_to[l];
      }
    }
  }
  
/*   if(debug){ */
/*     for (haba=bmx-1; haba>=0; haba--) { */
/*       printf ("%e %e %e %e %e %e %e\n",p[0][haba],p[1][haba],p[2][haba],p[3][haba],p[4][haba],p[5][haba],p[6][haba]); */
/*     } */
  /*   }    debug cyk ɽ*/
  
  for (bid=0; bid<bmx-1; bid++) {
    if (stat[bid][ds[0][bmx-1][bid]]!=0) {
      printf("%d %d %e\n", bid, ds[0][bmx-1][bid], stat[bid][ds[0][bmx-1][bid]]);
    }
  }
  if (!eos) puts("EOK");

  if (debug) {
    for (bid=0; bid<bmx; bid++) {
      for (j=bid+1; j<bmx; j++) {
	if (stat[bid][j]!=0) printf("%d %d %e %s", bid, j, stat[bid][j], calc[bid][j]);
      }
    }
    puts("EOB");
  }
}

help()
{
  fprintf(stderr,"saiteki: Saiteki path wo motomerunoda.. ver 0.03 By Hirachan\n");
  fprintf(stderr,"USAGE: saiteki [-option] [data_file]\n");
  fprintf(stderr,"       -h : this help\n");
  exit(1);
}

void opt_chk(char *p)
{
  switch(*p){
  case '1':
    mode=1; break;
  case '2':
    mode=2; break;
  case '3':
    mode=3; break;
  case 'd':
    debug=TRUE; break;
  case 'v':
    verbos=TRUE; break;
  case 'e':
    eos=TRUE; break;
    
  default:
    help();
  }
}


main(int argc, char **argv) /* ᥤʤΤ */
{
  int i,j,k, id, sen_no=0;
  FILE *fr=NULL;
  char s[BUFSIZ];
  char bunsetu[100][BUFSIZ];
  double p;
  
  while(--argc) {
    if (*argv[argc]=='-') {
      opt_chk(argv[argc]+1);
    } else {
      if ((fr = fopen(argv[argc], "r")) == NULL){
	printf("Can't open file '%s'\n",argv[argc]);
	exit(1);
      }
    }
  }
  if (fr==NULL) {
    fr=stdin;
  }

  sen_no=0;
  while(!feof(fr)) {
    sen_no++;
    for (i=0;i<BUNSETSU_MAX;i++) { /* ݽ*/
      for(j=0;j<BUNSETSU_MAX;j++) {
	stat[i][j]=0;
	calc[i][j][0]=0;
      }
    }
    for (k=0;fgets(s,256,fr),(!strstr(s,"EOS")&&!feof(fr));) {
      if (verbos) printf("%s", s);
      /*	  strcpy(s, bunsetu[k]);*/
    }
    if (verbos) puts("EOS");
    
    for (k=0; fgets(s,256,fr), (!strstr(s,"EOK") && !feof(fr));) {
      sscanf(s, "%d %d %lf %n", &i, &j, &p, &id);
      strcpy(calc[i][j], s+id);
      k= (j>k) ? j : k;
      if (j<=0) {
	fprintf(stderr, "áޥʥ褿(^^;; ɤʤ硣%dܤʸ䡣0Τ\n", sen_no);
	exit(1);
      }
      stat[i][j]=p;
    }
    
    if (k==0) break;
    
    switch (mode){
    case 1:
      cyk(k+1); break;
    case 2:
      cyk(k+1); break;
    case 3:
      cyk(k+1); break;
    }
/*    if (!eos) puts("EOK");*/
  }
  close (fr);
  return 0;
}
