/*********************************************************************/
/*								     */
/* parser_interface.pl 						     */
/*								     */
/* Copyright (C) 1997 Thanaruk Theeramunkong (ping@jaist.ac.jp)      */ 
/*                    Manabu Okumura         (oku@jaist.ac.jp)       */
/*                    Susumu Kunifuji        (kuni@jaist.ac.jp)      */
/*                    Hiroki Imai            (imai@cs.titech.ac.jp)  */
/*								     */
/*					     	9 May 1997	     */
/*								     */
/*								     */
/*********************************************************************/

:- unknown(_,fail).
:- dynamic wait/0.
:- dynamic use_dictionary/0.

start:-
	write('*******************************'),nl,
	write('*  Welcome to R-LRPar system  *'),nl,
	write('*                1.0 version  *'),nl,
	write('*******************************'),nl,
        write('Do you want to indicate the filename of the sentences ? (y/n)'),nl,
        write('(Default is sent_file.re)'),nl,
	abolish(input_sentence),
        read(Answer),
	( (Answer = 'y' ; Answer = 'Y') ->
	   write('Please input the filename of sentences you would like to analyse'),nl,
           read(SFileName);
           SFileName = 'sent_file.re' ),
	consult(SFileName),
	getcommand(i).

getcommand(q) :- !.
getcommand(_) :-
	format("~nCommand (h: help) > ",[]),
	read(Command),
	interpret(Command),
	getcommand(Command).

interpret(q) :- !.
interpret(h) :-
	format("~n",[]),
	format("  h      - help~n",[]),
	format("  c      - change sentence set~n",[]),
	format("  d(N)   - display result~n",[]),
	format("  l      - list sentences~n",[]),
	format("  l(N,M) - list Nth-Mth sentences~n",[]),
	format("  N      - Using Nth sentence~n",[]),
	format("  q      - quit~n~n",[]).
interpret(d) :-
	write('The result of which sentences you want to display ? '), nl,
	write('Please indicate by d(N)'), nl,
	write('If N = *, see the results of all analysed sentence'), nl.
interpret(d(*)) :-
	bagof([A,Num,Tree],result(A,Num,Tree),List),
	write_result1(List).
write_result1([]) :- !.
write_result1([[A,Num,_Tree]|Rest]) :-
	write('Sentence No. '), write(A),
	write(' has '), write(Num),
	write(' tree(s).'), nl,
	input_sentence(A,Sentence),
	write('--> '), write(Sentence), nl,
	write_result1(Rest).
interpret(d(N)) :-
	result(N,Num,Tree),
	write('Sentence No. '), write(N),
	write(' has '), write(Num),
	write(' tree(s).'),
	nl, nl, write_list(1,Tree), nl, nl,
	true, !.

interpret(c) :-
	write('Input filename of the sentence set (c=cancel)> '),
	read(SentSet),
	( SentSet = 'c' -> true;
	                  abolish(input_sentence),
			  abolish(result/3),
		          consult(SentSet) ).
	
interpret(l) :-
	bagof([N,S],input_sentence(N,S),LSen),
	list_sentence(LSen).
interpret(l(Min,Max)) :-
	bagof([N,S],(input_sentence(N,S),Min=<N,N=<Max),LSen),
	list_sentence(LSen).

interpret(A) :-
	input_sentence(A,SenLen),
	getsent(SenLen,Sentence),
	assert_null(Sentence,Sentence1),
	parser(Sentence1,Tree1,Tree2,NTime,ITime),
	( Tree1 == [] -> 
	    write('it is an ill-formed sentence'),nl;
	    write('it is a well-formed sentence'),nl ),
	count_lst(Tree2,0,TreeNo),
	write('The Number of Trees is '), write(TreeNo), nl,
	write('Calculation Time for normal phrase: '),
	write(NTime), write(' (ms)'), nl,
	write('Calculation Time for ill-formed phrase: '),
	write(ITime), write(' (ms)'), nl,
	( result(A,_TreeNo,_Tree2) ->  true ;
	    assert(result(A,TreeNo,Tree2)) ),
%	nl, nl, write_list(1,Tree2), nl, nl, !,
	true.

getsent([],[]) :- !.
getsent([[W,C]|SenLen],[[W,C]|Sentence]) :-
	getsent(SenLen,Sentence).

list_sentence([]) :- !.
list_sentence([[N,S]|LSen]) :-
	format("~p: ",[N]),
	list_a_sentence(S),
	format("~n",[]),
	list_sentence(LSen).

list_a_sentence([]) :- !.
list_a_sentence([[W,C]|S]) :-
	format("~p(~p) ",[W,C]),
	list_a_sentence(S).

assert_null([],OSentence) :- !,OSentence=[[null,null]].
assert_null([S|Sentence],OSentence) :-
	OSentence=[S|Sentence1],
	assert_null(Sentence,Sentence1).

