/*********************************************************************/
/*								     */
/* parser.pl 							     */
/*								     */
/* Copyright (C) 1997 Thanaruk Theeramunkong (ping@jaist.ac.jp)      */ 
/*                    Manabu Okumura         (oku@jaist.ac.jp)       */
/*                    Susumu Kunifuji        (kuni@jaist.ac.jp)      */
/*                    Hiroki Imai            (imai@cs.titech.ac.jp)  */
/*								     */
/*					     	9 May 1997	     */
/*								     */
/*								     */
/*********************************************************************/

%
% LR Parser
%
% $Header: /home/fs017/ping/work/project/icot/ICOT_FREE_SOFTWARE/LR_prolog/new/depthfirst/RCS/parser.pl,v 1.3 1997/02/12 11:57:39 ping Exp ping $
% $Log: parser.pl,v $
% Revision 1.3  1997/02/12 11:57:39  ping
% Complete Beta Version.
%
% Revision 1.2  1997/02/06 05:48:22  ping
% Add header
%
% $Id: parser.pl,v 1.3 1997/02/12 11:57:39 ping Exp ping $
%

parser(Input) :-
	abolish(sysmode,1),
	assert(sysmode(depthfirst)),
%	assert(sysmode(breathfirst)),
	write('input : '), write(Input),nl,nl,
	preprocess_input(0,Input,Input1,IStkLst,Length),!,
	IStkLst1 = [Input1:[[0]]|IStkLst],
	time(parser(Input1,[[0]],IStkLst1,OStkLst,[],OCTree1),Time1),!,
	time(illformed_process(OCTree1,0,OStkLst,OCTree,Length),Time2),
%	write_list(1,OCTree), nl, nl,
%	write('The following are the stack for each position.'), nl,
%	write_stack(1,OStkLst),
	count_lst(OCTree,0,TreeNo),
	( OCTree1 == [] -> 
	    write('it is an ill-formed sentence'),nl;
	    write('it is a well-formed sentence'),nl ),
	write('The Number of Trees is '),write(TreeNo),nl,
	write('Calculation Time for normal phrase: '),write(Time1),nl,
	write('Calculation Time for ill-formed phrase: '),write(Time2),nl,
	nl, nl, write_list(1,OCTree), nl, nl,
	true.

parser(Input,OCTree1,OCTree,NTime,ITime) :-
	abolish(sysmode,1),
	assert(sysmode(depthfirst)),
%	assert(sysmode(breathfirst)),
	write('input : '), write(Input),nl,nl,
	preprocess_input(0,Input,Input1,IStkLst,Length),!,
	IStkLst1 = [Input1:[[0]]|IStkLst],
	time(parser(Input1,[[0]],IStkLst1,OStkLst,[],OCTree1),NTime),!,
	time(illformed_process(OCTree1,0,OStkLst,OCTree,Length),ITime),
%	count_lst(OCTree,0,TreeNo),
%	( OCTree1 == [] -> 
%	    write('it is an ill-formed sentence'),nl;
%	    write('it is a well-formed sentence'),nl ),
%	write('The Number of Trees is '),write(TreeNo),nl,
%	write('Calculation Time for normal phrase: '),write(NTime),nl,
%	write('Calculation Time for ill-formed phrase: '),write(ITime),nl,
%	nl, nl, write_list(1,OCTree), nl, nl,!,
	true.

parser(Input,IStack,IStkLst,OStkLst,ICTree,OCTree) :-
	input(Input,IStack,IStkLst,OStkLst,ICTree,OCTree).

illformed_process([],From,StkLst,OCTree,Length) :-
	!,detect_error_point(0,EPos,StkLst),
	getstklst(0,From,StkLst,TStkLst),!,
	illformed_process1(From,EPos,TStkLst,StkLst,OStkLst,[],OCTree1),
	( (OCTree1 == [], Length \== EPos) ->
	  illformed_process([],EPos,OStkLst,OCTree,Length);
	  OCTree = OCTree1 ).
illformed_process(ICTree,_From,_StkLst,OCTree,_Length) :- 
	OCTree = ICTree.

illformed_process1(From,From,_StkLst,IStkLst,OStkLst,ICTree,OCTree) :- 
	!, OStkLst = IStkLst,
	OCTree  = ICTree.
illformed_process1(From,To,[S|StkLst],IStkLst,OStkLst,ICTree,OCTree) :-
	From1 is From+1,
	illformed_process2(S,IStkLst,IStkLst1,ICTree,ICTree1),
	illformed_process1(From1,To,StkLst,IStkLst1,OStkLst,ICTree1,OCTree).

illformed_process2(S,IStkLst,OStkLst,ICTree,OCTree) :-
	addword_process(S,IStkLst,IStkLst1,ICTree,ICTree1),
	delword_process(S,IStkLst1,IStkLst2,ICTree1,ICTree2),
	subword_process(S,IStkLst2,IStkLst3,ICTree2,ICTree3),
%	IStkLst4 = IStkLst3, ICTree4 = ICTree3,
	addcagy_process(S,IStkLst3,IStkLst4,ICTree3,ICTree4),
	delcagy_process(S,IStkLst4,OStkLst,ICTree4,OCTree),
%	OStkLst = IStkLst3, OCTree  = ICTree3,
	true.

% If Input is the last item --> [Length]:[], ignore it.
%detect_error_point(N,EPos,[_Input:[]]) :-
%	!,EPos is N-1.
detect_error_point(N,EPos,[_Input:[]|_StkLst]) :-
	!,EPos = N.
detect_error_point(N,EPos,[_Input:_Stk|StkLst]) :-
	N1 is N+1,
	detect_error_point(N1,EPos,StkLst).

% reduce clause

reduce(N,Rule,Stack,NStack) :-
	reduce(N,Rule,Stack,[],NStack).

reduce(0,Rule,List,IList,OList) :- 
	!,delete_number(IList,IList1,0,Score),
	transfer(List,List1),
	re(Rule,IList1:Score,List1,OList).
reduce(N,Rule,[S,T|List],IList,OList) :-
	integer(S),!,
	N1 is N-1,
	TList = [T,S|IList],
	reduce(N1,Rule,List,TList,OList).
reduce(N,Rule,List,IList,OList) :-
	reduce_list(N,Rule,List,IList,OList).

reduce_list(_N,_Rule,[],_IList,[]) :- !.
reduce_list(N,Rule,[L|List],IList,OList) :-
	reduce(N,Rule,L,IList,TList),
	reduce_list(N,Rule,List,IList,TList1),
	append(TList,TList1,OList).

%transfer([L],List1) :-
%	list(L),!,
%	List1 = L.
transfer([L|List],List1) :-
	list(L),!,
	List1 = [L|List].
transfer(List,[List]) :- !.

%transfer2([L],List1) :-
%	list(L),!,
%	List1 = L.
%transfer2(List,List) :- !.

delete_number([],OList,IN,ON) :- !, OList  = [], ON is IN.
delete_number([I|IList],OList,IN,ON) :-
	integer(I),!,
	delete_number(IList,OList,IN,ON).
delete_number([[Cat,Tree:Score]|IList],OList,IN,ON) :-
	OList = [[Cat,Tree:Score]|TList],
	IN1 is IN+Score,
	delete_number(IList,TList,IN1,ON).

preprocess_input(N,[],Input1,IStkLst,Length) :- 
	!,Input1 = [N], IStkLst = [], Length is N-1.
preprocess_input(N,[[Cat,Word]|Input],Input1,IStkLst,Length) :-
	N1 is N+1,
	Input1 = [N,[Cat,Word:0]|Input2],
	preprocess_input(N1,Input,Input2,IStkLst1,Length),
	IStkLst = [Input2:[]|IStkLst1],!.

insert_stack(0,Stk,[Input:PStks|ISL],OSL) :-
	!, append(Stk,PStks,PStks1),
	OSL    = [Input:PStks1|ISL].
insert_stack(N,Stk,[I|ISL],OSL) :-
	N1 is N-1,
	OSL = [I|OSL1],
	insert_stack(N1,Stk,ISL,OSL1).


write_stack(_N,[]) :- !.
write_stack(N,[Input:Stack|OStkLst]) :- 
	write(N), write('\t: '), write(Input),
	write('\n\t  '), write(Stack), nl, nl,
	N1 is N+1,
	write_stack(N1,OStkLst).

getstklst(N,N,IStkLst,OStkLst) :-
	!, OStkLst = IStkLst.
getstklst(N,N2,[_I|IStkLst],OStkLst) :-
	N1 is N+1,
	getstklst(N1,N2,IStkLst,OStkLst).


find_depth_width_top(Tree,Depth,OWidth) :-
	find_depth_width_top(Tree,Depth,0,OWidth).

find_depth_width_top([_Cat,T:_L],Depth,IWidth,OWidth) :-
	find_depth_width(T,Depth1,IWidth,OWidth),
	Depth is Depth1+1.

find_depth_width([],Depth,IWidth,OWidth) :- 
	!, Depth = 1000, OWidth = IWidth.
find_depth_width([T|Tree],Depth,IWidth,OWidth) :-
	!,find_depth_width_top(T,Depth1,IWidth,IWidth1),
	find_depth_width(Tree,Depth2,IWidth1,OWidth),
	find_min(Depth1,Depth2,Depth).
find_depth_width(_T,Depth,IWidth,OWidth) :- 
	Depth = 0, OWidth is IWidth+1.

find_min(N1,N2,N)  :- N1 > N2, !, N = N2.
find_min(N1,_N2,N) :- N = N1.



merge_stack([],OList) :- !,OList = [].
merge_stack([L|List],OList) :-
	merge_stack0(L,List,[],OList).

merge_stack0(I,[],TList,OList) :-
	!,OList = [I|OList1],
	merge_stack(TList,OList1).
merge_stack0([S,C|Rest],[[S,C|Rest1]|List],TList,OList) :-
	!,
	transfer(Rest,Rest2),
	transfer(Rest1,Rest3),
	merge_rest(Rest2,Rest3,ORest),
	merge_stack0([S,C,ORest],List,TList,OList).
merge_stack0(I,[L|List],TList,OList) :-
	TList1 = [L|TList],
	merge_stack0(I,List,TList1,OList).

merge_rest([R|Rest],[R1|Rest1],ORest) :-
	list(R),list(R1),!,
	append([R|Rest],[R1|Rest1],ORest).
merge_rest([R|Rest],Rest1,ORest) :-
	list(R),!,
	append([R|Rest],[Rest1],ORest).
merge_rest(Rest,[R1|Rest1],ORest) :-
	list(R1),!,
	append([Rest],[R1|Rest1],ORest).
merge_rest(Rest,Rest1,ORest) :-
	append([Rest],[Rest1],ORest).


% Measure Calculation Time.

time(Goal,Time) :- !,
    statistics(runtime,[_,Start]),
    call(Goal),
    statistics(runtime,[_,Finish]),
    Time is Finish - Start.

count_lst([],N,N) :- !.
count_lst([_L|List],N1,N) :-
	N2 is N1+1,
	count_lst(List,N2,N).
