/*********************************************************************/
/*								     */
/* error_handle.pl 						     */
/*								     */
/* Copyright (C) 1997 Thanaruk Theeramunkong (ping@jaist.ac.jp)      */ 
/*                    Manabu Okumura         (oku@jaist.ac.jp)       */
/*                    Susumu Kunifuji        (kuni@jaist.ac.jp)      */
/*                    Hiroki Imai            (imai@cs.titech.ac.jp)  */
/*								     */
/*					     	9 May 1997	     */
/*								     */
/*								     */
/*********************************************************************/

%
% Error Handling Process
%
% $Header: /home/fs017/ping/work/project/icot/ICOT_FREE_SOFTWARE/LR_prolog/new/depthfirst/RCS/error_handle.pl,v 1.1 1997/02/12 11:57:58 ping Exp $
% $Log: error_handle.pl,v $
% Revision 1.1  1997/02/12 11:57:58  ping
% Initial revision
%
%
%
% $Id: error_handle.pl,v 1.1 1997/02/12 11:57:58 ping Exp $

addword_process(S,IStkLst,OStkLst,ICTree,OCTree) :-
	S = [_Pos,[I,W:Score]|Input]:Stack,
	insert_word(I,Score,W,Input,Input1,Stack,Stack1),
	input(Input1,Stack1,IStkLst,OStkLst,ICTree,OCTree).

insert_word(_I,_Score,_W,[Pos],Input1,_Stack,Stack1) :-
	!, Input1 = [Pos], Stack1 = [].
insert_word(I,Score,W,[Pos,[Cat,null:N]|Input],Input1,Stack,Stack1) :-
	!,insert_word_stack(I,Score,W,Stack,Stack1),
	Input1 = [Pos,[Cat,null:N]|Input].
insert_word(I,Score,W,[Pos,[Cat,Word:N]|Input],Input1,Stack,Stack1) :-
	Word1 = Word-addword(I,W),
	N1 is Score+N+1,
	Input1 = [Pos,[Cat,Word1:N1]|Input],
	Stack1 = Stack.

insert_word_stack(_I,_Score,_W,[],Stack1) :- !, Stack1 = [].
insert_word_stack(I,Score,W,[[S,[Cat,Word:N]|Rest]|Stack],Stack1) :-
	Word1  = Word-addword(I,W),
	N1 is Score+N+1,
	Stack1 = [[S,[Cat,Word1:N1]|Rest]|Stack2],
	insert_word_stack(I,Score,W,Stack,Stack2).

delword_process(S,IStkLst,OStkLst,ICTree,OCTree) :-
	S = Input:Stack,
	is_term(Term),
	delword_process0(Term,Input,Stack,IStkLst,OStkLst,ICTree,OCTree).

delword_process0([],_Input,_Stack,IStkLst,OStkLst,ICTree,OCTree) :-
	!,OStkLst = IStkLst,
	OCTree  = ICTree.
delword_process0([T|Term],Input,Stack,IStkLst,OStkLst,ICTree,OCTree) :-
	input([*,[T,delword:1]|Input],Stack,IStkLst,IStkLst1,ICTree,ICTree1),
	delword_process0(Term,Input,Stack,IStkLst1,OStkLst,ICTree1,OCTree).

subword_process(S,IStkLst,OStkLst,ICTree,OCTree) :-
	S = [Pos,[I,W:Score]|Input]:Stack,
	is_term(Term),
	del_element(I,Term,Term1),
	subword_process0(Term1,[Pos,[I,W:Score]|Input],Stack,IStkLst,OStkLst,ICTree,OCTree).
	
subword_process0(_Term,[_Pos],_Stack,IStkLst,OStkLst,ICTree,OCTree) :-
	!, OStkLst = IStkLst, OCTree  = ICTree.
subword_process0([],_Input,_Stack,IStkLst,OStkLst,ICTree,OCTree) :-
	!, OStkLst = IStkLst, OCTree  = ICTree.
subword_process0([T|Term],Input,Stack,IStkLst,OStkLst,ICTree,OCTree) :-
	Input  = [Pos,[I,Word:Score]|Input1],
	Score1 is Score+1,
	Input2 = [Pos,[T,subword(I,Word):Score1]|Input1],
	input(Input2,Stack,IStkLst,IStkLst1,ICTree,ICTree1),
	subword_process0(Term,Input,Stack,IStkLst1,OStkLst,ICTree1,OCTree).

addcagy_process(S,IStkLst,OStkLst,ICTree,OCTree) :- 
	S = Input:Stack,
	find_reduce(Stack,[],OStack),
	insert_cat(Input,Input1,OStack,OStack1),
	addcagy_process1(Input1,OStack1,IStkLst,OStkLst,ICTree,OCTree).

addcagy_process1([],[],IStkLst,OStkLst,ICTree,OCTree) :-
	!,OStkLst=IStkLst, OCTree=ICTree.
addcagy_process1([I|Input1],[O|OStack],IStkLst,OStkLst,ICTree,OCTree) :-
	input(I,[O],IStkLst,IStkLst1,ICTree,ICTree1),
	addcagy_process1(Input1,OStack,IStkLst1,OStkLst,ICTree1,OCTree).

find_reduce([],IStack,OStack) :- !,OStack = IStack.
find_reduce([[S|I]|Stack],IStack,OStack) :-
	reduce(S,Reduces),
	make_reduce(Reduces,[S|I],IStack,IStack1),
	find_reduce(Stack,IStack1,OStack).

make_reduce([],_S,IStack,OStack) :- !,OStack = IStack.
make_reduce([(Rule,N)|Reduces],S,IStack,OStack) :-
	reduce(N,Rule,S,OS),
	append(OS,IStack,IStack1),
	find_reduce(OS,IStack1,IStack2),
	make_reduce(Reduces,S,IStack2,OStack).

insert_cat(_Input,Input1,[],OStack) :- 
	!, Input1 = [], OStack = [].
insert_cat(Input,Input1,[S|Stack],OStack) :-
	insert_cat1(Input,I,S,O),
	Input1 = [I|Input2],
	OStack = [O|OStack1],
	insert_cat(Input,Input2,Stack,OStack1).

insert_cat1([Pos],Input1,_Stack,Stack1) :-
	!, Input1 = [Pos], Stack1 = [].
insert_cat1([Pos,[Cat,null:N]|Input],Input1,[_S,Tree|Stack],Stack1) :-
	!, Input1 = [Pos,[Cat,null:N]|Input],
	transfer(Stack,TStack),
	insert_cat_stack(Tree,TStack,Stack1).
insert_cat1([Pos,[Cat,Word:N]|Input],Input1,[_S,[Cat1,PTree:A]|Stack],Stack1) :-
	find_depth_width_top([Cat1,PTree:A],Depth,Width),
	Area is Depth*Width,
	Word1 = Word-addcat(Cat1,PTree),
	N1 is N+Area,
	Input1 = [Pos,[Cat,Word1:N1]|Input],
	Stack1 = Stack.

insert_cat_stack(_Tree,[],Stack1) :- !, Stack1 = [].
insert_cat_stack(Tree,[[S,[Cat,Word:N]|Rest]|Stack],Stack1) :-
	Tree = [Cat1,PTree:_],
	find_depth_width_top(Tree,Depth,Width),
	Area is Depth*Width,
	Word1  = Word-addcat(Cat1,PTree),
	N1 is N+Area,
	Stack1 = [[S,[Cat,Word1:N1]|Rest]|Stack2],
	insert_cat_stack(Tree,Stack,Stack2).

delcagy_process(S,IStkLst,OStkLst,ICTree,OCTree) :-
	S = Input:Stack,
	is_non_term(NonTerm),
	delcagy_process0(NonTerm,Input,Stack,IStkLst,OStkLst,ICTree,OCTree).

delcagy_process0([],_Input,_Stack,IStkLst,OStkLst,ICTree,OCTree) :-
	!, OStkLst = IStkLst,
	OCTree  = ICTree.
delcagy_process0([N|NonTerm],Input,Stack,IStkLst,OStkLst,ICTree,OCTree) :-
	depth(N,Depth), width(N,Width),
	Area is Depth*Width,
	input([*,[N,delcat:Area]|Input],Stack,IStkLst,IStkLst1,ICTree,ICTree1),
	delcagy_process0(NonTerm,Input,Stack,IStkLst1,OStkLst,ICTree1,OCTree).

del_element(_I,[],Term) :- !, Term = [].
del_element(I,[I|Term],Term1) :- !, Term1 = Term.
del_element(I,[T|Term],Term1) :- 
	Term1 = [T|Term2],
	del_element(I,Term,Term2).
