/*********************************************************************/
/*								     */
/* maketable.pl 						     */
/*								     */
/* Copyright (C) 1997 Thanaruk Theeramunkong (ping@jaist.ac.jp)      */ 
/*                    Manabu Okumura         (oku@jaist.ac.jp)       */
/*                    Susumu Kunifuji        (kuni@jaist.ac.jp)      */
/*                    Hiroki Imai            (imai@cs.titech.ac.jp)  */
/*								     */
/*					     	9 May 1997	     */
/*								     */
/*								     */
/*********************************************************************/

%
% LR Table Constructor
%
%

maketable(CFGFile,GFile,TableFile,StartSym) :-
	preprocess(CFGFile,GFile),
	list_expand([([StartSym],[null],0)],Expand,[],ExR0),
	StateL  =  [([([StartSym],[null],0)],0)|RestSL],
	tell(TableFile),!,
	maketable0([(0,Expand)],1,_,StateL,RestSL,[],ExR0,_ExR1),
%	printstate(StateL),nl,nl,
%	printstate(ExR1),
	told.

printstate([]) :- !.
printstate([S|StateL]) :-
	write(S),nl,printstate(StateL).
	
maketable0([],State_number,State_number,_StateL,RestSL,RestSL,ExR0,ExR0):- !.
maketable0([(State_number,Expands)|Rest],
           State_number0,New_state_number,StateL,RestSL,RestSLO,ExR0,ExR1):-
        maketable1(State_number,Expands,
                   State_number0,State_number1,New_states,
		   StateL,RestSL,RestSL1,ExR0,ExR2),!,
        maketable0(Rest,State_number1,State_number2,
	           StateL,RestSL1,RestSL2,ExR2,ExR3),!,
        maketable0(New_states,State_number2,New_state_number,
	           StateL,RestSL2,RestSLO,ExR3,ExR1).

maketable1(_,[],End_state_number,End_state_number,[],
	                           _StateL,RestSL,RestSL,ExR0,ExR0):- !.
% reduce
maketable1(State_number,
	   [([],Lookahead,Rule_number)|Tail],State_number0,State_number1,
	   New_states,StateL,RestSL,RestSL1,ExR0,ExR1):-!,
        First_symbols = Lookahead,
	record_reduce(First_symbols,State_number,Rule_number),!,
	maketable1(State_number,Tail,State_number0,State_number1,New_states,
	           StateL,RestSL,RestSL1,ExR0,ExR1).

maketable1(Original_state_number,
	   [([Symbol|Rest],Lookahead,Number)|Tail0],State_number0,
	   State_number2,New_states,StateL,RestSL,RestSL1,ExR0,ExR1):-
% goto
	((is_non_terminal(Symbol),!,
	  eat_symbol(Symbol,Tail0,Eatens,Tail1),
	  sort([(Rest,Lookahead,Number)|Eatens],Eatens1),
	  record_state(Eatens1,
		       Next_state_number,State_number0,State_number1,
		       New_state1,StateL,RestSL,RestSL2,ExR0,ExR2),
	  record_goto(Symbol,Original_state_number,_,Next_state_number));
% shift
	 (is_terminal(Symbol),!,
	  eat_symbol(Symbol,Tail0,Eatens,Tail1),
	  sort([(Rest,Lookahead,Number)|Eatens],Eatens1),
	  record_state(Eatens1,
		       Next_state_number,State_number0,State_number1,
		       New_state1,StateL,RestSL,RestSL2,ExR0,ExR2),
	  record_shift(Symbol,Original_state_number,Next_state_number));
% start symbol
	 (New_state1=[],
	  State_number1=State_number0,
	  ExR2 = ExR0,
	  Tail1=Tail0)),!,
	append(New_state1,New_states2,New_states),!,
	maketable1(Original_state_number,
	           Tail1,State_number1,State_number2,
		   New_states2,StateL,RestSL2,RestSL1,ExR2,ExR1).


record_state(Eatens,State_number,State_number0,State_number1,
	     New_state1,StateL,RestSL,RestSL1,ExR0,ExR1):-!,
	     fd_state(Eatens,StateL,OState), /* Find Same State */
	     ( var(OState) -> (
	       State_number1 is State_number0+1,
	       State_number is State_number0,
	       RestSL = [(Eatens,State_number0)|RestSL1],
	       list_expand(Eatens,Expand,ExR0,ExR1),
               New_state1 = [(State_number0,Expand)] )
             ;
	       State_number is OState,
	       State_number1 is State_number0,
	       ExR0 = ExR1,
	       RestSL = RestSL1,
	       New_state1 = [] ).

fd_state(Eatens,[(Eatens,OState)|_StateL],OState) :- \+ var(Eatens),!.
fd_state(Eatens,[S|StateL],OState) :- 
	\+ var(S),!,fd_state(Eatens,StateL,OState).
fd_state(_Eatens,_StateL,_State) :- !.

preprocess(CFGFile,GFile) :-
	abolish(is_term),
	abolish(is_non_term),
	abolish(first),
	cfg2mod(CFGFile,GFile),
	consult(GFile),
	find_first(_First).

find_first(First) :-
%	fd_term_nonterm(Term,NonTerm),
	find_term_nonterm2(_Term,NonTerm),
	fd_first_proc(NonTerm,First).

fd_first_proc([],[]) :- !.
fd_first_proc([N|NonTerm],[(N,SortedFirst)|RFirst]) :-
	first_child_proc(N,First),
	sort(First,SortedFirst),
	assert(first(N,SortedFirst)),
	fd_first_proc(NonTerm,RFirst).

% First Function is not optimized now.

first_child_proc(N,First) :-
	is_term(Term),
	first_function([N|Rest],Rest,[],First,Term).

first_function([],[],_Expand,[],_Term) :- !.
first_function([N|Ptr],Rest,Expand,First,Term) :-
	member(N,Expand),!,
	first_function(Ptr,Rest,Expand,First,Term).
first_function([N|Ptr],Rest,Expand,[N|First],Term) :-
	member(N,Term),!,
	first_function(Ptr,Rest,[N|Expand],First,Term).
first_function([N|Ptr],Rest,Expand,First,Term) :-
	findall(R,grammar(_,N,[R|_Rhs],_GLen),FL),
	binding_var(FL,Rest,Rest1),
	first_function(Ptr,Rest1,[N|Expand],First,Term).
	
% Binding Rest with FL(CatgoriesList) and return tail pointer to Rest1
binding_var([],Rest,Rest) :- !.
binding_var([F|FL],[F|Rest],Rest1) :-
	binding_var(FL,Rest,Rest1).

% ======== List Expand ======== 

list_expand(Eatens,Expand,ExR0,ExR1) :-
        get_first_and_lookahead(Eatens,First_and_next0),
	sort(First_and_next0,First_and_next1),
        list_expand_no_precedent(First_and_next1,Expand1,ExR0,ExR1),
	append(Eatens,Expand1,Expand2),
	sort(Expand2,Expand).

list_expand_no_precedent([],[],ExR0,ExR0):- !.
list_expand_no_precedent([(Symbol,Next)|Tail],Expands,
	                 ExR0,ExR1):-
%	expand_no_precedent(Symbol,Expands_no_next1),
	expand_no_precedent(Symbol,Expands_no_next1,ExR0,ExR2),
% list_is_lookahead_var may produce duplicating expands(sort later)
	list_is_lookahead_var(Expands_no_next1,Next,Expands1),
	append(Expands1,Expands2,Expands),!,
	list_expand_no_precedent(Tail,Expands2,ExR2,ExR1).

expand_no_precedent(Symbol,Expands,ExR0,ExR0) :-
	member((Symbol,Expands),ExR0),!.
expand_no_precedent(Symbol,Expands,ExR0,ExR1) :- 
	expand_no_precedent0([(Symbol,_)],Expands0,[],_ExpandRec,ExR0),
	sort(Expands0,Expands),
	ExR1 = [(Symbol,Expands)|ExR0],
	true.

expand_no_precedent0([],[],ExpandRec0,ExpandRec0,_ExR0) :- !.
expand_no_precedent0([(Symbol,Lookahead)|Tail],Expands,
	               ExpandRec0,ExpandRec1,ExR0):- 
	((member((Symbol,Expands0),ExR0),!,
	  list_is_lookahead_var(Expands0,Lookahead,Expands2) )
         ;
	 (findall((RHS,Lookahead,Number),grammar(Number,Symbol,RHS,_GLen),ExpandsT),
	  list_is_lookahead_var(ExpandsT,Lookahead,ExpandsT1),
	  filterexpand(ExpandsT1,Expands0,ExpandRec0,ExpandRec2),
	  get_first_and_lookahead(Expands0,Symbol_and_nexts0),
	  sort(Symbol_and_nexts0,Symbol_and_nexts),!,
	  expand_no_precedent0(Symbol_and_nexts,Expands1,
	                       ExpandRec2,ExpandRec3,ExR0),
	  append(Expands0,Expands1,Expands2))),
	append(Expands2,Expands3,Expands),!,
	expand_no_precedent0(Tail,Expands3,ExpandRec3,ExpandRec1,ExR0).

filterexpand([],[],ExpandRec0,ExpandRec0) :- !.
filterexpand([(Rhs,Lookahead,Number)|ExpandT],Expand0,ExpandRec0,ExpandRec1) :-
	var(Lookahead),!,
	expand_recorded1(Rhs,Lookahead,Number,Expand0,Expand1,
	                ExpandRec0,ExpandRec2),
	filterexpand(ExpandT,Expand1,ExpandRec2,ExpandRec1).
filterexpand([(Rhs,Lookahead,Number)|ExpandT],Expand0,ExpandRec0,ExpandRec1) :-
	expand_recorded2(Rhs,Lookahead,Number,Expand0,Expand1,
	                ExpandRec0,ExpandRec2),
	filterexpand(ExpandT,Expand1,ExpandRec2,ExpandRec1).
	
expand_recorded1(Rhs,Lookahead,Number,Expand0,Expand1,ExpandRec0,ExpandRec1) :-
	( member(Number,ExpandRec0),!,
	  ExpandRec1=ExpandRec0,
	  Expand1 = Expand0 );
	( ExpandRec1 = [Number|ExpandRec0],
	  Expand0 = [(Rhs,Lookahead,Number)|Expand1] ).

expand_recorded2(Rhs,Lookahead,Number,Expand0,Expand1,ExpandRec0,ExpandRec1) :-
	( member((Lookahead,Number),ExpandRec0),!,
	  ExpandRec1=ExpandRec0,
	  Expand1 = Expand0 );
	( ExpandRec1 = [(Lookahead,Number)|ExpandRec0],
	  Expand0 = [(Rhs,Lookahead,Number)|Expand1] ).

% get Symbol=non-terminal only.
get_first_and_lookahead([],[]):-!.
get_first_and_lookahead([Expand|Expands],[(Symbol,Lookahead)|Tail]) :- 
        first_and_lookahead(Expand,Symbol,Next),!, 
	fd_first(Next,Lookahead), 
        get_first_and_lookahead(Expands,Tail). 
% if expand=[].
get_first_and_lookahead([_|Expands],Tail):-!, 
        get_first_and_lookahead(Expands,Tail). 

% return next symbol(non terminal) and next of next symbol. 
% if expand=[],fail. 
first_and_lookahead(([Symbol|Tail],Lookahead,_),Symbol,Next):- 
	\+ is_terminal(Symbol),!,
	((Tail==[],Next=Lookahead);Tail=[Next|_]),!.

is_terminal(S) :-
	is_term(TERM),
	member(S,TERM),!.
is_non_terminal(S) :-
	is_non_term(NONTERM),
	member(S,NONTERM),!.

fd_first(Next,[Next]) :- 
	\+ var(Next),
	is_terminal(Next),!.
fd_first(Next,Lookahead) :- 
	\+ var(Next),
	is_non_terminal(Next),
	!,first(Next,Lookahead).
fd_first(Next,Next) :- !.

list_is_lookahead_var([],_,[]):-!.
list_is_lookahead_var([(RHS,Lookahead,Number)|Tail_no_next],Next,
	                   [(RHS,Lookahead1,Number)|Tail]):-
%	                   [(RHS,Lookahead,Number)|Tail]):-
	is_lookahead_var(Lookahead,Next,Lookahead1),!,
%	is_lookahead_var(Lookahead,Next),!,
	list_is_lookahead_var(Tail_no_next,Next,Tail).

is_lookahead_var(Lookahead,Next,Lookahead1):-var(Lookahead),!,Lookahead1=Next.
is_lookahead_var(L,_,L):-!.

%is_lookahead_var(Lookahead,Next):-var(Lookahead),!,Lookahead=Next.
%is_lookahead_var(_,_):-!.

% eatable
eat_symbol(Symbol,[([Symbol|Rest],Lookahead,Number)|Tail0],
	          [(Rest,Lookahead,Number)|Eatens],Tail1):-!,
        eat_symbol(Symbol,Tail0,Eatens,Tail1).
% leftovers..
eat_symbol(_,Tail,[],Tail):-!.

% decide_action.pl
% decide action from recoded states.

record_reduce([],_,_):-!.
record_reduce([Terminal|Tail],State,Rule):-!,
	write('state('),
	write(State),write(','),
	write(Terminal),write(','),
	write('re,'),
	write(Rule),write(').'),nl,
	record_reduce(Tail,State,Rule).

record_shift(Terminal,State,New_state):-!,
	write('state('),
	write(State),write(','),
	write(Terminal),write(','),
	write('sh,'),
	write(New_state),write(').'),nl.

record_goto(Non_terminal,State,Precedent,New_state):-!,
	write('state('),
	write(State),write(','),
	write(Non_terminal),write(','),
	write('go,'),
	((var(Precedent),!,write(''));write(Precedent)),
	write(New_state),write(').'),nl.
