/*********************************************************************/
/*								     */
/* find_term_nonterm.pl 					     */
/*								     */
/* Copyright (C) 1997 Thanaruk Theeramunkong (ping@jaist.ac.jp)      */ 
/*                    Manabu Okumura         (oku@jaist.ac.jp)       */
/*                    Susumu Kunifuji        (kuni@jaist.ac.jp)      */
/*                    Hiroki Imai            (imai@cs.titech.ac.jp)  */
/*								     */
/*					     	9 May 1997	     */
/*								     */
/*								     */
/*********************************************************************/

%
% This program stands for finding Terminals and Nonterminals.
% There are two versions: "find_term_nonterm/2" and "find_term_nonterm2/2".
% Both of them do the same thing but the second version seems 
%     to be more efficient and elegant.
%

find_term_nonterm(Term,NonTerm) :-
	abolish(is_non_term),
	abolish(is_term),
	setof(Lhs,N^Rhs^Length^grammar(N,Lhs,Rhs,Length),LhsLst1),
	no_doubles(LhsLst1,LhsLst),
	setof(Rhs,N^Lhs^Length^grammar(N,Lhs,Rhs,Length),RhsLst1),
	flatten(RhsLst1,RhsLst2),
	no_doubles(RhsLst2,RhsLst3),
	ex_lst(RhsLst3,LhsLst,RhsLst),
	NonTerm = LhsLst,
	Term    = RhsLst,
	assert(is_non_term(LhsLst)),
	assert(is_term(RhsLst)),
	true.

find_term_nonterm2(Term,NonTerm) :-
	abolish(is_non_term),
	abolish(is_term),
	setof(NT,grammar(NT),NonTerm),
	findall(TT,grammar(_,_,TT,_GramLen),TmpTermL),
	flatten_dn(TmpTermL,TmpFTermL),!,
	ex_or(TmpFTermL,NonTerm,Term),
	assert('is_term'(Term)),
	assert('is_non_term'(NonTerm)).

grammar(NT) :-
	grammar(_,NT,_,_).
