/*********************************************************************/
/*								     */
/* makeclause.pl 						     */
/*								     */
/* Copyright (C) 1997 Thanaruk Theeramunkong (ping@jaist.ac.jp)      */ 
/*                    Manabu Okumura         (oku@jaist.ac.jp)       */
/*                    Susumu Kunifuji        (kuni@jaist.ac.jp)      */
/*                    Hiroki Imai            (imai@cs.titech.ac.jp)  */
/*								     */
/*					     	9 May 1997	     */
/*								     */
/*								     */
/*********************************************************************/

%
% Make Clause
%

makeclause(GramFile,InFile,OutFile) :-
	abolish(grammar,4),
	consult(GramFile),
	open(InFile,read,RStream),
	open(OutFile,write,WStream),
	abolish(state,4),
	read_in_clause(0,N,RStream),
	check_is_term_non_term,
	build_list(ASList),!,
%	write('ASLIst : '),write('\n'),write_list(ASList),
	format(WStream,'%~n',[]),
	format(WStream,'% The following is the definition of variables~n',[]),
	format(WStream,'%~n',[]),
	format(WStream,'% Stk = Stack~n',[]),
	format(WStream,'% SL  = Stack List~n',[]),
	format(WStream,'% TL  = Tree  List~n',[]),
	format(WStream,'% IN  = Input~n',[]),
	format(WStream,'% TR  = Tree~n',[]),
	format(WStream,'%~n~n',[]),
	format(WStream,'% Grammar~n',[]),
	write_gram(WStream),
	format(WStream,'~n~n',[]),
	format(WStream,'% Terminal~n',[]),
	write_term(WStream),
	format(WStream,'~n~n',[]),
	format(WStream,'% Non Terminal~n',[]),
	write_nonterm(WStream),
	format(WStream,'~n~n',[]),
	format(WStream,'% Area of Nonterminals~n',[]),
	write_area(WStream),
	format(WStream,'~n~n',[]),
	format(WStream,'% Reduce Information~n',[]),
	format(WStream,'% reduce(State,Reduces)~n',[]),
	format(WStream,'% Reduce = [(gram_number,gram_length)|RRest]~n',[]),
	write_reduce(WStream),
	format(WStream,'~n~n',[]),
	format(WStream,'% Main Input~n',[]),
	make_main_input(WStream),
	format(WStream,'% Main Clause~n',[]),
	make_mainclause(WStream),
	format(WStream,'~n~n% Reduce-Goto Clause~n',[]),
	make_main_re_go(WStream),
	format(WStream,'~n~n% Actions~n',[]),
	makeclause0(ASList,WStream),!,
	format(WStream,'~n~n% No Action~n',[]),
	makeclause_noaction(WStream),!,
	write_info1(N),
	close(RStream),
	close(WStream).

check_is_term_non_term :-
	is_term(_), is_non_term(_), !.
check_is_term_non_term :-
	find_term_nonterm2(_Term,_NonTerm).

write_area(WStream) :-
	!,is_term(Term),
	abolish(depth,2),
	abolish(width,2),
	cal_term_depth(Term),
	is_non_term(NonTerm),
	find_rhs(NonTerm,NonTerm_Rhs),
	cal_nonterm_depth(NonTerm_Rhs,[]),
%	setof((A,B),depth(A,B),DepthLst),
	setof((Category,DepthCat),depth(Category,DepthCat),DepthLst),
	write_depth(WStream,DepthLst),
	cal_nonterm_width(NonTerm),
	setof((Category1,WidthCat),width(Category1,WidthCat),WidthLst),
	write_width(WStream,WidthLst),
	write_list(DepthLst).

cal_nonterm_width([]) :- !.
cal_nonterm_width([N|NonTerm]) :-
	setof(Rhs,Num^Len^grammar(Num,N,Rhs,Len),N_Rhs),
	find_totallength(N_Rhs,0,TotalLength),
	length(N_Rhs,Length),
	AverageLen is TotalLength/Length,
	assert(width(N,AverageLen)),
	cal_nonterm_width(NonTerm).

write_width(_WStream,[]) :- !.
write_width(WStream,[(C,D)|DepthLst]) :-
	format(WStream,'width(~p,~3G).~n',[C,D]),
	write_width(WStream,DepthLst).

find_totallength([],Len,Len) :- !.
find_totallength([N|N_Rhs],TLen,Len) :-
	length1(N,NLen),
	TLen1 is TLen+NLen,
	find_totallength(N_Rhs,TLen1,Len).

write_depth(_WStream,[]) :- !.
write_depth(WStream,[(C,D)|DepthLst]) :-
	format(WStream,'depth(~p,~p).~n',[C,D]),
	write_depth(WStream,DepthLst).

cal_nonterm_depth([],[]) :- !.
cal_nonterm_depth([],List) :- 
	!,cal_nonterm_depth(List,[]).
cal_nonterm_depth([(N,N_Rhs1)|NonTerm_Rhs],List) :-
	cal_nonterm_depth1(N_Rhs1,1000,Depth),!,
	Depth1 is Depth+1,
	assert(depth(N,Depth1)),
	cal_nonterm_depth(NonTerm_Rhs,List).
cal_nonterm_depth([(N,N_Rhs1)|NonTerm_Rhs],List) :-
	List1 = [(N,N_Rhs1)|List],
	cal_nonterm_depth(NonTerm_Rhs,List1).
	
cal_nonterm_depth1([],1000,_Depth)     :- !,fail.
cal_nonterm_depth1([],MinDepth,MinDepth) :- !.
cal_nonterm_depth1([N|N_Rhs1],MinDepth,Depth) :-
	depth(N,L),!,
	find_min(L,MinDepth,MinDepth1),
	cal_nonterm_depth1(N_Rhs1,MinDepth1,Depth).

cal_nonterm_depth1([_N|N_Rhs1],MinDepth,Depth) :-
	cal_nonterm_depth1(N_Rhs1,MinDepth,Depth).

find_min(L,Min,L1) :-
	L < Min, !, L1 = L.
find_min(_L,Min,L1) :-
	L1 = Min.

find_max(L,Max,L1) :-
	L > Max, !, L1 = L.
find_max(_L,Max,L1) :-
	L1 = Max.

find_rhs([],[]) :- !.
find_rhs([N|NonTerm],[(N,N_Rhs1)|NonTerm_Rhs]) :-
	setof(Rhs,Num^Len^grammar(Num,N,Rhs,Len),N_Rhs),
	build_nonterm_rhs(N_Rhs,[],N_Rhs1),
	find_rhs(NonTerm,NonTerm_Rhs).

build_nonterm_rhs([],List,List) :- !.
build_nonterm_rhs([N|N_Rhs],List,N_Rhs1) :-
	orlist(N,List,List1),!,
	build_nonterm_rhs(N_Rhs,List1,N_Rhs1).

cal_term_depth([]) :- !.
cal_term_depth([T|Term]) :-
	assert(depth(T,1)),
	cal_term_depth(Term).

write_term(WStream) :-
	!,is_term(Term),
	format(WStream,'is_term(~p).~n',[Term]).

write_nonterm(WStream) :-
	!,is_non_term(NonTerm),
	format(WStream,'is_non_term(~p).~n',[NonTerm]).

write_reduce(WStream) :-
	setof(StateNum,L1^Act^ANum1^state(StateNum,L1,Act,ANum1),StateNumLst),
	setof(ReStateNum,L2^ANum2^state(ReStateNum,L2,re,ANum2),ReStateNumLst),
	del_re_0(ReStateNumLst,ReStateNumLst1),
	ex_lst(StateNumLst,ReStateNumLst1,RestStates),
	bagof([State,ReduceList],bagof((Reduce,Length),(Cat^state(State,Cat,re,Reduce),Lhs^Rhs^grammar(Reduce,Lhs,Rhs,Length)),ReduceList),Reduces),
	del_no_double(Reduces,Reduces1),
	write_reduce1(Reduces1,WStream),
	write_rest_reduce(RestStates,WStream),
	write('Reduce:'),nl,
	write(Reduces1),nl.

del_re_0(States,States1) :-
	state(State0,_L2,re,0),
	delete(States,State0,States1).

write_reduce1([],_WStream) :- !.
write_reduce1([[State,Reduce]|RList],WStream) :-
	format(WStream,'reduce(~p,~p).~n',[State,Reduce]),
	write_reduce1(RList,WStream).

write_rest_reduce([],_WStream) :- !.
write_rest_reduce([State|RestStates],WStream) :-
	format(WStream,'reduce(~p,[]).~n',[State]),
	write_rest_reduce(RestStates,WStream).

del_no_double([],Reduces1) :- !,Reduces1 = [].
del_no_double([[S,Reduce]|Reduces],Reduces1) :-
	no_doubles(Reduce,Reduce1),
	Reduces1 = [[S,Reduce1]|Reduces2],
	del_no_double(Reduces,Reduces2).

write_gram(WStream) :-
	bagof([A1,A2,A3,A4],grammar(A1,A2,A3,A4),GList),
	write_gram(GList,WStream).

write_gram([],_WStream) :- !.
write_gram([[A1,A2,A3,A4]|GList],WStream) :-
	format(WStream,'grammar(~p,~p,~p,~p).~n',[A1,A2,A3,A4]),
        write_gram(GList,WStream).

make_main_input(WStream) :-
	is_term(Term),
	format(WStream,'input(_IN,[],ISL,OSL,ITL,OTL) :-~n',[]),
	format(WStream,'\t!, OTL=ITL, OSL=ISL.~n',[]),
	format(WStream,'input([_S],_,ISL,OSL,ITL,OTL) :-~n',[]),
	format(WStream,'\t!, OTL=ITL, OSL=ISL.~n',[]),
	make_main_input0(Term,WStream),
	is_non_term(NonTerm),
	make_main_input1(NonTerm,WStream).

make_main_input0([],WStream) :- 
	format(WStream,'input([_P,[null,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-~n',[]),
	format(WStream,'\tnull(IStk,OStk,[null,Word],IN,ISL,ISL1,ITL,ITL1),~n',[]),
	format(WStream,'\tIN=[Pos|_],~n',[]),
	format(WStream,'\tinsert_stack(Pos,OStk,ISL1,ISL2),~n',[]),
	format(WStream,'\tinput(IN,OStk,ISL2,OSL,ITL1,OTL).~n',[]).
make_main_input0([T|Term],WStream) :-
	format(WStream,'input([_P,[~p,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-~n',[T]),
	format(WStream,'\t~p(IStk,OStk,[~p,Word],IN,ISL,ISL1,ITL,ITL1),~n',[T,T]),
	format(WStream,'\tIN=[Pos|_],~n',[]),
	format(WStream,'\tinsert_stack(Pos,OStk,ISL1,ISL2),~n',[]),
	format(WStream,'\tinput(IN,OStk,ISL2,OSL,ITL1,OTL).~n',[]),
	make_main_input0(Term,WStream).

make_main_input1([],_WStream)     :- !.
make_main_input1([N|NonTerm],WStream) :-
	format(WStream,'input([_P,[~p,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-~n',[N]),
	format(WStream,'\t~p(IStk,OStk,[~p,Word]),~n',[N,N]),
	format(WStream,'\tinput(IN,OStk,ISL,OSL,ITL,OTL).~n',[]),
	make_main_input1(NonTerm,WStream).

make_mainclause(WStream) :-
	is_term(Term),
	is_non_term(NonTerm),
	make_mainclause0([null|Term],WStream),
	make_mainclause1(NonTerm,WStream).

make_mainclause0([],_WStream) :- !.
make_mainclause0([T|Term],WStream) :-
	format(WStream,'~p([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-~n\t!, OStk=[], OSL=ISL, OTL=ITL.~n',[T]),
	format(WStream,'~p([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-~n',[T]),
	format(WStream,'\t~p0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),~n',[T]),
	format(WStream,'\t~p(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),~n',[T]),
	format(WStream,'\tappend(OStk1,OStk2,OStk3),!,~n',[]),
	format(WStream,'\tmerge_stack(OStk3,OStk),!.~n',[]),
	make_mainclause0(Term,WStream).

make_mainclause1([],_WStream) :- !.
make_mainclause1([N|NonTerm],WStream) :-
	format(WStream,'~p([],OStk,_T) :-~n\t!, OStk=[].~n',[N]),
	format(WStream,'~p([[S|I]|IStk],OStk,T)  :-~n',[N]),
	format(WStream,'\t~p0(S,[S|I],OStk2,T),~n',[N]),
	format(WStream,'\t~p(IStk,OStk1,T),~n',[N]),
	format(WStream,'\tappend(OStk1,OStk2,OStk3),!,~n',[]),
	format(WStream,'\tmerge_stack(OStk3,OStk),!.~n',[]),
	make_mainclause1(NonTerm,WStream).

make_main_re_go(WStream) :-
	bagof([Rule,Lhs],Len^Rhs^grammar(Rule,Lhs,Rhs,Len),AllGram),
	make_main_re_go0(AllGram,WStream).

make_main_re_go0([],_WStream) :- !.
make_main_re_go0([[Rule,Lhs]|AllGram],WStream) :-
	format(WStream,'re(~p,TR,Stk,OStk) :-~n',[Rule]),
	format(WStream,'\t!,~p(Stk,OStk,[~p,TR]).~n',[Lhs,Lhs]),
	make_main_re_go0(AllGram,WStream).

makeclause0([],_WStream) :- !.
makeclause0([[State,InCat,Actions]|ASList],WStream) :- 
	recog_action(Actions,ShiftNum,ReduceNum,GotoNum),
	Type = ShiftNum-ReduceNum-GotoNum,
	makeclause1(Type,State,InCat,WStream),
	makeclause0(ASList,WStream).

% Shift
makeclause1([[sh,X]]-[]-[],State,InCat,WStream) :-
	!,
	format(WStream,
	       '% sh~n~p0(~p,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-~n',[InCat,State]),
        format(WStream,'\t( sysmode(breathfirst) -> ~n',[]),
        format(WStream,'\t  OStk=[[~p,T|Stk]], OTL=ITL, OSL=ISL ;~n',[X]),
        format(WStream,'\t  OStk=[],~n',[]),
        format(WStream,'\t  IN=[Pos|_],~n',[]),
        format(WStream,'\t  insert_stack(Pos,[[~p,T|Stk]],ISL,ISL1),~n',[X]),
        format(WStream,'\t  input(IN,[[~p,T|Stk]],ISL1,OSL,ITL,OTL) ).~n',[X]),!.

% Accept
makeclause1([]-[[re,0]]-[],State,InCat,WStream) :-
	!,format(WStream,
	       '% acc~n~p0(~p,[_S,TR,0],[TR],_T,_IN,ISL,OSL,ITL,OTL) :-~n',[InCat,State]),
	format(WStream,'\tOTL=[TR|ITL], OSL=ISL.~n',[]).

% Reduce
makeclause1([]-[[re,X]]-[],State,InCat,WStream) :-
	!,
	format(WStream,
	     '% re~n~p0(~p,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-~n',[InCat,State]),
	grammar(X,_Lhs,_Rhs,Len),
    	format(WStream,'\treduce(~p,~p,Stk,[],OStk1),~n',[Len,X]),
	format(WStream,'\t~p(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).~n',[InCat]).

% Goto
makeclause1([]-[]-[[go,X]],State,InCat,WStream) :-
	!,
	format(WStream,
	     '% go~n~p0(~p,Stk,OStk,T) :-~n',[InCat,State]),
	format(WStream,'\tOStk=[[~p,T|Stk]].~n',[X]),!.
% Shift/Reduce
makeclause1([[sh,X]]-[[re,Y]|Reduces]-[],State,InCat,WStream) :-
	!,
	format(WStream,
	     '% sh/re~n~p0(~p,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-~n',[InCat,State]),
	grammar(Y,_Lhs,_Rhs,Len),
    	format(WStream,'\treduce(~p,~p,Stk,[],NStk0),~n',[Len,Y]),
	makeclause2(0,[[sh,X]]-Reduces-[],InCat,WStream).

% Reduce/Reduce
makeclause1([]-[[re,Y]|Reduces]-[],State,InCat,WStream) :-
	!,
	format(WStream,
	     '% re/re~n~p0(~p,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-~n',[InCat,State]),
	grammar(Y,_Lhs,_Rhs,Len),
    	format(WStream,'\treduce(~p,~p,Stk,[],NStk0),~n',[Len,Y]),
	makeclause3(0,[]-Reduces-[],InCat,WStream).
makeclause1(_X-_Y-_Z,_State,_InCat,_WStream) :- 
	write('Error'),nl.

makeclause2(N,[[sh,X]]-[]-[],InCat,WStream) :- 
	N1 is N+1,
	format(WStream,'\t~p(NStk~p,NStk~p,T,IN,ISL,ISL1,ITL,ITL1),~n',[InCat,N,N1]),
	format(WStream,'\t( sysmode(breathfirst) ->~n',[]),
	format(WStream,'\t  OStk=[[~p,T|Stk]|NStk~p], OSL=ISL1,',[X,N1]),
	format(WStream,' OTL=ITL1 ;~n',[]),
        format(WStream,'\t  OStk=[],~n',[]),
        format(WStream,'\t  IN=[Pos|_],~n',[]),
        format(WStream,'\t  insert_stack(Pos,[[~p,T|Stk]|NStk~p],ISL1,ISL2),~n',[X,N1]),
	format(WStream,'\t  input(IN,[[~p,T|Stk]|NStk~p],ISL2,OSL,ITL1,OTL) ).~n',[X,N1]).
makeclause2(N,[[sh,X]]-[[re,Y]|Reduces]-[],InCat,WStream) :- 
	N1 is N+1,
	grammar(Y,_Lhs,_Rhs,Len),
    	format(WStream,'\treduce(~p,~p,Stk,[],NStk~p),~n',[Len,Y,N1]),
	N2 is N1+1,
	format(WStream,'\tappend(NStk~p,NStk~p,NStk~p),~n',[N,N1,N2]),
	makeclause2(N2,[[sh,X]]-Reduces-[],InCat,WStream).

makeclause3(N,[]-[]-[],InCat,WStream) :- 
	N1 is N+1,
	format(WStream,'\t~p(NStk~p,OStk,T,IN,ISL,OSL,ITL,OTL).~n',[InCat,N,N1]).
makeclause3(N,[]-[[re,Y]|Reduces]-[],InCat,WStream) :- 
	N1 is N+1,
	grammar(Y,_Lhs,_Rhs,Len),
    	format(WStream,'\treduce(~p,~p,Stk,[],NStk~p),~n',[Len,Y,N1]),
	N2 is N1+1,
	format(WStream,'\tappend(NStk~p,NStk~p,NStk~p),~n',[N,N1,N2]),
	makeclause3(N2,[]-Reduces-[],InCat,WStream).

makeclause_noaction(WStream) :-
	is_term(Term),
	is_non_term(NonTerm),
	makeclause_noaction_term([null|Term],WStream),
	makeclause_noaction_nonterm(NonTerm,WStream).

makeclause_noaction_term([],_WStream) :- !.
makeclause_noaction_term([InCat|Term],WStream) :-
	format(WStream,'~p0(_S,_Stk,OStk,_T,_IN,ISL,OSL,ITL,OTL) :-~n',[InCat]),
	format(WStream,'\tOStk=[], OSL=ISL, OTL=ITL.~n',[]),
	makeclause_noaction_term(Term,WStream).

makeclause_noaction_nonterm([],_WStream) :- !.
makeclause_noaction_nonterm([InCat|NonTerm],WStream) :-
	format(WStream,'~p0(_S,_Stk,OStk,_T) :-~n',[InCat]),
	format(WStream,'\tOStk=[].~n',[]),
	makeclause_noaction_nonterm(NonTerm,WStream).


recog_action([],Shift,Reduce,Goto) :-
	Shift = [], Reduce = [], Goto = [].
recog_action([[sh,X]|Y],Shift,Reduce,Goto) :-
	recog_action(Y,Shift1,Reduce,Goto),
	Shift = [[sh,X]|Shift1].
recog_action([[re,X]|Y],Shift,Reduce,Goto) :-
	recog_action(Y,Shift,Reduce1,Goto),
	Reduce = [[re,X]|Reduce1].
recog_action([[go,X]|Y],Shift,Reduce,Goto) :-
	recog_action(Y,Shift,Reduce,Goto1),
	Goto = [[go,X]|Goto1].

build_list(ASList) :- 
	bagof([State,InCat,Actions],bagof([Action,OutState],
	      state(State,InCat,Action,OutState),Actions),ASList).

% Read from File Routine

read_in_clause(N0,N1,RStream) :-
	read(RStream,state(State,InCat,Action,OutState)),
	assert(state(State,InCat,Action,OutState)),
%	write_info0(State,InCat,Action,OutState),
	N2 is N0+1,
	read_in_clause(N2,N1,RStream).
read_in_clause(N0,N1,_RStream) :- 
	N1 is N0.

% Write Routine

write_info0(State,InCat,Action,OutState) :-
	write('state    = '),write(State),write(' : '),
	write('incat    = '),write(InCat),write(' : '),
	write('action   = '),write(Action),write(' : '),
	write('OutState = '),write(OutState),write(' : '),
	write('\n').

write_info1(N) :-
	write('The number of processed lines is '),
	write(N),write('.'),write('\n').

reverse_insert([],IList,OList) :- !,OList = IList.
reverse_insert([I|IList],List,OList) :-
	TList = [I|List],
	reverse_insert(IList,TList,OList).

