/*********************************************************************/
/*								     */
/* gramsmallclause.pl 						     */
/*								     */
/* Copyright (C) 1997 Thanaruk Theeramunkong (ping@jaist.ac.jp)      */ 
/*                    Manabu Okumura         (oku@jaist.ac.jp)       */
/*                    Susumu Kunifuji        (kuni@jaist.ac.jp)      */
/*                    Hiroki Imai            (imai@cs.titech.ac.jp)  */
/*								     */
/*					     	9 May 1997	     */
/*								     */
/*								     */
/*********************************************************************/

%
% The following is the definition of variables
%
% Stk = Stack
% SL  = Stack List
% TL  = Tree  List
% IN  = Input
% TR  = Tree
%

% Grammar
grammar(1,sentence,[s],1).
grammar(2,s,[np,vp],2).
grammar(3,np,[det,n],2).
grammar(4,np,[n],1).
grammar(5,np,[np,pp],2).
grammar(6,pp,[p,np],2).
grammar(7,vp,[v,np],2).
grammar(8,vp,[vp,pp],2).


% Terminal
is_term([v,p,n,det]).


% Non Terminal
is_non_term([np,pp,s,sentence,vp]).


% Area of Nonterminals
depth(det,1).
depth(n,1).
depth(np,2).
depth(p,1).
depth(pp,2).
depth(s,3).
depth(sentence,4).
depth(v,1).
depth(vp,2).
width(np,1.67).
width(pp,2).
width(s,2).
width(sentence,1).
width(vp,2).


% Reduce Information
% reduce(State,Reduces)
% Reduce = [(gram_number,gram_length)|RRest]
reduce(2,[(4,1)]).
reduce(4,[(1,1)]).
reduce(6,[(3,2)]).
reduce(8,[(5,2)]).
reduce(10,[(2,2)]).
reduce(11,[(6,2)]).
reduce(13,[(4,1)]).
reduce(14,[(7,2)]).
reduce(16,[(8,2)]).
reduce(17,[(6,2)]).
reduce(18,[(5,2)]).
reduce(19,[(3,2)]).
reduce(0,[]).
reduce(1,[]).
reduce(3,[]).
reduce(5,[]).
reduce(7,[]).
reduce(9,[]).
reduce(12,[]).
reduce(15,[]).


% Main Input
input(_IN,[],ISL,OSL,ITL,OTL) :-
	!, OTL=ITL, OSL=ISL.
input([_S],_,ISL,OSL,ITL,OTL) :-
	!, OTL=ITL, OSL=ISL.
input([_P,[v,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	v(IStk,OStk,[v,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[p,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	p(IStk,OStk,[p,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[n,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	n(IStk,OStk,[n,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[det,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	det(IStk,OStk,[det,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[null,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	null(IStk,OStk,[null,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[np,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	np(IStk,OStk,[np,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[pp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	pp(IStk,OStk,[pp,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[s,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	s(IStk,OStk,[s,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[sentence,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	sentence(IStk,OStk,[sentence,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[vp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	vp(IStk,OStk,[vp,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
% Main Clause
null([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
null([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	null0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	null(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
v([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
v([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	v0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	v(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
p([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
p([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	p0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	p(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
n([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
n([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	n0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	n(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
det([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
det([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	det0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	det(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
np([],OStk,_T) :-
	!, OStk=[].
np([[S|I]|IStk],OStk,T)  :-
	np0(S,[S|I],OStk2,T),
	np(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
pp([],OStk,_T) :-
	!, OStk=[].
pp([[S|I]|IStk],OStk,T)  :-
	pp0(S,[S|I],OStk2,T),
	pp(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
s([],OStk,_T) :-
	!, OStk=[].
s([[S|I]|IStk],OStk,T)  :-
	s0(S,[S|I],OStk2,T),
	s(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
sentence([],OStk,_T) :-
	!, OStk=[].
sentence([[S|I]|IStk],OStk,T)  :-
	sentence0(S,[S|I],OStk2,T),
	sentence(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
vp([],OStk,_T) :-
	!, OStk=[].
vp([[S|I]|IStk],OStk,T)  :-
	vp0(S,[S|I],OStk2,T),
	vp(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.


% Reduce-Goto Clause
re(1,TR,Stk,OStk) :-
	!,sentence(Stk,OStk,[sentence,TR]).
re(2,TR,Stk,OStk) :-
	!,s(Stk,OStk,[s,TR]).
re(3,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(4,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(5,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(6,TR,Stk,OStk) :-
	!,pp(Stk,OStk,[pp,TR]).
re(7,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(8,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).


% Actions
% sh
det0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[1,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]],ISL,ISL1),
	  input(IN,[[1,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
n0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
np0(0,Stk,OStk,T) :-
	OStk=[[3,T|Stk]].
% go
s0(0,Stk,OStk,T) :-
	OStk=[[4,T|Stk]].
% go
sentence0(0,Stk,OStk,T) :-
	OStk=[[5,T|Stk]].
% sh
n0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[6,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[6,T|Stk]],ISL,ISL1),
	  input(IN,[[6,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
p0(2,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,4,Stk,[],OStk1),
	p(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
v0(2,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,4,Stk,[],OStk1),
	v(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
p0(3,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
pp0(3,Stk,OStk,T) :-
	OStk=[[8,T|Stk]].
% sh
v0(3,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(3,Stk,OStk,T) :-
	OStk=[[10,T|Stk]].
% re
null0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,1,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% acc
null0(5,[_S,TR,0],[TR],_T,_IN,ISL,OSL,ITL,OTL) :-
	OTL=[TR|ITL], OSL=ISL.
% re
p0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,3,Stk,[],OStk1),
	p(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
v0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,3,Stk,[],OStk1),
	v(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
det0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[1,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]],ISL,ISL1),
	  input(IN,[[1,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
n0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
np0(7,Stk,OStk,T) :-
	OStk=[[11,T|Stk]].
% re
p0(8,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,5,Stk,[],OStk1),
	p(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
v0(8,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,5,Stk,[],OStk1),
	v(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
det0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
n0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
np0(9,Stk,OStk,T) :-
	OStk=[[14,T|Stk]].
% re
null0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,2,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
p0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
pp0(10,Stk,OStk,T) :-
	OStk=[[16,T|Stk]].
% sh/re
p0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,6,Stk,[],NStk0),
	p(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
pp0(11,Stk,OStk,T) :-
	OStk=[[8,T|Stk]].
% re
v0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,6,Stk,[],OStk1),
	v(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
n0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[19,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]],ISL,ISL1),
	  input(IN,[[19,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
null0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,4,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
p0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,4,Stk,[],OStk1),
	p(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,7,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
p0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,7,Stk,[],NStk0),
	p(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
pp0(14,Stk,OStk,T) :-
	OStk=[[18,T|Stk]].
% sh
det0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
n0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
np0(15,Stk,OStk,T) :-
	OStk=[[17,T|Stk]].
% re
null0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,8,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
p0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,8,Stk,[],OStk1),
	p(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,6,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
p0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,6,Stk,[],NStk0),
	p(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
pp0(17,Stk,OStk,T) :-
	OStk=[[18,T|Stk]].
% re
null0(18,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,5,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
p0(18,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,5,Stk,[],OStk1),
	p(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(19,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,3,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
p0(19,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,3,Stk,[],OStk1),
	p(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).


% No Action
null0(_S,_Stk,OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	OStk=[], OSL=ISL, OTL=ITL.
v0(_S,_Stk,OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	OStk=[], OSL=ISL, OTL=ITL.
p0(_S,_Stk,OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	OStk=[], OSL=ISL, OTL=ITL.
n0(_S,_Stk,OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	OStk=[], OSL=ISL, OTL=ITL.
det0(_S,_Stk,OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	OStk=[], OSL=ISL, OTL=ITL.
np0(_S,_Stk,OStk,_T) :-
	OStk=[].
pp0(_S,_Stk,OStk,_T) :-
	OStk=[].
s0(_S,_Stk,OStk,_T) :-
	OStk=[].
sentence0(_S,_Stk,OStk,_T) :-
	OStk=[].
vp0(_S,_Stk,OStk,_T) :-
	OStk=[].
