/*********************************************************************/
/*								     */
/* gram260clause.pl 						     */
/*								     */
/* Copyright (C) 1997 Thanaruk Theeramunkong (ping@jaist.ac.jp)      */ 
/*                    Manabu Okumura         (oku@jaist.ac.jp)       */
/*                    Susumu Kunifuji        (kuni@jaist.ac.jp)      */
/*                    Hiroki Imai            (imai@cs.titech.ac.jp)  */
/*								     */
/*					     	9 May 1997	     */
/*								     */
/*								     */
/*********************************************************************/

%
% The following is the definition of variables
%
% Stk = Stack
% SL  = Stack List
% TL  = Tree  List
% IN  = Input
% TR  = Tree
%

% Grammar
grammar(1,sentence,[s],1).
grammar(2,s,[sdec],1).
grammar(3,s,[sdec,cc,sdec],3).
grammar(4,s,[simp],1).
grammar(5,s,[pp,comma,s],3).
grammar(6,s,[sq],1).
grammar(7,s,[advp,comma,s],3).
grammar(8,s,[uh],1).
grammar(9,s,[uh,comma,s],3).
grammar(10,adjcomp,[infinitive],1).
grammar(11,adjcomp,[in,np],2).
grammar(12,adjcomp,[in,np,infinitive],3).
grammar(13,adjcpt,[jjr],1).
grammar(14,adjcpt,[jjr,adjcomp],2).
grammar(15,adjcpt,[jjr,adjp],2).
grammar(16,adjp,[jj],1).
grammar(17,adjp,[jjs],1).
grammar(18,adjp,[jj,adjcomp],2).
grammar(19,adjp,[wrb,jj],2).
grammar(20,adjp,[wrb,jj,adjcomp],3).
grammar(21,adjp,[wdt,adjp],2).
grammar(22,adjp,[dt,adjp],2).
grammar(23,adjp,[detq,adjp],2).
grammar(24,adjp,[adjcpt,thancomp],2).
grammar(25,adjp,[rb,adjp],2).
grammar(26,adjp,[adjp,cc,adjp],3).
grammar(27,advp,[rb],1).
grammar(28,advp,[rbs],1).
grammar(29,advp,[wrb],1).
grammar(30,advp,[wrb,jj],2).
grammar(31,advp,[wrb,rb],2).
grammar(32,advp,[in,sdec],2).
grammar(33,advp,[cc,sdec],2).
grammar(34,advp,[rbr,thancomp],2).
grammar(35,aux,[bep],1).
grammar(36,aux,[md],1).
grammar(37,auxd,[aux],1).
grammar(38,bep,[vbd],1).
grammar(39,bep,[vbp],1).
grammar(40,bep,[vbz],1).
grammar(41,bep,[vbd,rb],2).
grammar(42,bep,[vbp,rb],2).
grammar(43,bep,[vbz,rb],2).
grammar(44,ddet,[dt],1).
grammar(45,ddet,[pdt],1).
grammar(46,ddet,[pdt,in,dt],3).
grammar(47,detq,[wdt],1).
grammar(48,dop,[vb],1).
grammar(49,dop,[vb,rb],2).
grammar(50,gerund,[vp],1).
grammar(51,gerund,[rb,vp],2).
grammar(52,havep,[vb],1).
grammar(53,infinitive,[to,vp],2).
grammar(54,infinitive,[rb,to,vp],3).
grammar(55,infinitive1,[vp],1).
grammar(56,infinitive1,[bep,pred],2).
grammar(57,infinitive1,[bep,vp],2).
grammar(58,infinitrel,[infinitive],1).
grammar(59,infinitrel,[vp],1).
grammar(60,infinitrel,[bep,vp],2).
grammar(61,infinitrel,[in,np,infinitive],3).
grammar(62,infinitrel,[in,np,bep,vp],4).
grammar(63,ncomp,[pp],1).
grammar(64,ncomp,[in,np],2).
grammar(65,ncomp,[vp2],1).
grammar(66,ncomp,[srel],1).
grammar(67,ncomp,[infinitrel],1).
grammar(68,ncomp,[adjp],1).
grammar(69,ncomp,[thancomp],1).
grammar(70,ncomp,[ncomp,pp],2).
grammar(71,nomhd,[nn],1).
grammar(72,nomhd,[nns],1).
grammar(73,nomhd,[nn,pos],2).
grammar(74,nomhd,[nns,pos],2).
grammar(75,nomhd,[nnp],1).
grammar(76,nomhd,[nnps],1).
grammar(77,nomhd,[nnp,pos],2).
grammar(78,nomhd,[nnps,pos],2).
grammar(79,nomhd,[adjp,nomhd],2).
grammar(80,nomhd,[wdt,adjp,nomhd],3).
grammar(81,np,[nomhd,ncomp],2).
grammar(82,np,[nomhd],1).
grammar(83,np,[dt,nomhd,ncomp],3).
grammar(84,np,[dt,nomhd],2).
grammar(85,np,[ddet,nomhd,ncomp],3).
grammar(86,np,[ddet,nomhd],2).
grammar(87,np,[detq,nomhd,ncomp],3).
grammar(88,np,[detq,nomhd],2).
grammar(89,np,[dt,ncomp],2).
grammar(90,np,[ddet,ncomp],2).
grammar(91,np,[ddet],1).
grammar(92,np,[detq,ncomp],2).
grammar(93,np,[detq],1).
grammar(94,np,[prp],1).
grammar(95,np,[prp,ncomp],2).
grammar(96,np,[psp,nomhd,ncomp],3).
grammar(97,np,[psp,ncomp],2).
grammar(98,np,[psp,nomhd],2).
grammar(99,np,[ddet,adjp,nomhd,ncomp],4).
grammar(100,np,[ddet,adjp,nomhd],3).
grammar(101,np,[ddet,adjp,ncomp],3).
grammar(102,np,[dt,gerund],2).
grammar(103,np,[gerund],1).
grammar(104,np,[wp,sdec],2).
grammar(105,np,[np,cc,np],3).
grammar(106,np,[np,comma,np],3).
grammar(107,np,[dollar,cd],2).
grammar(108,np,[cd,nns],2).
grammar(109,obj,[np],1).
grammar(110,obj1,[np],1).
grammar(111,obj2,[np],1).
grammar(112,pp,[in,obj],2).
grammar(113,pp,[in,np,in,np],4).
grammar(114,pp,[rp,obj],2).
grammar(115,pp,[rp,np,in,np],4).
grammar(116,pred,[adjp],1).
grammar(117,pred,[np],1).
grammar(118,pred,[pp],1).
grammar(119,pred,[vp2],1).
grammar(120,pred,[pred,pp],2).
grammar(121,pred,[pred,comma,pp],3).
grammar(122,pred,[pred,infinitive],2).
grammar(123,sdec,[subj,vp],2).
grammar(124,sdec,[subj,auxd,vp],3).
grammar(125,sdec,[subj,auxd,rb,vp],4).
grammar(126,sdec,[subj,bep,pred],3).
grammar(127,sdec,[subj,bep],2).
grammar(128,sdec,[ex,bep,subj],3).
grammar(129,sdec,[ex,bep,subj,rb,pred],5).
grammar(130,sdec,[ex,bep,subj,pred],4).
grammar(131,sdec,[sdec,comma,vp3],3).
grammar(132,sdec,[sdec,advp],2).
grammar(133,simp,[dop,vp],2).
grammar(134,simp,[vp],1).
grammar(135,simp,[vb,rb,pred],3).
grammar(136,simp,[vb,pred],2).
grammar(137,simp,[simp,advp],2).
grammar(138,simp,[simp,comma,advp],3).
grammar(139,sq,[bep,subj,pred],3).
grammar(140,sq,[md,subj,bep,pred],4).
grammar(141,sq,[md,subj,havep,bep,pred],5).
grammar(142,sq,[dop,subj,vp],3).
grammar(143,sq,[md,subj,vp],3).
grammar(144,sq,[md,subj,bep,vp],4).
grammar(145,sq,[md,subj,havep,bep,vp],5).
grammar(146,sq,[bep,subj,vp],3).
grammar(147,sq,[bep,ex,subj],3).
grammar(148,sq,[bep,ex,subj,pred],4).
grammar(149,srel,[wp,auxd,vp],3).
grammar(150,srel,[wp,vp],2).
grammar(151,srel,[wp,bep,pred],3).
grammar(152,srel,[subj,vp2],2).
grammar(153,srel,[subj,auxd,vp2],3).
grammar(154,srel,[subj,bep],2).
grammar(155,srel,[wp,subj,bep],3).
grammar(156,srel,[comma,srel],2).
grammar(157,srel,[srel,pp],2).
grammar(158,srel,[srel,comma,pp],3).
grammar(159,subj,[np],1).
grammar(160,thancomp,[in,np],2).
grammar(161,thancomp,[in,sdec],2).
grammar(162,thancomp,[in,subj,vp2],3).
grammar(163,thancomp,[in,subj,bep],3).
grammar(164,vp,[vbd],1).
grammar(165,vp,[vbp],1).
grammar(166,vp,[vbz],1).
grammar(167,vp,[vbd,np],2).
grammar(168,vp,[vbp,np],2).
grammar(169,vp,[vbz,np],2).
grammar(170,vp,[vbd,adjp],2).
grammar(171,vp,[vbp,adjp],2).
grammar(172,vp,[vbz,adjp],2).
grammar(173,vp,[vbd,infinitive],2).
grammar(174,vp,[vbp,infinitive],2).
grammar(175,vp,[vbz,infinitive],2).
grammar(176,vp,[vbd,bep,pred],3).
grammar(177,vp,[vbp,bep,pred],3).
grammar(178,vp,[vbz,bep,pred],3).
grammar(179,vp,[vbd,obj],2).
grammar(180,vp,[vbp,obj],2).
grammar(181,vp,[vbz,obj],2).
grammar(182,vp,[vbd,obj1,obj2],3).
grammar(183,vp,[vbp,obj1,obj2],3).
grammar(184,vp,[vbz,obj1,obj2],3).
grammar(185,vp,[vbd,obj2,in,obj1],4).
grammar(186,vp,[vbp,obj2,in,obj1],4).
grammar(187,vp,[vbz,obj2,in,obj1],4).
grammar(188,vp,[vbd,infinitive],2).
grammar(189,vp,[vbp,infinitive],2).
grammar(190,vp,[vbz,infinitive],2).
grammar(191,vp,[vbd,obj,infinitive],3).
grammar(192,vp,[vbp,obj,infinitive],3).
grammar(193,vp,[vbz,obj,infinitive],3).
grammar(194,vp,[vbd,obj,infinitive1],3).
grammar(195,vp,[vbp,obj,infinitive1],3).
grammar(196,vp,[vbz,obj,infinitive1],3).
grammar(197,vp,[vbd,sdec],2).
grammar(198,vp,[vbp,sdec],2).
grammar(199,vp,[vbz,sdec],2).
grammar(200,vp,[vbd,wp,sdec],3).
grammar(201,vp,[vbp,wp,sdec],3).
grammar(202,vp,[vbz,wp,sdec],3).
grammar(203,vp,[vbd,obj,adjp],3).
grammar(204,vp,[vbp,obj,adjp],3).
grammar(205,vp,[vbz,obj,adjp],3).
grammar(206,vp,[vbd,obj,vp],3).
grammar(207,vp,[vbp,obj,vp],3).
grammar(208,vp,[vbz,obj,vp],3).
grammar(209,vp,[vbd,obj,advp],3).
grammar(210,vp,[vbp,obj,advp],3).
grammar(211,vp,[vbz,obj,advp],3).
grammar(212,vp,[vbg],1).
grammar(213,vp,[vbg,np],2).
grammar(214,vp,[vbg,adjp],2).
grammar(215,vp,[vbg,infinitive],2).
grammar(216,vp,[vbg,bep,pred],3).
grammar(217,vp,[vbg,obj],2).
grammar(218,vp,[vbg,obj1,obj2],3).
grammar(219,vp,[vbg,obj2,in,obj1],4).
grammar(220,vp,[vbg,infinitive],2).
grammar(221,vp,[vbg,obj,infinitive],3).
grammar(222,vp,[vbg,obj,infinitive1],3).
grammar(223,vp,[vbg,sdec],2).
grammar(224,vp,[vbg,wp,sdec],3).
grammar(225,vp,[vbg,obj,adjp],3).
grammar(226,vp,[vbg,obj,vp],3).
grammar(227,vp,[vbg,obj,advp],3).
grammar(228,vp,[vb],1).
grammar(229,vp,[vb,np],2).
grammar(230,vp,[vb,adjp],2).
grammar(231,vp,[vb,infinitive],2).
grammar(232,vp,[vb,bep,pred],3).
grammar(233,vp,[vb,obj],2).
grammar(234,vp,[vb,obj1,obj2],3).
grammar(235,vp,[vb,obj2,in,obj1],4).
grammar(236,vp,[vb,infinitive],2).
grammar(237,vp,[vb,obj,infinitive],3).
grammar(238,vp,[vb,obj,infinitive1],3).
grammar(239,vp,[vb,sdec],2).
grammar(240,vp,[vb,wp,sdec],3).
grammar(241,vp,[vb,obj,adjp],3).
grammar(242,vp,[vb,obj,vp],3).
grammar(243,vp,[vb,obj,advp],3).
grammar(244,vp,[vp,pp],2).
grammar(245,vp,[vp,comma,pp],3).
grammar(246,vp,[vp,infinitive],2).
grammar(247,vp,[vp,advp],2).
grammar(248,vp,[vp,cc,adjp],3).
grammar(249,vp2,[vbn],1).
grammar(250,vp2,[vbn,obj1],2).
grammar(251,vp2,[vbn,infinitive1],2).
grammar(252,vp2,[vbn,in,obj1],3).
grammar(253,vp2,[vbn,adjp],2).
grammar(254,vp2,[vp2,advp],2).
grammar(255,vp2,[vp2,pp],2).
grammar(256,vp3,[vp],1).
grammar(257,vp3,[vbd,pred],2).
grammar(258,vp3,[vbp,pred],2).
grammar(259,vp3,[vbz,pred],2).
grammar(260,vp3,[rb,vp3],2).


% Terminal
is_term([vbn,vbg,ex,rp,cd,dollar,wp,psp,prp,nnps,nnp,pos,nns,nn,to,vb,pdt,vbz,vbp,vbd,md,rbr,rbs,rb,dt,wdt,wrb,jjs,jj,jjr,in,uh,comma,cc]).


% Non Terminal
is_non_term([adjcomp,adjcpt,adjp,advp,aux,auxd,bep,ddet,detq,dop,gerund,havep,infinitive,infinitive1,infinitrel,ncomp,nomhd,np,obj,obj1,obj2,pp,pred,s,sdec,sentence,simp,sq,srel,subj,thancomp,vp,vp2,vp3]).


% Area of Nonterminals
depth(adjcomp,2).
depth(adjcpt,2).
depth(adjp,2).
depth(advp,2).
depth(aux,2).
depth(auxd,3).
depth(bep,2).
depth(cc,1).
depth(cd,1).
depth(comma,1).
depth(ddet,2).
depth(detq,2).
depth(dollar,1).
depth(dop,2).
depth(dt,1).
depth(ex,1).
depth(gerund,2).
depth(havep,2).
depth(in,1).
depth(infinitive,2).
depth(infinitive1,3).
depth(infinitrel,2).
depth(jj,1).
depth(jjr,1).
depth(jjs,1).
depth(md,1).
depth(ncomp,2).
depth(nn,1).
depth(nnp,1).
depth(nnps,1).
depth(nns,1).
depth(nomhd,2).
depth(np,2).
depth(obj,3).
depth(obj1,3).
depth(obj2,3).
depth(pdt,1).
depth(pos,1).
depth(pp,2).
depth(pred,2).
depth(prp,1).
depth(psp,1).
depth(rb,1).
depth(rbr,1).
depth(rbs,1).
depth(rp,1).
depth(s,2).
depth(sdec,2).
depth(sentence,3).
depth(simp,2).
depth(sq,2).
depth(srel,2).
depth(subj,3).
depth(thancomp,2).
depth(to,1).
depth(uh,1).
depth(vb,1).
depth(vbd,1).
depth(vbg,1).
depth(vbn,1).
depth(vbp,1).
depth(vbz,1).
depth(vp,2).
depth(vp2,2).
depth(vp3,2).
depth(wdt,1).
depth(wp,1).
depth(wrb,1).
width(adjcomp,2).
width(adjcpt,1.67).
width(adjp,2).
width(advp,1.62).
width(aux,1).
width(auxd,1).
width(bep,1.5).
width(ddet,1.67).
width(detq,1).
width(dop,1.5).
width(gerund,1.5).
width(havep,1).
width(infinitive,2.5).
width(infinitive1,1.67).
width(infinitrel,2.2).
width(ncomp,1.25).
width(nomhd,1.7).
width(np,2.18).
width(obj,1).
width(obj1,1).
width(obj2,1).
width(pp,3).
width(pred,1.57).
width(s,2).
width(sdec,3.1).
width(sentence,1).
width(simp,2.17).
width(sq,3.7).
width(srel,2.5).
width(subj,1).
width(thancomp,2.5).
width(vp,2.59).
width(vp2,2).
width(vp3,1.8).


% Reduce Information
% reduce(State,Reduces)
% Reduce = [(gram_number,gram_length)|RRest]
reduce(4,[(44,1)]).
reduce(7,[(16,1)]).
reduce(8,[(13,1)]).
reduce(9,[(17,1)]).
reduce(11,[(71,1)]).
reduce(12,[(75,1)]).
reduce(13,[(76,1)]).
reduce(14,[(72,1)]).
reduce(15,[(45,1)]).
reduce(16,[(94,1)]).
reduce(18,[(27,1)]).
reduce(20,[(28,1)]).
reduce(22,[(8,1)]).
reduce(23,[(228,1),(48,1)]).
reduce(24,[(164,1),(38,1)]).
reduce(25,[(212,1)]).
reduce(26,[(165,1),(39,1)]).
reduce(27,[(166,1),(40,1)]).
reduce(28,[(47,1)]).
reduce(30,[(29,1)]).
reduce(31,[(1,1)]).
reduce(36,[(91,1)]).
reduce(37,[(93,1)]).
reduce(39,[(103,1)]).
reduce(40,[(82,1)]).
reduce(41,[(159,1)]).
reduce(43,[(2,1)]).
reduce(44,[(4,1)]).
reduce(45,[(6,1)]).
reduce(47,[(50,1),(134,1)]).
reduce(49,[(228,1)]).
reduce(50,[(164,1)]).
reduce(51,[(165,1)]).
reduce(52,[(166,1)]).
reduce(54,[(33,2)]).
reduce(55,[(50,1)]).
reduce(56,[(108,2)]).
reduce(57,[(107,2)]).
reduce(62,[(249,1)]).
reduce(64,[(68,1),(22,2)]).
reduce(66,[(103,1),(102,2)]).
reduce(67,[(58,1)]).
reduce(68,[(67,1)]).
reduce(69,[(89,2)]).
reduce(70,[(82,1),(84,2)]).
reduce(71,[(63,1)]).
reduce(72,[(66,1)]).
reduce(74,[(69,1)]).
reduce(75,[(59,1),(50,1)]).
reduce(76,[(65,1)]).
reduce(77,[(38,1)]).
reduce(78,[(39,1)]).
reduce(79,[(40,1)]).
reduce(81,[(159,1),(109,1)]).
reduce(82,[(112,2)]).
reduce(83,[(32,2)]).
reduce(86,[(18,2)]).
reduce(87,[(10,1)]).
reduce(90,[(47,1)]).
reduce(91,[(14,2)]).
reduce(92,[(15,2)]).
reduce(95,[(73,2)]).
reduce(96,[(77,2)]).
reduce(97,[(78,2)]).
reduce(98,[(74,2)]).
reduce(100,[(68,1)]).
reduce(101,[(95,2)]).
reduce(102,[(97,2)]).
reduce(103,[(82,1),(98,2)]).
reduce(105,[(25,2)]).
reduce(106,[(51,2)]).
reduce(108,[(34,2)]).
reduce(109,[(109,1)]).
reduce(110,[(114,2)]).
reduce(113,[(49,2)]).
reduce(115,[(230,2),(116,1)]).
reduce(117,[(231,2),(236,2)]).
reduce(118,[(111,1),(159,1),(117,1),(109,1),(110,1)]).
reduce(119,[(233,2)]).
reduce(122,[(118,1)]).
reduce(123,[(136,2)]).
reduce(124,[(239,2)]).
reduce(125,[(119,1)]).
reduce(126,[(41,2)]).
reduce(128,[(170,2)]).
reduce(130,[(173,2),(188,2)]).
reduce(131,[(111,1),(159,1),(167,2),(109,1),(110,1)]).
reduce(132,[(179,2)]).
reduce(135,[(197,2)]).
reduce(137,[(214,2)]).
reduce(139,[(215,2),(220,2)]).
reduce(140,[(111,1),(159,1),(213,2),(109,1),(110,1)]).
reduce(141,[(217,2)]).
reduce(144,[(223,2)]).
reduce(145,[(42,2)]).
reduce(147,[(171,2)]).
reduce(149,[(174,2),(189,2)]).
reduce(150,[(111,1),(159,1),(168,2),(109,1),(110,1)]).
reduce(151,[(180,2)]).
reduce(154,[(198,2)]).
reduce(155,[(43,2)]).
reduce(157,[(172,2)]).
reduce(159,[(175,2),(190,2)]).
reduce(160,[(111,1),(159,1),(169,2),(109,1),(110,1)]).
reduce(161,[(181,2)]).
reduce(164,[(199,2)]).
reduce(165,[(21,2)]).
reduce(166,[(104,2)]).
reduce(167,[(19,2),(30,2)]).
reduce(168,[(31,2)]).
reduce(169,[(24,2)]).
reduce(171,[(79,2)]).
reduce(175,[(68,1)]).
reduce(176,[(90,2)]).
reduce(177,[(82,1),(86,2)]).
reduce(178,[(68,1),(23,2)]).
reduce(179,[(92,2)]).
reduce(180,[(82,1),(88,2)]).
reduce(182,[(50,1),(133,2)]).
reduce(183,[(81,2)]).
reduce(190,[(27,1)]).
reduce(191,[(29,1)]).
reduce(192,[(132,2)]).
reduce(194,[(137,2)]).
reduce(195,[(36,1)]).
reduce(196,[(37,1)]).
reduce(198,[(35,1),(127,2)]).
reduce(199,[(123,2)]).
reduce(202,[(27,1)]).
reduce(203,[(247,2)]).
reduce(204,[(246,2)]).
reduce(205,[(244,2)]).
reduce(206,[(230,2)]).
reduce(207,[(111,1),(159,1),(229,2),(109,1),(110,1)]).
reduce(208,[(19,2)]).
reduce(209,[(156,2)]).
reduce(210,[(109,1),(64,2)]).
reduce(211,[(161,2)]).
reduce(214,[(53,2)]).
reduce(216,[(253,2)]).
reduce(218,[(251,2)]).
reduce(219,[(110,1)]).
reduce(220,[(250,2)]).
reduce(221,[(55,1),(50,1)]).
reduce(223,[(35,1)]).
reduce(225,[(50,1),(150,2)]).
reduce(226,[(60,2)]).
reduce(227,[(70,2)]).
reduce(228,[(81,2),(83,3)]).
reduce(230,[(157,2)]).
reduce(232,[(35,1),(154,2)]).
reduce(233,[(152,2)]).
reduce(234,[(254,2)]).
reduce(235,[(255,2)]).
reduce(236,[(41,2)]).
reduce(237,[(42,2)]).
reduce(238,[(43,2)]).
reduce(239,[(128,3)]).
reduce(241,[(11,2)]).
reduce(242,[(22,2)]).
reduce(243,[(21,2)]).
reduce(244,[(23,2)]).
reduce(245,[(52,1),(228,1)]).
reduce(248,[(143,3)]).
reduce(249,[(46,3)]).
reduce(250,[(81,2),(96,3)]).
reduce(251,[(159,1),(160,2)]).
reduce(253,[(9,3)]).
reduce(254,[(109,1)]).
reduce(255,[(116,1),(25,2)]).
reduce(256,[(117,1)]).
reduce(257,[(135,3)]).
reduce(258,[(51,2),(50,1)]).
reduce(259,[(240,3),(104,2)]).
reduce(260,[(116,1)]).
reduce(261,[(232,3)]).
reduce(262,[(27,1)]).
reduce(263,[(241,3)]).
reduce(264,[(243,3)]).
reduce(265,[(237,3)]).
reduce(266,[(238,3)]).
reduce(267,[(242,3),(55,1)]).
reduce(268,[(111,1)]).
reduce(269,[(234,3)]).
reduce(272,[(122,2)]).
reduce(273,[(120,2)]).
reduce(274,[(200,3),(104,2)]).
reduce(275,[(176,3)]).
reduce(276,[(203,3)]).
reduce(277,[(209,3)]).
reduce(278,[(191,3)]).
reduce(279,[(194,3)]).
reduce(280,[(206,3),(55,1)]).
reduce(281,[(182,3)]).
reduce(283,[(224,3),(104,2)]).
reduce(284,[(216,3)]).
reduce(285,[(225,3)]).
reduce(286,[(227,3)]).
reduce(287,[(221,3)]).
reduce(288,[(222,3)]).
reduce(289,[(226,3),(55,1)]).
reduce(290,[(218,3)]).
reduce(292,[(201,3),(104,2)]).
reduce(293,[(177,3)]).
reduce(294,[(204,3)]).
reduce(295,[(210,3)]).
reduce(296,[(192,3)]).
reduce(297,[(195,3)]).
reduce(298,[(207,3),(55,1)]).
reduce(299,[(183,3)]).
reduce(301,[(202,3),(104,2)]).
reduce(302,[(178,3)]).
reduce(303,[(205,3)]).
reduce(304,[(211,3)]).
reduce(305,[(193,3)]).
reduce(306,[(196,3)]).
reduce(307,[(208,3),(55,1)]).
reduce(308,[(184,3)]).
reduce(310,[(80,3)]).
reduce(311,[(20,3)]).
reduce(312,[(26,3)]).
reduce(313,[(7,3)]).
reduce(314,[(147,3)]).
reduce(315,[(139,3)]).
reduce(316,[(146,3),(50,1)]).
reduce(317,[(101,3)]).
reduce(318,[(82,1),(100,3),(79,2)]).
reduce(319,[(81,2),(85,3)]).
reduce(320,[(81,2),(87,3)]).
reduce(321,[(142,3)]).
reduce(322,[(105,3)]).
reduce(323,[(106,3)]).
reduce(324,[(5,3)]).
reduce(325,[(3,3),(33,2)]).
reduce(327,[(164,1)]).
reduce(328,[(165,1)]).
reduce(329,[(166,1)]).
reduce(330,[(256,1)]).
reduce(331,[(131,3)]).
reduce(332,[(30,2)]).
reduce(333,[(138,3)]).
reduce(335,[(124,3)]).
reduce(336,[(126,3)]).
reduce(337,[(248,3)]).
reduce(338,[(245,3)]).
reduce(340,[(61,3)]).
reduce(341,[(163,3),(35,1),(127,2)]).
reduce(342,[(162,3)]).
reduce(343,[(54,3)]).
reduce(344,[(252,3)]).
reduce(345,[(56,2)]).
reduce(346,[(57,2),(50,1)]).
reduce(347,[(149,3)]).
reduce(348,[(151,3)]).
reduce(349,[(35,1),(155,3),(127,2)]).
reduce(350,[(158,3)]).
reduce(351,[(153,3)]).
reduce(353,[(130,4)]).
reduce(354,[(113,4)]).
reduce(355,[(12,3)]).
reduce(356,[(140,4)]).
reduce(357,[(144,4),(50,1)]).
reduce(359,[(115,4)]).
reduce(360,[(235,4)]).
reduce(361,[(121,3)]).
reduce(362,[(185,4)]).
reduce(363,[(219,4)]).
reduce(364,[(186,4)]).
reduce(365,[(187,4)]).
reduce(366,[(148,4)]).
reduce(367,[(81,2),(99,4)]).
reduce(368,[(260,2)]).
reduce(369,[(170,2),(116,1)]).
reduce(370,[(111,1),(117,1),(109,1),(110,1)]).
reduce(371,[(257,2)]).
reduce(372,[(171,2),(116,1)]).
reduce(373,[(111,1),(117,1),(109,1),(110,1)]).
reduce(374,[(258,2)]).
reduce(375,[(172,2),(116,1)]).
reduce(376,[(111,1),(117,1),(109,1),(110,1)]).
reduce(377,[(259,2)]).
reduce(378,[(125,4)]).
reduce(379,[(62,4)]).
reduce(380,[(129,5)]).
reduce(381,[(141,5)]).
reduce(382,[(145,5),(50,1)]).
reduce(0,[]).
reduce(1,[]).
reduce(2,[]).
reduce(3,[]).
reduce(5,[]).
reduce(6,[]).
reduce(10,[]).
reduce(17,[]).
reduce(19,[]).
reduce(21,[]).
reduce(29,[]).
reduce(32,[]).
reduce(33,[]).
reduce(34,[]).
reduce(35,[]).
reduce(38,[]).
reduce(42,[]).
reduce(46,[]).
reduce(48,[]).
reduce(53,[]).
reduce(58,[]).
reduce(59,[]).
reduce(60,[]).
reduce(61,[]).
reduce(63,[]).
reduce(65,[]).
reduce(73,[]).
reduce(80,[]).
reduce(84,[]).
reduce(85,[]).
reduce(88,[]).
reduce(89,[]).
reduce(93,[]).
reduce(94,[]).
reduce(99,[]).
reduce(104,[]).
reduce(107,[]).
reduce(111,[]).
reduce(112,[]).
reduce(114,[]).
reduce(116,[]).
reduce(120,[]).
reduce(121,[]).
reduce(127,[]).
reduce(129,[]).
reduce(133,[]).
reduce(134,[]).
reduce(136,[]).
reduce(138,[]).
reduce(142,[]).
reduce(143,[]).
reduce(146,[]).
reduce(148,[]).
reduce(152,[]).
reduce(153,[]).
reduce(156,[]).
reduce(158,[]).
reduce(162,[]).
reduce(163,[]).
reduce(170,[]).
reduce(172,[]).
reduce(173,[]).
reduce(174,[]).
reduce(181,[]).
reduce(184,[]).
reduce(185,[]).
reduce(186,[]).
reduce(187,[]).
reduce(188,[]).
reduce(189,[]).
reduce(193,[]).
reduce(197,[]).
reduce(200,[]).
reduce(201,[]).
reduce(212,[]).
reduce(213,[]).
reduce(215,[]).
reduce(217,[]).
reduce(222,[]).
reduce(224,[]).
reduce(229,[]).
reduce(231,[]).
reduce(240,[]).
reduce(246,[]).
reduce(247,[]).
reduce(252,[]).
reduce(270,[]).
reduce(271,[]).
reduce(282,[]).
reduce(291,[]).
reduce(300,[]).
reduce(309,[]).
reduce(326,[]).
reduce(334,[]).
reduce(339,[]).
reduce(352,[]).
reduce(358,[]).
reduce(383,[]).


% Main Input
input(_IN,[],ISL,OSL,ITL,OTL) :-
	!, OTL=ITL, OSL=ISL.
input([_S],_,ISL,OSL,ITL,OTL) :-
	!, OTL=ITL, OSL=ISL.
input([_P,[vbn,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	vbn(IStk,OStk,[vbn,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[vbg,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	vbg(IStk,OStk,[vbg,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[ex,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	ex(IStk,OStk,[ex,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[rp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	rp(IStk,OStk,[rp,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[cd,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	cd(IStk,OStk,[cd,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[dollar,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	dollar(IStk,OStk,[dollar,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[wp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	wp(IStk,OStk,[wp,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[psp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	psp(IStk,OStk,[psp,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[prp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	prp(IStk,OStk,[prp,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[nnps,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	nnps(IStk,OStk,[nnps,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[nnp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	nnp(IStk,OStk,[nnp,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[pos,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	pos(IStk,OStk,[pos,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[nns,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	nns(IStk,OStk,[nns,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[nn,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	nn(IStk,OStk,[nn,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[to,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	to(IStk,OStk,[to,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[vb,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	vb(IStk,OStk,[vb,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[pdt,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	pdt(IStk,OStk,[pdt,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[vbz,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	vbz(IStk,OStk,[vbz,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[vbp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	vbp(IStk,OStk,[vbp,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[vbd,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	vbd(IStk,OStk,[vbd,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[md,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	md(IStk,OStk,[md,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[rbr,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	rbr(IStk,OStk,[rbr,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[rbs,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	rbs(IStk,OStk,[rbs,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[rb,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	rb(IStk,OStk,[rb,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[dt,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	dt(IStk,OStk,[dt,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[wdt,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	wdt(IStk,OStk,[wdt,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[wrb,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	wrb(IStk,OStk,[wrb,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[jjs,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	jjs(IStk,OStk,[jjs,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[jj,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	jj(IStk,OStk,[jj,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[jjr,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	jjr(IStk,OStk,[jjr,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[in,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	in(IStk,OStk,[in,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[uh,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	uh(IStk,OStk,[uh,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[comma,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	comma(IStk,OStk,[comma,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[cc,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	cc(IStk,OStk,[cc,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[null,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	null(IStk,OStk,[null,Word],IN,ISL,ISL1,ITL,ITL1),
	IN=[Pos|_],
	insert_stack(Pos,OStk,ISL1,ISL2),
	input(IN,OStk,ISL2,OSL,ITL1,OTL).
input([_P,[adjcomp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	adjcomp(IStk,OStk,[adjcomp,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[adjcpt,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	adjcpt(IStk,OStk,[adjcpt,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[adjp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	adjp(IStk,OStk,[adjp,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[advp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	advp(IStk,OStk,[advp,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[aux,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	aux(IStk,OStk,[aux,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[auxd,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	auxd(IStk,OStk,[auxd,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[bep,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	bep(IStk,OStk,[bep,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[ddet,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	ddet(IStk,OStk,[ddet,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[detq,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	detq(IStk,OStk,[detq,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[dop,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	dop(IStk,OStk,[dop,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[gerund,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	gerund(IStk,OStk,[gerund,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[havep,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	havep(IStk,OStk,[havep,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[infinitive,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	infinitive(IStk,OStk,[infinitive,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[infinitive1,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	infinitive1(IStk,OStk,[infinitive1,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[infinitrel,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	infinitrel(IStk,OStk,[infinitrel,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[ncomp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	ncomp(IStk,OStk,[ncomp,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[nomhd,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	nomhd(IStk,OStk,[nomhd,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[np,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	np(IStk,OStk,[np,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[obj,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	obj(IStk,OStk,[obj,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[obj1,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	obj1(IStk,OStk,[obj1,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[obj2,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	obj2(IStk,OStk,[obj2,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[pp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	pp(IStk,OStk,[pp,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[pred,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	pred(IStk,OStk,[pred,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[s,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	s(IStk,OStk,[s,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[sdec,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	sdec(IStk,OStk,[sdec,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[sentence,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	sentence(IStk,OStk,[sentence,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[simp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	simp(IStk,OStk,[simp,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[sq,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	sq(IStk,OStk,[sq,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[srel,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	srel(IStk,OStk,[srel,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[subj,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	subj(IStk,OStk,[subj,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[thancomp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	thancomp(IStk,OStk,[thancomp,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[vp,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	vp(IStk,OStk,[vp,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[vp2,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	vp2(IStk,OStk,[vp2,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
input([_P,[vp3,Word]|IN],IStk,ISL,OSL,ITL,OTL) :-
	vp3(IStk,OStk,[vp3,Word]),
	input(IN,OStk,ISL,OSL,ITL,OTL).
%input(_L,_IStk,ISL,OSL,ITL,OTL) :-
%	!, OTL=ITL, OSL=ISL.

% Main Clause
null([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
null([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	null0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	null(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
vbn([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
vbn([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	vbn0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	vbn(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
vbg([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
vbg([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	vbg0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	vbg(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
ex([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
ex([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	ex0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	ex(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
rp([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
rp([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	rp0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	rp(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
cd([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
cd([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	cd0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	cd(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
dollar([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
dollar([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	dollar0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	dollar(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
wp([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
wp([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	wp0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	wp(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
psp([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
psp([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	psp0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	psp(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
prp([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
prp([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	prp0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	prp(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
nnps([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
nnps([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	nnps0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	nnps(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
nnp([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
nnp([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	nnp0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	nnp(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
pos([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
pos([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	pos0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	pos(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
nns([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
nns([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	nns0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	nns(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
nn([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
nn([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	nn0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	nn(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
to([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
to([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	to0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	to(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
vb([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
vb([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	vb0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	vb(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
pdt([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
pdt([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	pdt0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	pdt(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
vbz([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
vbz([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	vbz0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	vbz(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
vbp([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
vbp([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	vbp0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	vbp(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
vbd([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
vbd([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	vbd0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	vbd(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
md([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
md([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	md0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	md(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
rbr([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
rbr([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	rbr0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	rbr(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
rbs([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
rbs([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	rbs0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	rbs(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
rb([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
rb([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	rb0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	rb(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
dt([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
dt([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	dt0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	dt(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
wdt([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
wdt([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	wdt0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	wdt(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
wrb([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
wrb([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	wrb0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	wrb(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
jjs([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
jjs([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	jjs0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	jjs(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
jj([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
jj([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	jj0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	jj(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
jjr([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
jjr([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	jjr0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	jjr(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
in([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
in([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	in0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	in(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
uh([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
uh([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	uh0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	uh(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
comma([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
comma([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	comma0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	comma(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
cc([],OStk,_T,_IN,ISL,OSL,ITL,OTL) :-
	!, OStk=[], OSL=ISL, OTL=ITL.
cc([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL)  :-
	cc0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1),
	cc(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
adjcomp([],OStk,_T) :-
	!, OStk=[].
adjcomp([[S|I]|IStk],OStk,T)  :-
	adjcomp0(S,[S|I],OStk2,T),
	adjcomp(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
adjcpt([],OStk,_T) :-
	!, OStk=[].
adjcpt([[S|I]|IStk],OStk,T)  :-
	adjcpt0(S,[S|I],OStk2,T),
	adjcpt(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
adjp([],OStk,_T) :-
	!, OStk=[].
adjp([[S|I]|IStk],OStk,T)  :-
	adjp0(S,[S|I],OStk2,T),
	adjp(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
advp([],OStk,_T) :-
	!, OStk=[].
advp([[S|I]|IStk],OStk,T)  :-
	advp0(S,[S|I],OStk2,T),
	advp(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
aux([],OStk,_T) :-
	!, OStk=[].
aux([[S|I]|IStk],OStk,T)  :-
	aux0(S,[S|I],OStk2,T),
	aux(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
auxd([],OStk,_T) :-
	!, OStk=[].
auxd([[S|I]|IStk],OStk,T)  :-
	auxd0(S,[S|I],OStk2,T),
	auxd(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
bep([],OStk,_T) :-
	!, OStk=[].
bep([[S|I]|IStk],OStk,T)  :-
	bep0(S,[S|I],OStk2,T),
	bep(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
ddet([],OStk,_T) :-
	!, OStk=[].
ddet([[S|I]|IStk],OStk,T)  :-
	ddet0(S,[S|I],OStk2,T),
	ddet(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
detq([],OStk,_T) :-
	!, OStk=[].
detq([[S|I]|IStk],OStk,T)  :-
	detq0(S,[S|I],OStk2,T),
	detq(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
dop([],OStk,_T) :-
	!, OStk=[].
dop([[S|I]|IStk],OStk,T)  :-
	dop0(S,[S|I],OStk2,T),
	dop(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
gerund([],OStk,_T) :-
	!, OStk=[].
gerund([[S|I]|IStk],OStk,T)  :-
	gerund0(S,[S|I],OStk2,T),
	gerund(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
havep([],OStk,_T) :-
	!, OStk=[].
havep([[S|I]|IStk],OStk,T)  :-
	havep0(S,[S|I],OStk2,T),
	havep(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
infinitive([],OStk,_T) :-
	!, OStk=[].
infinitive([[S|I]|IStk],OStk,T)  :-
	infinitive0(S,[S|I],OStk2,T),
	infinitive(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
infinitive1([],OStk,_T) :-
	!, OStk=[].
infinitive1([[S|I]|IStk],OStk,T)  :-
	infinitive10(S,[S|I],OStk2,T),
	infinitive1(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
infinitrel([],OStk,_T) :-
	!, OStk=[].
infinitrel([[S|I]|IStk],OStk,T)  :-
	infinitrel0(S,[S|I],OStk2,T),
	infinitrel(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
ncomp([],OStk,_T) :-
	!, OStk=[].
ncomp([[S|I]|IStk],OStk,T)  :-
	ncomp0(S,[S|I],OStk2,T),
	ncomp(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
nomhd([],OStk,_T) :-
	!, OStk=[].
nomhd([[S|I]|IStk],OStk,T)  :-
	nomhd0(S,[S|I],OStk2,T),
	nomhd(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
np([],OStk,_T) :-
	!, OStk=[].
np([[S|I]|IStk],OStk,T)  :-
	np0(S,[S|I],OStk2,T),
	np(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
obj([],OStk,_T) :-
	!, OStk=[].
obj([[S|I]|IStk],OStk,T)  :-
	obj0(S,[S|I],OStk2,T),
	obj(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
obj1([],OStk,_T) :-
	!, OStk=[].
obj1([[S|I]|IStk],OStk,T)  :-
	obj10(S,[S|I],OStk2,T),
	obj1(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
obj2([],OStk,_T) :-
	!, OStk=[].
obj2([[S|I]|IStk],OStk,T)  :-
	obj20(S,[S|I],OStk2,T),
	obj2(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
pp([],OStk,_T) :-
	!, OStk=[].
pp([[S|I]|IStk],OStk,T)  :-
	pp0(S,[S|I],OStk2,T),
	pp(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
pred([],OStk,_T) :-
	!, OStk=[].
pred([[S|I]|IStk],OStk,T)  :-
	pred0(S,[S|I],OStk2,T),
	pred(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
s([],OStk,_T) :-
	!, OStk=[].
s([[S|I]|IStk],OStk,T)  :-
	s0(S,[S|I],OStk2,T),
	s(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
sdec([],OStk,_T) :-
	!, OStk=[].
sdec([[S|I]|IStk],OStk,T)  :-
	sdec0(S,[S|I],OStk2,T),
	sdec(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
sentence([],OStk,_T) :-
	!, OStk=[].
sentence([[S|I]|IStk],OStk,T)  :-
	sentence0(S,[S|I],OStk2,T),
	sentence(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
simp([],OStk,_T) :-
	!, OStk=[].
simp([[S|I]|IStk],OStk,T)  :-
	simp0(S,[S|I],OStk2,T),
	simp(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
sq([],OStk,_T) :-
	!, OStk=[].
sq([[S|I]|IStk],OStk,T)  :-
	sq0(S,[S|I],OStk2,T),
	sq(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
srel([],OStk,_T) :-
	!, OStk=[].
srel([[S|I]|IStk],OStk,T)  :-
	srel0(S,[S|I],OStk2,T),
	srel(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
subj([],OStk,_T) :-
	!, OStk=[].
subj([[S|I]|IStk],OStk,T)  :-
	subj0(S,[S|I],OStk2,T),
	subj(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
thancomp([],OStk,_T) :-
	!, OStk=[].
thancomp([[S|I]|IStk],OStk,T)  :-
	thancomp0(S,[S|I],OStk2,T),
	thancomp(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
vp([],OStk,_T) :-
	!, OStk=[].
vp([[S|I]|IStk],OStk,T)  :-
	vp0(S,[S|I],OStk2,T),
	vp(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
vp2([],OStk,_T) :-
	!, OStk=[].
vp2([[S|I]|IStk],OStk,T)  :-
	vp20(S,[S|I],OStk2,T),
	vp2(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.
vp3([],OStk,_T) :-
	!, OStk=[].
vp3([[S|I]|IStk],OStk,T)  :-
	vp30(S,[S|I],OStk2,T),
	vp3(IStk,OStk1,T),
	append(OStk1,OStk2,OStk3),!,
	merge_stack(OStk3,OStk),!.


% Reduce-Goto Clause
re(1,TR,Stk,OStk) :-
	!,sentence(Stk,OStk,[sentence,TR]).
re(2,TR,Stk,OStk) :-
	!,s(Stk,OStk,[s,TR]).
re(3,TR,Stk,OStk) :-
	!,s(Stk,OStk,[s,TR]).
re(4,TR,Stk,OStk) :-
	!,s(Stk,OStk,[s,TR]).
re(5,TR,Stk,OStk) :-
	!,s(Stk,OStk,[s,TR]).
re(6,TR,Stk,OStk) :-
	!,s(Stk,OStk,[s,TR]).
re(7,TR,Stk,OStk) :-
	!,s(Stk,OStk,[s,TR]).
re(8,TR,Stk,OStk) :-
	!,s(Stk,OStk,[s,TR]).
re(9,TR,Stk,OStk) :-
	!,s(Stk,OStk,[s,TR]).
re(10,TR,Stk,OStk) :-
	!,adjcomp(Stk,OStk,[adjcomp,TR]).
re(11,TR,Stk,OStk) :-
	!,adjcomp(Stk,OStk,[adjcomp,TR]).
re(12,TR,Stk,OStk) :-
	!,adjcomp(Stk,OStk,[adjcomp,TR]).
re(13,TR,Stk,OStk) :-
	!,adjcpt(Stk,OStk,[adjcpt,TR]).
re(14,TR,Stk,OStk) :-
	!,adjcpt(Stk,OStk,[adjcpt,TR]).
re(15,TR,Stk,OStk) :-
	!,adjcpt(Stk,OStk,[adjcpt,TR]).
re(16,TR,Stk,OStk) :-
	!,adjp(Stk,OStk,[adjp,TR]).
re(17,TR,Stk,OStk) :-
	!,adjp(Stk,OStk,[adjp,TR]).
re(18,TR,Stk,OStk) :-
	!,adjp(Stk,OStk,[adjp,TR]).
re(19,TR,Stk,OStk) :-
	!,adjp(Stk,OStk,[adjp,TR]).
re(20,TR,Stk,OStk) :-
	!,adjp(Stk,OStk,[adjp,TR]).
re(21,TR,Stk,OStk) :-
	!,adjp(Stk,OStk,[adjp,TR]).
re(22,TR,Stk,OStk) :-
	!,adjp(Stk,OStk,[adjp,TR]).
re(23,TR,Stk,OStk) :-
	!,adjp(Stk,OStk,[adjp,TR]).
re(24,TR,Stk,OStk) :-
	!,adjp(Stk,OStk,[adjp,TR]).
re(25,TR,Stk,OStk) :-
	!,adjp(Stk,OStk,[adjp,TR]).
re(26,TR,Stk,OStk) :-
	!,adjp(Stk,OStk,[adjp,TR]).
re(27,TR,Stk,OStk) :-
	!,advp(Stk,OStk,[advp,TR]).
re(28,TR,Stk,OStk) :-
	!,advp(Stk,OStk,[advp,TR]).
re(29,TR,Stk,OStk) :-
	!,advp(Stk,OStk,[advp,TR]).
re(30,TR,Stk,OStk) :-
	!,advp(Stk,OStk,[advp,TR]).
re(31,TR,Stk,OStk) :-
	!,advp(Stk,OStk,[advp,TR]).
re(32,TR,Stk,OStk) :-
	!,advp(Stk,OStk,[advp,TR]).
re(33,TR,Stk,OStk) :-
	!,advp(Stk,OStk,[advp,TR]).
re(34,TR,Stk,OStk) :-
	!,advp(Stk,OStk,[advp,TR]).
re(35,TR,Stk,OStk) :-
	!,aux(Stk,OStk,[aux,TR]).
re(36,TR,Stk,OStk) :-
	!,aux(Stk,OStk,[aux,TR]).
re(37,TR,Stk,OStk) :-
	!,auxd(Stk,OStk,[auxd,TR]).
re(38,TR,Stk,OStk) :-
	!,bep(Stk,OStk,[bep,TR]).
re(39,TR,Stk,OStk) :-
	!,bep(Stk,OStk,[bep,TR]).
re(40,TR,Stk,OStk) :-
	!,bep(Stk,OStk,[bep,TR]).
re(41,TR,Stk,OStk) :-
	!,bep(Stk,OStk,[bep,TR]).
re(42,TR,Stk,OStk) :-
	!,bep(Stk,OStk,[bep,TR]).
re(43,TR,Stk,OStk) :-
	!,bep(Stk,OStk,[bep,TR]).
re(44,TR,Stk,OStk) :-
	!,ddet(Stk,OStk,[ddet,TR]).
re(45,TR,Stk,OStk) :-
	!,ddet(Stk,OStk,[ddet,TR]).
re(46,TR,Stk,OStk) :-
	!,ddet(Stk,OStk,[ddet,TR]).
re(47,TR,Stk,OStk) :-
	!,detq(Stk,OStk,[detq,TR]).
re(48,TR,Stk,OStk) :-
	!,dop(Stk,OStk,[dop,TR]).
re(49,TR,Stk,OStk) :-
	!,dop(Stk,OStk,[dop,TR]).
re(50,TR,Stk,OStk) :-
	!,gerund(Stk,OStk,[gerund,TR]).
re(51,TR,Stk,OStk) :-
	!,gerund(Stk,OStk,[gerund,TR]).
re(52,TR,Stk,OStk) :-
	!,havep(Stk,OStk,[havep,TR]).
re(53,TR,Stk,OStk) :-
	!,infinitive(Stk,OStk,[infinitive,TR]).
re(54,TR,Stk,OStk) :-
	!,infinitive(Stk,OStk,[infinitive,TR]).
re(55,TR,Stk,OStk) :-
	!,infinitive1(Stk,OStk,[infinitive1,TR]).
re(56,TR,Stk,OStk) :-
	!,infinitive1(Stk,OStk,[infinitive1,TR]).
re(57,TR,Stk,OStk) :-
	!,infinitive1(Stk,OStk,[infinitive1,TR]).
re(58,TR,Stk,OStk) :-
	!,infinitrel(Stk,OStk,[infinitrel,TR]).
re(59,TR,Stk,OStk) :-
	!,infinitrel(Stk,OStk,[infinitrel,TR]).
re(60,TR,Stk,OStk) :-
	!,infinitrel(Stk,OStk,[infinitrel,TR]).
re(61,TR,Stk,OStk) :-
	!,infinitrel(Stk,OStk,[infinitrel,TR]).
re(62,TR,Stk,OStk) :-
	!,infinitrel(Stk,OStk,[infinitrel,TR]).
re(63,TR,Stk,OStk) :-
	!,ncomp(Stk,OStk,[ncomp,TR]).
re(64,TR,Stk,OStk) :-
	!,ncomp(Stk,OStk,[ncomp,TR]).
re(65,TR,Stk,OStk) :-
	!,ncomp(Stk,OStk,[ncomp,TR]).
re(66,TR,Stk,OStk) :-
	!,ncomp(Stk,OStk,[ncomp,TR]).
re(67,TR,Stk,OStk) :-
	!,ncomp(Stk,OStk,[ncomp,TR]).
re(68,TR,Stk,OStk) :-
	!,ncomp(Stk,OStk,[ncomp,TR]).
re(69,TR,Stk,OStk) :-
	!,ncomp(Stk,OStk,[ncomp,TR]).
re(70,TR,Stk,OStk) :-
	!,ncomp(Stk,OStk,[ncomp,TR]).
re(71,TR,Stk,OStk) :-
	!,nomhd(Stk,OStk,[nomhd,TR]).
re(72,TR,Stk,OStk) :-
	!,nomhd(Stk,OStk,[nomhd,TR]).
re(73,TR,Stk,OStk) :-
	!,nomhd(Stk,OStk,[nomhd,TR]).
re(74,TR,Stk,OStk) :-
	!,nomhd(Stk,OStk,[nomhd,TR]).
re(75,TR,Stk,OStk) :-
	!,nomhd(Stk,OStk,[nomhd,TR]).
re(76,TR,Stk,OStk) :-
	!,nomhd(Stk,OStk,[nomhd,TR]).
re(77,TR,Stk,OStk) :-
	!,nomhd(Stk,OStk,[nomhd,TR]).
re(78,TR,Stk,OStk) :-
	!,nomhd(Stk,OStk,[nomhd,TR]).
re(79,TR,Stk,OStk) :-
	!,nomhd(Stk,OStk,[nomhd,TR]).
re(80,TR,Stk,OStk) :-
	!,nomhd(Stk,OStk,[nomhd,TR]).
re(81,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(82,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(83,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(84,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(85,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(86,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(87,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(88,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(89,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(90,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(91,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(92,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(93,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(94,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(95,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(96,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(97,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(98,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(99,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(100,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(101,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(102,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(103,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(104,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(105,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(106,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(107,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(108,TR,Stk,OStk) :-
	!,np(Stk,OStk,[np,TR]).
re(109,TR,Stk,OStk) :-
	!,obj(Stk,OStk,[obj,TR]).
re(110,TR,Stk,OStk) :-
	!,obj1(Stk,OStk,[obj1,TR]).
re(111,TR,Stk,OStk) :-
	!,obj2(Stk,OStk,[obj2,TR]).
re(112,TR,Stk,OStk) :-
	!,pp(Stk,OStk,[pp,TR]).
re(113,TR,Stk,OStk) :-
	!,pp(Stk,OStk,[pp,TR]).
re(114,TR,Stk,OStk) :-
	!,pp(Stk,OStk,[pp,TR]).
re(115,TR,Stk,OStk) :-
	!,pp(Stk,OStk,[pp,TR]).
re(116,TR,Stk,OStk) :-
	!,pred(Stk,OStk,[pred,TR]).
re(117,TR,Stk,OStk) :-
	!,pred(Stk,OStk,[pred,TR]).
re(118,TR,Stk,OStk) :-
	!,pred(Stk,OStk,[pred,TR]).
re(119,TR,Stk,OStk) :-
	!,pred(Stk,OStk,[pred,TR]).
re(120,TR,Stk,OStk) :-
	!,pred(Stk,OStk,[pred,TR]).
re(121,TR,Stk,OStk) :-
	!,pred(Stk,OStk,[pred,TR]).
re(122,TR,Stk,OStk) :-
	!,pred(Stk,OStk,[pred,TR]).
re(123,TR,Stk,OStk) :-
	!,sdec(Stk,OStk,[sdec,TR]).
re(124,TR,Stk,OStk) :-
	!,sdec(Stk,OStk,[sdec,TR]).
re(125,TR,Stk,OStk) :-
	!,sdec(Stk,OStk,[sdec,TR]).
re(126,TR,Stk,OStk) :-
	!,sdec(Stk,OStk,[sdec,TR]).
re(127,TR,Stk,OStk) :-
	!,sdec(Stk,OStk,[sdec,TR]).
re(128,TR,Stk,OStk) :-
	!,sdec(Stk,OStk,[sdec,TR]).
re(129,TR,Stk,OStk) :-
	!,sdec(Stk,OStk,[sdec,TR]).
re(130,TR,Stk,OStk) :-
	!,sdec(Stk,OStk,[sdec,TR]).
re(131,TR,Stk,OStk) :-
	!,sdec(Stk,OStk,[sdec,TR]).
re(132,TR,Stk,OStk) :-
	!,sdec(Stk,OStk,[sdec,TR]).
re(133,TR,Stk,OStk) :-
	!,simp(Stk,OStk,[simp,TR]).
re(134,TR,Stk,OStk) :-
	!,simp(Stk,OStk,[simp,TR]).
re(135,TR,Stk,OStk) :-
	!,simp(Stk,OStk,[simp,TR]).
re(136,TR,Stk,OStk) :-
	!,simp(Stk,OStk,[simp,TR]).
re(137,TR,Stk,OStk) :-
	!,simp(Stk,OStk,[simp,TR]).
re(138,TR,Stk,OStk) :-
	!,simp(Stk,OStk,[simp,TR]).
re(139,TR,Stk,OStk) :-
	!,sq(Stk,OStk,[sq,TR]).
re(140,TR,Stk,OStk) :-
	!,sq(Stk,OStk,[sq,TR]).
re(141,TR,Stk,OStk) :-
	!,sq(Stk,OStk,[sq,TR]).
re(142,TR,Stk,OStk) :-
	!,sq(Stk,OStk,[sq,TR]).
re(143,TR,Stk,OStk) :-
	!,sq(Stk,OStk,[sq,TR]).
re(144,TR,Stk,OStk) :-
	!,sq(Stk,OStk,[sq,TR]).
re(145,TR,Stk,OStk) :-
	!,sq(Stk,OStk,[sq,TR]).
re(146,TR,Stk,OStk) :-
	!,sq(Stk,OStk,[sq,TR]).
re(147,TR,Stk,OStk) :-
	!,sq(Stk,OStk,[sq,TR]).
re(148,TR,Stk,OStk) :-
	!,sq(Stk,OStk,[sq,TR]).
re(149,TR,Stk,OStk) :-
	!,srel(Stk,OStk,[srel,TR]).
re(150,TR,Stk,OStk) :-
	!,srel(Stk,OStk,[srel,TR]).
re(151,TR,Stk,OStk) :-
	!,srel(Stk,OStk,[srel,TR]).
re(152,TR,Stk,OStk) :-
	!,srel(Stk,OStk,[srel,TR]).
re(153,TR,Stk,OStk) :-
	!,srel(Stk,OStk,[srel,TR]).
re(154,TR,Stk,OStk) :-
	!,srel(Stk,OStk,[srel,TR]).
re(155,TR,Stk,OStk) :-
	!,srel(Stk,OStk,[srel,TR]).
re(156,TR,Stk,OStk) :-
	!,srel(Stk,OStk,[srel,TR]).
re(157,TR,Stk,OStk) :-
	!,srel(Stk,OStk,[srel,TR]).
re(158,TR,Stk,OStk) :-
	!,srel(Stk,OStk,[srel,TR]).
re(159,TR,Stk,OStk) :-
	!,subj(Stk,OStk,[subj,TR]).
re(160,TR,Stk,OStk) :-
	!,thancomp(Stk,OStk,[thancomp,TR]).
re(161,TR,Stk,OStk) :-
	!,thancomp(Stk,OStk,[thancomp,TR]).
re(162,TR,Stk,OStk) :-
	!,thancomp(Stk,OStk,[thancomp,TR]).
re(163,TR,Stk,OStk) :-
	!,thancomp(Stk,OStk,[thancomp,TR]).
re(164,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(165,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(166,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(167,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(168,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(169,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(170,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(171,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(172,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(173,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(174,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(175,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(176,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(177,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(178,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(179,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(180,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(181,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(182,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(183,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(184,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(185,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(186,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(187,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(188,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(189,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(190,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(191,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(192,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(193,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(194,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(195,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(196,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(197,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(198,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(199,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(200,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(201,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(202,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(203,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(204,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(205,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(206,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(207,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(208,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(209,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(210,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(211,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(212,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(213,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(214,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(215,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(216,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(217,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(218,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(219,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(220,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(221,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(222,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(223,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(224,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(225,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(226,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(227,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(228,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(229,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(230,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(231,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(232,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(233,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(234,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(235,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(236,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(237,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(238,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(239,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(240,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(241,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(242,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(243,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(244,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(245,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(246,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(247,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(248,TR,Stk,OStk) :-
	!,vp(Stk,OStk,[vp,TR]).
re(249,TR,Stk,OStk) :-
	!,vp2(Stk,OStk,[vp2,TR]).
re(250,TR,Stk,OStk) :-
	!,vp2(Stk,OStk,[vp2,TR]).
re(251,TR,Stk,OStk) :-
	!,vp2(Stk,OStk,[vp2,TR]).
re(252,TR,Stk,OStk) :-
	!,vp2(Stk,OStk,[vp2,TR]).
re(253,TR,Stk,OStk) :-
	!,vp2(Stk,OStk,[vp2,TR]).
re(254,TR,Stk,OStk) :-
	!,vp2(Stk,OStk,[vp2,TR]).
re(255,TR,Stk,OStk) :-
	!,vp2(Stk,OStk,[vp2,TR]).
re(256,TR,Stk,OStk) :-
	!,vp3(Stk,OStk,[vp3,TR]).
re(257,TR,Stk,OStk) :-
	!,vp3(Stk,OStk,[vp3,TR]).
re(258,TR,Stk,OStk) :-
	!,vp3(Stk,OStk,[vp3,TR]).
re(259,TR,Stk,OStk) :-
	!,vp3(Stk,OStk,[vp3,TR]).
re(260,TR,Stk,OStk) :-
	!,vp3(Stk,OStk,[vp3,TR]).


% Actions
% go
adjcpt0(0,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(0,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% go
advp0(0,Stk,OStk,T) :-
	OStk=[[34,T|Stk]].
% go
bep0(0,Stk,OStk,T) :-
	OStk=[[35,T|Stk]].
% sh
cc0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[1,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]],ISL,ISL1),
	  input(IN,[[1,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
cd0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(0,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(0,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
dop0(0,Stk,OStk,T) :-
	OStk=[[38,T|Stk]].
% sh
dt0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(0,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
in0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[6,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[6,T|Stk]],ISL,ISL1),
	  input(IN,[[6,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
md0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[10,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[10,T|Stk]],ISL,ISL1),
	  input(IN,[[10,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(0,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(0,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
pp0(0,Stk,OStk,T) :-
	OStk=[[42,T|Stk]].
% sh
prp0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[18,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[18,T|Stk]],ISL,ISL1),
	  input(IN,[[18,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rbr0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[19,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]],ISL,ISL1),
	  input(IN,[[19,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rbs0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[20,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]],ISL,ISL1),
	  input(IN,[[20,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rp0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[21,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]],ISL,ISL1),
	  input(IN,[[21,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
s0(0,Stk,OStk,T) :-
	OStk=[[31,T|Stk]].
% go
sdec0(0,Stk,OStk,T) :-
	OStk=[[43,T|Stk]].
% go
sentence0(0,Stk,OStk,T) :-
	OStk=[[383,T|Stk]].
% go
simp0(0,Stk,OStk,T) :-
	OStk=[[44,T|Stk]].
% go
sq0(0,Stk,OStk,T) :-
	OStk=[[45,T|Stk]].
% go
subj0(0,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh
uh0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[22,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[22,T|Stk]],ISL,ISL1),
	  input(IN,[[22,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[23,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[23,T|Stk]],ISL,ISL1),
	  input(IN,[[23,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[24,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]],ISL,ISL1),
	  input(IN,[[24,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[26,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]],ISL,ISL1),
	  input(IN,[[26,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[27,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]],ISL,ISL1),
	  input(IN,[[27,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(0,Stk,OStk,T) :-
	OStk=[[47,T|Stk]].
% sh
wdt0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(0,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[30,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[30,T|Stk]],ISL,ISL1),
	  input(IN,[[30,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(1,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(1,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(1,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(1,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(1,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(1,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(1,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
sdec0(1,Stk,OStk,T) :-
	OStk=[[54,T|Stk]].
% go
subj0(1,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh
vb0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(1,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(1,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(2,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[56,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[56,T|Stk]],ISL,ISL1),
	  input(IN,[[56,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
cd0(3,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[57,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[57,T|Stk]],ISL,ISL1),
	  input(IN,[[57,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(4,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(4,Stk,OStk,T) :-
	OStk=[[64,T|Stk]].
% go
bep0(4,Stk,OStk,T) :-
	OStk=[[65,T|Stk]].
% re
cc0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
comma0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[58,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[58,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[58,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
ddet0(4,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(4,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
gerund0(4,Stk,OStk,T) :-
	OStk=[[66,T|Stk]].
% sh/re
in0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[59,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[59,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[59,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(4,Stk,OStk,T) :-
	OStk=[[67,T|Stk]].
% go
infinitrel0(4,Stk,OStk,T) :-
	OStk=[[68,T|Stk]].
% sh/re
jj0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ncomp0(4,Stk,OStk,T) :-
	OStk=[[69,T|Stk]].
% sh/re
nn0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(4,Stk,OStk,T) :-
	OStk=[[70,T|Stk]].
% go
np0(4,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% re
null0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
pdt0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
pp0(4,Stk,OStk,T) :-
	OStk=[[71,T|Stk]].
% sh/re
prp0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[60,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[60,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
srel0(4,Stk,OStk,T) :-
	OStk=[[72,T|Stk]].
% go
subj0(4,Stk,OStk,T) :-
	OStk=[[73,T|Stk]].
% go
thancomp0(4,Stk,OStk,T) :-
	OStk=[[74,T|Stk]].
% sh/re
to0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbn0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	vbn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[62,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[62,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbp0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(4,Stk,OStk,T) :-
	OStk=[[75,T|Stk]].
% go
vp20(4,Stk,OStk,T) :-
	OStk=[[76,T|Stk]].
% sh/re
wdt0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[63,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[63,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[63,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(4,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,44,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
bep0(5,Stk,OStk,T) :-
	OStk=[[80,T|Stk]].
% sh
vbd0(5,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[77,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[77,T|Stk]],ISL,ISL1),
	  input(IN,[[77,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(5,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[78,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[78,T|Stk]],ISL,ISL1),
	  input(IN,[[78,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(5,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[79,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[79,T|Stk]],ISL,ISL1),
	  input(IN,[[79,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(6,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(6,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(6,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(6,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(6,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(6,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(6,Stk,OStk,T) :-
	OStk=[[81,T|Stk]].
% go
obj0(6,Stk,OStk,T) :-
	OStk=[[82,T|Stk]].
% sh
pdt0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
sdec0(6,Stk,OStk,T) :-
	OStk=[[83,T|Stk]].
% go
subj0(6,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh
vb0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(6,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(6,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcomp0(7,Stk,OStk,T) :-
	OStk=[[86,T|Stk]].
% re
cc0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[84,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[84,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[84,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(7,Stk,OStk,T) :-
	OStk=[[87,T|Stk]].
% re
jj0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[85,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[85,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[85,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
to0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vb0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(7,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,16,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcomp0(8,Stk,OStk,T) :-
	OStk=[[91,T|Stk]].
% go
adjcpt0(8,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(8,Stk,OStk,T) :-
	OStk=[[92,T|Stk]].
% go
detq0(8,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% sh
dt0(8,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[88,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]],ISL,ISL1),
	  input(IN,[[88,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh/re
in0(8,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,13,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[84,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[84,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[84,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(8,Stk,OStk,T) :-
	OStk=[[87,T|Stk]].
% sh
jj0(8,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(8,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(8,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(8,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[89,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[89,T|Stk]],ISL,ISL1),
	  input(IN,[[89,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
to0(8,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[61,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]],ISL,ISL1),
	  input(IN,[[61,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wdt0(8,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[90,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]],ISL,ISL1),
	  input(IN,[[90,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(8,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
cc0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(9,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,17,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(10,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(10,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(10,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(10,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(10,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(10,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(10,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
subj0(10,Stk,OStk,T) :-
	OStk=[[94,T|Stk]].
% sh
vb0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(10,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(10,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
cc0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
pos0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[95,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[95,T|Stk]],ISL,ISL1),
	  input(IN,[[95,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
prp0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(11,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,71,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
pos0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[96,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[96,T|Stk]],ISL,ISL1),
	  input(IN,[[96,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
prp0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(12,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,75,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
pos0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[97,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[97,T|Stk]],ISL,ISL1),
	  input(IN,[[97,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
prp0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(13,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,76,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
pos0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[98,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[98,T|Stk]],ISL,ISL1),
	  input(IN,[[98,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
prp0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(14,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,72,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[99,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[99,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[99,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(15,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,45,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(16,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(16,Stk,OStk,T) :-
	OStk=[[100,T|Stk]].
% go
bep0(16,Stk,OStk,T) :-
	OStk=[[65,T|Stk]].
% re
cc0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
comma0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[58,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[58,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[58,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
ddet0(16,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(16,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
gerund0(16,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh/re
in0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[59,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[59,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[59,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(16,Stk,OStk,T) :-
	OStk=[[67,T|Stk]].
% go
infinitrel0(16,Stk,OStk,T) :-
	OStk=[[68,T|Stk]].
% sh/re
jj0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ncomp0(16,Stk,OStk,T) :-
	OStk=[[101,T|Stk]].
% sh/re
nn0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(16,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(16,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% re
null0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
pdt0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
pp0(16,Stk,OStk,T) :-
	OStk=[[71,T|Stk]].
% sh/re
prp0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[60,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[60,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
srel0(16,Stk,OStk,T) :-
	OStk=[[72,T|Stk]].
% go
subj0(16,Stk,OStk,T) :-
	OStk=[[73,T|Stk]].
% go
thancomp0(16,Stk,OStk,T) :-
	OStk=[[74,T|Stk]].
% sh/re
to0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbn0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	vbn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[62,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[62,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbp0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(16,Stk,OStk,T) :-
	OStk=[[75,T|Stk]].
% go
vp20(16,Stk,OStk,T) :-
	OStk=[[76,T|Stk]].
% sh/re
wdt0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[63,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[63,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[63,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(16,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,94,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(17,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(17,Stk,OStk,T) :-
	OStk=[[100,T|Stk]].
% go
bep0(17,Stk,OStk,T) :-
	OStk=[[65,T|Stk]].
% sh
cd0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
comma0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[58,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[58,T|Stk]],ISL,ISL1),
	  input(IN,[[58,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(17,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(17,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(17,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
in0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[59,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[59,T|Stk]],ISL,ISL1),
	  input(IN,[[59,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
infinitive0(17,Stk,OStk,T) :-
	OStk=[[67,T|Stk]].
% go
infinitrel0(17,Stk,OStk,T) :-
	OStk=[[68,T|Stk]].
% sh
jj0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ncomp0(17,Stk,OStk,T) :-
	OStk=[[102,T|Stk]].
% sh
nn0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(17,Stk,OStk,T) :-
	OStk=[[103,T|Stk]].
% go
np0(17,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
pp0(17,Stk,OStk,T) :-
	OStk=[[71,T|Stk]].
% sh
prp0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[60,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]],ISL,ISL1),
	  input(IN,[[60,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rp0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[21,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]],ISL,ISL1),
	  input(IN,[[21,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
srel0(17,Stk,OStk,T) :-
	OStk=[[72,T|Stk]].
% go
subj0(17,Stk,OStk,T) :-
	OStk=[[73,T|Stk]].
% go
thancomp0(17,Stk,OStk,T) :-
	OStk=[[74,T|Stk]].
% sh
to0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[61,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]],ISL,ISL1),
	  input(IN,[[61,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[24,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]],ISL,ISL1),
	  input(IN,[[24,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbn0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[62,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]],ISL,ISL1),
	  input(IN,[[62,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[26,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]],ISL,ISL1),
	  input(IN,[[26,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[27,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]],ISL,ISL1),
	  input(IN,[[27,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(17,Stk,OStk,T) :-
	OStk=[[75,T|Stk]].
% go
vp20(17,Stk,OStk,T) :-
	OStk=[[76,T|Stk]].
% sh
wdt0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[63,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[63,T|Stk]],ISL,ISL1),
	  input(IN,[[63,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(17,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(18,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(18,Stk,OStk,T) :-
	OStk=[[105,T|Stk]].
% re
comma0(18,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(18,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% sh
dt0(18,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[88,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]],ISL,ISL1),
	  input(IN,[[88,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(18,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(18,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(18,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(18,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[104,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]],ISL,ISL1),
	  input(IN,[[104,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(18,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(18,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(18,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(18,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(18,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(18,Stk,OStk,T) :-
	OStk=[[106,T|Stk]].
% sh
wdt0(18,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[90,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]],ISL,ISL1),
	  input(IN,[[90,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(18,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
in0(19,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[107,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[107,T|Stk]],ISL,ISL1),
	  input(IN,[[107,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
thancomp0(19,Stk,OStk,T) :-
	OStk=[[108,T|Stk]].
% re
cc0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(20,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,28,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(21,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(21,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(21,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(21,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(21,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(21,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(21,Stk,OStk,T) :-
	OStk=[[109,T|Stk]].
% go
obj0(21,Stk,OStk,T) :-
	OStk=[[110,T|Stk]].
% sh
pdt0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(21,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(21,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
comma0(22,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[111,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[111,T|Stk]],ISL,ISL1),
	  input(IN,[[111,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
null0(22,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,8,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(23,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(23,Stk,OStk,T) :-
	OStk=[[115,T|Stk]].
% go
bep0(23,Stk,OStk,T) :-
	OStk=[[116,T|Stk]].
% re
cc0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
comma0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ddet0(23,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(23,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh
ex0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(23,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh/re
in0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[112,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[112,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(23,Stk,OStk,T) :-
	OStk=[[117,T|Stk]].
% sh/re
jj0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(23,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(23,Stk,OStk,T) :-
	OStk=[[118,T|Stk]].
% re
null0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
obj0(23,Stk,OStk,T) :-
	OStk=[[119,T|Stk]].
% go
obj10(23,Stk,OStk,T) :-
	OStk=[[120,T|Stk]].
% go
obj20(23,Stk,OStk,T) :-
	OStk=[[121,T|Stk]].
% sh/re
pdt0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
pp0(23,Stk,OStk,T) :-
	OStk=[[122,T|Stk]].
% go
pred0(23,Stk,OStk,T) :-
	OStk=[[123,T|Stk]].
% sh/re
prp0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[113,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[113,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[113,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
sdec0(23,Stk,OStk,T) :-
	OStk=[[124,T|Stk]].
% go
subj0(23,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh/re
to0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh
vbn0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[62,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]],ISL,ISL1),
	  input(IN,[[62,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh/re
vbp0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(23,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% go
vp20(23,Stk,OStk,T) :-
	OStk=[[125,T|Stk]].
% sh/re
wdt0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[114,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[114,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[114,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(23,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,48,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(24,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(24,Stk,OStk,T) :-
	OStk=[[128,T|Stk]].
% go
bep0(24,Stk,OStk,T) :-
	OStk=[[129,T|Stk]].
% re/re
cc0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	reduce(1,38,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cc(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
comma0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	reduce(1,38,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	comma(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ddet0(24,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(24,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
ex0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	ex(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[5,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[5,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
gerund0(24,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% re/re
in0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	reduce(1,38,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
infinitive0(24,Stk,OStk,T) :-
	OStk=[[130,T|Stk]].
% sh/re
jj0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
md0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	reduce(1,38,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(24,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(24,Stk,OStk,T) :-
	OStk=[[131,T|Stk]].
% re/re
null0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	reduce(1,38,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
obj0(24,Stk,OStk,T) :-
	OStk=[[132,T|Stk]].
% go
obj10(24,Stk,OStk,T) :-
	OStk=[[133,T|Stk]].
% go
obj20(24,Stk,OStk,T) :-
	OStk=[[134,T|Stk]].
% sh/re
pdt0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
prp0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[126,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[126,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[126,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
rbr0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	reduce(1,38,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	reduce(1,38,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	reduce(1,38,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
sdec0(24,Stk,OStk,T) :-
	OStk=[[135,T|Stk]].
% go
subj0(24,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh/re
to0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
vbn0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	reduce(1,38,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(24,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh/re
wdt0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[127,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[127,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[127,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(24,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(25,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(25,Stk,OStk,T) :-
	OStk=[[137,T|Stk]].
% go
bep0(25,Stk,OStk,T) :-
	OStk=[[138,T|Stk]].
% re
cc0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
comma0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ddet0(25,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(25,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh
ex0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(25,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% re
in0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
infinitive0(25,Stk,OStk,T) :-
	OStk=[[139,T|Stk]].
% sh/re
jj0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(25,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(25,Stk,OStk,T) :-
	OStk=[[140,T|Stk]].
% re
null0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
obj0(25,Stk,OStk,T) :-
	OStk=[[141,T|Stk]].
% go
obj10(25,Stk,OStk,T) :-
	OStk=[[142,T|Stk]].
% go
obj20(25,Stk,OStk,T) :-
	OStk=[[143,T|Stk]].
% sh/re
pdt0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
prp0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[60,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[60,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
sdec0(25,Stk,OStk,T) :-
	OStk=[[144,T|Stk]].
% go
subj0(25,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh/re
to0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vbn0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(25,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh/re
wdt0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[136,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[136,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[136,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(25,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,212,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(26,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(26,Stk,OStk,T) :-
	OStk=[[147,T|Stk]].
% go
bep0(26,Stk,OStk,T) :-
	OStk=[[148,T|Stk]].
% re/re
cc0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	reduce(1,39,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cc(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
comma0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	reduce(1,39,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	comma(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ddet0(26,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(26,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
ex0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	ex(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[5,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[5,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
gerund0(26,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% re/re
in0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	reduce(1,39,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
infinitive0(26,Stk,OStk,T) :-
	OStk=[[149,T|Stk]].
% sh/re
jj0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
md0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	reduce(1,39,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(26,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(26,Stk,OStk,T) :-
	OStk=[[150,T|Stk]].
% re/re
null0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	reduce(1,39,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
obj0(26,Stk,OStk,T) :-
	OStk=[[151,T|Stk]].
% go
obj10(26,Stk,OStk,T) :-
	OStk=[[152,T|Stk]].
% go
obj20(26,Stk,OStk,T) :-
	OStk=[[153,T|Stk]].
% sh/re
pdt0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
prp0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[145,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[145,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[145,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
rbr0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	reduce(1,39,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	reduce(1,39,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	reduce(1,39,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
sdec0(26,Stk,OStk,T) :-
	OStk=[[154,T|Stk]].
% go
subj0(26,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh/re
to0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
vbn0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	reduce(1,39,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(26,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh/re
wdt0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[146,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[146,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[146,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(26,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(27,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(27,Stk,OStk,T) :-
	OStk=[[157,T|Stk]].
% go
bep0(27,Stk,OStk,T) :-
	OStk=[[158,T|Stk]].
% re/re
cc0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	reduce(1,40,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cc(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
comma0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	reduce(1,40,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	comma(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ddet0(27,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(27,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
ex0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	ex(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[5,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[5,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
gerund0(27,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% re/re
in0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	reduce(1,40,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
infinitive0(27,Stk,OStk,T) :-
	OStk=[[159,T|Stk]].
% sh/re
jj0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
md0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	reduce(1,40,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(27,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(27,Stk,OStk,T) :-
	OStk=[[160,T|Stk]].
% re/re
null0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	reduce(1,40,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
obj0(27,Stk,OStk,T) :-
	OStk=[[161,T|Stk]].
% go
obj10(27,Stk,OStk,T) :-
	OStk=[[162,T|Stk]].
% go
obj20(27,Stk,OStk,T) :-
	OStk=[[163,T|Stk]].
% sh/re
pdt0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
prp0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[155,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[155,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[155,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
rbr0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	reduce(1,40,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	reduce(1,40,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	reduce(1,40,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
sdec0(27,Stk,OStk,T) :-
	OStk=[[164,T|Stk]].
% go
subj0(27,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh/re
to0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
vbn0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	reduce(1,40,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(27,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh/re
wdt0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[156,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[156,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[156,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(27,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(28,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(28,Stk,OStk,T) :-
	OStk=[[165,T|Stk]].
% re
cc0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(28,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re
dollar0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
in0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
jj0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[104,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[104,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wdt0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[90,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[90,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
wp0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(28,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(29,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(29,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(29,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(29,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(29,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(29,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(29,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
sdec0(29,Stk,OStk,T) :-
	OStk=[[166,T|Stk]].
% go
subj0(29,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh
vb0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(29,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(29,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
cc0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
jj0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[167,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[167,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[167,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jjr0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[168,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[168,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[168,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(30,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(31,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,1,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
in0(32,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[107,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[107,T|Stk]],ISL,ISL1),
	  input(IN,[[107,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
thancomp0(32,Stk,OStk,T) :-
	OStk=[[169,T|Stk]].
% go
adjcpt0(33,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(33,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cc0(33,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[170,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[170,T|Stk]],ISL,ISL1),
	  input(IN,[[170,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
detq0(33,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% sh
dt0(33,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[88,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]],ISL,ISL1),
	  input(IN,[[88,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(33,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(33,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(33,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(33,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(33,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(33,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(33,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(33,Stk,OStk,T) :-
	OStk=[[171,T|Stk]].
% sh
rb0(33,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[104,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]],ISL,ISL1),
	  input(IN,[[104,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wdt0(33,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(33,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
comma0(34,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[172,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[172,T|Stk]],ISL,ISL1),
	  input(IN,[[172,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(35,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(35,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(35,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(35,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[173,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[173,T|Stk]],ISL,ISL1),
	  input(IN,[[173,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(35,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(35,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(35,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
subj0(35,Stk,OStk,T) :-
	OStk=[[174,T|Stk]].
% sh
vb0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(35,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(35,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(36,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(36,Stk,OStk,T) :-
	OStk=[[175,T|Stk]].
% go
bep0(36,Stk,OStk,T) :-
	OStk=[[65,T|Stk]].
% re
cc0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
comma0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[58,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[58,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[58,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
ddet0(36,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(36,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
gerund0(36,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh/re
in0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[59,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[59,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[59,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(36,Stk,OStk,T) :-
	OStk=[[67,T|Stk]].
% go
infinitrel0(36,Stk,OStk,T) :-
	OStk=[[68,T|Stk]].
% sh/re
jj0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ncomp0(36,Stk,OStk,T) :-
	OStk=[[176,T|Stk]].
% sh/re
nn0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(36,Stk,OStk,T) :-
	OStk=[[177,T|Stk]].
% go
np0(36,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% re
null0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
pdt0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
pp0(36,Stk,OStk,T) :-
	OStk=[[71,T|Stk]].
% sh/re
prp0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[60,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[60,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
srel0(36,Stk,OStk,T) :-
	OStk=[[72,T|Stk]].
% go
subj0(36,Stk,OStk,T) :-
	OStk=[[73,T|Stk]].
% go
thancomp0(36,Stk,OStk,T) :-
	OStk=[[74,T|Stk]].
% sh/re
to0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbn0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	vbn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[62,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[62,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbp0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(36,Stk,OStk,T) :-
	OStk=[[75,T|Stk]].
% go
vp20(36,Stk,OStk,T) :-
	OStk=[[76,T|Stk]].
% sh/re
wdt0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[63,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[63,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[63,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(36,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,91,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(37,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(37,Stk,OStk,T) :-
	OStk=[[178,T|Stk]].
% go
bep0(37,Stk,OStk,T) :-
	OStk=[[65,T|Stk]].
% re
cc0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
comma0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[58,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[58,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[58,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
ddet0(37,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(37,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
gerund0(37,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh/re
in0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[59,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[59,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[59,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(37,Stk,OStk,T) :-
	OStk=[[67,T|Stk]].
% go
infinitrel0(37,Stk,OStk,T) :-
	OStk=[[68,T|Stk]].
% sh/re
jj0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ncomp0(37,Stk,OStk,T) :-
	OStk=[[179,T|Stk]].
% sh/re
nn0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(37,Stk,OStk,T) :-
	OStk=[[180,T|Stk]].
% go
np0(37,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% re
null0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
pdt0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
pp0(37,Stk,OStk,T) :-
	OStk=[[71,T|Stk]].
% sh/re
prp0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[60,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[60,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
srel0(37,Stk,OStk,T) :-
	OStk=[[72,T|Stk]].
% go
subj0(37,Stk,OStk,T) :-
	OStk=[[73,T|Stk]].
% go
thancomp0(37,Stk,OStk,T) :-
	OStk=[[74,T|Stk]].
% sh/re
to0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbn0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	vbn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[62,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[62,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbp0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(37,Stk,OStk,T) :-
	OStk=[[75,T|Stk]].
% go
vp20(37,Stk,OStk,T) :-
	OStk=[[76,T|Stk]].
% sh/re
wdt0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[63,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[63,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[63,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(37,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,93,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(38,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(38,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(38,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(38,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(38,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(38,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(38,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
subj0(38,Stk,OStk,T) :-
	OStk=[[181,T|Stk]].
% sh
vb0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(38,Stk,OStk,T) :-
	OStk=[[182,T|Stk]].
% sh
wdt0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(38,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
cc0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(39,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,103,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(40,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(40,Stk,OStk,T) :-
	OStk=[[100,T|Stk]].
% go
bep0(40,Stk,OStk,T) :-
	OStk=[[65,T|Stk]].
% re
cc0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
comma0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[58,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[58,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[58,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
ddet0(40,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(40,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
gerund0(40,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh/re
in0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[59,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[59,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[59,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(40,Stk,OStk,T) :-
	OStk=[[67,T|Stk]].
% go
infinitrel0(40,Stk,OStk,T) :-
	OStk=[[68,T|Stk]].
% sh/re
jj0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ncomp0(40,Stk,OStk,T) :-
	OStk=[[183,T|Stk]].
% sh/re
nn0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(40,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(40,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% re
null0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
pdt0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
pp0(40,Stk,OStk,T) :-
	OStk=[[71,T|Stk]].
% sh/re
prp0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[60,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[60,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
srel0(40,Stk,OStk,T) :-
	OStk=[[72,T|Stk]].
% go
subj0(40,Stk,OStk,T) :-
	OStk=[[73,T|Stk]].
% go
thancomp0(40,Stk,OStk,T) :-
	OStk=[[74,T|Stk]].
% sh/re
to0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbn0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[62,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[62,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbp0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(40,Stk,OStk,T) :-
	OStk=[[75,T|Stk]].
% go
vp20(40,Stk,OStk,T) :-
	OStk=[[76,T|Stk]].
% sh/re
wdt0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[63,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[63,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[63,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(40,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
cc0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[184,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[184,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[184,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[185,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[185,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[185,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
dollar0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(41,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,159,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
comma0(42,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[186,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[186,T|Stk]],ISL,ISL1),
	  input(IN,[[186,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
advp0(43,Stk,OStk,T) :-
	OStk=[[192,T|Stk]].
% sh
cc0(43,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[187,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[187,T|Stk]],ISL,ISL1),
	  input(IN,[[187,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
comma0(43,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[188,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[188,T|Stk]],ISL,ISL1),
	  input(IN,[[188,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
in0(43,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[189,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[189,T|Stk]],ISL,ISL1),
	  input(IN,[[189,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
null0(43,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,2,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
rb0(43,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[190,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[190,T|Stk]],ISL,ISL1),
	  input(IN,[[190,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rbr0(43,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[19,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]],ISL,ISL1),
	  input(IN,[[19,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rbs0(43,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[20,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]],ISL,ISL1),
	  input(IN,[[20,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(43,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[191,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]],ISL,ISL1),
	  input(IN,[[191,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
advp0(44,Stk,OStk,T) :-
	OStk=[[194,T|Stk]].
% sh
cc0(44,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[1,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]],ISL,ISL1),
	  input(IN,[[1,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
comma0(44,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[193,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[193,T|Stk]],ISL,ISL1),
	  input(IN,[[193,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
in0(44,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[189,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[189,T|Stk]],ISL,ISL1),
	  input(IN,[[189,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
null0(44,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,4,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
rb0(44,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[190,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[190,T|Stk]],ISL,ISL1),
	  input(IN,[[190,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rbr0(44,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[19,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]],ISL,ISL1),
	  input(IN,[[19,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rbs0(44,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[20,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]],ISL,ISL1),
	  input(IN,[[20,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(44,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[191,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]],ISL,ISL1),
	  input(IN,[[191,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
null0(45,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,6,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
aux0(46,Stk,OStk,T) :-
	OStk=[[196,T|Stk]].
% go
auxd0(46,Stk,OStk,T) :-
	OStk=[[197,T|Stk]].
% go
bep0(46,Stk,OStk,T) :-
	OStk=[[198,T|Stk]].
% sh
md0(46,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[195,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[195,T|Stk]],ISL,ISL1),
	  input(IN,[[195,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(46,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(46,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[24,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]],ISL,ISL1),
	  input(IN,[[24,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(46,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(46,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[26,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]],ISL,ISL1),
	  input(IN,[[26,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(46,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[27,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]],ISL,ISL1),
	  input(IN,[[27,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(46,Stk,OStk,T) :-
	OStk=[[199,T|Stk]].
% go
advp0(47,Stk,OStk,T) :-
	OStk=[[203,T|Stk]].
% sh/re
cc0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[200,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[200,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[200,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
comma0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[201,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[201,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[201,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
in0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,134,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[6,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[6,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[6,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(47,Stk,OStk,T) :-
	OStk=[[204,T|Stk]].
% re
md0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,134,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
pp0(47,Stk,OStk,T) :-
	OStk=[[205,T|Stk]].
% sh/re
rb0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,134,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[202,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[202,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[202,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,134,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,134,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh
rp0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[21,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]],ISL,ISL1),
	  input(IN,[[21,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
to0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[61,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]],ISL,ISL1),
	  input(IN,[[61,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
vb0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(47,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,134,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[191,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[191,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(48,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(48,Stk,OStk,T) :-
	OStk=[[105,T|Stk]].
% go
detq0(48,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% sh
dt0(48,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[88,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]],ISL,ISL1),
	  input(IN,[[88,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(48,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(48,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(48,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(48,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[104,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]],ISL,ISL1),
	  input(IN,[[104,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(48,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(48,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(48,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(48,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(48,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(48,Stk,OStk,T) :-
	OStk=[[106,T|Stk]].
% sh
wdt0(48,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[90,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]],ISL,ISL1),
	  input(IN,[[90,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(48,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(49,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(49,Stk,OStk,T) :-
	OStk=[[206,T|Stk]].
% go
bep0(49,Stk,OStk,T) :-
	OStk=[[116,T|Stk]].
% re
cc0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
comma0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ddet0(49,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(49,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh
ex0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(49,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% re
in0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
infinitive0(49,Stk,OStk,T) :-
	OStk=[[117,T|Stk]].
% sh/re
jj0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(49,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(49,Stk,OStk,T) :-
	OStk=[[207,T|Stk]].
% re
null0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
obj0(49,Stk,OStk,T) :-
	OStk=[[119,T|Stk]].
% go
obj10(49,Stk,OStk,T) :-
	OStk=[[120,T|Stk]].
% go
obj20(49,Stk,OStk,T) :-
	OStk=[[121,T|Stk]].
% sh/re
pdt0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
prp0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[60,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[60,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
sdec0(49,Stk,OStk,T) :-
	OStk=[[124,T|Stk]].
% go
subj0(49,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh/re
to0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vbn0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(49,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh/re
wdt0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[114,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[114,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[114,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(49,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,228,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(50,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(50,Stk,OStk,T) :-
	OStk=[[128,T|Stk]].
% go
bep0(50,Stk,OStk,T) :-
	OStk=[[129,T|Stk]].
% re
cc0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
comma0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ddet0(50,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(50,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh
ex0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(50,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% re
in0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
infinitive0(50,Stk,OStk,T) :-
	OStk=[[130,T|Stk]].
% sh/re
jj0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(50,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(50,Stk,OStk,T) :-
	OStk=[[131,T|Stk]].
% re
null0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
obj0(50,Stk,OStk,T) :-
	OStk=[[132,T|Stk]].
% go
obj10(50,Stk,OStk,T) :-
	OStk=[[133,T|Stk]].
% go
obj20(50,Stk,OStk,T) :-
	OStk=[[134,T|Stk]].
% sh/re
pdt0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
prp0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[60,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[60,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
sdec0(50,Stk,OStk,T) :-
	OStk=[[135,T|Stk]].
% go
subj0(50,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh/re
to0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vbn0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(50,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh/re
wdt0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[127,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[127,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[127,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(50,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,164,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(51,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(51,Stk,OStk,T) :-
	OStk=[[147,T|Stk]].
% go
bep0(51,Stk,OStk,T) :-
	OStk=[[148,T|Stk]].
% re
cc0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
comma0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ddet0(51,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(51,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh
ex0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(51,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% re
in0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
infinitive0(51,Stk,OStk,T) :-
	OStk=[[149,T|Stk]].
% sh/re
jj0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(51,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(51,Stk,OStk,T) :-
	OStk=[[150,T|Stk]].
% re
null0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
obj0(51,Stk,OStk,T) :-
	OStk=[[151,T|Stk]].
% go
obj10(51,Stk,OStk,T) :-
	OStk=[[152,T|Stk]].
% go
obj20(51,Stk,OStk,T) :-
	OStk=[[153,T|Stk]].
% sh/re
pdt0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
prp0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[60,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[60,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
sdec0(51,Stk,OStk,T) :-
	OStk=[[154,T|Stk]].
% go
subj0(51,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh/re
to0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vbn0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(51,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh/re
wdt0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[146,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[146,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[146,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(51,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,165,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(52,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(52,Stk,OStk,T) :-
	OStk=[[157,T|Stk]].
% go
bep0(52,Stk,OStk,T) :-
	OStk=[[158,T|Stk]].
% re
cc0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
comma0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ddet0(52,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(52,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh
ex0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(52,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% re
in0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
infinitive0(52,Stk,OStk,T) :-
	OStk=[[159,T|Stk]].
% sh/re
jj0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(52,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(52,Stk,OStk,T) :-
	OStk=[[160,T|Stk]].
% re
null0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
obj0(52,Stk,OStk,T) :-
	OStk=[[161,T|Stk]].
% go
obj10(52,Stk,OStk,T) :-
	OStk=[[162,T|Stk]].
% go
obj20(52,Stk,OStk,T) :-
	OStk=[[163,T|Stk]].
% sh/re
pdt0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
prp0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[60,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[60,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
sdec0(52,Stk,OStk,T) :-
	OStk=[[164,T|Stk]].
% go
subj0(52,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh/re
to0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vbn0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(52,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh/re
wdt0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[156,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[156,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[156,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(52,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,166,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh
jj0(53,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[208,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[208,T|Stk]],ISL,ISL1),
	  input(IN,[[208,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
advp0(54,Stk,OStk,T) :-
	OStk=[[192,T|Stk]].
% sh/re
cc0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[1,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[1,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[188,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[188,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[188,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
dollar0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[189,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[189,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[189,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[190,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[190,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[190,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rp0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(54,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,33,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[191,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[191,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
advp0(55,Stk,OStk,T) :-
	OStk=[[203,T|Stk]].
% sh/re
cc0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[200,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[200,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[200,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[201,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[201,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[201,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
dollar0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[6,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[6,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[6,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(55,Stk,OStk,T) :-
	OStk=[[204,T|Stk]].
% re
jj0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
pp0(55,Stk,OStk,T) :-
	OStk=[[205,T|Stk]].
% re
prp0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[202,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[202,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[202,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rp0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
to0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vb0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(55,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[191,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[191,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cc0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(56,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,108,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(57,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,107,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(58,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(58,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
comma0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[58,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[58,T|Stk]],ISL,ISL1),
	  input(IN,[[58,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(58,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(58,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(58,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(58,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(58,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
srel0(58,Stk,OStk,T) :-
	OStk=[[209,T|Stk]].
% go
subj0(58,Stk,OStk,T) :-
	OStk=[[73,T|Stk]].
% sh
vb0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(58,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[63,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[63,T|Stk]],ISL,ISL1),
	  input(IN,[[63,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(58,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(59,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(59,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(59,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(59,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(59,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(59,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(59,Stk,OStk,T) :-
	OStk=[[210,T|Stk]].
% go
obj0(59,Stk,OStk,T) :-
	OStk=[[82,T|Stk]].
% sh
pdt0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
sdec0(59,Stk,OStk,T) :-
	OStk=[[211,T|Stk]].
% go
subj0(59,Stk,OStk,T) :-
	OStk=[[212,T|Stk]].
% sh
vb0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(59,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(59,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(60,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(60,Stk,OStk,T) :-
	OStk=[[105,T|Stk]].
% go
detq0(60,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% sh
dt0(60,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[88,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]],ISL,ISL1),
	  input(IN,[[88,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(60,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(60,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(60,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(60,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[104,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]],ISL,ISL1),
	  input(IN,[[104,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
to0(60,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[213,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[213,T|Stk]],ISL,ISL1),
	  input(IN,[[213,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(60,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(60,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(60,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(60,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(60,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(60,Stk,OStk,T) :-
	OStk=[[106,T|Stk]].
% sh
wdt0(60,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[90,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]],ISL,ISL1),
	  input(IN,[[90,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(60,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(61,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(61,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(61,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(61,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(61,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(61,Stk,OStk,T) :-
	OStk=[[214,T|Stk]].
% go
adjcpt0(62,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(62,Stk,OStk,T) :-
	OStk=[[216,T|Stk]].
% go
bep0(62,Stk,OStk,T) :-
	OStk=[[217,T|Stk]].
% re
cc0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
comma0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ddet0(62,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(62,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
gerund0(62,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh/re
in0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[215,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[215,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[215,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive10(62,Stk,OStk,T) :-
	OStk=[[218,T|Stk]].
% sh/re
jj0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(62,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(62,Stk,OStk,T) :-
	OStk=[[219,T|Stk]].
% re
null0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
obj10(62,Stk,OStk,T) :-
	OStk=[[220,T|Stk]].
% sh/re
pdt0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
prp0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[48,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[48,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vb0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vbn0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(62,Stk,OStk,T) :-
	OStk=[[221,T|Stk]].
% sh/re
wdt0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[29,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[29,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(62,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,249,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(63,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(63,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% go
aux0(63,Stk,OStk,T) :-
	OStk=[[196,T|Stk]].
% go
auxd0(63,Stk,OStk,T) :-
	OStk=[[222,T|Stk]].
% go
bep0(63,Stk,OStk,T) :-
	OStk=[[223,T|Stk]].
% sh
cd0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(63,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(63,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(63,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
md0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[195,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[195,T|Stk]],ISL,ISL1),
	  input(IN,[[195,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(63,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(63,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
sdec0(63,Stk,OStk,T) :-
	OStk=[[166,T|Stk]].
% go
subj0(63,Stk,OStk,T) :-
	OStk=[[224,T|Stk]].
% sh
vb0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[24,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]],ISL,ISL1),
	  input(IN,[[24,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[26,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]],ISL,ISL1),
	  input(IN,[[26,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[27,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]],ISL,ISL1),
	  input(IN,[[27,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(63,Stk,OStk,T) :-
	OStk=[[225,T|Stk]].
% sh
wdt0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(63,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(64,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(64,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh/re
cc0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[170,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[170,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[170,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
cd0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
comma0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	comma(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(64,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re/re
dollar0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dollar(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
in0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
jj0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
md0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(64,Stk,OStk,T) :-
	OStk=[[171,T|Stk]].
% re/re
null0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
pdt0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	pdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
prp0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	prp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
psp0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	psp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[104,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[104,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
rbr0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
to0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	to(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vb0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbg0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbg(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbn0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wdt0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
wp0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(64,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,22,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh
vb0(65,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(65,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(65,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(65,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(65,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(65,Stk,OStk,T) :-
	OStk=[[226,T|Stk]].
% re/re
cc0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],NStk0),
	reduce(1,103,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cc(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
comma0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],NStk0),
	reduce(1,103,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	comma(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
md0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],NStk0),
	reduce(1,103,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],NStk0),
	reduce(1,103,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbn0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],NStk0),
	reduce(1,103,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],NStk0),
	reduce(1,103,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],NStk0),
	reduce(1,103,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(66,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,102,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(67,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,58,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(68,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,67,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[112,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[112,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
pp0(69,Stk,OStk,T) :-
	OStk=[[227,T|Stk]].
% re
prp0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
to0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(69,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,89,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(70,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(70,Stk,OStk,T) :-
	OStk=[[100,T|Stk]].
% go
bep0(70,Stk,OStk,T) :-
	OStk=[[65,T|Stk]].
% re/re
cc0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	reduce(2,84,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cc(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
comma0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[58,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[58,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[58,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
ddet0(70,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(70,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
gerund0(70,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh/re
in0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[59,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[59,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[59,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(70,Stk,OStk,T) :-
	OStk=[[67,T|Stk]].
% go
infinitrel0(70,Stk,OStk,T) :-
	OStk=[[68,T|Stk]].
% sh/re
jj0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
md0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	reduce(2,84,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ncomp0(70,Stk,OStk,T) :-
	OStk=[[228,T|Stk]].
% sh/re
nn0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(70,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(70,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% re
null0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
pdt0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
pp0(70,Stk,OStk,T) :-
	OStk=[[71,T|Stk]].
% sh/re
prp0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[60,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[60,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
srel0(70,Stk,OStk,T) :-
	OStk=[[72,T|Stk]].
% go
subj0(70,Stk,OStk,T) :-
	OStk=[[73,T|Stk]].
% go
thancomp0(70,Stk,OStk,T) :-
	OStk=[[74,T|Stk]].
% sh/re
to0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbn0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[62,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[62,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbp0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(70,Stk,OStk,T) :-
	OStk=[[75,T|Stk]].
% go
vp20(70,Stk,OStk,T) :-
	OStk=[[76,T|Stk]].
% sh/re
wdt0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[63,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[63,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[63,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(70,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,84,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cc0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(71,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,63,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[229,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[229,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[229,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
dollar0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[112,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[112,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
pp0(72,Stk,OStk,T) :-
	OStk=[[230,T|Stk]].
% re
prp0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
to0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(72,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,66,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
aux0(73,Stk,OStk,T) :-
	OStk=[[196,T|Stk]].
% go
auxd0(73,Stk,OStk,T) :-
	OStk=[[231,T|Stk]].
% go
bep0(73,Stk,OStk,T) :-
	OStk=[[232,T|Stk]].
% sh
md0(73,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[195,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[195,T|Stk]],ISL,ISL1),
	  input(IN,[[195,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(73,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[77,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[77,T|Stk]],ISL,ISL1),
	  input(IN,[[77,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbn0(73,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[62,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]],ISL,ISL1),
	  input(IN,[[62,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(73,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[78,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[78,T|Stk]],ISL,ISL1),
	  input(IN,[[78,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(73,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[79,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[79,T|Stk]],ISL,ISL1),
	  input(IN,[[79,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp20(73,Stk,OStk,T) :-
	OStk=[[233,T|Stk]].
% re
cc0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(74,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,69,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
advp0(75,Stk,OStk,T) :-
	OStk=[[203,T|Stk]].
% sh/re
cc0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[200,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[200,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[200,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
cd0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[201,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[201,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[201,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
dollar0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dollar(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dt0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[6,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[6,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[6,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(75,Stk,OStk,T) :-
	OStk=[[204,T|Stk]].
% re/re
jj0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jj(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjr0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjs0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
md0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nn0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnp0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnps0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnps(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nns0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nns(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
null0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
pdt0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	pdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
pp0(75,Stk,OStk,T) :-
	OStk=[[205,T|Stk]].
% re/re
prp0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	prp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
psp0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	psp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[202,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[202,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[202,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rp0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
to0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
vb0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbg0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbg(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbn0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wdt0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wp0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	reduce(1,59,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(75,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[191,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[191,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
advp0(76,Stk,OStk,T) :-
	OStk=[[234,T|Stk]].
% sh/re
cc0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[1,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[1,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[6,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[6,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[6,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
pp0(76,Stk,OStk,T) :-
	OStk=[[235,T|Stk]].
% re
prp0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[190,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[190,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[190,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rp0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
to0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(76,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,65,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[191,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[191,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cc0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[236,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[236,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[236,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(77,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,38,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[237,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[237,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[237,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(78,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,39,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[238,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[238,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[238,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(79,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,40,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(80,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(80,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(80,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(80,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(80,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(80,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(80,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
subj0(80,Stk,OStk,T) :-
	OStk=[[239,T|Stk]].
% sh
vb0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(80,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(80,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh/re
cc0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[184,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[184,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[184,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[185,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[185,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[185,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
dollar0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[240,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[240,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[240,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
md0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,159,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vb0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,159,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,159,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbg0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,159,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbg(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,159,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,159,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(81,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(82,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,112,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
advp0(83,Stk,OStk,T) :-
	OStk=[[192,T|Stk]].
% sh/re
cc0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[1,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[1,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[188,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[188,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[188,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
dollar0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[189,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[189,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[189,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[190,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[190,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[190,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rp0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(83,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,32,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[191,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[191,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(84,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(84,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(84,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(84,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(84,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(84,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(84,Stk,OStk,T) :-
	OStk=[[241,T|Stk]].
% sh
pdt0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(84,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(84,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
to0(85,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[213,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[213,T|Stk]],ISL,ISL1),
	  input(IN,[[213,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
cc0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(86,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,18,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(87,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,10,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(88,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(88,Stk,OStk,T) :-
	OStk=[[242,T|Stk]].
% go
detq0(88,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% sh
dt0(88,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[88,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]],ISL,ISL1),
	  input(IN,[[88,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(88,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(88,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(88,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(88,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[104,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]],ISL,ISL1),
	  input(IN,[[104,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wdt0(88,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[90,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]],ISL,ISL1),
	  input(IN,[[90,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(88,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(89,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(89,Stk,OStk,T) :-
	OStk=[[105,T|Stk]].
% go
detq0(89,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% sh
dt0(89,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[88,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]],ISL,ISL1),
	  input(IN,[[88,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(89,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(89,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(89,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(89,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[104,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]],ISL,ISL1),
	  input(IN,[[104,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
to0(89,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[213,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[213,T|Stk]],ISL,ISL1),
	  input(IN,[[213,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wdt0(89,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[90,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]],ISL,ISL1),
	  input(IN,[[90,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(89,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(90,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(90,Stk,OStk,T) :-
	OStk=[[243,T|Stk]].
% go
detq0(90,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% sh/re
dt0(90,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jj0(90,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(90,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(90,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(90,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[104,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[104,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wdt0(90,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[90,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[90,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(90,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,47,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
in0(91,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,14,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
cc0(92,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[170,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[170,T|Stk]],ISL,ISL1),
	  input(IN,[[170,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
in0(92,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,15,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(93,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(93,Stk,OStk,T) :-
	OStk=[[244,T|Stk]].
% go
detq0(93,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% sh
dt0(93,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[88,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]],ISL,ISL1),
	  input(IN,[[88,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(93,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(93,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(93,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(93,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[104,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]],ISL,ISL1),
	  input(IN,[[104,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wdt0(93,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[90,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]],ISL,ISL1),
	  input(IN,[[90,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(93,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
bep0(94,Stk,OStk,T) :-
	OStk=[[246,T|Stk]].
% go
havep0(94,Stk,OStk,T) :-
	OStk=[[247,T|Stk]].
% sh
vb0(94,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[245,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[245,T|Stk]],ISL,ISL1),
	  input(IN,[[245,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(94,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[24,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]],ISL,ISL1),
	  input(IN,[[24,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(94,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(94,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[26,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]],ISL,ISL1),
	  input(IN,[[26,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(94,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[27,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]],ISL,ISL1),
	  input(IN,[[27,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(94,Stk,OStk,T) :-
	OStk=[[248,T|Stk]].
% re
cc0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(95,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,73,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(96,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,77,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(97,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,78,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(98,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,74,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
dt0(99,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[249,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[249,T|Stk]],ISL,ISL1),
	  input(IN,[[249,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(100,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(100,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh/re
cc0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[170,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[170,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[170,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(100,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re
dollar0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
in0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
jj0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(100,Stk,OStk,T) :-
	OStk=[[171,T|Stk]].
% re
null0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[104,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[104,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wdt0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
wp0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(100,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cc0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[112,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[112,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
pp0(101,Stk,OStk,T) :-
	OStk=[[227,T|Stk]].
% re
prp0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
to0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(101,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,95,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[112,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[112,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
pp0(102,Stk,OStk,T) :-
	OStk=[[227,T|Stk]].
% re
prp0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
to0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(102,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,97,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(103,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(103,Stk,OStk,T) :-
	OStk=[[100,T|Stk]].
% go
bep0(103,Stk,OStk,T) :-
	OStk=[[65,T|Stk]].
% re/re
cc0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	reduce(2,98,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cc(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
comma0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[58,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[58,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[58,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
ddet0(103,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(103,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
gerund0(103,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh/re
in0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[59,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[59,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[59,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(103,Stk,OStk,T) :-
	OStk=[[67,T|Stk]].
% go
infinitrel0(103,Stk,OStk,T) :-
	OStk=[[68,T|Stk]].
% sh/re
jj0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
md0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	reduce(2,98,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ncomp0(103,Stk,OStk,T) :-
	OStk=[[250,T|Stk]].
% sh/re
nn0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(103,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(103,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% re
null0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
pdt0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
pp0(103,Stk,OStk,T) :-
	OStk=[[71,T|Stk]].
% sh/re
prp0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[60,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[60,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
srel0(103,Stk,OStk,T) :-
	OStk=[[72,T|Stk]].
% go
subj0(103,Stk,OStk,T) :-
	OStk=[[73,T|Stk]].
% go
thancomp0(103,Stk,OStk,T) :-
	OStk=[[74,T|Stk]].
% sh/re
to0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbn0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[62,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[62,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbp0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(103,Stk,OStk,T) :-
	OStk=[[75,T|Stk]].
% go
vp20(103,Stk,OStk,T) :-
	OStk=[[76,T|Stk]].
% sh/re
wdt0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[63,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[63,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[63,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(103,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,98,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(104,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(104,Stk,OStk,T) :-
	OStk=[[105,T|Stk]].
% go
detq0(104,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% sh
dt0(104,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[88,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]],ISL,ISL1),
	  input(IN,[[88,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(104,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(104,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(104,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(104,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[104,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]],ISL,ISL1),
	  input(IN,[[104,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wdt0(104,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[90,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]],ISL,ISL1),
	  input(IN,[[90,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(104,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh/re
cc0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[170,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[170,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[170,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(105,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,25,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
advp0(106,Stk,OStk,T) :-
	OStk=[[203,T|Stk]].
% sh/re
cc0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[200,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[200,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[200,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[201,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[201,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[201,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
dollar0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[6,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[6,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[6,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(106,Stk,OStk,T) :-
	OStk=[[204,T|Stk]].
% re
jj0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
pp0(106,Stk,OStk,T) :-
	OStk=[[205,T|Stk]].
% re
prp0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[202,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[202,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[202,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rp0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
to0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vb0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(106,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,51,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[191,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[191,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(107,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(107,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(107,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(107,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(107,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(107,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(107,Stk,OStk,T) :-
	OStk=[[251,T|Stk]].
% sh
pdt0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
sdec0(107,Stk,OStk,T) :-
	OStk=[[211,T|Stk]].
% go
subj0(107,Stk,OStk,T) :-
	OStk=[[212,T|Stk]].
% sh
vb0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(107,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(107,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
cc0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(108,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,34,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cc0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[184,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[184,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[184,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[185,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[185,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[185,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
dollar0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[252,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[252,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[252,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(109,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(110,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,114,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(111,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(111,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% go
advp0(111,Stk,OStk,T) :-
	OStk=[[34,T|Stk]].
% go
bep0(111,Stk,OStk,T) :-
	OStk=[[35,T|Stk]].
% sh
cc0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[1,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]],ISL,ISL1),
	  input(IN,[[1,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
cd0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(111,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(111,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
dop0(111,Stk,OStk,T) :-
	OStk=[[38,T|Stk]].
% sh
dt0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(111,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
in0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[6,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[6,T|Stk]],ISL,ISL1),
	  input(IN,[[6,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
md0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[10,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[10,T|Stk]],ISL,ISL1),
	  input(IN,[[10,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(111,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(111,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
pp0(111,Stk,OStk,T) :-
	OStk=[[42,T|Stk]].
% sh
prp0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[18,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[18,T|Stk]],ISL,ISL1),
	  input(IN,[[18,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rbr0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[19,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]],ISL,ISL1),
	  input(IN,[[19,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rbs0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[20,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]],ISL,ISL1),
	  input(IN,[[20,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rp0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[21,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]],ISL,ISL1),
	  input(IN,[[21,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
s0(111,Stk,OStk,T) :-
	OStk=[[253,T|Stk]].
% go
sdec0(111,Stk,OStk,T) :-
	OStk=[[43,T|Stk]].
% go
simp0(111,Stk,OStk,T) :-
	OStk=[[44,T|Stk]].
% go
sq0(111,Stk,OStk,T) :-
	OStk=[[45,T|Stk]].
% go
subj0(111,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh
uh0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[22,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[22,T|Stk]],ISL,ISL1),
	  input(IN,[[22,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[23,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[23,T|Stk]],ISL,ISL1),
	  input(IN,[[23,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[24,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]],ISL,ISL1),
	  input(IN,[[24,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[26,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]],ISL,ISL1),
	  input(IN,[[26,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[27,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]],ISL,ISL1),
	  input(IN,[[27,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(111,Stk,OStk,T) :-
	OStk=[[47,T|Stk]].
% sh
wdt0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(111,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[30,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[30,T|Stk]],ISL,ISL1),
	  input(IN,[[30,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(112,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(112,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(112,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(112,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(112,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(112,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(112,Stk,OStk,T) :-
	OStk=[[254,T|Stk]].
% go
obj0(112,Stk,OStk,T) :-
	OStk=[[82,T|Stk]].
% sh
pdt0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(112,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(112,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(113,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(113,Stk,OStk,T) :-
	OStk=[[255,T|Stk]].
% sh/re
cd0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
ddet0(113,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(113,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
gerund0(113,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
in0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[112,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]],ISL,ISL1),
	  input(IN,[[112,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh/re
jj0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nn0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(113,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(113,Stk,OStk,T) :-
	OStk=[[256,T|Stk]].
% sh/re
pdt0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
pp0(113,Stk,OStk,T) :-
	OStk=[[122,T|Stk]].
% go
pred0(113,Stk,OStk,T) :-
	OStk=[[257,T|Stk]].
% sh/re
prp0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[48,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[48,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh
rp0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[21,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]],ISL,ISL1),
	  input(IN,[[21,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
to0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[213,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[213,T|Stk]],ISL,ISL1),
	  input(IN,[[213,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh/re
vb0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[50,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[50,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh
vbn0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[62,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]],ISL,ISL1),
	  input(IN,[[62,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh/re
vbp0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[51,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[51,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[52,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[52,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(113,Stk,OStk,T) :-
	OStk=[[258,T|Stk]].
% go
vp20(113,Stk,OStk,T) :-
	OStk=[[125,T|Stk]].
% sh/re
wdt0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[29,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[29,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(113,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,49,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(114,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(114,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(114,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(114,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(114,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(114,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(114,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
sdec0(114,Stk,OStk,T) :-
	OStk=[[259,T|Stk]].
% go
subj0(114,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh
vb0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(114,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(114,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(115,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(115,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh/re
cc0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,116,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[170,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[170,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[170,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
comma0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,116,Stk,[],NStk0),
	reduce(2,230,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	comma(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(115,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% sh
dt0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[88,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]],ISL,ISL1),
	  input(IN,[[88,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re/re
in0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,116,Stk,[],NStk0),
	reduce(2,230,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
jj0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
md0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,230,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
nn0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(115,Stk,OStk,T) :-
	OStk=[[171,T|Stk]].
% re/re
null0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,116,Stk,[],NStk0),
	reduce(2,230,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,116,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[104,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[104,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
rbr0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,116,Stk,[],NStk0),
	reduce(2,230,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,116,Stk,[],NStk0),
	reduce(2,230,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,116,Stk,[],NStk0),
	reduce(2,230,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
to0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,116,Stk,[],NStk0),
	reduce(2,230,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	to(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,230,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,230,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,230,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,230,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,230,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
wdt0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh/re
wrb0(115,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,116,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(116,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(116,Stk,OStk,T) :-
	OStk=[[260,T|Stk]].
% sh
cd0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(116,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(116,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(116,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
in0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[112,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]],ISL,ISL1),
	  input(IN,[[112,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(116,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(116,Stk,OStk,T) :-
	OStk=[[256,T|Stk]].
% sh
pdt0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
pp0(116,Stk,OStk,T) :-
	OStk=[[122,T|Stk]].
% go
pred0(116,Stk,OStk,T) :-
	OStk=[[261,T|Stk]].
% sh
prp0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rp0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[21,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]],ISL,ISL1),
	  input(IN,[[21,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbn0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[62,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]],ISL,ISL1),
	  input(IN,[[62,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(116,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% go
vp20(116,Stk,OStk,T) :-
	OStk=[[125,T|Stk]].
% sh
wdt0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(116,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re/re
cc0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cc(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
cd0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
comma0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	comma(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dollar0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dollar(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dt0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
in0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jj0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jj(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjr0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjs0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
md0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nn0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnp0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnps0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnps(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nns0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nns(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
null0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
pdt0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	pdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
prp0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	prp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
psp0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	psp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rb0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbr0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
to0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	to(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vb0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbg0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbg(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbn0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wdt0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wp0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wrb0(117,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,231,Stk,[],NStk0),
	reduce(2,236,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wrb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cc0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[184,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[184,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[184,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,110,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[185,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[185,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[185,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
dollar0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,110,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dt0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
in0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,111,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jj0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jj(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjr0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjs0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
md0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,159,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,110,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,110,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,110,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,110,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
null0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,117,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,110,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,110,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,110,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rb0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbr0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,117,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,117,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,117,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
to0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,117,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	to(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vb0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbg0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbg(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wdt0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,110,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wrb0(118,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wrb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(119,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(119,Stk,OStk,T) :-
	OStk=[[263,T|Stk]].
% go
advp0(119,Stk,OStk,T) :-
	OStk=[[264,T|Stk]].
% go
bep0(119,Stk,OStk,T) :-
	OStk=[[217,T|Stk]].
% sh/re
cc0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[1,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[1,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(119,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re
dollar0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
in0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[189,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[189,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[189,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(119,Stk,OStk,T) :-
	OStk=[[265,T|Stk]].
% go
infinitive10(119,Stk,OStk,T) :-
	OStk=[[266,T|Stk]].
% sh/re
jj0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[262,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[262,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[262,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rp0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
to0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vbn0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(119,Stk,OStk,T) :-
	OStk=[[267,T|Stk]].
% sh/re
wdt0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[90,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[90,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
wp0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(119,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,233,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[30,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[30,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[30,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(120,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(120,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(120,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(120,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(120,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(120,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(120,Stk,OStk,T) :-
	OStk=[[268,T|Stk]].
% go
obj20(120,Stk,OStk,T) :-
	OStk=[[269,T|Stk]].
% sh
pdt0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(120,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(120,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
in0(121,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[270,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[270,T|Stk]],ISL,ISL1),
	  input(IN,[[270,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
cc0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(122,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,118,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(123,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,136,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(123,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,136,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[271,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[271,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[271,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
in0(123,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,136,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[112,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[112,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(123,Stk,OStk,T) :-
	OStk=[[272,T|Stk]].
% re
null0(123,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,136,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
pp0(123,Stk,OStk,T) :-
	OStk=[[273,T|Stk]].
% sh/re
rb0(123,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,136,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[85,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[85,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[85,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(123,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,136,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(123,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,136,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh
rp0(123,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[21,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]],ISL,ISL1),
	  input(IN,[[21,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
to0(123,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[61,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]],ISL,ISL1),
	  input(IN,[[61,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
wrb0(123,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,136,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
advp0(124,Stk,OStk,T) :-
	OStk=[[192,T|Stk]].
% sh/re
cc0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[1,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[1,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[188,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[188,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[188,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
dollar0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[189,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[189,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[189,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[190,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[190,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[190,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rp0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(124,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,239,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[191,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[191,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
advp0(125,Stk,OStk,T) :-
	OStk=[[234,T|Stk]].
% sh/re
cc0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[1,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[1,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[6,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[6,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[6,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
pp0(125,Stk,OStk,T) :-
	OStk=[[235,T|Stk]].
% re
prp0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[190,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[190,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[190,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rp0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
to0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(125,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,119,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[191,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[191,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(126,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(126,Stk,OStk,T) :-
	OStk=[[105,T|Stk]].
% re
cc0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(126,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re
dollar0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
ex0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	ex(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
jj0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[104,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[104,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
to0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[213,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[213,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[213,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[50,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[50,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vbn0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[51,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[51,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[52,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[52,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(126,Stk,OStk,T) :-
	OStk=[[106,T|Stk]].
% sh/re
wdt0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[90,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[90,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
wp0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(126,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,41,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(127,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(127,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(127,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(127,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(127,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(127,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(127,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
sdec0(127,Stk,OStk,T) :-
	OStk=[[274,T|Stk]].
% go
subj0(127,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh
vb0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(127,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(127,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(128,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(128,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh/re
cc0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[170,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[170,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[170,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(128,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re
dollar0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
in0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
jj0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(128,Stk,OStk,T) :-
	OStk=[[171,T|Stk]].
% re
null0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[104,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[104,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wdt0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
wp0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(128,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,170,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(129,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(129,Stk,OStk,T) :-
	OStk=[[260,T|Stk]].
% sh
cd0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(129,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(129,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(129,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
in0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[112,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]],ISL,ISL1),
	  input(IN,[[112,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(129,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(129,Stk,OStk,T) :-
	OStk=[[256,T|Stk]].
% sh
pdt0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
pp0(129,Stk,OStk,T) :-
	OStk=[[122,T|Stk]].
% go
pred0(129,Stk,OStk,T) :-
	OStk=[[275,T|Stk]].
% sh
prp0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rp0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[21,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]],ISL,ISL1),
	  input(IN,[[21,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbn0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[62,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]],ISL,ISL1),
	  input(IN,[[62,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(129,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% go
vp20(129,Stk,OStk,T) :-
	OStk=[[125,T|Stk]].
% sh
wdt0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(129,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re/re
cc0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cc(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
cd0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
comma0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	comma(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dollar0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dollar(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dt0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
in0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jj0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jj(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjr0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjs0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
md0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nn0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnp0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnps0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnps(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nns0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nns(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
null0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
pdt0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	pdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
prp0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	prp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
psp0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	psp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rb0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbr0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
to0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	to(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vb0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbg0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbg(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbn0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wdt0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wp0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wrb0(130,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,173,Stk,[],NStk0),
	reduce(2,188,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wrb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cc0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[184,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[184,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[184,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
cd0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[185,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[185,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[185,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
dollar0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dollar(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dt0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
in0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,111,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jj0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jj(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjr0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjs0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
md0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,159,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nn0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnp0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnps0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnps(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nns0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nns(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
null0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,167,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
pdt0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	pdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
prp0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	prp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
psp0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	psp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rb0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbr0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,167,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,167,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,167,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
to0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,167,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	to(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vb0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbg0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbg(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbn0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,167,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wdt0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wp0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wrb0(131,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wrb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(132,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(132,Stk,OStk,T) :-
	OStk=[[276,T|Stk]].
% go
advp0(132,Stk,OStk,T) :-
	OStk=[[277,T|Stk]].
% go
bep0(132,Stk,OStk,T) :-
	OStk=[[217,T|Stk]].
% sh/re
cc0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[1,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[1,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(132,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re
dollar0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
in0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[189,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[189,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[189,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(132,Stk,OStk,T) :-
	OStk=[[278,T|Stk]].
% go
infinitive10(132,Stk,OStk,T) :-
	OStk=[[279,T|Stk]].
% sh/re
jj0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[262,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[262,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[262,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rp0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
to0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vbn0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(132,Stk,OStk,T) :-
	OStk=[[280,T|Stk]].
% sh/re
wdt0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[90,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[90,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
wp0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(132,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,179,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[30,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[30,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[30,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(133,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(133,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(133,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(133,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(133,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(133,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(133,Stk,OStk,T) :-
	OStk=[[268,T|Stk]].
% go
obj20(133,Stk,OStk,T) :-
	OStk=[[281,T|Stk]].
% sh
pdt0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(133,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(133,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
in0(134,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[282,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[282,T|Stk]],ISL,ISL1),
	  input(IN,[[282,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
advp0(135,Stk,OStk,T) :-
	OStk=[[192,T|Stk]].
% sh/re
cc0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[1,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[1,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[188,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[188,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[188,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
dollar0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[189,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[189,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[189,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[190,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[190,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[190,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rp0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(135,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,197,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[191,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[191,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(136,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(136,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(136,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(136,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(136,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(136,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(136,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
sdec0(136,Stk,OStk,T) :-
	OStk=[[283,T|Stk]].
% go
subj0(136,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh
vb0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(136,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(136,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(137,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(137,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh/re
cc0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[170,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[170,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[170,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(137,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re
dollar0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
in0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
jj0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(137,Stk,OStk,T) :-
	OStk=[[171,T|Stk]].
% re
null0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[104,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[104,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wdt0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
wp0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(137,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,214,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(138,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(138,Stk,OStk,T) :-
	OStk=[[260,T|Stk]].
% sh
cd0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(138,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(138,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(138,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
in0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[112,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]],ISL,ISL1),
	  input(IN,[[112,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(138,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(138,Stk,OStk,T) :-
	OStk=[[256,T|Stk]].
% sh
pdt0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
pp0(138,Stk,OStk,T) :-
	OStk=[[122,T|Stk]].
% go
pred0(138,Stk,OStk,T) :-
	OStk=[[284,T|Stk]].
% sh
prp0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rp0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[21,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]],ISL,ISL1),
	  input(IN,[[21,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbn0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[62,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]],ISL,ISL1),
	  input(IN,[[62,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(138,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% go
vp20(138,Stk,OStk,T) :-
	OStk=[[125,T|Stk]].
% sh
wdt0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(138,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re/re
cc0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cc(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
cd0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
comma0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	comma(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dollar0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dollar(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dt0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
in0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jj0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jj(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjr0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjs0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
md0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nn0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnp0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnps0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnps(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nns0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nns(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
null0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
pdt0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	pdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
prp0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	prp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
psp0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	psp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rb0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbr0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
to0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	to(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vb0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbg0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbg(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbn0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wdt0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wp0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wrb0(139,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,215,Stk,[],NStk0),
	reduce(2,220,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wrb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cc0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[184,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[184,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[184,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
cd0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[185,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[185,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[185,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
dollar0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dollar(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dt0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
in0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,111,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jj0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jj(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjr0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjs0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
md0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,159,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nn0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnp0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnps0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnps(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nns0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nns(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
null0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,213,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
pdt0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	pdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
prp0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	prp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
psp0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	psp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rb0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbr0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,213,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,213,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,213,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
to0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,213,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	to(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vb0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbg0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbg(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbn0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,213,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wdt0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wp0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wrb0(140,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wrb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(141,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(141,Stk,OStk,T) :-
	OStk=[[285,T|Stk]].
% go
advp0(141,Stk,OStk,T) :-
	OStk=[[286,T|Stk]].
% go
bep0(141,Stk,OStk,T) :-
	OStk=[[217,T|Stk]].
% sh/re
cc0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[1,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[1,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(141,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re
dollar0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
in0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[189,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[189,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[189,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(141,Stk,OStk,T) :-
	OStk=[[287,T|Stk]].
% go
infinitive10(141,Stk,OStk,T) :-
	OStk=[[288,T|Stk]].
% sh/re
jj0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[262,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[262,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[262,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rp0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
to0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vbn0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(141,Stk,OStk,T) :-
	OStk=[[289,T|Stk]].
% sh/re
wdt0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[90,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[90,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
wp0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(141,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,217,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[30,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[30,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[30,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(142,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(142,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(142,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(142,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(142,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(142,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(142,Stk,OStk,T) :-
	OStk=[[268,T|Stk]].
% go
obj20(142,Stk,OStk,T) :-
	OStk=[[290,T|Stk]].
% sh
pdt0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(142,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(142,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
in0(143,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[291,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[291,T|Stk]],ISL,ISL1),
	  input(IN,[[291,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
advp0(144,Stk,OStk,T) :-
	OStk=[[192,T|Stk]].
% sh/re
cc0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[1,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[1,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[188,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[188,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[188,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
dollar0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[189,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[189,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[189,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[190,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[190,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[190,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rp0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(144,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,223,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[191,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[191,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(145,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(145,Stk,OStk,T) :-
	OStk=[[105,T|Stk]].
% re
cc0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(145,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re
dollar0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
ex0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	ex(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
jj0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[104,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[104,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
to0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[213,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[213,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[213,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[50,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[50,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vbn0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[51,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[51,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[52,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[52,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(145,Stk,OStk,T) :-
	OStk=[[106,T|Stk]].
% sh/re
wdt0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[90,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[90,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
wp0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(145,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,42,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(146,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(146,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(146,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(146,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(146,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(146,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(146,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
sdec0(146,Stk,OStk,T) :-
	OStk=[[292,T|Stk]].
% go
subj0(146,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh
vb0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(146,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(146,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(147,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(147,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh/re
cc0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[170,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[170,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[170,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(147,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re
dollar0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
in0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
jj0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(147,Stk,OStk,T) :-
	OStk=[[171,T|Stk]].
% re
null0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[104,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[104,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wdt0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
wp0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(147,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,171,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(148,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(148,Stk,OStk,T) :-
	OStk=[[260,T|Stk]].
% sh
cd0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(148,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(148,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(148,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
in0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[112,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]],ISL,ISL1),
	  input(IN,[[112,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(148,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(148,Stk,OStk,T) :-
	OStk=[[256,T|Stk]].
% sh
pdt0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
pp0(148,Stk,OStk,T) :-
	OStk=[[122,T|Stk]].
% go
pred0(148,Stk,OStk,T) :-
	OStk=[[293,T|Stk]].
% sh
prp0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rp0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[21,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]],ISL,ISL1),
	  input(IN,[[21,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbn0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[62,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]],ISL,ISL1),
	  input(IN,[[62,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(148,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% go
vp20(148,Stk,OStk,T) :-
	OStk=[[125,T|Stk]].
% sh
wdt0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(148,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re/re
cc0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cc(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
cd0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
comma0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	comma(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dollar0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dollar(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dt0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
in0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jj0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jj(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjr0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjs0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
md0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nn0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnp0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnps0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnps(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nns0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nns(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
null0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
pdt0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	pdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
prp0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	prp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
psp0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	psp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rb0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbr0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
to0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	to(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vb0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbg0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbg(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbn0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wdt0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wp0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wrb0(149,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,174,Stk,[],NStk0),
	reduce(2,189,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wrb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cc0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[184,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[184,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[184,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
cd0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[185,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[185,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[185,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
dollar0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dollar(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dt0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
in0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,111,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jj0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jj(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjr0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjs0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
md0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,159,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nn0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnp0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnps0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnps(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nns0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nns(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
null0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,168,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
pdt0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	pdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
prp0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	prp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
psp0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	psp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rb0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbr0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,168,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,168,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,168,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
to0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,168,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	to(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vb0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbg0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbg(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbn0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,168,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wdt0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wp0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wrb0(150,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wrb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(151,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(151,Stk,OStk,T) :-
	OStk=[[294,T|Stk]].
% go
advp0(151,Stk,OStk,T) :-
	OStk=[[295,T|Stk]].
% go
bep0(151,Stk,OStk,T) :-
	OStk=[[217,T|Stk]].
% sh/re
cc0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[1,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[1,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(151,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re
dollar0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
in0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[189,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[189,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[189,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(151,Stk,OStk,T) :-
	OStk=[[296,T|Stk]].
% go
infinitive10(151,Stk,OStk,T) :-
	OStk=[[297,T|Stk]].
% sh/re
jj0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[262,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[262,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[262,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rp0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
to0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vbn0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(151,Stk,OStk,T) :-
	OStk=[[298,T|Stk]].
% sh/re
wdt0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[90,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[90,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
wp0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(151,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,180,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[30,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[30,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[30,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(152,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(152,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(152,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(152,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(152,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(152,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(152,Stk,OStk,T) :-
	OStk=[[268,T|Stk]].
% go
obj20(152,Stk,OStk,T) :-
	OStk=[[299,T|Stk]].
% sh
pdt0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(152,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(152,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
in0(153,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[300,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[300,T|Stk]],ISL,ISL1),
	  input(IN,[[300,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
advp0(154,Stk,OStk,T) :-
	OStk=[[192,T|Stk]].
% sh/re
cc0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[1,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[1,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[188,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[188,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[188,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
dollar0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[189,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[189,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[189,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[190,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[190,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[190,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rp0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(154,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,198,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[191,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[191,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(155,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(155,Stk,OStk,T) :-
	OStk=[[105,T|Stk]].
% re
cc0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(155,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re
dollar0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
ex0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	ex(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
jj0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[104,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[104,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
to0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[213,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[213,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[213,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[50,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[50,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vbn0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[51,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[51,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[52,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[52,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(155,Stk,OStk,T) :-
	OStk=[[106,T|Stk]].
% sh/re
wdt0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[90,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[90,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
wp0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(155,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,43,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(156,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(156,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(156,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(156,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(156,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(156,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(156,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
sdec0(156,Stk,OStk,T) :-
	OStk=[[301,T|Stk]].
% go
subj0(156,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh
vb0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(156,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(156,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(157,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(157,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh/re
cc0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[170,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[170,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[170,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(157,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re
dollar0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
in0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
jj0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(157,Stk,OStk,T) :-
	OStk=[[171,T|Stk]].
% re
null0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[104,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[104,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wdt0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
wp0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(157,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,172,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(158,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(158,Stk,OStk,T) :-
	OStk=[[260,T|Stk]].
% sh
cd0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(158,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(158,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(158,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
in0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[112,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]],ISL,ISL1),
	  input(IN,[[112,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(158,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(158,Stk,OStk,T) :-
	OStk=[[256,T|Stk]].
% sh
pdt0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
pp0(158,Stk,OStk,T) :-
	OStk=[[122,T|Stk]].
% go
pred0(158,Stk,OStk,T) :-
	OStk=[[302,T|Stk]].
% sh
prp0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rp0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[21,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]],ISL,ISL1),
	  input(IN,[[21,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbn0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[62,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]],ISL,ISL1),
	  input(IN,[[62,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(158,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% go
vp20(158,Stk,OStk,T) :-
	OStk=[[125,T|Stk]].
% sh
wdt0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(158,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re/re
cc0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cc(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
cd0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
comma0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	comma(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dollar0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dollar(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dt0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
in0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jj0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jj(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjr0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjs0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
md0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nn0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnp0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnps0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnps(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nns0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nns(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
null0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
pdt0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	pdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
prp0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	prp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
psp0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	psp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rb0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbr0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
to0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	to(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vb0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbg0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbg(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbn0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wdt0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wp0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wrb0(159,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,175,Stk,[],NStk0),
	reduce(2,190,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wrb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cc0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[184,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[184,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[184,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
cd0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[185,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[185,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[185,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
dollar0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dollar(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dt0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
in0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,111,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jj0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jj(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjr0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjs0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
md0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,159,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nn0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnp0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnps0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnps(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nns0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nns(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
null0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,169,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
pdt0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	pdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
prp0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	prp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
psp0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	psp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rb0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbr0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,169,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,169,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,169,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
to0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,169,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	to(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vb0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbg0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbg(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbn0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(2,169,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wdt0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wp0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wrb0(160,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,109,Stk,[],NStk0),
	reduce(1,110,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wrb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(161,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(161,Stk,OStk,T) :-
	OStk=[[303,T|Stk]].
% go
advp0(161,Stk,OStk,T) :-
	OStk=[[304,T|Stk]].
% go
bep0(161,Stk,OStk,T) :-
	OStk=[[217,T|Stk]].
% sh/re
cc0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[1,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[1,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(161,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re
dollar0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
in0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[189,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[189,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[189,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(161,Stk,OStk,T) :-
	OStk=[[305,T|Stk]].
% go
infinitive10(161,Stk,OStk,T) :-
	OStk=[[306,T|Stk]].
% sh/re
jj0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[262,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[262,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[262,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rp0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
to0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
vbn0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
vbp0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(161,Stk,OStk,T) :-
	OStk=[[307,T|Stk]].
% sh/re
wdt0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[90,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[90,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
wp0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(161,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,181,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[30,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[30,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[30,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(162,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(162,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(162,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(162,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(162,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(162,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(162,Stk,OStk,T) :-
	OStk=[[268,T|Stk]].
% go
obj20(162,Stk,OStk,T) :-
	OStk=[[308,T|Stk]].
% sh
pdt0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(162,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(162,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
in0(163,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[309,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[309,T|Stk]],ISL,ISL1),
	  input(IN,[[309,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
advp0(164,Stk,OStk,T) :-
	OStk=[[192,T|Stk]].
% sh/re
cc0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[1,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[1,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[188,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[188,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[188,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
dollar0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[189,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[189,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[189,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[190,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[190,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[190,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rp0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(164,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,199,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[191,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[191,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(165,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(165,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh/re
cc0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[170,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[170,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[170,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(165,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re
dollar0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
in0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
jj0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(165,Stk,OStk,T) :-
	OStk=[[310,T|Stk]].
% re
null0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[104,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[104,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wdt0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
wp0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(165,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,21,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
advp0(166,Stk,OStk,T) :-
	OStk=[[192,T|Stk]].
% sh/re
cc0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[1,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[1,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cd0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
comma0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[188,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[188,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[188,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
dollar0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[189,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[189,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[189,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[190,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[190,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[190,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rp0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(166,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,104,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[191,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[191,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcomp0(167,Stk,OStk,T) :-
	OStk=[[311,T|Stk]].
% re/re
cc0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cc(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
cd0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
comma0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	comma(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dollar0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dollar(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
dt0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[84,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[84,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[84,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(167,Stk,OStk,T) :-
	OStk=[[87,T|Stk]].
% re/re
jj0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jj(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjr0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
jjs0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	jjs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
md0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nn0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnp0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nnps0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nnps(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
nns0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	nns(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
null0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
pdt0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	pdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
prp0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	prp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
psp0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	psp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[85,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[85,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[85,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
rbr0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
to0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
vb0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbg0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbg(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbn0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wdt0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wp0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
wrb0(167,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,19,Stk,[],NStk0),
	reduce(2,30,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wrb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(168,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,31,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(169,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,24,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(170,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(170,Stk,OStk,T) :-
	OStk=[[312,T|Stk]].
% go
detq0(170,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% sh
dt0(170,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[88,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]],ISL,ISL1),
	  input(IN,[[88,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(170,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(170,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(170,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(170,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[104,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]],ISL,ISL1),
	  input(IN,[[104,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wdt0(170,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[90,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[90,T|Stk]],ISL,ISL1),
	  input(IN,[[90,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(170,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
cc0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(171,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,79,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(172,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(172,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% go
advp0(172,Stk,OStk,T) :-
	OStk=[[34,T|Stk]].
% go
bep0(172,Stk,OStk,T) :-
	OStk=[[35,T|Stk]].
% sh
cc0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[1,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]],ISL,ISL1),
	  input(IN,[[1,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
cd0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(172,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(172,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
dop0(172,Stk,OStk,T) :-
	OStk=[[38,T|Stk]].
% sh
dt0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(172,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
in0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[6,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[6,T|Stk]],ISL,ISL1),
	  input(IN,[[6,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
md0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[10,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[10,T|Stk]],ISL,ISL1),
	  input(IN,[[10,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(172,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(172,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
pp0(172,Stk,OStk,T) :-
	OStk=[[42,T|Stk]].
% sh
prp0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[18,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[18,T|Stk]],ISL,ISL1),
	  input(IN,[[18,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rbr0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[19,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]],ISL,ISL1),
	  input(IN,[[19,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rbs0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[20,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]],ISL,ISL1),
	  input(IN,[[20,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rp0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[21,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]],ISL,ISL1),
	  input(IN,[[21,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
s0(172,Stk,OStk,T) :-
	OStk=[[313,T|Stk]].
% go
sdec0(172,Stk,OStk,T) :-
	OStk=[[43,T|Stk]].
% go
simp0(172,Stk,OStk,T) :-
	OStk=[[44,T|Stk]].
% go
sq0(172,Stk,OStk,T) :-
	OStk=[[45,T|Stk]].
% go
subj0(172,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh
uh0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[22,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[22,T|Stk]],ISL,ISL1),
	  input(IN,[[22,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[23,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[23,T|Stk]],ISL,ISL1),
	  input(IN,[[23,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[24,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]],ISL,ISL1),
	  input(IN,[[24,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[26,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]],ISL,ISL1),
	  input(IN,[[26,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[27,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]],ISL,ISL1),
	  input(IN,[[27,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(172,Stk,OStk,T) :-
	OStk=[[47,T|Stk]].
% sh
wdt0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(172,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[30,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[30,T|Stk]],ISL,ISL1),
	  input(IN,[[30,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(173,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(173,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(173,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(173,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(173,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(173,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(173,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
subj0(173,Stk,OStk,T) :-
	OStk=[[314,T|Stk]].
% sh
vb0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(173,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(173,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(174,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(174,Stk,OStk,T) :-
	OStk=[[260,T|Stk]].
% sh
cd0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(174,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(174,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(174,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
in0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[112,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]],ISL,ISL1),
	  input(IN,[[112,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(174,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(174,Stk,OStk,T) :-
	OStk=[[256,T|Stk]].
% sh
pdt0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
pp0(174,Stk,OStk,T) :-
	OStk=[[122,T|Stk]].
% go
pred0(174,Stk,OStk,T) :-
	OStk=[[315,T|Stk]].
% sh
prp0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rp0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[21,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]],ISL,ISL1),
	  input(IN,[[21,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbn0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[62,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]],ISL,ISL1),
	  input(IN,[[62,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(174,Stk,OStk,T) :-
	OStk=[[316,T|Stk]].
% go
vp20(174,Stk,OStk,T) :-
	OStk=[[125,T|Stk]].
% sh
wdt0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(174,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(175,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(175,Stk,OStk,T) :-
	OStk=[[100,T|Stk]].
% go
bep0(175,Stk,OStk,T) :-
	OStk=[[65,T|Stk]].
% sh/re
cc0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[170,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[170,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[170,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
cd0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
comma0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[58,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[58,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[58,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
ddet0(175,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(175,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
gerund0(175,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh/re
in0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[59,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[59,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[59,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(175,Stk,OStk,T) :-
	OStk=[[67,T|Stk]].
% go
infinitrel0(175,Stk,OStk,T) :-
	OStk=[[68,T|Stk]].
% sh/re
jj0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
md0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ncomp0(175,Stk,OStk,T) :-
	OStk=[[317,T|Stk]].
% sh/re
nn0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(175,Stk,OStk,T) :-
	OStk=[[318,T|Stk]].
% go
np0(175,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% re
null0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
pdt0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
pp0(175,Stk,OStk,T) :-
	OStk=[[71,T|Stk]].
% sh/re
prp0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[60,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[60,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
srel0(175,Stk,OStk,T) :-
	OStk=[[72,T|Stk]].
% go
subj0(175,Stk,OStk,T) :-
	OStk=[[73,T|Stk]].
% go
thancomp0(175,Stk,OStk,T) :-
	OStk=[[74,T|Stk]].
% sh/re
to0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbn0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	vbn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[62,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[62,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbp0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(175,Stk,OStk,T) :-
	OStk=[[75,T|Stk]].
% go
vp20(175,Stk,OStk,T) :-
	OStk=[[76,T|Stk]].
% sh/re
wdt0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[63,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[63,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[63,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(175,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,68,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cc0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[112,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[112,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
pp0(176,Stk,OStk,T) :-
	OStk=[[227,T|Stk]].
% re
prp0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
to0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(176,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,90,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(177,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(177,Stk,OStk,T) :-
	OStk=[[100,T|Stk]].
% go
bep0(177,Stk,OStk,T) :-
	OStk=[[65,T|Stk]].
% re/re
cc0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	reduce(2,86,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cc(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
comma0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[58,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[58,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[58,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
ddet0(177,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(177,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
gerund0(177,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh/re
in0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[59,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[59,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[59,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(177,Stk,OStk,T) :-
	OStk=[[67,T|Stk]].
% go
infinitrel0(177,Stk,OStk,T) :-
	OStk=[[68,T|Stk]].
% sh/re
jj0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
md0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	reduce(2,86,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ncomp0(177,Stk,OStk,T) :-
	OStk=[[319,T|Stk]].
% sh/re
nn0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(177,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(177,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% re
null0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
pdt0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
pp0(177,Stk,OStk,T) :-
	OStk=[[71,T|Stk]].
% sh/re
prp0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[60,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[60,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
srel0(177,Stk,OStk,T) :-
	OStk=[[72,T|Stk]].
% go
subj0(177,Stk,OStk,T) :-
	OStk=[[73,T|Stk]].
% go
thancomp0(177,Stk,OStk,T) :-
	OStk=[[74,T|Stk]].
% sh/re
to0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbn0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[62,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[62,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbp0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(177,Stk,OStk,T) :-
	OStk=[[75,T|Stk]].
% go
vp20(177,Stk,OStk,T) :-
	OStk=[[76,T|Stk]].
% sh/re
wdt0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[63,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[63,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[63,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(177,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,86,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
adjcpt0(178,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(178,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh/re
cc0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[170,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[170,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[170,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
cd0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
comma0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	comma(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
detq0(178,Stk,OStk,T) :-
	OStk=[[93,T|Stk]].
% re/re
dollar0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	dollar(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
dt0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[88,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[88,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[88,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
in0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	in(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
jj0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
md0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
nn0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(178,Stk,OStk,T) :-
	OStk=[[171,T|Stk]].
% re/re
null0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	null(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
pdt0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	pdt(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
prp0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	prp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
psp0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	psp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[104,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[104,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[104,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
rbr0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbr(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rbs0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rbs(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
rp0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	rp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
to0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	to(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vb0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vb(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbd0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbd(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbg0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbg(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbn0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbn(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbp0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% re/re
vbz0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	vbz(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wdt0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
wp0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	reduce(1,68,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	wp(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(178,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,23,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cc0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[112,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[112,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
pp0(179,Stk,OStk,T) :-
	OStk=[[227,T|Stk]].
% re
prp0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
to0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(179,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,92,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(180,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(180,Stk,OStk,T) :-
	OStk=[[100,T|Stk]].
% go
bep0(180,Stk,OStk,T) :-
	OStk=[[65,T|Stk]].
% re/re
cc0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	reduce(2,88,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	cc(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
cd0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	cd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[2,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[2,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
comma0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[58,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[58,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[58,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
ddet0(180,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(180,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh/re
dollar0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	dollar(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[3,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[3,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
dt0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	dt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[4,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[4,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
gerund0(180,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh/re
in0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[59,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[59,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[59,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(180,Stk,OStk,T) :-
	OStk=[[67,T|Stk]].
% go
infinitrel0(180,Stk,OStk,T) :-
	OStk=[[68,T|Stk]].
% sh/re
jj0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[7,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[7,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjr0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	jjr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[8,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[8,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
jjs0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	jjs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[9,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[9,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re/re
md0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	reduce(2,88,Stk,[],NStk1),
	append(NStk0,NStk1,NStk2),
	md(NStk2,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
ncomp0(180,Stk,OStk,T) :-
	OStk=[[320,T|Stk]].
% sh/re
nn0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	nn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[11,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[11,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnp0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	nnp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[12,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[12,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nnps0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	nnps(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[13,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[13,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
nns0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	nns(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[14,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[14,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
nomhd0(180,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(180,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% re
null0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
pdt0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	pdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[15,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[15,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
pp0(180,Stk,OStk,T) :-
	OStk=[[71,T|Stk]].
% sh/re
prp0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	prp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[16,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[16,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
psp0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	psp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[17,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[17,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rb0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[60,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[60,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[60,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
srel0(180,Stk,OStk,T) :-
	OStk=[[72,T|Stk]].
% go
subj0(180,Stk,OStk,T) :-
	OStk=[[73,T|Stk]].
% go
thancomp0(180,Stk,OStk,T) :-
	OStk=[[74,T|Stk]].
% sh/re
to0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	to(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[61,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[61,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vb0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	vb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[49,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[49,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbd0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbd(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[24,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[24,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbg0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	vbg(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[25,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[25,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbn0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbn(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[62,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[62,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[62,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbp0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[26,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[26,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
vbz0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,82,Stk,[],NStk0),
	vbz(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[27,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[27,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
vp0(180,Stk,OStk,T) :-
	OStk=[[75,T|Stk]].
% go
vp20(180,Stk,OStk,T) :-
	OStk=[[76,T|Stk]].
% sh/re
wdt0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	wdt(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[28,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[28,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wp0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	wp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[63,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[63,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[63,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
wrb0(180,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,88,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[53,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[53,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh
vb0(181,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(181,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(181,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(181,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(181,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(181,Stk,OStk,T) :-
	OStk=[[321,T|Stk]].
% go
advp0(182,Stk,OStk,T) :-
	OStk=[[203,T|Stk]].
% sh/re
cc0(182,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	cc(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[200,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[200,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[200,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
comma0(182,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],NStk0),
	comma(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[201,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[201,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[201,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
in0(182,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,133,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[6,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[6,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[6,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% go
infinitive0(182,Stk,OStk,T) :-
	OStk=[[204,T|Stk]].
% re
null0(182,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,133,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
pp0(182,Stk,OStk,T) :-
	OStk=[[205,T|Stk]].
% sh/re
rb0(182,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,133,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[202,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[202,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[202,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbr0(182,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,133,Stk,[],NStk0),
	rbr(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[19,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[19,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh/re
rbs0(182,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,133,Stk,[],NStk0),
	rbs(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[20,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[20,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% sh
rp0(182,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[21,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]],ISL,ISL1),
	  input(IN,[[21,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
to0(182,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[61,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[61,T|Stk]],ISL,ISL1),
	  input(IN,[[61,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
vb0(182,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(182,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(182,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(182,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(182,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,50,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
wrb0(182,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,133,Stk,[],NStk0),
	wrb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[191,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[191,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[191,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
cc0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
in0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],NStk0),
	in(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[112,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[112,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[112,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jj0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
pp0(183,Stk,OStk,T) :-
	OStk=[[227,T|Stk]].
% re
prp0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rp0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],NStk0),
	rp(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[21,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[21,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
to0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(183,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,81,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% go
adjcpt0(184,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(184,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(184,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(184,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(184,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(184,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(184,Stk,OStk,T) :-
	OStk=[[322,T|Stk]].
% sh
pdt0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(184,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(184,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(185,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(185,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(185,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(185,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(185,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(185,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(185,Stk,OStk,T) :-
	OStk=[[323,T|Stk]].
% sh
pdt0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(185,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(185,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(186,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(186,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% go
advp0(186,Stk,OStk,T) :-
	OStk=[[34,T|Stk]].
% go
bep0(186,Stk,OStk,T) :-
	OStk=[[35,T|Stk]].
% sh
cc0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[1,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[1,T|Stk]],ISL,ISL1),
	  input(IN,[[1,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
cd0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(186,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(186,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
dop0(186,Stk,OStk,T) :-
	OStk=[[38,T|Stk]].
% sh
dt0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(186,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
in0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[6,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[6,T|Stk]],ISL,ISL1),
	  input(IN,[[6,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jj0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
md0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[10,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[10,T|Stk]],ISL,ISL1),
	  input(IN,[[10,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(186,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(186,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
pp0(186,Stk,OStk,T) :-
	OStk=[[42,T|Stk]].
% sh
prp0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[18,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[18,T|Stk]],ISL,ISL1),
	  input(IN,[[18,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rbr0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[19,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[19,T|Stk]],ISL,ISL1),
	  input(IN,[[19,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rbs0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[20,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[20,T|Stk]],ISL,ISL1),
	  input(IN,[[20,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rp0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[21,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[21,T|Stk]],ISL,ISL1),
	  input(IN,[[21,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
s0(186,Stk,OStk,T) :-
	OStk=[[324,T|Stk]].
% go
sdec0(186,Stk,OStk,T) :-
	OStk=[[43,T|Stk]].
% go
simp0(186,Stk,OStk,T) :-
	OStk=[[44,T|Stk]].
% go
sq0(186,Stk,OStk,T) :-
	OStk=[[45,T|Stk]].
% go
subj0(186,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh
uh0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[22,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[22,T|Stk]],ISL,ISL1),
	  input(IN,[[22,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[23,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[23,T|Stk]],ISL,ISL1),
	  input(IN,[[23,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[24,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[24,T|Stk]],ISL,ISL1),
	  input(IN,[[24,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[26,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[26,T|Stk]],ISL,ISL1),
	  input(IN,[[26,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[27,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[27,T|Stk]],ISL,ISL1),
	  input(IN,[[27,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(186,Stk,OStk,T) :-
	OStk=[[47,T|Stk]].
% sh
wdt0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(186,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[30,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[30,T|Stk]],ISL,ISL1),
	  input(IN,[[30,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
adjcpt0(187,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(187,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(187,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(187,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(187,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(187,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(187,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
sdec0(187,Stk,OStk,T) :-
	OStk=[[325,T|Stk]].
% go
subj0(187,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh
vb0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(187,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(187,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(188,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[326,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[326,T|Stk]],ISL,ISL1),
	  input(IN,[[326,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vb0(188,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(188,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[327,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[327,T|Stk]],ISL,ISL1),
	  input(IN,[[327,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(188,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(188,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[328,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[328,T|Stk]],ISL,ISL1),
	  input(IN,[[328,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(188,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[329,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[329,T|Stk]],ISL,ISL1),
	  input(IN,[[329,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(188,Stk,OStk,T) :-
	OStk=[[330,T|Stk]].
% go
vp30(188,Stk,OStk,T) :-
	OStk=[[331,T|Stk]].
% go
adjcpt0(189,Stk,OStk,T) :-
	OStk=[[32,T|Stk]].
% go
adjp0(189,Stk,OStk,T) :-
	OStk=[[33,T|Stk]].
% sh
cd0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[2,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[2,T|Stk]],ISL,ISL1),
	  input(IN,[[2,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
ddet0(189,Stk,OStk,T) :-
	OStk=[[36,T|Stk]].
% go
detq0(189,Stk,OStk,T) :-
	OStk=[[37,T|Stk]].
% sh
dollar0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[3,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[3,T|Stk]],ISL,ISL1),
	  input(IN,[[3,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
dt0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[4,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[4,T|Stk]],ISL,ISL1),
	  input(IN,[[4,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
ex0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[5,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[5,T|Stk]],ISL,ISL1),
	  input(IN,[[5,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
gerund0(189,Stk,OStk,T) :-
	OStk=[[39,T|Stk]].
% sh
jj0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[7,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[7,T|Stk]],ISL,ISL1),
	  input(IN,[[7,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjr0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[8,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[8,T|Stk]],ISL,ISL1),
	  input(IN,[[8,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
jjs0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[9,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[9,T|Stk]],ISL,ISL1),
	  input(IN,[[9,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nn0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[11,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[11,T|Stk]],ISL,ISL1),
	  input(IN,[[11,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnp0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[12,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[12,T|Stk]],ISL,ISL1),
	  input(IN,[[12,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nnps0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[13,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[13,T|Stk]],ISL,ISL1),
	  input(IN,[[13,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
nns0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[14,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[14,T|Stk]],ISL,ISL1),
	  input(IN,[[14,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
nomhd0(189,Stk,OStk,T) :-
	OStk=[[40,T|Stk]].
% go
np0(189,Stk,OStk,T) :-
	OStk=[[41,T|Stk]].
% sh
pdt0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[15,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[15,T|Stk]],ISL,ISL1),
	  input(IN,[[15,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
prp0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[16,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[16,T|Stk]],ISL,ISL1),
	  input(IN,[[16,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
psp0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[17,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[17,T|Stk]],ISL,ISL1),
	  input(IN,[[17,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
rb0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[48,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[48,T|Stk]],ISL,ISL1),
	  input(IN,[[48,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
sdec0(189,Stk,OStk,T) :-
	OStk=[[83,T|Stk]].
% go
subj0(189,Stk,OStk,T) :-
	OStk=[[46,T|Stk]].
% sh
vb0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[49,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[49,T|Stk]],ISL,ISL1),
	  input(IN,[[49,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbd0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[50,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[50,T|Stk]],ISL,ISL1),
	  input(IN,[[50,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbg0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[25,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[25,T|Stk]],ISL,ISL1),
	  input(IN,[[25,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbp0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[51,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[51,T|Stk]],ISL,ISL1),
	  input(IN,[[51,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
vbz0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[52,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[52,T|Stk]],ISL,ISL1),
	  input(IN,[[52,T|Stk]],ISL1,OSL,ITL,OTL) ).
% go
vp0(189,Stk,OStk,T) :-
	OStk=[[55,T|Stk]].
% sh
wdt0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[28,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[28,T|Stk]],ISL,ISL1),
	  input(IN,[[28,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wp0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[29,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[29,T|Stk]],ISL,ISL1),
	  input(IN,[[29,T|Stk]],ISL1,OSL,ITL,OTL) ).
% sh
wrb0(189,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	( sysmode(breathfirst) -> 
	  OStk=[[53,T|Stk]], OTL=ITL, OSL=ISL ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[53,T|Stk]],ISL,ISL1),
	  input(IN,[[53,T|Stk]],ISL1,OSL,ITL,OTL) ).
% re
cc0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rb0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	rb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbr0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(190,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,27,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
jj0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],NStk0),
	jj(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[332,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[332,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[332,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
jjr0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	md(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nn0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	nn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnp0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	nnp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nnps0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	nnps(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
nns0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	nns(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
null0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	null(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
pdt0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	pdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
prp0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	prp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
psp0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	psp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% sh/re
rb0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],NStk0),
	rb(NStk0,NStk1,T,IN,ISL,ISL1,ITL,ITL1),
	( sysmode(breathfirst) ->
	  OStk=[[168,T|Stk]|NStk1], OSL=ISL1, OTL=ITL1 ;
	  OStk=[],
	  IN=[Pos|_],
	  insert_stack(Pos,[[168,T|Stk]|NStk1],ISL1,ISL2),
	  input(IN,[[168,T|Stk]|NStk1],ISL2,OSL,ITL1,OTL) ).
% re
rbr0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	rbr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rbs0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	rbs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
rp0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	rp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
to0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	to(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vb0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	vb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbd0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	vbd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbg0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	vbg(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbn0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	vbn(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbp0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	vbp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
vbz0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	vbz(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wdt0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	wdt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wp0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	wp(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
wrb0(191,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(1,29,Stk,[],OStk1),
	wrb(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cc0(192,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,132,Stk,[],OStk1),
	cc(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
cd0(192,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,132,Stk,[],OStk1),
	cd(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
comma0(192,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,132,Stk,[],OStk1),
	comma(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dollar0(192,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,132,Stk,[],OStk1),
	dollar(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
dt0(192,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,132,Stk,[],OStk1),
	dt(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
in0(192,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,132,Stk,[],OStk1),
	in(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jj0(192,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,132,Stk,[],OStk1),
	jj(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjr0(192,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,132,Stk,[],OStk1),
	jjr(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
jjs0(192,Stk,OStk,T,IN,ISL,OSL,ITL,OTL) :-
	reduce(2,132,Stk,[],OStk1),
	jjs(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL).
% re
md0(192,Stk,OStk,T,IN,ISL,OSL,