/*********************************************************************/
/*								     */
/* cfg2mod.pl 							     */
/*								     */
/* Copyright (C) 1997 Thanaruk Theeramunkong (ping@jaist.ac.jp)      */ 
/*                    Manabu Okumura         (oku@jaist.ac.jp)       */
/*                    Susumu Kunifuji        (kuni@jaist.ac.jp)      */
/*                    Hiroki Imai            (imai@cs.titech.ac.jp)  */
/*								     */
/*					     	9 May 1997	     */
/*								     */
/*								     */
/*********************************************************************/

% Change A --> B  TO  grammar(Number,A,[B],GramLen).

cfg2mod :-
	write('Input CFG rules file name: '), 
	read(CFGFile), nl,
	open(CFGFile,read,RStream),
	write('Input gram rules file name: '), 
	read(GFile), nl, 
	open(GFile,write,WStream),!,
	mk_gram_rules(1,RStream,WStream),
	close(RStream),
	close(WStream).

cfg2mod(CFGFile,GFile) :-
        format('Calling CFG2MOD Module~n',[]),
	open(CFGFile,read,RStream),
	open(GFile,write,WStream),!,
	abolish(grammar/4),
	mk_gram_rules(1,RStream,WStream),
	close(RStream),
	close(WStream),
        format('Finish  CFG2MOD Module~n',[]).

mk_gram_rules(N,RStream,WStream) :-
	read(RStream,(Lhs-->Rhs)),
	N1 is N+1,
	'A2L'(Rhs,List),
	cnt_lst(List,List_Len),
	assert(grammar(N,Lhs,List,List_Len)),
	format(WStream,'~p.~50|%~d~n',[grammar(N,Lhs,List,List_Len),N]),
	mk_gram_rules(N1,RStream,WStream).
mk_gram_rules(_N,_RStream,_WStream).

'A2L'((A,C),[A,B|P]) :- !,'A2L'(C,[B|P]).
'A2L'(Last,[Last]).
