/*********************************************************************/
/*								     */
/* makeclausekl1.pl 						     */
/*								     */
/* Copyright (C) 1997 Thanaruk Theeramunkong (ping@jaist.ac.jp)      */ 
/*                    Manabu Okumura         (oku@jaist.ac.jp)       */
/*                    Susumu Kunifuji        (kuni@jaist.ac.jp)      */
/*                    Hiroki Imai            (imai@cs.titech.ac.jp)  */
/*								     */
/*					     	9 May 1997	     */
/*								     */
/*								     */
/*********************************************************************/

%
% Make Clause for KL1
%

makeclause(GramFile,NumFiles,InFile,OutFile1,OutFile2,Dir) :-
	assert(dir(Dir)),
	dir(Dir),
	abolish(grammar,4),
	abolish(cat_file_table,3),
	abolish(cat_file_table1,2),
	consult(GramFile),
%	open(InFile,read,RStream),
	charcat(Dir,OutFile1,DOutFile1),
	open(DOutFile1,write,WStream1),
%	abolish(state,4),
%	read_in_clause(0,N,RStream),
%	consult(InFile),
	!,
	open_out_file(0,NumFiles,Dir,OutFile2,Streams),
	check_is_term_non_term,
	build_list(Streams,NumFiles,ASList),!,
	format(WStream1,'%~n',[]),
	format(WStream1,'% GRAMMAR MAIN~n',[]),
	format(WStream1,'%~n',[]),
	format(WStream1,':- with_macro pimos.~n',[]),
	format(WStream1,':- module gram_main.~n',[]),
	format(WStream1,':- public reduce/2, is_term/1, is_non_term/1.~n',[]),
	format(WStream1,':- public depth/2, width/2, re/4.~n',[]),
	format(WStream1,':- public input/9.~n',[]),
	make_header_gram_main(WStream1),
	format(WStream1,'~n',[]),
	format(WStream1,'% End Header~n',[]),
	format(WStream1,'%~n',[]),
%	write('ASLIst : '),write('\n'),write_list(ASList),
	format(WStream1,'%~n',[]),
	format(WStream1,'% The following is the definition of variables~n',[]),
	format(WStream1,'%~n',[]),
	format(WStream1,'% Stk = Stack~n',[]),
	format(WStream1,'% SL  = Stack List~n',[]),
	format(WStream1,'% TL  = Tree  List~n',[]),
	format(WStream1,'% IN  = Input~n',[]),
	format(WStream1,'% TR  = Tree~n',[]),
	format(WStream1,'%~n~n',[]),
%	format(WStream1,'% Grammar~n',[]),
%	write_gram(WStream1),
%	format(WStream1,'~n~n',[]),
	format(WStream1,'% Terminal~n',[]),
	write_term(WStream1),!,
	format(WStream1,'~n~n',[]),
	format(WStream1,'% Non Terminal~n',[]),
	write_nonterm(WStream1),!,
	format(WStream1,'~n~n',[]),
	format(WStream1,'% Area of Nonterminals~n',[]),
	write_area(WStream1),!,
	format(WStream1,'~n~n',[]),
	format(WStream1,'% Reduce Information~n',[]),
	format(WStream1,'% reduce(State,Reduces)~n',[]),
	format(WStream1,'% Reduce = [(gram_number,gram_length)|RRest]~n',[]),
	write_reduce(WStream1),!,
	format(WStream1,'% Main Input~n',[]),
	make_main_input(WStream1),!,
	format(WStream1,'% Main Clause~n',[]),
	make_mainclause(WStream1),!,
	format(WStream1,'~n~n% Reduce-Goto Clause~n',[]),
	make_main_re_go(WStream1),!,
	close(WStream1),
	is_term(Term),
	make_header1(Streams),
	make_header([null|Term]),
	makeclause_top(ASList),!,
	close_out_file(Streams),
	true.

check_is_term_non_term :-
	is_term(_), is_non_term(_), !.
check_is_term_non_term :-
	find_term_nonterm2(_Term,_NonTerm).

make_header1([]) :- !.
make_header1([(S,F)|Stream]) :-
	format(S,':- with_macro pimos.~n',[]),
	format(S,':- module ~p.~n',[F]),
	format(S,':- public ',[]),
	make_header1(Stream).

make_header_gram_main(WStream) :-
	!, is_term(Term),
	format(WStream,':- public ~p/~p',[null,11]),
	make_header_gram_main1(Term,11,WStream),
	!, is_non_term(NonTerm),
	make_header_gram_main1(NonTerm,3,WStream),
	!, format(WStream,'.~n',[]).


make_header_gram_main1([],_N,_S) :- !.
make_header_gram_main1([L|List],N,S) :-
	format(S,', ~p/~p',[L,N]),
	make_header_gram_main1(List,N,S).
	
make_header(Term) :-
	bagof([CatList,Stream],cat_file_table1(CatList,Stream),CLS),
	make_header_proc(CLS,Term).

make_header_proc([],_Term) :- !.
make_header_proc([[[C|CatList],S]|CLS],Term) :-
	member(C,Term),!,
	format(S,'~p0/12',[C]),
	make_header_proc1(CatList,S,Term),
	make_header_proc(CLS,Term).
make_header_proc([[[C|CatList],S]|CLS],Term) :-
	format(S,'~p0/4',[C]),
	make_header_proc1(CatList,S,Term),
	make_header_proc(CLS,Term).

make_header_proc1([],S,_Term) :- 
	!, format(S,'.~n',[]).
make_header_proc1([C|CatList],S,Term) :-
	member(C,Term),!,
	format(S,', ~p0/12',[C]),
	make_header_proc1(CatList,S,Term).
make_header_proc1([C|CatList],S,Term) :-
	format(S,', ~p0/4',[C]),
	make_header_proc1(CatList,S,Term).

build_list(Streams,0,AllActions) :- 
	!,
	bagof([InCat,Actions],
	   bagof([State,ASList],bagof([Action,OutState],
	      state(State,InCat,Action,OutState),ASList),Actions),AllActions),
	assert_cat_file_table(0,Streams,[],AllActions).
build_list(Streams,NF,AllActions) :- 
	bagof([InCat,Actions],
	   bagof([State,ASList],bagof([Action,OutState],
	      state(State,InCat,Action,OutState),ASList),Actions),AllActions),
	count_lst(AllActions,N),
	N1 is N//NF,
	N2 is N1,
	assert_cat_file_table(0,N2,Streams,[],AllActions).

assert_cat_file_table(0,[(Stream,_File)],CLst,[]) :-
	!, assert(cat_file_table1(CLst,Stream)).
assert_cat_file_table(0,[(Stream,File)],CLst,[A|AllActions]) :-
	!, A = [C,_Action],
	assert(cat_file_table(C,Stream,File)),
	assert_cat_file_table(0,[(Stream,File)],[C|CLst],AllActions).

assert_cat_file_table(_IN,_ON,[(Stream,_File)],CLst,[]) :- 
	!, assert(cat_file_table1(CLst,Stream)).
assert_cat_file_table(_IN,_ON,[(Stream,File)],CLst,[A|AllActions]) :-
	!, A = [C,_Action],
	assert(cat_file_table(C,Stream,File)),
	assert_cat_file_table(_IN,_ON,[(Stream,File)],[C|CLst],AllActions).
assert_cat_file_table(ON,ON,[(Stream,_File)|RStreams],CLst,AllActions) :- 
	!,  assert(cat_file_table1(CLst,Stream)),
	assert_cat_file_table(0,ON,RStreams,[],AllActions).
assert_cat_file_table(IN,ON,[(Stream,File)|RStreams],CLst,[A|AllActions]) :-
	A = [C,_Action],
	assert(cat_file_table(C,Stream,File)),
	IN1 is IN+1,
	assert_cat_file_table(IN1,ON,[(Stream,File)|RStreams],[C|CLst],AllActions).
	
open_out_file(0,0,Dir,OutFile,Streams) :- 
	!,
	charcat(Dir,OutFile,TOutFile1),
	charcat(TOutFile1,'.kl1',TOutFile2),
	open(TOutFile2,write,WStream),
	Streams = [(WStream,OutFile)],
	true.
open_out_file(NumFiles,NumFiles,Dir,OutFile,Streams) :- 
	!, 
	N1 is NumFiles+1,
	charcat(Dir,OutFile,TOutFile1),
	charcat(TOutFile1,N1,TOutFile2),
	charcat(TOutFile2,'.kl1',TOutFile3),
	charcat(OutFile,N1,OutFileN1),
	open(TOutFile3,write,WStream),
	Streams = [(WStream,OutFileN1)],
	true.
open_out_file(N,NumFiles,Dir,OutFile,Streams) :-
	N1 is N+1,
	charcat(Dir,OutFile,TOutFile1),
	charcat(TOutFile1,N1,TOutFile2),
	charcat(TOutFile2,'.kl1',TOutFile3),
	charcat(OutFile,N1,OutFileN1),
	open(TOutFile3,write,WStream),
	Streams = [(WStream,OutFileN1)|Streams1],
	open_out_file(N1,NumFiles,Dir,OutFile,Streams1),
	true.

close_out_file([]) :- !.
close_out_file([(S,_F)|Streams]) :-
	close(S),
	close_out_file(Streams).

charcat(Head,Tail,CatAns) :-
	name(Head,HeadL),
	name(Tail,TailL),
	append(HeadL,TailL,CatAnsL),
	name(CatAns,CatAnsL),
	true.

write_area(WStream) :-
	!,is_term(Term),
	abolish(depth,2),
	abolish(width,2),
	cal_term_depth(Term),
	is_non_term(NonTerm),
	find_rhs(NonTerm,NonTerm_Rhs),
	cal_nonterm_depth(NonTerm_Rhs,[]),
%	setof((A,B),depth(A,B),DepthLst),
	setof((Category,DepthCat),depth(Category,DepthCat),DepthLst),
	write_depth(WStream,DepthLst),
	cal_nonterm_width(NonTerm),
	setof((Category1,WidthCat),width(Category1,WidthCat),WidthLst),
	write_width(WStream,WidthLst),
	write_list(DepthLst).

cal_nonterm_width([]) :- !.
cal_nonterm_width([N|NonTerm]) :-
	setof(Rhs,Num^Len^grammar(Num,N,Rhs,Len),N_Rhs),
	find_totallength(N_Rhs,0,TotalLength),
	length(N_Rhs,Length),
	AverageLen is TotalLength/Length,
	assert(width(N,AverageLen)),
	cal_nonterm_width(NonTerm).

write_width(WStream,[]) :- 
	!,format(WStream,'otherwise.~n',[]),
	format(WStream,'width(_,Width) :- true | Width = 0.0 .~n',[]).
write_width(WStream,[(C,D)|WidthLst]) :-
	D1 is integer(D),
	( D > D1 ; D1 > D) ,!,
	format(WStream,'width(~p,Width) :- true | Width = ~3G .~n',[C,D]),
	write_width(WStream,WidthLst).
write_width(WStream,[(C,D)|WidthLst]) :-
	format(WStream,'width(~p,Width) :- true | Width = ~3G.0 .~n',[C,D]),
	write_width(WStream,WidthLst).

find_totallength([],Len,Len) :- !.
find_totallength([N|N_Rhs],TLen,Len) :-
	length1(N,NLen),
	TLen1 is TLen+NLen,
	find_totallength(N_Rhs,TLen1,Len).

write_depth(WStream,[]) :- 
	!,format(WStream,'otherwise.~n',[]),
	format(WStream,'depth(_,Depth) :- true | Depth = 0.0 .~n',[]).
write_depth(WStream,[(C,D)|DepthLst]) :-
	integer(D),!,
	format(WStream,'depth(~p,Depth) :- true | Depth = ~3G.0 .~n',[C,D]),
	write_depth(WStream,DepthLst).
write_depth(WStream,[(C,D)|DepthLst]) :-
	format(WStream,'depth(~p,Depth) :- true | Depth = ~3G .~n',[C,D]),
	write_depth(WStream,DepthLst).

cal_nonterm_depth([],[]) :- !.
cal_nonterm_depth([],List) :- 
	!,cal_nonterm_depth(List,[]).
cal_nonterm_depth([(N,N_Rhs1)|NonTerm_Rhs],List) :-
	cal_nonterm_depth1(N_Rhs1,1000,Depth),!,
	Depth1 is Depth+1,
	assert(depth(N,Depth1)),
	cal_nonterm_depth(NonTerm_Rhs,List).
cal_nonterm_depth([(N,N_Rhs1)|NonTerm_Rhs],List) :-
	List1 = [(N,N_Rhs1)|List],
	cal_nonterm_depth(NonTerm_Rhs,List1).
	
cal_nonterm_depth1([],1000,_Depth)     :- !,fail.
cal_nonterm_depth1([],MinDepth,MinDepth) :- !.
cal_nonterm_depth1([N|N_Rhs1],MinDepth,Depth) :-
	depth(N,L),!,
	find_min(L,MinDepth,MinDepth1),
	cal_nonterm_depth1(N_Rhs1,MinDepth1,Depth).

cal_nonterm_depth1([_N|N_Rhs1],MinDepth,Depth) :-
	cal_nonterm_depth1(N_Rhs1,MinDepth,Depth).

find_min(L,Min,L1) :-
	L < Min, !, L1 = L.
find_min(_L,Min,L1) :-
	L1 = Min.

find_max(L,Max,L1) :-
	L > Max, !, L1 = L.
find_max(_L,Max,L1) :-
	L1 = Max.

find_rhs([],[]) :- !.
find_rhs([N|NonTerm],[(N,N_Rhs1)|NonTerm_Rhs]) :-
	setof(Rhs,Num^Len^grammar(Num,N,Rhs,Len),N_Rhs),
	build_nonterm_rhs(N_Rhs,[],N_Rhs1),
	find_rhs(NonTerm,NonTerm_Rhs).

build_nonterm_rhs([],List,List) :- !.
build_nonterm_rhs([N|N_Rhs],List,N_Rhs1) :-
	orlist(N,List,List1),!,
	build_nonterm_rhs(N_Rhs,List1,N_Rhs1).

cal_term_depth([]) :- !.
cal_term_depth([T|Term]) :-
	assert(depth(T,1)),
	cal_term_depth(Term).

write_term(WStream) :-
	!,is_term(Term),
	format(WStream,'is_term(Term) :- true | Term = ~p.~n',[Term]).

write_nonterm(WStream) :-
	!,is_non_term(NonTerm),
	format(WStream,'is_non_term(NonTerm) :- true | NonTerm = ~p.~n',[NonTerm]).

write_reduce(WStream) :-
	setof(StateNum,L1^Act^ANum1^state(StateNum,L1,Act,ANum1),StateNumLst),
	setof(ReStateNum,L2^ANum2^state(ReStateNum,L2,re,ANum2),ReStateNumLst),
	del_re_0(ReStateNumLst,ReStateNumLst1),
	ex_lst(StateNumLst,ReStateNumLst1,RestStates),
	bagof([State,ReduceList],bagof((Reduce,Length),(Cat^state(State,Cat,re,Reduce),Lhs^Rhs^grammar(Reduce,Lhs,Rhs,Length)),ReduceList),Reduces),
	del_no_double(Reduces,Reduces1),
	write_reduce1(Reduces1,WStream),
	write_rest_reduce(RestStates,WStream),
	write('Reduce:'),nl,
	write(Reduces1),nl.

del_re_0(States,States1) :-
	state(State0,_L2,re,0),
	delete(States,State0,States1).

write_reduce1([],_WStream) :- !.
write_reduce1([[State,Reduce]|RList],WStream) :-
	format(WStream,'reduce(~p,Reduces) :- true | Reduces = ~p.~n',[State,Reduce]),
	write_reduce1(RList,WStream).

write_rest_reduce([],_WStream) :- !.
write_rest_reduce([State|RestStates],WStream) :-
	format(WStream,'reduce(~p,Reduces) :- true | Reduces = [].~n',[State]),
	write_rest_reduce(RestStates,WStream).

del_no_double([],Reduces1) :- !,Reduces1 = [].
del_no_double([[S,Reduce]|Reduces],Reduces1) :-
	no_doubles(Reduce,Reduce1),
	Reduces1 = [[S,Reduce1]|Reduces2],
	del_no_double(Reduces,Reduces2).

write_gram(WStream) :-
	bagof([A1,A2,A3,A4],grammar(A1,A2,A3,A4),GList),
	write_gram(GList,WStream).

write_gram([],_WStream) :- !.
write_gram([[A1,A2,A3,A4]|GList],WStream) :-
	format(WStream,'grammar(~p,~p,Rhs,Length) :- true | Rhs = ~p, Length = ~p.~n',[A1,A2,A3,A4]),
        write_gram(GList,WStream).

make_main_input(WStream) :-
	is_term(Term),
	format(WStream,'input(_IN,[],ISL,OSL,ITL,OTL,PE,RQ,RS) :- true | ~n',[]),
	format(WStream,'\tOTL=ITL, OSL=ISL, RQ = [], RS = [PE].~n',[]),
	format(WStream,'input([_S],_,ISL,OSL,ITL,OTL,PE,RQ,RS) :- true | ~n',[]),
	format(WStream,'\tOTL=ITL, OSL=ISL, RQ = [], RS = [PE].~n',[]),
	make_main_input0(Term,WStream),
	is_non_term(NonTerm),
	make_main_input1(NonTerm,WStream).

make_main_input0([],WStream) :- 
	format(WStream,'input([_P,[null,Word]|IN],IStk,ISL,OSL,ITL,OTL,PE,RQ,RS) :-~n\tIStk \\= [] |~n',[]),
	format(WStream,'\tRQ = {[get(PE1)],RQ1,RQ2},~n\tRS = {RS1,RS2},~n',[]),
	format(WStream,'\tnull(IStk,OStk,[null,Word],IN,ISL,ISL1,ITL,ITL1,PE,RQ1,RS1),~n',[]),
	format(WStream,'\tIN=[Pos|_],~n',[]),
	format(WStream,'\tparser_main:insert_stack(Pos,OStk,ISL1,ISL2),~n',[]),
	format(WStream,'\tinput(IN,OStk,ISL2,OSL,ITL1,OTL,PE1,RQ2,RS2)@processor(PE1).~n',[]).
make_main_input0([T|Term],WStream) :-
	format(WStream,'input([_P,[~p,Word]|IN],IStk,ISL,OSL,ITL,OTL,PE,RQ,RS) :-~n\tIStk \\= [] |~n',[T]),
	format(WStream,'\tRQ = {[get(PE1)],RQ1,RQ2},~n\tRS = {RS1,RS2},~n',[]),
	format(WStream,'\t~p(IStk,OStk,[~p,Word],IN,ISL,ISL1,ITL,ITL1,PE,RQ1,RS1),~n',[T,T]),
	format(WStream,'\tIN=[Pos|_],~n',[]),
	format(WStream,'\tparser_main:insert_stack(Pos,OStk,ISL1,ISL2),~n',[]),
	format(WStream,'\tinput(IN,OStk,ISL2,OSL,ITL1,OTL,PE1,RQ2,RS2)@processor(PE1).~n',[]),
	make_main_input0(Term,WStream).

make_main_input1([],_WStream)     :- !.
make_main_input1([N|NonTerm],WStream) :-
	format(WStream,'input([_P,[~p,Word]|IN],IStk,ISL,OSL,ITL,OTL,PE,RQ,RS) :-~n\tIStk \\= [] |~n',[N]),
	format(WStream,'\t~p(IStk,OStk,[~p,Word]),~n',[N,N]),
	format(WStream,'\tinput(IN,OStk,ISL,OSL,ITL,OTL,PE,RQ,RS).~n',[]),
	make_main_input1(NonTerm,WStream).

make_mainclause(WStream) :-
	is_term(Term),
	is_non_term(NonTerm),
	make_mainclause0([null|Term],WStream),
	make_mainclause1(NonTerm,WStream).

make_mainclause0([],_WStream) :- !.
make_mainclause0([T|Term],WStream) :-
	format(WStream,'~p([],OStk,_T,_IN,ISL,OSL,ITL,OTL,PE,RQ,RS) :- true |~n\tOStk=[], OSL=ISL, OTL=ITL, RQ = [], RS = [PE].~n',[T]),
	format(WStream,'~p([[S|I]|IStk],OStk,T,IN,ISL,OSL,ITL,OTL,PE,RQ,RS)  :- true |~n',[T]),
	cat_file_table(T,_Stream,File),
	format(WStream,'\t( IStk = [] ->~n\t\t~p:~p0(S,[S|I],OStk,T,IN,ISL,OSL,ITL,OTL,PE,RQ,RS);~n\totherwise;~n\ttrue ->~n',[File,T]),
	format(WStream,'\t\tRQ = {[get(PE1)],RQ1,RQ2},~n\t\tRS = {RS1,RS2},~n\t\t~p:~p0(S,[S|I],OStk2,T,IN,ISL,ISL1,ITL,ITL1,PE1,RQ1,RS1)@processor(PE1),~n',[File,T]),
	format(WStream,'\t\t~p(IStk,OStk1,T,IN,ISL1,OSL,ITL1,OTL,PE,RQ2,RS2),~n',[T]),
	format(WStream,'\t\tparser_main:append(OStk1,OStk2,OStk3),~n',[]),
	format(WStream,'\t\tparser_main:merge_stack(OStk3,OStk) ).~n',[]),
	make_mainclause0(Term,WStream).

make_mainclause1([],_WStream) :- !.
make_mainclause1([N|NonTerm],WStream) :-
	format(WStream,'~p([],OStk,_T) :- true |~n\tOStk=[].~n',[N]),
	format(WStream,'~p([[S|I]|IStk],OStk,T)  :- true |~n',[N]),
	cat_file_table(N,_Stream,File),
	format(WStream,'\t~p:~p0(S,[S|I],OStk2,T),~n',[File,N]),
	format(WStream,'\t~p(IStk,OStk1,T),~n',[N]),
	format(WStream,'\tparser_main:append(OStk1,OStk2,OStk3),~n',[]),
	format(WStream,'\tparser_main:merge_stack(OStk3,OStk).~n',[]),
	make_mainclause1(NonTerm,WStream).

make_main_re_go(WStream) :-
	bagof([Rule,Lhs],Len^Rhs^grammar(Rule,Lhs,Rhs,Len),AllGram),
	make_main_re_go0(AllGram,WStream).

make_main_re_go0([],_WStream) :- !.
make_main_re_go0([[Rule,Lhs]|AllGram],WStream) :-
	format(WStream,'re(~p,TR,Stk,OStk) :- true |~n',[Rule]),
	format(WStream,'\t~p(Stk,OStk,[~p,TR]).~n',[Lhs,Lhs]),
	make_main_re_go0(AllGram,WStream).

makeclause_top([]) :- !.
makeclause_top([[InCat,Actions]|ASList]) :- 
	cat_file_table(InCat,WStream,_File),
	format(WStream,'~n~n% ACTIONS CONCERNED WITH ** ~p **~n',[InCat]),
	makeclause0(InCat,Actions,WStream),
	makeclause_top(ASList).
	
makeclause0(InCat,[],WStream) :- 
	is_non_term(NonTerm),
	member(InCat,NonTerm),!,
	format(WStream,'otherwise.~n~p0(_S,_Stk,OStk,_T) :- true |~n',[InCat]),
	format(WStream,'\tOStk=[].~n',[]).
makeclause0(InCat,[],WStream) :- 
	!,
	format(WStream,'otherwise.~n~p0(_S,_Stk,OStk,_T,_IN,ISL,OSL,ITL,OTL,PE,RQ,RS) :- true |~n',[InCat]),
	format(WStream,'\tOStk=[], OSL=ISL, OTL=ITL, RQ = [], RS = [PE].~n',[]).
makeclause0(InCat,[[State,Actions]|ASList],WStream) :- 
	recog_action(Actions,ShiftNum,ReduceNum,GotoNum),
	Type = ShiftNum-ReduceNum-GotoNum,
	makeclause1(Type,State,InCat,WStream),
	makeclause0(InCat,ASList,WStream).

% Shift
makeclause1([[sh,X]]-[]-[],State,InCat,WStream) :-
	!,
	format(WStream,
	       '% sh~n~p0(~p,Stk,OStk,T,IN,ISL,OSL,ITL,OTL,PE,RQ,RS) :- true |~n',[InCat,State]),
        format(WStream,'\tOStk=[],~n',[]),
        format(WStream,'\tIN=[Pos|_],~n',[]),
        format(WStream,'\tparser_main:insert_stack(Pos,[[~p,T|Stk]],ISL,ISL1),~n',[X]),
        format(WStream,'\tgram_main:input(IN,[[~p,T|Stk]],ISL1,OSL,ITL,OTL,PE,RQ,RS).~n',[X]),!.

% Accept
makeclause1([]-[[re,0]]-[],State,InCat,WStream) :-
	!,format(WStream,
	       '% acc~n~p0(~p,[_S,TR,0],OStk,_T,_IN,ISL,OSL,ITL,OTL,PE,RQ,RS) :- true |~n',[InCat,State]),
	format(WStream,'\tOTL=[TR|ITL], OStk = [TR], OSL=ISL, RQ = [], RS = [PE].~n',[]).

% Reduce
makeclause1([]-[[re,X]]-[],State,InCat,WStream) :-
	!,
	format(WStream,
	     '% re~n~p0(~p,Stk,OStk,T,IN,ISL,OSL,ITL,OTL,PE,RQ,RS) :- true |~n',[InCat,State]),
	grammar(X,_Lhs,_Rhs,Len),
    	format(WStream,'\tparser_main:reduce(~p,~p,Stk,[],OStk1),~n',[Len,X]),
	format(WStream,'\tgram_main:~p(OStk1,OStk,T,IN,ISL,OSL,ITL,OTL,PE,RQ,RS).~n',[InCat]).

% Goto
makeclause1([]-[]-[[go,X]],State,InCat,WStream) :-
	!,
	format(WStream,
	     '% go~n~p0(~p,Stk,OStk,T) :- true |~n',[InCat,State]),
	format(WStream,'\tOStk=[[~p,T|Stk]].~n',[X]),!.
% Shift/Reduce
makeclause1([[sh,X]]-[[re,Y]|Reduces]-[],State,InCat,WStream) :-
	!,
	format(WStream,
	     '% sh/re~n~p0(~p,Stk,OStk,T,IN,ISL,OSL,ITL,OTL,PE,RQ,RS) :- true |~n',[InCat,State]),
	grammar(Y,_Lhs,_Rhs,Len),
    	format(WStream,'\tparser_main:reduce(~p,~p,Stk,[],NStk0),~n',[Len,Y]),
	makeclause2(0,[[sh,X]]-Reduces-[],InCat,WStream).

% Reduce/Reduce
makeclause1([]-[[re,Y]|Reduces]-[],State,InCat,WStream) :-
	!,
	format(WStream,
	     '% re/re~n~p0(~p,Stk,OStk,T,IN,ISL,OSL,ITL,OTL,PE,RQ,RS) :- true |~n',[InCat,State]),
	grammar(Y,_Lhs,_Rhs,Len),
    	format(WStream,'\tparser_main:reduce(~p,~p,Stk,[],NStk0),~n',[Len,Y]),
	makeclause3(0,[]-Reduces-[],InCat,WStream).
makeclause1(_X-_Y-_Z,_State,_InCat,_WStream) :- 
	write('Error'),nl.

makeclause2(N,[[sh,X]]-[]-[],InCat,WStream) :- 
	N1 is N+1,
	format(WStream,'\tRQ = {[get(PE1)],RQ1,RQ2},~n\tRS = {RS1,RS2},~n',[]),
	format(WStream,'\tgram_main:~p(NStk~p,NStk~p,T,IN,ISL,ISL1,ITL,ITL1,PE1,RQ1,RS1)@processor(PE1),~n',[InCat,N,N1]),
        format(WStream,'\tOStk=[],~n',[]),
        format(WStream,'\tIN=[Pos|_],~n',[]),
        format(WStream,'\tparser_main:insert_stack(Pos,[[~p,T|Stk]|NStk~p],ISL1,ISL2),~n',[X,N1]),
	format(WStream,'\tgram_main:input(IN,[[~p,T|Stk]|NStk~p],ISL2,OSL,ITL1,OTL,PE,RQ2,RS2).~n',[X,N1]).
makeclause2(N,[[sh,X]]-[[re,Y]|Reduces]-[],InCat,WStream) :- 
	N1 is N+1,
	grammar(Y,_Lhs,_Rhs,Len),
    	format(WStream,'\tparser_main:reduce(~p,~p,Stk,[],NStk~p)<,~n',[Len,Y,N1]),
	N2 is N1+1,
	format(WStream,'\tparser_main:append(NStk~p,NStk~p,NStk~p),~n',[N,N1,N2]),
	makeclause2(N2,[[sh,X]]-Reduces-[],InCat,WStream).

makeclause3(N,[]-[]-[],InCat,WStream) :- 
	N1 is N+1,
	format(WStream,'\tgram_main:~p(NStk~p,OStk,T,IN,ISL,OSL,ITL,OTL,PE,RQ,RS).~n',[InCat,N,N1]).
makeclause3(N,[]-[[re,Y]|Reduces]-[],InCat,WStream) :- 
	N1 is N+1,
	grammar(Y,_Lhs,_Rhs,Len),
    	format(WStream,'\tparser_main:reduce(~p,~p,Stk,[],NStk~p),~n',[Len,Y,N1]),
	N2 is N1+1,
	format(WStream,'\tparser_main:append(NStk~p,NStk~p,NStk~p),~n',[N,N1,N2]),
	makeclause3(N2,[]-Reduces-[],InCat,WStream).

%makeclause_noaction(WStream) :-
%	is_term(Term),
%	is_non_term(NonTerm),
%	makeclause_noaction_term([null|Term],WStream),
%	makeclause_noaction_nonterm(NonTerm,WStream).
%
%makeclause_noaction_term([],_WStream) :- !.
%makeclause_noaction_term([InCat|Term],WStream) :-
%	format(WStream,'otherwise.~n~p0(_S,_Stk,OStk,_T,_IN,ISL,OSL,ITL,OTL) :- true |~n',[InCat]),
%	format(WStream,'\tOStk=[], OSL=ISL, OTL=ITL.~n',[]),
%	makeclause_noaction_term(Term,WStream).
%
%makeclause_noaction_nonterm([],_WStream) :- !.
%makeclause_noaction_nonterm([InCat|NonTerm],WStream) :-
%	format(WStream,'otherwise.~n~p0(_S,_Stk,OStk,_T) :- true |~n',[InCat]),
%	format(WStream,'\tOStk=[].~n',[]),
%	makeclause_noaction_nonterm(NonTerm,WStream).

recog_action([],Shift,Reduce,Goto) :-
	Shift = [], Reduce = [], Goto = [].
recog_action([[sh,X]|Y],Shift,Reduce,Goto) :-
	recog_action(Y,Shift1,Reduce,Goto),
	Shift = [[sh,X]|Shift1].
recog_action([[re,X]|Y],Shift,Reduce,Goto) :-
	recog_action(Y,Shift,Reduce1,Goto),
	Reduce = [[re,X]|Reduce1].
recog_action([[go,X]|Y],Shift,Reduce,Goto) :-
	recog_action(Y,Shift,Reduce,Goto1),
	Goto = [[go,X]|Goto1].

% Read from File Routine

read_in_clause(N0,N1,RStream) :-
	read(RStream,state(State,InCat,Action,OutState)),
	assert(state(State,InCat,Action,OutState)),
%	write_info0(State,InCat,Action,OutState),
	N2 is N0+1,
	read_in_clause(N2,N1,RStream).
read_in_clause(N0,N1,_RStream) :- 
	N1 is N0.

% Write Routine

write_info0(State,InCat,Action,OutState) :-
	write('state    = '),write(State),write(' : '),
	write('incat    = '),write(InCat),write(' : '),
	write('action   = '),write(Action),write(' : '),
	write('OutState = '),write(OutState),write(' : '),
	write('\n').

write_info1(N) :-
	write('The number of processed lines is '),
	write(N),write('.'),write('\n').

reverse_insert([],IList,OList) :- !,OList = IList.
reverse_insert([I|IList],List,OList) :-
	TList = [I|List],
	reverse_insert(IList,TList,OList).

