%--------------------------------------------------------------------------
% File     : SYN014=Quant2-2 : TPTP v1.2.1. Released v1.0.0.
% Domain   : Syntactic
% Problem  : A problem in quantification theory
% Version  : [Wang, 1965] axioms : Reduced & Augmented > Incomplete.
%            Theorem formulation : Modified.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : Wang H. (1965), Formalization & Automatic Theorem Proving, 
%            Proceedings of the IFIP Congress 1965, 51-58.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 32 [Wos, 1965]
%          : wos32 [Wilson & Minker, 1976]

% Status   : unsatisfiable
% Syntax   : Number of clauses    :   26 (  13 non-Horn;   7 unit;  23 RR)
%            Number of literals   :   70 (   0 equality)
%            Maximal clause size  :    6
%            Number of predicates :    2 (   0 propositional; 2-2 arity)
%            Number of functors   :    6 (   4 constant; 0-1 arity)
%            Number of variables  :   29 (   0 singleton)
%            Maximal term depth   :    2

% Comments : 
%--------------------------------------------------------------------------
%----Don't include equality axioms because it's incomplete
%include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(reflexivity,axiom,
    [++equalish(X,X)]).

input_clause(symmetry,axiom,
    [--equalish(X,Y),
     ++equalish(Y,X)]).

input_clause(transitivity,axiom,
    [--equalish(X,Y),
     --equalish(Y,Z),
     ++equalish(X,Z)]).

input_clause(element_substitution1,axiom,
    [--equalish(A,B),
     --element(C,A),
     ++element(C,B)]).

input_clause(element_substitution2,axiom,
    [--element(A,B),
     --equalish(A,C),
     ++element(C,B)]).

input_clause(c_3,conjecture,
    [--element(A,a),
     ++equalish(A,k),
     ++equalish(A,a)]).

input_clause(c_4,conjecture,
    [--equalish(A,k),
     ++element(A,a),
     ++equalish(A,a)]).

input_clause(c_5,conjecture,
    [--equalish(f(A),m),
     --element(A,m),
     ++equalish(A,m)]).

input_clause(c_6,conjecture,
    [--equalish(f(A),A),
     --element(A,m),
     ++equalish(A,m)]).

input_clause(c_7,conjecture,
    [++element(A,f(A)),
     --element(A,m),
     ++equalish(A,m)]).

input_clause(c_8,conjecture,
    [++element(f(A),A),
     --element(A,m),
     ++equalish(A,m)]).

input_clause(c_9,conjecture,
    [--element(A,B),
     --element(B,A),
     ++equalish(A,B),
     ++equalish(A,m),
     ++element(B,m),
     ++equalish(B,m)]).

input_clause(c_10,conjecture,
    [--equalish(g(A),n),
     ++element(A,n),
     ++equalish(A,n)]).

input_clause(c_11,conjecture,
    [--equalish(g(A),A),
     ++element(A,n),
     ++equalish(A,n)]).

input_clause(c_12,conjecture,
    [++element(A,g(A)),
     ++element(A,n),
     ++equalish(A,n)]).

input_clause(c_13,conjecture,
    [++element(g(A),A),
     ++element(A,n),
     ++equalish(A,n)]).

input_clause(c_14,conjecture,
    [--element(A,B),
     --element(B,A),
     ++equalish(A,B),
     ++equalish(A,n),
     --element(B,n),
     ++equalish(B,n)]).

input_clause(c_15,conjecture,
    [--equalish(A,m),
     ++element(A,k),
     ++equalish(A,k)]).

input_clause(c_16,conjecture,
    [--equalish(A,n),
     ++element(A,k),
     ++equalish(A,k)]).

input_clause(c_17,conjecture,
    [--element(A,k),
     ++equalish(A,n),
     ++equalish(A,m),
     ++equalish(A,k)]).

input_clause(c_18,conjecture,
    [--equalish(n,a)]).

input_clause(c_19,conjecture,
    [--equalish(m,n)]).

%----This is the only difference from wos33 - SYN015-1.p 
input_clause(c_20,conjecture,
    [++equalish(n,k)]).

input_clause(c_21,conjecture,
    [--equalish(m,a)]).

input_clause(c_22,conjecture,
    [--equalish(k,a)]).

input_clause(c_23,conjecture,
    [++equalish(m,k)]).
%--------------------------------------------------------------------------
